/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tango.pogo.generator.cpp;

import com.google.inject.Inject;
import fr.esrf.tango.pogo.generator.cpp.utils.Attributes;
import fr.esrf.tango.pogo.generator.cpp.utils.Commands;
import fr.esrf.tango.pogo.generator.cpp.utils.CppStringUtils;
import fr.esrf.tango.pogo.generator.cpp.utils.Headers;
import fr.esrf.tango.pogo.generator.cpp.utils.ProtectedArea;
import fr.esrf.tango.pogo.pogoDsl.Attribute;
import fr.esrf.tango.pogo.pogoDsl.Command;
import fr.esrf.tango.pogo.pogoDsl.PogoDeviceClass;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;

public class DynamicAttributeUtils {
    @Inject
    @Extension
    private ProtectedArea _protectedArea;
    @Inject
    @Extension
    private Headers _headers;
    @Inject
    @Extension
    private CppStringUtils _cppStringUtils;
    @Inject
    @Extension
    private Attributes _attributes;
    @Inject
    @Extension
    private Commands _commands;

    public CharSequence generateDynamicAttrUtilsFile(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _fileHeader = this.fileHeader(cls);
        _builder.append((Object)_fileHeader, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        EList<Attribute> _dynamicAttributes = cls.getDynamicAttributes();
        String _attributesTable = this._cppStringUtils.attributesTable(_dynamicAttributes);
        _builder.append((Object)_attributesTable, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("//\tFor compatibility reason, this file (");
        String _name = cls.getName();
        _builder.append((Object)_name, "");
        _builder.append("DynAttrUtils)");
        _builder.newLineIfNotEmpty();
        _builder.append("//\tmanage also the dynamic command utilities.");
        _builder.newLine();
        EList<Command> _dynamicCommands = cls.getDynamicCommands();
        String _commandsTable = this._cppStringUtils.commandsTable(_dynamicCommands);
        _builder.append((Object)_commandsTable, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("namespace ");
        String _name_1 = cls.getName();
        _builder.append((Object)_name_1, "");
        _builder.append("_ns");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        CharSequence _addAndRemoveAttributeMethods = this.addAndRemoveAttributeMethods(cls);
        _builder.append((Object)_addAndRemoveAttributeMethods, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.newLine();
        _builder.append("//============================================================");
        _builder.newLine();
        _builder.append("//\tTool methods to get pointer on attribute data buffer ");
        _builder.newLine();
        _builder.append("//============================================================");
        _builder.newLine();
        EList<Attribute> _dynamicAttributes_1 = cls.getDynamicAttributes();
        for (Attribute attribute : _dynamicAttributes_1) {
            CharSequence _dynamicAttributeTools = this.dynamicAttributeTools(cls, attribute);
            _builder.append((Object)_dynamicAttributeTools, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.newLine();
        CharSequence _addAndRemoveCommandMethods = this.addAndRemoveCommandMethods(cls);
        _builder.append((Object)_addAndRemoveCommandMethods, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("} //\tnamespace");
        _builder.newLine();
        return _builder;
    }

    public CharSequence fileHeader(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        String _dynamicAttrUtilsFileHeader = this._headers.dynamicAttrUtilsFileHeader(cls);
        String _plus = String.valueOf(_dynamicAttrUtilsFileHeader) + "\n\n";
        String _plus_1 = String.valueOf(_plus) + "#include <";
        String _name = cls.getName();
        String _plus_2 = String.valueOf(_plus_1) + _name;
        String _plus_3 = String.valueOf(_plus_2) + ".h>\n";
        String _plus_4 = String.valueOf(_plus_3) + "#include <";
        String _name_1 = cls.getName();
        String _plus_5 = String.valueOf(_plus_4) + _name_1;
        String _plus_6 = String.valueOf(_plus_5) + "Class.h>";
        String _protectedArea = this._protectedArea.protectedArea(cls, "DynAttrUtils.cpp", _plus_6, false);
        _builder.append((Object)_protectedArea, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence addAndRemoveAttributeMethods(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("//=============================================================");
        _builder.newLine();
        _builder.append("//\tAdd/Remove dynamic attribute methods");
        _builder.newLine();
        _builder.append("//=============================================================");
        _builder.newLine();
        _builder.newLine();
        EList<Attribute> _dynamicAttributes = cls.getDynamicAttributes();
        for (Attribute attribute : _dynamicAttributes) {
            CharSequence _addDynamicAttribute = this.addDynamicAttribute(cls, attribute);
            _builder.append((Object)_addDynamicAttribute, "");
            _builder.newLineIfNotEmpty();
            CharSequence _removeDynamicAttribute = this.removeDynamicAttribute(cls, attribute);
            _builder.append((Object)_removeDynamicAttribute, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence addDynamicAttribute(PogoDeviceClass cls, Attribute attribute) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("//--------------------------------------------------------");
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*\tAdd a ");
        String _name = attribute.getName();
        _builder.append((Object)_name, " ");
        _builder.append(" dynamic attribute.");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        String _addDynamicAttributeHeaderComment = this._cppStringUtils.addDynamicAttributeHeaderComment(attribute);
        _builder.append((Object)_addDynamicAttributeHeaderComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("//--------------------------------------------------------");
        _builder.newLine();
        String _addDynamicAttributeSignature = this._cppStringUtils.addDynamicAttributeSignature(cls, attribute, false);
        _builder.append((Object)_addDynamicAttributeSignature, "");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _attributeFactory = this._attributes.attributeFactory(attribute, cls);
        _builder.append((Object)_attributeFactory, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence removeDynamicAttribute(PogoDeviceClass cls, Attribute attribute) {
        boolean _equals_1;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("//--------------------------------------------------------");
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*\tremove a ");
        String _name = attribute.getName();
        _builder.append((Object)_name, " ");
        _builder.append(" dynamic attribute.");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        String _removeDynamicAttributeHeaderComment = this._cppStringUtils.removeDynamicAttributeHeaderComment(attribute);
        _builder.append((Object)_removeDynamicAttributeHeaderComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("//--------------------------------------------------------");
        _builder.newLine();
        String _removeDynamicAttributeSignature = this._cppStringUtils.removeDynamicAttributeSignature(cls, attribute, false);
        _builder.append((Object)_removeDynamicAttributeSignature, "");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("remove_attribute(attname, true);");
        _builder.newLine();
        boolean _isScalar = this._cppStringUtils.isScalar(attribute);
        if (_isScalar) {
            _builder.append("\t");
            _builder.append("map<string,");
            String _strType = this._cppStringUtils.strType(attribute);
            _builder.append((Object)_strType, "\t");
            _builder.append(">::iterator ite;");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append("\t");
            _builder.append("map<string,");
            String _strType_1 = this._cppStringUtils.strType(attribute);
            _builder.append((Object)_strType_1, "\t");
            _builder.append(" *>::iterator ite;");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("    ");
        _builder.append("if ((ite=");
        String _name_1 = attribute.getName();
        _builder.append((Object)_name_1, "    ");
        _builder.append("_data.find(attname))!=");
        String _name_2 = attribute.getName();
        _builder.append((Object)_name_2, "    ");
        _builder.append("_data.end())");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("{");
        _builder.newLine();
        _builder.append("    \t");
        String _name_3 = attribute.getName();
        String _plus = "remove_" + _name_3;
        String _plus_1 = String.valueOf(_plus) + "_dynamic_attribute";
        String _protectedArea = this._protectedArea.protectedArea(cls, _plus_1);
        _builder.append((Object)_protectedArea, "    \t");
        _builder.newLineIfNotEmpty();
        String _attType = attribute.getAttType();
        boolean _equals = _attType.equals("Scalar");
        boolean bl = _equals_1 = !_equals;
        if (_equals_1) {
            _builder.append("\t\t");
            _builder.append("if (free_it)");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("delete[] ite->second;");
            _builder.newLine();
        }
        _builder.append("\t\t");
        String _name_4 = attribute.getName();
        _builder.append((Object)_name_4, "\t\t");
        _builder.append("_data.erase(ite);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence dynamicAttributeTools(PogoDeviceClass cls, Attribute attribute) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("//--------------------------------------------------------");
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*\tReturn a pointer on ");
        String _name = attribute.getName();
        _builder.append((Object)_name, " ");
        _builder.append(" data.");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*  parameter attname: the specified attribute name.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("//--------------------------------------------------------");
        _builder.newLine();
        String _strType = this._cppStringUtils.strType(attribute);
        _builder.append((Object)_strType, "");
        _builder.append(" *");
        String _name_1 = cls.getName();
        _builder.append((Object)_name_1, "");
        _builder.append("::get_");
        String _name_2 = attribute.getName();
        _builder.append((Object)_name_2, "");
        _builder.append("_data_ptr(string &name)");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        boolean _isScalar = this._cppStringUtils.isScalar(attribute);
        if (_isScalar) {
            _builder.append("\t");
            _builder.append("map<string,");
            String _strType_1 = this._cppStringUtils.strType(attribute);
            _builder.append((Object)_strType_1, "\t");
            _builder.append(">::iterator ite;");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append("\t");
            _builder.append("map<string,");
            String _strType_2 = this._cppStringUtils.strType(attribute);
            _builder.append((Object)_strType_2, "\t");
            _builder.append(" *>::iterator ite;");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("    ");
        _builder.append("if ((ite=");
        String _name_3 = attribute.getName();
        _builder.append((Object)_name_3, "    ");
        _builder.append("_data.find(name))==");
        String _name_4 = attribute.getName();
        _builder.append((Object)_name_4, "    ");
        _builder.append("_data.end())");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("TangoSys_OMemStream\ttms;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("tms << \"Dynamic attribute \" << name << \" has not been created\";");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("Tango::Except::throw_exception(");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("(const char *)\"ATTRIBUTE_NOT_FOUND\",");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("tms.str().c_str(),");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("(const char *)\"");
        String _name_5 = cls.getName();
        _builder.append((Object)_name_5, "\t\t\t\t\t");
        _builder.append("::get_");
        String _name_6 = attribute.getName();
        _builder.append((Object)_name_6, "\t\t\t\t\t");
        _builder.append("_data_ptr()\");");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        boolean _isScalar_1 = this._cppStringUtils.isScalar(attribute);
        if (_isScalar_1) {
            _builder.append("\t");
            _builder.append("return  &(ite->second);");
            _builder.newLine();
        } else {
            _builder.append("\t");
            _builder.append("return  ite->second;");
            _builder.newLine();
        }
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence addAndRemoveCommandMethods(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("//=============================================================");
        _builder.newLine();
        _builder.append("//\tAdd/Remove dynamic command methods");
        _builder.newLine();
        _builder.append("//=============================================================");
        _builder.newLine();
        _builder.newLine();
        EList<Command> _dynamicCommands = cls.getDynamicCommands();
        for (Command command : _dynamicCommands) {
            CharSequence _addDynamicCommand = this.addDynamicCommand(cls, command);
            _builder.append((Object)_addDynamicCommand, "");
            _builder.newLineIfNotEmpty();
            CharSequence _removeDynamicCommand = this.removeDynamicCommand(cls, command);
            _builder.append((Object)_removeDynamicCommand, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence addDynamicCommand(PogoDeviceClass cls, Command command) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("//--------------------------------------------------------");
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*\tAdd a ");
        String _name = command.getName();
        _builder.append((Object)_name, " ");
        _builder.append(" dynamic command.");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        String _addDynamicCommandHeaderComment = this._cppStringUtils.addDynamicCommandHeaderComment(command);
        _builder.append((Object)_addDynamicCommandHeaderComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("//--------------------------------------------------------");
        _builder.newLine();
        String _addDynamicCommandSignature = this._cppStringUtils.addDynamicCommandSignature(cls, command, false);
        _builder.append((Object)_addDynamicCommandSignature, "");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _dynamicCommandFactory = this._commands.dynamicCommandFactory(command);
        _builder.append((Object)_dynamicCommandFactory, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence removeDynamicCommand(PogoDeviceClass cls, Command command) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("//--------------------------------------------------------");
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*\tremove a ");
        String _name = command.getName();
        _builder.append((Object)_name, " ");
        _builder.append(" dynamic command.");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        String _removeDynamicCommandHeaderComment = this._cppStringUtils.removeDynamicCommandHeaderComment(command);
        _builder.append((Object)_removeDynamicCommandHeaderComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("//--------------------------------------------------------");
        _builder.newLine();
        String _removeDynamicCommandSignature = this._cppStringUtils.removeDynamicCommandSignature(cls, command, false);
        _builder.append((Object)_removeDynamicCommandSignature, "");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("remove_command(cmdname, true);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }
}

