/*
 * Decompiled with CFR 0.152.
 */
package pogo.gene;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import pogo.gene.Attrib;
import pogo.gene.AttribTable;
import pogo.gene.Cmd;
import pogo.gene.CmdTable;
import pogo.gene.DevState;
import pogo.gene.DevStateTable;
import pogo.gene.DeviceID;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;
import pogo.gene.PogoString;
import pogo.gene.PogoUtil;
import pogo.gene.ProjectFiles;
import pogo.gene.Property;
import pogo.gene.PropertyTable;
import pogo.gene.ServerDefinitions;

public class PogoClass
implements PogoDefs {
    public String title;
    public String class_name;
    public String inherited_from = null;
    public String class_desc;
    public String templates_dir;
    public PropertyTable class_properties;
    public PropertyTable dev_properties;
    public CmdTable commands;
    public AttribTable attributes;
    public DevStateTable states;
    public int language;
    public String author;
    public String revision;
    public String cvs_repository = null;
    public int deviceImpl;
    public ProjectFiles projectFiles;
    public boolean is_abstractclass = false;
    public Exception except = null;
    public DeviceID device_id;
    private String template_class = "<b><Font size=-1 COLOR=\"#0000FF\"> CLASS </b></Font>";
    private String template_lang = "<Center><Font size=-1 COLOR=\"#0000FF\"><b> LANG </b></Font></Center>";
    private String template_desc = "<b><Font size=-1><a href=CLASS/doc_html/index.html> DESCRIPTION </a></Font></b>";
    private static final int max_desc = 300;

    public String namespace() {
        return this.class_name + "_ns";
    }

    public String inheritedNamespace() {
        return this.inheritedClassName() + "_ns";
    }

    public String inheritedClassName() {
        if (this.inherited_from == null) {
            return "Device_4Impl";
        }
        if (this.inherited_from.equals("Device_4Impl")) {
            return "Device_4Impl";
        }
        int start = this.inherited_from.lastIndexOf("/");
        int end = this.inherited_from.lastIndexOf(".");
        String classname = end > ++start ? this.inherited_from.substring(start, end) : this.inherited_from.substring(start);
        return classname;
    }

    public String inheritedClassPath() {
        String classname = "";
        if (this.inherited_from == null) {
            return classname;
        }
        if (this.inherited_from.equals("Device_4Impl")) {
            return classname;
        }
        int end = this.inherited_from.lastIndexOf("/");
        classname = end > 0 ? this.inherited_from.substring(0, end) : this.inherited_from;
        return classname;
    }

    public PogoClass(String className, String inherited_from, String classDesc, Vector classPropVect, Vector devPropVect, Vector cmdVect, Vector attrVect, Vector statesVector, int language, String path) throws PogoException {
        this.class_name = className;
        this.inherited_from = inherited_from;
        if (classDesc != null) {
            this.class_desc = classDesc;
        }
        this.author = "";
        this.revision = "";
        this.class_properties = new PropertyTable(classPropVect, 0);
        this.dev_properties = new PropertyTable(devPropVect, 1);
        this.commands = new CmdTable(cmdVect);
        this.attributes = new AttribTable(attrVect);
        this.states = new DevStateTable(statesVector);
        this.language = language;
        this.projectFiles = new ProjectFiles(path, this.class_name, language);
        if (language == 1) {
            this.deviceImpl = 4;
        } else if (language == 0) {
            this.deviceImpl = 2;
        } else if (language == 2) {
            this.deviceImpl = 4;
        }
        this.templates_dir = System.getProperty("TEMPL_HOME");
        if (this.templates_dir == null) {
            throw new PogoException("No Template Property (TEMPL_HOME) Fixed !");
        }
    }

    public PogoClass(ServerDefinitions sd, int language, String path) throws PogoException {
        this.class_name = sd.name;
        this.inherited_from = sd.inherited_from;
        this.class_desc = sd.description;
        this.title = sd.project_title;
        this.author = "";
        this.revision = "";
        this.class_properties = new PropertyTable(0);
        this.dev_properties = new PropertyTable(1);
        this.commands = new CmdTable();
        this.attributes = new AttribTable();
        this.states = new DevStateTable();
        this.language = language;
        this.projectFiles = new ProjectFiles(path, this.class_name, language);
        if (language == 1) {
            this.deviceImpl = 4;
        } else if (language == 0) {
            this.deviceImpl = 2;
        } else if (language == 2) {
            this.deviceImpl = 4;
        }
        this.templates_dir = System.getProperty("TEMPL_HOME");
        if (this.templates_dir == null) {
            throw new PogoException("No Template Property (TEMPL_HOME) Fixed !");
        }
    }

    public PogoClass(String filename) throws FileNotFoundException, IOException, PogoException {
        String code = "";
        try {
            code = PogoUtil.readFile(filename);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (code.startsWith("/*PROTECTED REGION ID(")) {
            throw new PogoException("This a too recent Pogo model (using oAW model) !");
        }
        this.projectFiles = new ProjectFiles(filename);
        this.author = "";
        this.revision = "";
        this.templates_dir = System.getProperty("TEMPL_HOME");
        if (this.templates_dir == null) {
            throw new PogoException("No Template Property (TEMPL_HOME) Fixed !");
        }
        this.initializePogoFromSrcFiles();
        String id_filename = DeviceID.getFilename(filename);
        if (new File(id_filename).exists()) {
            this.device_id = new DeviceID(PogoUtil.readFile(id_filename));
            this.author = this.device_id.getAuthorFromContact();
        } else {
            this.device_id = new DeviceID();
        }
    }

    private void initializePogoFromSrcFiles() throws FileNotFoundException, SecurityException, IOException, PogoException {
        this.class_name = this.projectFiles.getClassName();
        this.language = this.projectFiles.getLanguage();
        String serverDescriptionFile = this.language == 1 ? this.projectFiles.getServer_h() : this.projectFiles.getServer();
        String classDescriptionFile = this.language == 1 ? this.projectFiles.getServerClass_h() : this.projectFiles.getServerClass();
        this.deviceImpl = 2;
        if (this.language == 1) {
            this.deviceImpl = PogoUtil.deviceImplRevisionNumber(serverDescriptionFile);
            System.out.println("Server inherits from Device_" + this.deviceImpl + "Impl class");
            if (this.deviceImpl < 3) {
                PogoUtil.logString(this.class_name + "\tinherits from Device " + this.deviceImpl + "Impl class");
            }
        } else if (this.language == 2) {
            this.deviceImpl = PogoUtil.deviceImplRevisionNumber(serverDescriptionFile);
            System.out.println("Server inherits from Device_" + this.deviceImpl + "Impl class");
        }
        this.commands = new CmdTable(this.projectFiles.getServerClass(), this.deviceImpl);
        this.commands.getDescriptions(serverDescriptionFile, this.projectFiles.getServerClass(), this.language);
        if (this.language == 1) {
            if (this.deviceImpl >= 3) {
                this.inherited_from = PogoUtil.getInstance().getInheritance(this.class_name, serverDescriptionFile);
                this.is_abstractclass = PogoUtil.checkIfSuperclass(serverDescriptionFile, this.commands);
                System.out.println("This class is " + (this.is_abstractclass ? "" : "NOT") + " a super class");
                System.out.println("Server inherits " + this.inherited_from + " class");
            }
            System.out.println("Server is a Device_" + this.deviceImpl + "Impl object");
        } else {
            this.inherited_from = "Device_4Impl";
        }
        if (this.language == 1 && this.deviceImpl >= 3) {
            this.commands.setAllowedState(this.class_name, this.projectFiles.getAllowed(), this.is_abstractclass);
        }
        this.states = new DevStateTable(serverDescriptionFile, this.language);
        this.attributes = new AttribTable(this.projectFiles, this.language);
        if (this.language == 1 && this.deviceImpl >= 3) {
            this.attributes.setAllowedState(this.class_name, this.projectFiles.getAllowed(), this.is_abstractclass);
        }
        this.getTheProjectTitle(serverDescriptionFile);
        if (this.language == 2) {
            this.class_desc = this.parsePyClassDescription(serverDescriptionFile);
        } else {
            this.getTheClassDescription(serverDescriptionFile);
        }
        this.getIfOverrided(serverDescriptionFile);
        this.class_properties = new PropertyTable(classDescriptionFile, 0, this.language);
        this.class_properties.readDefaultValues(this.projectFiles.getServerClass(), this.language);
        this.dev_properties = new PropertyTable(serverDescriptionFile, 1, this.language);
        this.dev_properties.readDefaultValues(this.projectFiles.getServerClass(), this.language);
        if (this.commands.except != null) {
            this.except = this.commands.except;
            this.commands.except = null;
        }
        if (this.attributes.except != null) {
            this.except = this.attributes.except;
            this.attributes.except = null;
        }
    }

    private String parsePyClassDescription(String filename) {
        String code;
        try {
            code = PogoUtil.readFile(filename);
        }
        catch (Exception e) {
            return "";
        }
        String target = this.class_name + " Class Description:";
        int start = code.indexOf(target);
        if (start < 0) {
            return "";
        }
        int end = code.indexOf("#==========", start);
        if (end < 0) {
            return "";
        }
        String s = code.substring(start += target.length() + 1, end);
        String description = "";
        StringTokenizer stk = new StringTokenizer(s, "\n");
        while (stk.hasMoreTokens()) {
            description = description + stk.nextToken().substring(1).trim() + "\n";
        }
        return description.trim();
    }

    private void getIfOverrided(String filename) throws FileNotFoundException, SecurityException, IOException {
        PogoString pgs = new PogoString(PogoUtil.readFile(filename));
        for (int i = 0; i < this.commands.size(); ++i) {
            Cmd cmd = this.commands.cmdAt(i);
            if (!cmd.virtual_method) continue;
            String cppLine = cmd.buildCppCmdProtypesLine();
            if (pgs.str.indexOf(cppLine) > 0) {
                cmd.override_method = 2;
                continue;
            }
            cppLine = cmd.buildCppCmdProtypesLineNoTab();
            if (pgs.str.indexOf(cppLine) > 0) {
                cmd.override_method = 2;
                continue;
            }
            String javaLine = cmd.buildJavaExecCmdMethodSignature(0);
            if (pgs.str.indexOf(javaLine) <= 0) continue;
            cmd.override_method = 2;
        }
    }

    private void getTheProjectTitle(String filename) throws FileNotFoundException, SecurityException, IOException {
        int end;
        String str = PogoUtil.readFile(filename);
        int start = str.indexOf("project :");
        if (start < 0) {
            System.out.println("WARNING: 'project :' Not Found in " + filename);
        } else {
            end = str.indexOf("\n", start += "project :".length());
            this.title = str.substring(start, end).trim();
        }
        String tmp = PogoUtil.getCvsInfo(filename, "author:");
        if (tmp.length() > 0) {
            this.author = tmp;
        } else {
            tmp = PogoUtil.getSvnInfo(filename, "Last Changed Author:");
            if (tmp.length() > 0) {
                this.author = tmp;
            } else {
                start = str.indexOf("Author:");
                if (start > 0) {
                    end = str.indexOf("$", start += "Author:".length());
                    this.author = str.substring(start, end).trim();
                    end = this.author.indexOf(10);
                    if (end > 0) {
                        this.author = this.author.substring(0, end);
                    }
                }
            }
        }
        start = str.indexOf("Revision:");
        if (start > 0) {
            end = str.indexOf("$", start += "Revision:".length());
            this.revision = str.substring(start, end).trim();
        }
        this.revision = PogoUtil.getCvsInfo(filename, "symbolic names:");
        if (this.language == 1) {
            this.cvs_repository = PogoUtil.getCvsRepository(this.projectFiles.getPath());
        }
    }

    private void getTheClassDescription(String filename) throws FileNotFoundException, SecurityException, IOException {
        String str = PogoUtil.readFile(filename);
        int start = str.indexOf("Class Description:");
        if (start < 0) {
            this.class_desc = "";
            return;
        }
        int end = str.indexOf("*/", start += "Class Description:".length());
        if (end < 0) {
            this.class_desc = "";
            return;
        }
        PogoString comments = new PogoString(str.substring(start, end));
        this.class_desc = comments.getDescription().trim();
    }

    public void setRevision(String vers) {
        this.revision = vers;
    }

    public void setAuthor(String name) {
        this.author = name;
    }

    public void setTitle(String projTitle) {
        this.title = projTitle;
    }

    public void addClassProperty(Property prop) {
        this.class_properties.addElement(prop);
    }

    public void addDevProperty(Property prop) {
        this.dev_properties.addElement(prop);
    }

    public void addCommand(Cmd cmd) {
        this.commands.addElement(cmd);
    }

    public void addAttribute(Attrib attr) {
        this.attributes.addElement(attr);
    }

    public void addState(DevState st) {
        this.states.addElement(st);
    }

    public String[] buildServersListHtmlLine(String repository, String family) {
        PogoString html_class = new PogoString(this.template_class);
        String target = this.class_name;
        String cs = "\"http://tango-cs.cvs.sourceforge.net/tango-cs/tango/cppserver/\"";
        String ds = "\"http://tango-ds.cvs.sourceforge.net/tango-ds/\"";
        if (repository.equals("SourceForge(Tango-cs)")) {
            target = "<a href=" + cs + " target=new> " + this.class_name + " </a>";
        } else if (repository.equals("SourceForge(Tango-ds)")) {
            target = "<a href=" + ds + " target=new> " + this.class_name + " </a>";
        }
        while (html_class.indexOf("CLASS") >= 0) {
            html_class.replace("CLASS", target);
        }
        PogoString html_lang = new PogoString(this.template_lang);
        String strlang = "?";
        if (this.language == 1) {
            strlang = "C++";
        } else if (this.language == 0) {
            strlang = "Java";
        } else if (this.language == 2) {
            strlang = "Python";
        }
        while (html_lang.indexOf("LANG") >= 0) {
            html_lang.replace("LANG", strlang);
        }
        PogoString html_desc = new PogoString(this.template_desc);
        while (html_desc.indexOf("CLASS") >= 0) {
            html_desc.replace("CLASS", this.class_name);
        }
        String desc = this.class_desc.length() > 300 ? this.class_desc.substring(0, 300) + "....." : (this.class_desc.length() == 0 ? "Tango device server" : this.class_desc);
        desc = new PogoString(desc).removeHtmlTags();
        html_desc.replace("DESCRIPTION", desc);
        String[] retstr = new String[]{html_class.str, html_lang.str, html_desc.str};
        return retstr;
    }

    public void setProjectPath(String path) {
        this.projectFiles = new ProjectFiles(path, this.class_name, this.language);
    }

    String buildPyDescription() {
        String code = "#   " + this.class_name + " Class Description:\n#\n";
        StringTokenizer stk = new StringTokenizer(this.class_desc, "\n");
        while (stk.hasMoreTokens()) {
            code = code + "#         " + stk.nextToken() + "\n";
        }
        return code;
    }

    public String toString() {
        String s = this.class_name + "\n";
        s = s + this.class_desc + "\n";
        s = s + "COMMANDS\n";
        s = s + this.commands;
        s = s + "ATTRIBUTES\n";
        s = s + this.attributes;
        s = s + "STATES\n";
        s = s + this.states;
        s = s + "CLASS PROPERTIES\n";
        s = s + this.class_properties;
        s = s + "Device PROPERTIES\n";
        s = s + this.dev_properties;
        return s;
    }
}

