/*
 * Decompiled with CFR 0.152.
 */
package pogo.gene;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import pogo.gene.DevState;
import pogo.gene.PogoDefs;
import pogo.gene.PogoGenePython;
import pogo.gene.PogoString;
import pogo.gene.PogoUtil;

public class DevStateTable
extends Vector
implements PogoDefs {
    public DevStateTable() {
    }

    public DevStateTable(Vector v_in) {
        for (int i = 0; i < v_in.size(); ++i) {
            this.addElement(v_in.elementAt(i));
        }
    }

    public DevStateTable(String filename, int lang) throws FileNotFoundException, SecurityException, IOException {
        String str = PogoUtil.readFile(filename);
        int start = str.indexOf("Device States Description:");
        if (start < 0) {
            System.out.println("WARNING: Device States Description:Not found !");
            return;
        }
        start = str.indexOf("\n", start) + 1;
        int end = lang == 2 ? str.indexOf("#==========", start) : str.indexOf("*/", start);
        PogoString pgs = new PogoString(str.substring(start, end));
        pgs.str = lang == 2 ? pgs.getPyDescription() : pgs.getDescription();
        String pattern = lang == 1 ? "Tango::" : "DevState.";
        end = 0;
        while (end >= 0 && (start = pgs.str.indexOf(pattern, end)) >= 0) {
            end = pgs.str.indexOf(":", start + pattern.length() + 1);
            String name = pgs.str.substring(start, end).trim();
            start = end + 2;
            String desc = (end = pgs.str.indexOf(pattern, start)) > 0 ? pgs.str.substring(start, end).trim() : (start < pgs.str.length() ? pgs.str.substring(start).trim() : "");
            this.addElement(new DevState(name, desc));
        }
    }

    public DevState stateAt(int idx) {
        return (DevState)this.elementAt(idx);
    }

    @Override
    public String toString() {
        String str = "";
        for (int i = 0; i < this.size(); ++i) {
            DevState state = (DevState)this.elementAt(i);
            str = str + state.name + ":\n";
            str = str + state.description + "\n";
        }
        return str;
    }

    void setPyNotAllowedFor(String code, String name) {
        String target = "def is_" + name + "_allowed(self";
        int start = code.indexOf(target);
        if (start < 0) {
            return;
        }
        int end = PogoGenePython.pyEndMethod(code, start);
        String method = code.substring(start, end);
        if ((start = method.indexOf(target = "self.get_state() in [")) < 0) {
            return;
        }
        end = method.indexOf(93, start += target.length());
        String str = method.substring(start, end);
        end = 0;
        target = "PyTango.DevState.";
        while ((start = str.indexOf(target, end)) >= 0 && end >= 0) {
            end = str.indexOf(",", start);
            String statename = end < 0 ? str.substring(start).trim() : str.substring(start, end).trim();
            this.add(new DevState(statename, ""));
        }
    }

    String pyUpdateAllowedStateMethod(String code, String signature) {
        int start = code.indexOf(signature);
        if (start < 0) {
            return code;
        }
        String target = "#\tEnd of Generated Code";
        int end = code.indexOf(target, start += signature.length() + 1);
        if ((end = code.lastIndexOf(10, end) + 1) > start) {
            code = code.substring(0, start) + code.substring(end);
        }
        if (this.size() == 0) {
            start = code.indexOf("#\tRe-Start of Generated Code");
            if ((start = code.indexOf("return False", start)) > 0) {
                end = code.indexOf("\n", start);
                start = code.lastIndexOf("\n", start);
                code = code.substring(0, start) + code.substring(end);
            }
            return code;
        }
        String test = "\t\tif self.get_state() in [";
        for (int i = 0; i < this.size(); ++i) {
            DevState state = this.stateAt(i);
            test = test + state.getPyName();
            test = i < this.size() - 1 ? test + ",\n\t\t                        " : test + "]:\n";
        }
        code = code.substring(0, start) + test + code.substring(start);
        target = "#\tRe-Start of Generated Code";
        start = code.indexOf(target);
        if (code.indexOf("return False", start += target.length()) < 0) {
            end = code.indexOf("return True", start);
            if ((end = code.lastIndexOf("\n", end)) < 0) {
                end = code.length() - 1;
            }
            code = code.substring(0, start) + "\n\t\t\treturn False" + code.substring(end);
        }
        return code;
    }

    public String toStringComments(int lang) {
        String name;
        DevState state;
        int i;
        String retVal = lang == 2 ? "# \tDevice States Description:\n#\n" : " *\tDevice States Description:\n";
        int len = 0;
        for (i = 0; i < this.size(); ++i) {
            state = (DevState)this.elementAt(i);
            name = lang == 1 ? state.name : state.javaName();
            String title = lang == 2 ? "#   " + name + " :  " : " *  " + name + " :  ";
            if (title.length() <= len) continue;
            len = title.length();
        }
        for (i = 0; i < this.size(); ++i) {
            int l;
            state = (DevState)this.elementAt(i);
            name = lang == 1 ? state.name : state.javaName();
            String str = lang == 2 ? "#   " + name + " :  " : " *  " + name + " :  ";
            for (int j = l = str.length(); j < len; ++j) {
                str = str + " ";
            }
            StringTokenizer stk = new StringTokenizer(state.description, "\n");
            int j = 0;
            while (stk.hasMoreTokens()) {
                String line = stk.nextToken().trim();
                if (j > 0) {
                    str = lang == 2 ? str + "# " : str + " *";
                    for (int s = 0; s < len - 2; ++s) {
                        str = str + " ";
                    }
                }
                str = str + line + "\n";
                ++j;
            }
            retVal = retVal + str.trim() + "\n";
        }
        return retVal;
    }

    String allowedCore() {
        if (this.size() == 0) {
            return null;
        }
        String s = "{\n\tif (";
        for (int i = 0; i < this.size(); ++i) {
            DevState state = this.stateAt(i);
            if (i > 0) {
                s = s + "\t||\n\t\t";
            }
            s = s + "get_state() == " + TangoStatesArray[state.code];
        }
        s = s + ")\n\t{\n\t\t//\t";
        return s;
    }

    public DevStateTable(String method) {
        int start = method.indexOf("if (");
        if (start < 0) {
            return;
        }
        int end = method.indexOf(")\n", start += "if (".length());
        String code = method.substring(start, end);
        start = 0;
        String target = "get_state() == ";
        while ((start = code.indexOf(target, start)) >= 0) {
            StringTokenizer st = new StringTokenizer(code.substring(start += target.length()));
            String str_state = st.nextToken();
            this.add(new DevState(str_state, str_state));
        }
    }

    public static void main(String[] args) {
        String code = "//=========================================================\n/**\n *\tRead/Write allowed for Voltage attribute.\n */\n//=========================================================\nbool PowerSupply::is_Voltage_allowed(Tango::AttReqType type)\n{\n\tif (get_state() == Tango::FAULT\t||\n\t\tget_state() == Tango::ALARM)\n\t{\n\t\t//\tEnd of Generated Code\n\t\t\n\t\t\tif(All_ok)\n\t\t\t\tdo_it();\n\n\t\t//\tRe-Start of Generated Code\n\t\treturn false;\n\t}\n\treturn true\n}\n";
        try {
            DevStateTable table = new DevStateTable(code);
            System.out.println(table);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

