/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui;

import fr.esrf.tango.pogo.pogoDsl.ClassIdentification;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.tango.pogo.pogo_gui.ClassDialog;
import org.tango.pogo.pogo_gui.ClassPanel;
import org.tango.pogo.pogo_gui.ClassTree;
import org.tango.pogo.pogo_gui.DeviceClass;
import org.tango.pogo.pogo_gui.DeviceIdDialog;
import org.tango.pogo.pogo_gui.GenerateDialog;
import org.tango.pogo.pogo_gui.InheritancePanel;
import org.tango.pogo.pogo_gui.InheritanceUtils;
import org.tango.pogo.pogo_gui.MultiClassesPanel;
import org.tango.pogo.pogo_gui.OldPogoModel;
import org.tango.pogo.pogo_gui.PogoConst;
import org.tango.pogo.pogo_gui.PreferencesDialog;
import org.tango.pogo.pogo_gui.packaging.ConfigurePackagingDialog;
import org.tango.pogo.pogo_gui.packaging.Packaging;
import org.tango.pogo.pogo_gui.tools.PogoConfiguration;
import org.tango.pogo.pogo_gui.tools.PogoException;
import org.tango.pogo.pogo_gui.tools.PogoFileFilter;
import org.tango.pogo.pogo_gui.tools.PogoProperty;
import org.tango.pogo.pogo_gui.tools.PopupColorCode;
import org.tango.pogo.pogo_gui.tools.PopupHtml;
import org.tango.pogo.pogo_gui.tools.Utils;

public class PogoGUI
extends JFrame {
    public static boolean useDisplay = false;
    private static ArrayList<JFrame> runningApplis = new ArrayList();
    private static JFileChooser chooser = null;
    static final PogoFileFilter pogoFilter = new PogoFileFilter("xmi", "Tango Classes");
    static final PogoFileFilter pogo6Filter = new PogoFileFilter(new String[]{"h", "java", "py"}, "Pogo-6 Tango Classes");
    static String homeDir;
    private static boolean startup;
    private ArrayList<JButton> topButtons = new ArrayList();
    private static final int TOP_RELOAD = 0;
    private static final int TOP_NEW = 1;
    private static final int TOP_OPEN = 2;
    private static final int TOP_GENE = 3;
    private ClassPanels class_panels;
    private JLabel languageLabel;
    private LanguagePopupMenu languageMenu;
    private boolean hasInheritance = false;
    public static MultiClassesPanel multiClassesPanel;
    private boolean reBuildTabbedPane = false;
    private JMenuItem aboutItem;
    private JMenuItem colorItem;
    private JMenuItem deleteItem;
    private JMenu editMenu;
    private JMenuItem exitItem;
    private JMenu fileMenu;
    private JMenuItem generateItem;
    private JMenu helpMenu;
    private JPanel inherPanel;
    private JMenuItem moveDownItem;
    private JMenuItem moveUpItem;
    private JMenuItem multiItem;
    private JMenuItem newItem;
    private JMenuItem openItem;
    private JMenuItem packageItem;
    private JMenuItem preferencesItem;
    private JMenu recentMenu;
    private JMenuItem stateMachineItem;
    private JTabbedPane tabbedPane;
    private JMenu toolsMenu;
    private JPanel topPanel;

    public PogoGUI(String string) throws PogoException {
        this();
        this.checkLoadAtStartup(string);
    }

    public PogoGUI(DeviceClass deviceClass, boolean bl) throws PogoException {
        this();
        this.class_panels.addPanels(deviceClass);
        this.tabbedPane.setIconAt(this.class_panels.size() - 1, Utils.getInstance().logoIcon);
        this.reBuildTabbedPane = false;
        this.setTitle(this.applicationTitle(deviceClass));
        ((ClassPanel)this.class_panels.get(0)).getTree().setModified(bl);
    }

    public PogoGUI() throws PogoException {
        useDisplay = true;
        this.initComponents();
        PogoProperty.init();
        this.initOwnComponents();
        this.customizeMenus();
        this.class_panels = new ClassPanels(this);
        ClassPanel classPanel = new ClassPanel(this);
        this.class_panels.add(classPanel);
        this.tabbedPane.add(classPanel);
        this.setIconImage(Utils.getInstance().logoIcon.getImage());
        this.pack();
        this.setScreenPosition(this);
        this.setVisible(true);
        runningApplis.add(this);
    }

    private String applicationTitle(DeviceClass deviceClass) {
        String string = "9.2.1  -  Thu Feb 04 10:47:34 CET 2016";
        string = string.substring(0, string.indexOf(45));
        if (deviceClass != null) {
            return "TANGO Code Generator - " + string + " - " + deviceClass.toString();
        }
        return "TANGO Code Generator - " + string;
    }

    private void checkLoadAtStartup(String string) {
        if (string != null && string.length() > 0) {
            this.loadDeviceClassFromFile(string);
        } else {
            String string2 = Utils.getXmiFile();
            if (string2 != null) {
                this.openItemActionPerformed(null);
            } else if (PogoProperty.loadPrevious && PogoProperty.projectHistory.size() > 0) {
                this.loadDeviceClassFromFile(PogoProperty.projectHistory.get(0));
            }
        }
        startup = false;
    }

    public void setScreenPosition(JFrame jFrame) {
        Serializable serializable;
        Point point = new Point();
        for (int i = runningApplis.size() - 1; i >= 0; --i) {
            serializable = runningApplis.get(i);
            if (!((Component)serializable).isVisible()) continue;
            point = ((Component)serializable).getLocation();
            point.x += 20;
            point.y += 20;
            jFrame.setLocation(point);
            return;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        serializable = toolkit.getScreenSize();
        Dimension dimension = jFrame.getSize();
        point.x = (((Dimension)serializable).width - dimension.width) / 2;
        point.y = (((Dimension)serializable).height - dimension.height) / 2;
        jFrame.setLocation(point);
    }

    private void customizeMenus() {
        this.fileMenu.setMnemonic('F');
        this.newItem.setMnemonic('N');
        this.newItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.openItem.setMnemonic('O');
        this.openItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.generateItem.setMnemonic('G');
        this.generateItem.setAccelerator(KeyStroke.getKeyStroke(71, 2));
        this.exitItem.setMnemonic('E');
        this.exitItem.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.editMenu.setMnemonic('E');
        this.stateMachineItem.setMnemonic('M');
        this.stateMachineItem.setAccelerator(KeyStroke.getKeyStroke(77, 2));
        this.deleteItem.setMnemonic('D');
        this.deleteItem.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        this.moveUpItem.setMnemonic('U');
        this.moveUpItem.setAccelerator(KeyStroke.getKeyStroke(85, 2));
        this.moveDownItem.setMnemonic('D');
        this.moveDownItem.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        this.preferencesItem.setMnemonic('P');
        this.preferencesItem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.toolsMenu.setMnemonic('T');
        if (!Utils.osIsUnix()) {
            this.toolsMenu.setVisible(false);
        }
        this.multiItem.setMnemonic('M');
        this.multiItem.setAccelerator(KeyStroke.getKeyStroke(77, 3));
        this.helpMenu.setMnemonic('H');
        this.colorItem.setMnemonic('C');
        this.aboutItem.setMnemonic('A');
        this.manageRecentMenu(null);
    }

    private void manageRecentMenu(String string) {
        try {
            if (string == null && PogoProperty.projectHistory.size() == 0) {
                return;
            }
            if (this.tabbedPane.getSelectedIndex() > 0) {
                return;
            }
            if (string != null) {
                PogoProperty.addProject(string, 0);
            }
            this.recentMenu.removeAll();
            for (String string2 : PogoProperty.projectHistory) {
                JMenuItem jMenuItem = new JMenuItem(string2);
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        PogoGUI.this.recentItemActionPerformed(actionEvent);
                    }
                });
                this.recentMenu.add(jMenuItem);
            }
        }
        catch (Exception exception) {
            System.err.println("\nWARNING:\t" + exception);
        }
    }

    private void initOwnComponents() {
        Utils utils = Utils.getInstance();
        this.addTopPanelButton(utils.reloadIcon, "Reload Class", false);
        this.addTopPanelButton(utils.newIcon, "New Class", false);
        this.addTopPanelButton(utils.openIcon, "Open Class", false);
        this.addTopPanelButton(utils.saveIcon, "Generate Class", false);
        JLabel jLabel = new JLabel("      Palette:");
        jLabel.setFont(new Font("Dialog", 1, 12));
        this.topPanel.add(jLabel);
        this.addTopPanelButton(utils.classPropertyIcon, "Add Class Property", true);
        this.addTopPanelButton(utils.devicePropertyIcon, "Add Device Property", true);
        this.addTopPanelButton(utils.cmdIcon, "Add Command", true);
        this.addTopPanelButton(utils.scalarIcon, "Add ScalarAttribute", true);
        this.addTopPanelButton(utils.spectrumIcon, "Add Spectrum Attribute", true);
        this.addTopPanelButton(utils.imageIcon, "Add ImageAttribute", true);
        this.addTopPanelButton(utils.forwardedIcon, "Add Forwarded Attribute", true);
        this.addTopPanelButton(utils.pipeIcon, "Add Pipe", true);
        this.addTopPanelButton(utils.stateIcon, "Add State", true);
        jLabel = new JLabel("           ");
        this.topPanel.add(jLabel);
        this.languageLabel = new JLabel("");
        this.topPanel.add(this.languageLabel);
        this.languageMenu = new LanguagePopupMenu(this.languageLabel);
        this.languageLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                PogoGUI.this.languageMenu.showMenu(mouseEvent);
            }
        });
        homeDir = System.getenv("SOURCE_PATH");
        if (homeDir == null && (homeDir = System.getProperty("SOURCE_PATH")) == null) {
            homeDir = new File("").getAbsolutePath();
        }
        chooser = new JFileChooser(new File(homeDir).getAbsolutePath());
        chooser.setFileFilter(pogo6Filter);
        chooser.setFileFilter(pogoFilter);
    }

    public void setLanguageLogo(String string) {
        if (string.toLowerCase().equals("cpp")) {
            this.languageLabel.setIcon(Utils.getInstance().cppLogo);
        } else if (string.toLowerCase().equals("java")) {
            this.languageLabel.setIcon(Utils.getInstance().javaLogo);
        } else if (string.toLowerCase().equals("python")) {
            this.languageLabel.setIcon(Utils.getInstance().pythonLogo);
        } else if (string.toLowerCase().equals("pythonhl")) {
            this.languageLabel.setIcon(Utils.getInstance().pythonHLLogo);
        }
        this.pack();
    }

    private void addTopPanelButton(ImageIcon imageIcon, String string, final boolean bl) {
        JButton jButton = new JButton(imageIcon);
        jButton.setToolTipText(Utils.buildToolTip(string));
        jButton.setBorder(new SoftBevelBorder(0));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (bl) {
                    PogoGUI.this.paletteActionPerformed(actionEvent);
                } else {
                    PogoGUI.this.topButtonActionPerformed(actionEvent);
                }
            }
        });
        this.topPanel.add(jButton);
        this.topButtons.add(jButton);
    }

    private void initComponents() {
        this.inherPanel = new JPanel();
        this.topPanel = new JPanel();
        this.tabbedPane = new JTabbedPane();
        JMenuBar jMenuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.newItem = new JMenuItem();
        this.openItem = new JMenuItem();
        this.recentMenu = new JMenu();
        JMenuItem jMenuItem = new JMenuItem();
        this.generateItem = new JMenuItem();
        this.packageItem = new JMenuItem();
        JMenuItem jMenuItem2 = new JMenuItem();
        this.exitItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.stateMachineItem = new JMenuItem();
        JSeparator jSeparator = new JSeparator();
        this.deleteItem = new JMenuItem();
        this.moveUpItem = new JMenuItem();
        this.moveDownItem = new JMenuItem();
        this.preferencesItem = new JMenuItem();
        JMenuItem jMenuItem3 = new JMenuItem();
        this.toolsMenu = new JMenu();
        this.multiItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.colorItem = new JMenuItem();
        JMenuItem jMenuItem4 = new JMenuItem();
        this.aboutItem = new JMenuItem();
        JSeparator jSeparator2 = new JSeparator();
        JMenuItem jMenuItem5 = new JMenuItem();
        JMenuItem jMenuItem6 = new JMenuItem();
        JMenuItem jMenuItem7 = new JMenuItem();
        JMenuItem jMenuItem8 = new JMenuItem();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                PogoGUI.this.exitForm(windowEvent);
            }
        });
        this.inherPanel.setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.inherPanel, "East");
        this.topPanel.setLayout(new FlowLayout(0));
        this.getContentPane().add((Component)this.topPanel, "First");
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                PogoGUI.this.tabbedPaneStateChanged(changeEvent);
            }
        });
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.fileMenu.setText("File");
        this.fileMenu.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                PogoGUI.this.fileMenuStateChanged(changeEvent);
            }
        });
        this.newItem.setText("New");
        this.newItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PogoGUI.this.newItemActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.newItem);
        this.openItem.setText("Open");
        this.openItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PogoGUI.this.openItemActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.openItem);
        this.recentMenu.setText("Open Recent");
        jMenuItem.setText("...");
        this.recentMenu.add(jMenuItem);
        this.fileMenu.add(this.recentMenu);
        this.generateItem.setText("Generate");
        this.generateItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PogoGUI.this.generateItemActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.generateItem);
        this.packageItem.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        this.packageItem.setText("Export Package");
        this.packageItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PogoGUI.this.packageItemActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.packageItem);
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        jMenuItem2.setText("Re-Load project");
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PogoGUI.this.reLoadItemActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(jMenuItem2);
        this.exitItem.setText("Exit");
        this.exitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PogoGUI.this.exitItemActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.exitItem);
        jMenuBar.add(this.fileMenu);
        this.editMenu.setText("Edit");
        this.editMenu.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                PogoGUI.this.editMenuStateChanged(changeEvent);
            }
        });
        this.stateMachineItem.setText("State Machine");
        this.stateMachineItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PogoGUI.this.stateMachineItemActionPerformed(actionEvent);
            }
        });
        this.editMenu.add(this.stateMachineItem);
        this.editMenu.add(jSeparator);
        this.deleteItem.setText("Delete Selection");
        this.deleteItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PogoGUI.this.deleteItemActionPerformed(actionEvent);
            }
        });
        this.editMenu.add(this.deleteItem);
        this.moveUpItem.setText("Move Up");
        this.moveUpItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PogoGUI.this.moveUpItemActionPerformed(actionEvent);
            }
        });
        this.editMenu.add(this.moveUpItem);
        this.moveDownItem.setText("Move Down");
        this.moveDownItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PogoGUI.this.moveDownItemActionPerformed(actionEvent);
            }
        });
        this.editMenu.add(this.moveDownItem);
        this.preferencesItem.setText("Preferences");
        this.preferencesItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PogoGUI.this.preferencesItemActionPerformed(actionEvent);
            }
        });
        this.editMenu.add(this.preferencesItem);
        jMenuItem3.setText("Site Preferences");
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PogoGUI.this.sitePreferencesItemActionPerformed(actionEvent);
            }
        });
        this.editMenu.add(jMenuItem3);
        jMenuBar.add(this.editMenu);
        this.toolsMenu.setText("Tools");
        this.multiItem.setText("Multi Cpp Classes Manager");
        this.multiItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PogoGUI.this.multiItemActionPerformed(actionEvent);
            }
        });
        this.toolsMenu.add(this.multiItem);
        jMenuBar.add(this.toolsMenu);
        this.helpMenu.setText("Help");
        this.colorItem.setText("On Color");
        this.colorItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PogoGUI.this.colorItemActionPerformed(actionEvent);
            }
        });
        this.helpMenu.add(this.colorItem);
        jMenuItem4.setText("Release Notes");
        jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PogoGUI.this.releaseItemActionPerformed(actionEvent);
            }
        });
        this.helpMenu.add(jMenuItem4);
        this.aboutItem.setText("about");
        this.aboutItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PogoGUI.this.aboutItemActionPerformed(actionEvent);
            }
        });
        this.helpMenu.add(this.aboutItem);
        this.helpMenu.add(jSeparator2);
        jMenuItem5.setText("Tango Pages");
        jMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PogoGUI.this.tangoItemActionPerformed(actionEvent);
            }
        });
        this.helpMenu.add(jMenuItem5);
        jMenuItem6.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        jMenuItem6.setText("Pogo Pages");
        jMenuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PogoGUI.this.pogoItemActionPerformed(actionEvent);
            }
        });
        this.helpMenu.add(jMenuItem6);
        jMenuItem7.setText("Kernel Pages");
        jMenuItem7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PogoGUI.this.kernelItemActionPerformed(actionEvent);
            }
        });
        this.helpMenu.add(jMenuItem7);
        jMenuItem8.setText("Device Class Pages");
        jMenuItem8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PogoGUI.this.classItemActionPerformed(actionEvent);
            }
        });
        this.helpMenu.add(jMenuItem8);
        jMenuBar.add(this.helpMenu);
        this.setJMenuBar(jMenuBar);
        this.pack();
    }

    private void recentItemActionPerformed(ActionEvent actionEvent) {
        String string = ((JMenuItem)actionEvent.getSource()).getText();
        this.loadDeviceClassFromFile(string);
    }

    private void openItemActionPerformed(ActionEvent actionEvent) {
        File file;
        chooser.setFileFilter(pogoFilter);
        if (chooser.showOpenDialog(this) == 0 && (file = chooser.getSelectedFile()) != null && !file.isDirectory()) {
            homeDir = file.getParentFile().toString();
            this.loadDeviceClassFromFile(file.getAbsolutePath());
        }
    }

    private void buildTree(DeviceClass deviceClass) {
        ClassIdentification classIdentification = deviceClass.getPogoDeviceClass().getDescription().getIdentification();
        if (classIdentification == null && !Utils.isTrue(System.getenv("TEST_MODE"))) {
            Utils.getInstance().stopSplashRefresher();
            this.setCursor(new Cursor(0));
            DeviceIdDialog deviceIdDialog = new DeviceIdDialog(this);
            if (deviceIdDialog.showDialog() == 0) {
                classIdentification = deviceIdDialog.getInputs();
                deviceClass.getPogoDeviceClass().getDescription().setIdentification(classIdentification);
            } else {
                return;
            }
        }
        this.reBuildTabbedPane = true;
        this.tabbedPane.removeAll();
        this.class_panels.addPanels(deviceClass);
        this.tabbedPane.setIconAt(this.class_panels.size() - 1, Utils.getInstance().logoIcon);
        this.reBuildTabbedPane = false;
    }

    private void exitItemActionPerformed(ActionEvent actionEvent) {
        this.exitAppli();
    }

    private void exitForm(WindowEvent windowEvent) {
        if (this.exitAppli() == 2) {
            new SetVisibleLater(this).start();
        }
    }

    private int checkModifications() {
        for (ClassPanel classPanel : this.class_panels) {
            if (classPanel.getTree() == null || !classPanel.getTree().getModified()) continue;
            String string = classPanel.getName();
            Object[] objectArray = new Object[]{"Generate", "Discard", "Cancel"};
            switch (JOptionPane.showOptionDialog(this, string + " project has not been generated !\n\n", "Warning", -1, 2, null, objectArray, objectArray[0])) {
                case 0: {
                    this.generateSourceFiles(classPanel.getTree());
                    break;
                }
                case 1: {
                    break;
                }
                case -1: 
                case 2: {
                    return 2;
                }
            }
        }
        return 0;
    }

    private int exitAppli() {
        if (this.checkModifications() == 0) {
            this.setVisible(false);
            for (JFrame jFrame : runningApplis) {
                if (!jFrame.isVisible()) continue;
                return 0;
            }
            if (multiClassesPanel != null && multiClassesPanel.isVisible()) {
                return 0;
            }
            System.exit(0);
        }
        return 2;
    }

    String getMainClassName() {
        return this.class_panels.getPanelNameAt(0);
    }

    private void generateItemActionPerformed(ActionEvent actionEvent) {
        int n = this.tabbedPane.getSelectedIndex();
        ClassTree classTree = this.class_panels.getSelectedTree();
        if (classTree == null) {
            return;
        }
        this.generateSourceFiles(classTree);
    }

    private boolean generateSourceFiles(ClassTree classTree) {
        GenerateDialog generateDialog = new GenerateDialog(this);
        DeviceClass deviceClass = classTree.getDeviceClass();
        if (deviceClass == null) {
            return true;
        }
        if (generateDialog.showDialog(deviceClass) == 0) {
            Cursor cursor = new Cursor(3);
            this.setCursor(cursor);
            try {
                deviceClass = generateDialog.getDevClass();
                Utils.getInstance().startSplashRefresher("Generate class: " + deviceClass.getPogoDeviceClass().getName());
                deviceClass.generate(classTree.getDeletedObjects(), classTree.getRenamedObjects());
                Utils.getInstance().stopSplashRefresher();
                classTree.setModified(false);
                classTree.setSrcPath(deviceClass.getPogoDeviceClass().getDescription().getSourcePath());
                this.manageRecentMenu(deviceClass.getProjectFilename());
            }
            catch (Exception exception) {
                Utils.getInstance().stopSplashRefresher();
                cursor = new Cursor(0);
                this.setCursor(cursor);
                PogoException.popup((Component)this, exception);
                return false;
            }
            cursor = new Cursor(0);
            this.setCursor(cursor);
            return true;
        }
        return false;
    }

    private void newItemActionPerformed(ActionEvent actionEvent) {
        ClassDialog classDialog = new ClassDialog(this);
        if (classDialog.showDialog() == 0) {
            DeviceClass deviceClass = classDialog.getInputs();
            if (this.class_panels.getSelectedTree() != null) {
                try {
                    new PogoGUI(deviceClass, true);
                    return;
                }
                catch (Exception exception) {
                    Utils.getInstance().stopSplashRefresher();
                    PogoException.popup((Component)this, exception);
                }
            }
            this.reBuildTabbedPane = true;
            this.tabbedPane.removeAll();
            this.class_panels.addPanels(deviceClass);
            this.tabbedPane.setIconAt(this.class_panels.size() - 1, Utils.getInstance().logoIcon);
            this.class_panels.checkWarnings();
            this.reBuildTabbedPane = false;
        }
    }

    private void deleteItemActionPerformed(ActionEvent actionEvent) {
        ClassTree classTree = this.class_panels.getSelectedTree();
        Object object = classTree.getSelectedEditableObject();
        if (object != null) {
            classTree.removeSelectedItem();
        }
    }

    private void moveUpItemActionPerformed(ActionEvent actionEvent) {
        ClassTree classTree = this.class_panels.getSelectedTree();
        Object object = classTree.getSelectedEditableObject();
        if (object != null) {
            classTree.moveSelectedItem(true);
        }
    }

    private void moveDownItemActionPerformed(ActionEvent actionEvent) {
        ClassTree classTree = this.class_panels.getSelectedTree();
        Object object = classTree.getSelectedEditableObject();
        if (object != null) {
            classTree.moveSelectedItem(false);
        }
    }

    private void reloadProject() {
        String string;
        if (this.class_panels.getSelectedTree() != null && this.checkModifications() == 0 && (string = ((ClassPanel)this.class_panels.get(0)).getTree().getClassFileName()) != null) {
            this.loadDeviceClassFromFile(string, false);
        }
    }

    private void topButtonActionPerformed(ActionEvent actionEvent) {
        JButton jButton = (JButton)actionEvent.getSource();
        block6: for (int i = 0; i < this.topButtons.size(); ++i) {
            if (this.topButtons.get(i) != jButton) continue;
            switch (i) {
                case 0: {
                    this.reloadProject();
                    continue block6;
                }
                case 1: {
                    this.newItemActionPerformed(actionEvent);
                    continue block6;
                }
                case 2: {
                    this.openItemActionPerformed(actionEvent);
                    continue block6;
                }
                case 3: {
                    this.generateItemActionPerformed(actionEvent);
                }
            }
        }
    }

    private void paletteActionPerformed(ActionEvent actionEvent) {
        ClassTree classTree = this.class_panels.getSelectedTree();
        if (classTree != null) {
            JButton jButton = (JButton)actionEvent.getSource();
            String string = jButton.getToolTipText();
            classTree.addItem(string);
        }
    }

    private void stateMachineItemActionPerformed(ActionEvent actionEvent) {
        ClassTree classTree = this.class_panels.getSelectedTree();
        if (classTree != null) {
            classTree.editStateMachine();
        }
    }

    private void editMenuStateChanged(ChangeEvent changeEvent) {
        if (this.class_panels == null) {
            return;
        }
        ClassTree classTree = this.class_panels.getSelectedTree();
        boolean bl = classTree != null && (!this.editMenu.isSelected() || classTree.getSelectedEditableObject() != null);
        this.deleteItem.setEnabled(bl);
        this.moveUpItem.setEnabled(bl);
        this.moveDownItem.setEnabled(bl);
    }

    private void colorItemActionPerformed(ActionEvent actionEvent) {
        new PopupColorCode(this).setVisible(true);
    }

    private void aboutItemActionPerformed(ActionEvent actionEvent) {
        JOptionPane.showMessageDialog(this, "             Pogo  (Tango Code Generator)\nThis programme is able to generate, update and modify\n                 Tango device classes.\n\n9.2.1  -  Thu Feb 04 10:47:34 CET 2016\n\nhttp://www.tango-controls.org/     -    tango@esrf.fr", "Help Window", 1);
    }

    private void tabbedPaneStateChanged(ChangeEvent changeEvent) {
        this.class_panels.updateInheritancePanelForSelection();
    }

    private void preferencesItemActionPerformed(ActionEvent actionEvent) {
        new PreferencesDialog(this).setVisible(true);
    }

    private void releaseItemActionPerformed(ActionEvent actionEvent) {
        new PopupHtml(this).show("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\">\n<HTML>\n<HEAD>\n<Title> Release Note </Title>\n</HEAD>\n<BODY TEXT=\"#000000\" BGCOLOR=\"#FFFFFF\" LINK=\"#0000FF\" VLINK=\"#7F00FF\" ALINK=\"#FF0000\">\n<P><!-------TITLE------></P>\n<Center>\t<h2>Pogo Release Note</h2>\n\t(Generated Thu Feb 04 10:47:34 CET 2016)</Center><Br>\n<li><b>Pogo-9.2.1 - 04/02/2016:</b><Br>\n&nbsp; &nbsp; Improve Python and PythonHL templates for inheritance<Br>\n<li><b>Pogo-9.2.0 - 20/01/2016:</b><Br>\n&nbsp; &nbsp; Improve check name for forwarded attributes.<Br>\n<li><b>Pogo-9.1.12 - 02/12/2015:</b><Br>\n&nbsp; &nbsp; Fix a problem in relative path for multi classes project.<Br>\n<li><b>Pogo-9.1.11 - 01/12/2015:</b><Br>\n&nbsp; &nbsp; Bugs in dynamic commands fixed.<Br>\n<li><b>Pogo-9.1.10 - 25/11/2015:</b><Br>\n&nbsp; &nbsp; Fix bug in DevLong64 java property type<Br>\n&nbsp; &nbsp; Improve Python templates (path handling bug fix, protected region for run method)<Br>\n<li><b>Pogo-9.1.9 - 20/11/2015:</b><Br>\n&nbsp; &nbsp; Fix a bug protected area when rename attribute on c++.<Br>\n&nbsp; &nbsp; Fix a problem in relative path for multi classes project.<Br>\n<li><b>Pogo-9.1.8 - 19/11/2015:</b><Br>\n&nbsp; &nbsp; Add a potected region in main method for java code.<Br>\n&nbsp; &nbsp; Add colors on State objects.<Br>\n<li><b>Pogo-9.1.7 - 02/10/2015:</b><Br>\n&nbsp; &nbsp; Manage relative path for inheritance and multiple classes project.<Br>\n&nbsp; &nbsp; Improve State machine window.<Br>\n<li><b>Pogo-9.1.6 - 17/09/2015:</b><Br>\n&nbsp; &nbsp; Improve Python HL templates once more.<Br>\n<li><b>Pogo-9.1.5 - 25/08/2015:</b><Br>\n&nbsp; &nbsp; Attribute name can start with '_'<Br>\n<li><b>Pogo-9.1.4 - 14/08/2015:</b><Br>\n&nbsp; &nbsp; Remove DevVarBooleanArray for command (not supported)<Br>\n<li><b>Pogo-9.1.3 - 04/08/2015:</b><Br>\n&nbsp; &nbsp; Add move class on multi classes tree<Br>\n&nbsp; &nbsp; Improve attribute summary<Br>\n&nbsp; &nbsp; Improve State machine dialog size management.<Br>\n&nbsp; &nbsp; Add protected region at end of state machine file.<Br>\n<li><b>Pogo-9.1.2 - 30/06/2015:</b><Br>\n&nbsp; &nbsp; Visual C++ 12 project are available for Tango-9<Br>\n&nbsp; &nbsp; Improve Python HL templates.<Br>\n&nbsp; &nbsp; Add several missing types for properties.<Br>\n<li><b>Pogo-9.1.0 - 12/05/2015:</b><Br>\n&nbsp; &nbsp; Pogo is now compiled using java 1.7<Br>\n&nbsp; &nbsp; Double cotes supported in class description and title,<Br>\n<li><b>Pogo-9.0.6 - 06/05/2015:</b><Br>\n&nbsp; &nbsp; Java forwarded attributes are available.<Br>\n&nbsp; &nbsp; Improve enum management.<Br>\n&nbsp; &nbsp; Fix a bug with void argin on dynamic command<Br>\n<li><b>Pogo-9.0.5 - 27/04/2015:</b><Br>\n&nbsp; &nbsp; Problem on void dynamic command fixed.<Br>\n<li><b>Pogo-9.0.4 - 19/03/2015:</b><Br>\n&nbsp; &nbsp; PythonHL bug fixes.<Br>\n&nbsp; &nbsp; PythonHL test added.<Br>\n<li><b>Pogo-9.0.3 - 20/01/2015:</b><Br>\n&nbsp; &nbsp; PythonHL bug fixes.<Br>\n&nbsp; &nbsp; PythonHL Project directory added.<Br>\n<li><b>Pogo-9.0.2 - 16/12/2014:</b><Br>\n&nbsp; &nbsp; Fix a problem in path management for multiple classes tool.<Br>\n<li><b>Pogo-9.0.1 - 29/10/2014:</b><Br>\n&nbsp; &nbsp; PythonHL code generation added (not tested).<Br>\n<li><b>Pogo-9.0.0 - 01/10/2014:</b><Br>\n&nbsp; &nbsp; Tango-9 features added for C++ and java.<Br>\n<li><b>Pogo-8.4.8 - 29/08/2014:</b><Br>\n&nbsp; &nbsp; Fix bugs on adding state and property type display.<Br>\n<li><b>Pogo-8.4.7 - 18/06/2014:</b><Br>\n&nbsp; &nbsp; Fix a problem in linuxMakefile for additional files.<Br>\n<li><b>Pogo-8.4.6 - 12/06/2014:</b><Br>\n&nbsp; &nbsp; Add an environment variable (MANAGE_WRITE_METHOD=false) to do not modify write_xxx method.<Br>\n<li><b>Pogo-8.4.5 - 23/04/2014:</b><Br>\n&nbsp; &nbsp; Inverse order between allocation and mandatory test in init_device().<Br>\n<li><b>Pogo-8.4.4 - 07/04/2014:</b><Br>\n&nbsp; &nbsp; Fix a problem with pushEvent in java classes.<Br>\n&nbsp; &nbsp; Remove evironment variable _812_ (tango-8.1.2)<Br>\n<li><b>Pogo-8.4.3 - 25/03/2014:</b><Br>\n&nbsp; &nbsp; Improve python dynamic attribute management.<Br>\n<li><b>Pogo-8.4.2 - 19/03/2014:</b><Br>\n&nbsp; &nbsp; Fix problem in python when memorized attribute does not have property.<Br>\n&nbsp; &nbsp; Fix problem on scalar attribute value.<Br>\n<li><b>Pogo-8.4.0 - 26/02/2014:</b><Br>\n&nbsp; &nbsp; Replace TangORB.jar and ATK*.jar by a tango_ulight.jar file,<Br>\n&nbsp; &nbsp; containing only 2 tangorb classes and 5 atk classes,<Br>\n&nbsp; &nbsp; to decrease the org.tango.pogo.jar size (~14 Mbytes).<Br>\n<li><b>Pogo-8.3.5 - 20/02/2014:</b><Br>\n&nbsp; &nbsp; Add a protected region in main method for python class<Br>\n<li><b>Pogo-8.3.4 - 27/01/2014:</b><Br>\n&nbsp; &nbsp; Add a protected region for programmer methods in python class<Br>\n&nbsp; &nbsp; Fix a problem in changing language.<Br>\n<li><b>Pogo-8.3.3 - 17/01/2014:</b><Br>\n&nbsp; &nbsp; Fix a bug in Pogo Multiple classes.<Br>\n&nbsp; &nbsp; Modified linux Makefile for shared libs<Br>\n<li><b>Pogo-8.3.2 - 17/01/2014:</b><Br>\n&nbsp; &nbsp; Fix another problem on python class with inheritance.<Br>\n<li><b>Pogo-8.3.1 - 07/01/2014:</b><Br>\n&nbsp; &nbsp; Fix a problem on python class with inheritance.<Br>\n<li><b>Pogo-8.3.0 - 29/11/2013:</b><Br>\n&nbsp; &nbsp; First release with packaging feature.<Br>\n&nbsp; &nbsp; Add javadoc throw tag for java classes.;<Br>\n<li><b>Pogo-8.2.7 - 28/11/2013:</b><Br>\n&nbsp; &nbsp; Fix a problem in property default values for java classes.<Br>\n<li><b>Pogo-8.2.6 - 18/11/2013:</b><Br>\n&nbsp; &nbsp; Fix problem in case of exception thrown by an inherited class during startup phase.<Br>\n&nbsp; &nbsp; Update Tango kernel link for inheritance documentation.<Br>\n<li><b>Pogo-8.2.5 - 15/11/2013:</b><Br>\n&nbsp; &nbsp; Fix bug in void returning commands in python classes.<Br>\n<li><b>Pogo-8.2.4 - 08/11/2013:</b><Br>\n&nbsp; &nbsp; Improve State and Status execute method code in Python classes.<Br>\n&nbsp; &nbsp; Manage state machine for write attribute in Python classes.<Br>\n<li><b>Pogo-8.2.3 - 06/11/2013:</b><Br>\n&nbsp; &nbsp; Problem to overload State and Status commands in Python classes fixed.<Br>\n&nbsp; &nbsp; Problem in String attribute initialization for Java classes fixed<Br>\n<li><b>Pogo-8.2.2 - 17/10/2013:</b><Br>\n&nbsp; &nbsp; Fix a NullPointerException when class come from pogo-6 class without TangoClassID.txt file.<Br>\n<li><b>Pogo-8.2.1 - 15/10/2013:</b><Br>\n&nbsp; &nbsp; Fix problems in multiple classes server Makefile.<Br>\n&nbsp; &nbsp; Add new Tango logo.<Br>\n<li><b>Pogo-8.2.0 - 14/10/2013:</b><Br>\n&nbsp; &nbsp; Add event management for java.<Br>\n<li><b>Pogo-8.1.18 - 01/10/2013:</b><Br>\n&nbsp; &nbsp; Change boolean attribute java method name.<Br>\n<li><b>Pogo-8.1.17 - 13/09/2013:</b><Br>\n&nbsp; &nbsp; Improve properties and Attribute/Command/Property dialogs.<Br>\n<li><b>Pogo-8.1.16 - 11/09/2013:</b><Br>\n&nbsp; &nbsp; Crash reporting management added on main.cpp.<Br>\n<li><b>Pogo-8.1.15 - 02/09/2013:</b><Br>\n&nbsp; &nbsp; Improve get<Attribute> method for java class.<Br>\n<li><b>Pogo-8.1.14 - 26/06/2013:</b><Br>\n&nbsp; &nbsp; Add Tango-8.1.2 specific features.<Br>\n&nbsp; &nbsp; Fix a problem with state machine when attribute is modified.<Br>\n&nbsp; &nbsp; Improve documentation generation to be used by Class2www classes.<Br>\n<li><b>Pogo-8.1.13 - 03/05/2013:</b><Br>\n&nbsp; &nbsp; Improve documentation generation to be used by Class2www cleasses.<Br>\n<li><b>Pogo-8.1.12 - 02/05/2013:</b><Br>\n&nbsp; &nbsp; Improve edit source file feature.<Br>\n<li><b>Pogo-8.1.11 - 26/04/2013:</b><Br>\n&nbsp; &nbsp; Problem on READ_WITH_WRITE fixed.<Br>\n<li><b>Pogo-8.1.10 - 05/04/2013:</b><Br>\n&nbsp; &nbsp; State/Status polling problem fixed.<Br>\n&nbsp; &nbsp; Problem on makefile for multi classes with inheritance fixed.<Br>\n<li><b>Pogo-8.1.9 - 04/03/2013:</b><Br>\n&nbsp; &nbsp; Fix problem on string dynamic attribute does not compile due to a mix of const char * and char * data type<Br>\n<li><b>Pogo-8.1.8 - 08/02/2013:</b><Br>\n&nbsp; &nbsp; Check for special char on state description.<Br>\n&nbsp; &nbsp; Force to not memorized for spectrum/image attribute cloned from a scalar one.<Br>\n<li><b>Pogo-8.1.7 - 07/02/2013:</b><Br>\n&nbsp; &nbsp; Fix problem in include path in VC9 projects.<Br>\n<li><b>Pogo-8.1.6 - 06/02/2013:</b><Br>\n&nbsp; &nbsp; Fix a problem with bad char in VC9 project.<Br>\n&nbsp; &nbsp; Change lib and include pathes in VC9 projects.<Br>\n<li><b>Pogo-8.1.5 - 18/01/2013:</b><Br>\n&nbsp; &nbsp; Problem in command using DevEncoded fixed.<Br>\n<li><b>Pogo-8.1.4 - 15/01/2013:</b><Br>\n&nbsp; &nbsp; Eclipse project added for C++ classes.<Br>\n&nbsp; &nbsp; Add a popup menu on main window to change language.<Br>\n&nbsp; &nbsp; Problem in string spectrum write attribute fixed.<Br>\n<li><b>Pogo-8.1.3 - 19/11/2012:</b><Br>\n&nbsp; &nbsp; Fix problem in class/device property description for python.<Br>\n<li><b>Pogo-8.1.2 - 05/11/2012:</b><Br>\n&nbsp; &nbsp; Fix a problem on inheritance.<Br>\n&nbsp; &nbsp; Fix a problem on remove dynamic attribute.<Br>\n<li><b>Pogo-8.1.1 - 23/10/2012:</b><Br>\n&nbsp; &nbsp; Problems in python due to generated file name fixed.<Br>\n&nbsp; &nbsp; Remove the Soleil special case.<Br>\n&nbsp; &nbsp; Problem links to sub-directory in java fixed.<Br>\n<li><b>Pogo-8.1.0 - 22/10/2012:</b><Br>\n&nbsp; &nbsp; XTend replaces XPand to define templates.<Br>\n&nbsp; &nbsp; C++ and html templates have been re written using xtend.<Br>\n&nbsp; &nbsp; Java and Python generators are now available.<Br>\n<li><b>Pogo-8.0.8 - 10/08/2012:</b><Br>\n&nbsp; &nbsp; Add methods for future compatibility.<Br>\n<li><b>Pogo-8.0.7 - 07/08/2012:</b><Br>\n&nbsp; &nbsp; Pb in generate dialog for multi class project fixed.<Br>\n<li><b>Pogo-8.0.7 - 27/06/2012:</b><Br>\n&nbsp; &nbsp; Problem in allocation data member when inherited fixed.<Br>\n<li><b>Pogo-8.0.6 - 21/06/2012:</b><Br>\n&nbsp; &nbsp; Problem in write dynamic attribute fixed.<Br>\n<li><b>Pogo-8.0.5 - 11/06/2012:</b><Br>\n&nbsp; &nbsp; VC 10 pb with dll fixed.<Br>\n<li><b>Pogo-8.0.4 - 04/06/2012:</b><Br>\n&nbsp; &nbsp; zmq.lib added to vc9 project.<Br>\n<li><b>Pogo-8.0.3 - 29/05/2012:</b><Br>\n&nbsp; &nbsp; Improve vc10 project.<Br>\n&nbsp; &nbsp; Modify file filter for java classes.<Br>\n<li><b>Pogo-8.0.2 - 03/05/2012:</b><Br>\n&nbsp; &nbsp; Bug on abstract command inherited fixed.<Br>\n<li><b>Pogo-8.0.1 - 05/04/2012:</b><Br>\n&nbsp; &nbsp; Pb with inherited object when DevRestart command received fixed.<Br>\n&nbsp; &nbsp; Event criteria management added for attributes (new Tango 8 feature)<Br>\n&nbsp; &nbsp; Pb in inheritance for attribute_factory() fixed.<Br>\n<li><b>Pogo-8.0.0 - 05/03/2012:</b><Br>\n&nbsp; &nbsp; Improve inheritance<Br>\n&nbsp; &nbsp; Add polling on State and Status<Br>\n&nbsp; &nbsp; Make corrections to remove warnings when compile with -Wall<Br>\n&nbsp; &nbsp; Add ULong64 and ULong64Array.<Br>\n&nbsp; &nbsp; Add DevEncoded for Command.<Br>\n&nbsp; &nbsp; Fix a problem in non double dynamic attribute.<Br>\n<li><b>Pogo-7.5.0 - 30/01/2012:</b><Br>\n&nbsp; &nbsp; Win64/VC10 project added.<Br>\n&nbsp; &nbsp; Call for init/delete device and command factory added when class is inherited.<Br>\n<li><b>Pogo-7.4.0 - 01/12/2011:</b><Br>\n&nbsp; &nbsp; Workflow upgrade (Eclipse-3.7, XText-2.0, XPand-1.1)<Br>\n<li><b>Pogo-7.3.2 - 08/09/2011:</b><Br>\n&nbsp; &nbsp; Bug with DevVarLongStringArray and DevVarDoubleStringArray fixed.<Br>\n<li><b>Pogo-7.3.1 - 27/07/2011:</b><Br>\n&nbsp; &nbsp; Pb with dev_state() method in case of ALARM state fixed.<Br>\n&nbsp; &nbsp; Pb in case of main.cpp missing (convertion from pogo-6) fixed.<Br>\n&nbsp; &nbsp; Buttons for java projects added.<Br>\n<li><b>Pogo-7.3.0 - 27/07/2011:</b><Br>\n&nbsp; &nbsp; Dynamic attributes management added.<Br>\n<li><b>Pogo-7.2.7 - 15/06/2011:</b><Br>\n&nbsp; &nbsp; Problem in property dialog (description & default value) fixed.<Br>\n<li><b>Pogo-7.2.6 - 19/05/2011:</b><Br>\n&nbsp; &nbsp; Mandatory device property management added.<Br>\n&nbsp; &nbsp; Change ToolTips management.<Br>\n<li><b>Pogo-7.2.5 - 16/05/2011:</b><Br>\n&nbsp; &nbsp; Litle bug in checkLinesToRemove() method fixed.<Br>\n&nbsp; &nbsp; Problem with omniORB library release number in vc project files fixed.<Br>\n<li><b>Pogo-7.2.4 - 02/05/2011:</b><Br>\n&nbsp; &nbsp; Pb in headers when class name has changed fixed.<Br>\n<li><b>Pogo-7.2.3 - 19/04/2011:</b><Br>\n&nbsp; &nbsp; Associated attribute for READ_WITH_WRITE added.<Br>\n&nbsp; &nbsp; Fixe a pb between Long and Long64.<Br>\n<li><b>Pogo-7.2.2 - 15/04/2011:</b><Br>\n&nbsp; &nbsp; Does not generate read_xxx() metod if xxx attribute is WRITE type.<Br>\n&nbsp; &nbsp; Add a filter on Tango types for commands.<Br>\n<li><b>Pogo-7.2.1 - 14/03/2011:</b><Br>\n&nbsp; &nbsp; Tools to modified keys (for compatibility with PogoDsl changes) in xmi file added.<Br>\n&nbsp; &nbsp; Exclude not generated files from vcX_proj dir for workflow.<Br>\n<li><b>Pogo-7.2.0 - 16/02/2011:</b><Br>\n&nbsp; &nbsp; Multi classes manager tool added.<Br>\n&nbsp; &nbsp; Additional files added for Makefile and vc9 projects.<Br>\n&nbsp; &nbsp; VC9 project templates improved.<Br>\n&nbsp; &nbsp; Bug in multi lines attribute description fixed.<Br>\n<li><b>Pogo-7.1.1 - 14/02/2011:</b><Br>\n&nbsp; &nbsp; Does not generate Classfactory.cpp and main.cpp if clas is abstract.<Br>\n&nbsp; &nbsp; Pb in commands table fixed.<Br>\n<li><b>Pogo-7.1.0 - 10/02/2011:</b><Br>\n&nbsp; &nbsp; Class name change is now managed.<Br>\n&nbsp; &nbsp; If a xmi file is in current directory, it is proposed to be loaded.<Br>\n<li><b>Pogo-7.0.8 - 07/02/2011:</b><Br>\n&nbsp; &nbsp; Pb in command factory (args description) fixed.<Br>\n&nbsp; &nbsp; Fire DatReady event added on attribute.<Br>\n<li><b>Pogo-7.0.7 - 01/02/2011:</b><Br>\n&nbsp; &nbsp; VC9 project generation added.<Br>\n<li><b>Pogo-7.0.6 - 27/01/2011:</b><Br>\n&nbsp; &nbsp; The files and sub directories not scaned at workflow is now passed dynamicaly to the workflow.<Br>\n<li><b>Pogo-7.0.5 - 26/01/2011:</b><Br>\n&nbsp; &nbsp; Some files and sub directories are not scaned any more at workflow.<Br>\n<li><b>Pogo-7.0.4 - 04/01/2011:</b><Br>\n&nbsp; &nbsp; Pb with inherited class path for Pogo-6 convertion fixed.<Br>\n<li><b>Pogo-7.0.3 - 20/12/2010:</b><Br>\n&nbsp; &nbsp; Pb with DevVarLongArray and DevVarULongArray fixed.<Br>\n&nbsp; &nbsp; Pb with special characters in comments fixed.<Br>\n<li><b>Pogo-7.0.2 - 15/12/2010:</b><Br>\n&nbsp; &nbsp; Pb on command polled (by default) fixed.<Br>\n<li><b>Pogo-7.0.1 - 30/11/2010:</b><Br>\n&nbsp; &nbsp; State/Status polling forbidden.<Br>\n<li><b>Pogo-7.0.0 - 24/09/2010:</b><Br>\n&nbsp; &nbsp; First release for Tango distribution.<Br>\n</Body>\n</Html>\n", 550, 400);
    }

    private DeviceClass generateFromOldAndReload(DeviceClass deviceClass, String string) throws PogoException {
        Object object;
        boolean bl;
        Utils.getInstance().stopSplashRefresher();
        Cursor cursor = new Cursor(0);
        this.setCursor(cursor);
        String string2 = "         Class:  " + deviceClass.toString() + "  loaded.\n" + "         This device class has been generated by an old version of Pogo\n\n" + "                       Do you want to convert and reload ?\n\n";
        if (deviceClass.isOldPogoModelAbstract()) {
            if (JOptionPane.showConfirmDialog(this, string2, "Confirmation Window", 0) != 0) {
                return null;
            }
            bl = false;
        } else {
            object = deviceClass.getPogoDeviceClass().getDescription().getLanguage().equals("Cpp") ? new String[]{"Convert and Insert User Code", "Convert Class Only", "Cancel"} : new String[]{"Convert Class (code insertion must be done manually)", "Cancel"};
            int n = JOptionPane.showOptionDialog(this, string2, "Confirmation Window", -1, 2, null, object, object[0]);
            switch (n) {
                case 0: {
                    if (OldPogoModel.checkForInheritance(this, deviceClass) == 2) {
                        return null;
                    }
                    bl = true;
                    break;
                }
                case 1: {
                    if (OldPogoModel.checkForInheritance(this, deviceClass) == 2) {
                        return null;
                    }
                    bl = false;
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        cursor = new Cursor(0);
        this.setCursor(cursor);
        Utils.getInstance().startSplashRefresher("Generate  source files fo " + deviceClass.getPogoDeviceClass().getName());
        deviceClass.generateFromOldModel(string, bl);
        object = System.getenv("TEST_MODE");
        String string3 = Utils.isTrue((String)object) ? "/new_src" : "";
        String string4 = Utils.getPath(string) + string3 + "/" + deviceClass.getPogoDeviceClass().getName() + ".xmi";
        Utils.getInstance().startSplashRefresher("Loading  " + Utils.getRelativeFilename(string4));
        deviceClass = new DeviceClass(string4);
        JOptionPane.showMessageDialog(new JFrame(), "Device class source files have been generated in :\n" + Utils.getPath(string) + string3, "Message Window", 1);
        this.manageRecentMenu(deviceClass.getProjectFilename());
        return deviceClass;
    }

    private void reLoadItemActionPerformed(ActionEvent actionEvent) {
        this.reloadProject();
    }

    private void tangoItemActionPerformed(ActionEvent actionEvent) {
        Utils.showInHtmBrowser(PogoConst.tangoHTTP[0]);
    }

    private void kernelItemActionPerformed(ActionEvent actionEvent) {
        Utils.showInHtmBrowser(PogoConst.tangoHTTP[2]);
    }

    private void classItemActionPerformed(ActionEvent actionEvent) {
        Utils.showInHtmBrowser(PogoConst.tangoHTTP[3]);
    }

    private void pogoItemActionPerformed(ActionEvent actionEvent) {
        Utils.showInHtmBrowser(PogoConst.tangoHTTP[1]);
    }

    private void sitePreferencesItemActionPerformed(ActionEvent actionEvent) {
        new PogoConfiguration(this).showDialog();
    }

    private void multiItemActionPerformed(ActionEvent actionEvent) {
        try {
            if (multiClassesPanel == null) {
                multiClassesPanel = new MultiClassesPanel(this, null);
            }
            multiClassesPanel.setVisible(true);
        }
        catch (PogoException pogoException) {
            PogoException.popup((Component)this, pogoException);
        }
    }

    private void packageItemActionPerformed(ActionEvent actionEvent) {
        ClassTree classTree = this.class_panels.getSelectedTree();
        if (classTree == null) {
            return;
        }
        if (classTree.getModified()) {
            JOptionPane.showMessageDialog(new JFrame(), "Save your project by generating the xmi file before.", "Message Window", 1);
        }
        DeviceClass deviceClass = classTree.getDeviceClass();
        new ConfigurePackagingDialog(this, deviceClass.getPogoDeviceClass()).setVisible(true);
    }

    private void fileMenuStateChanged(ChangeEvent changeEvent) {
        ClassTree classTree;
        if (this.class_panels == null) {
            return;
        }
        boolean bl = false;
        if (Packaging.isAvailable() && (classTree = this.class_panels.getSelectedTree()) != null) {
            DeviceClass deviceClass = classTree.getDeviceClass();
            String string = deviceClass.getPogoDeviceClass().getDescription().getLanguage();
            bl = string.equals(PogoConst.strLang[1]);
        }
        this.packageItem.setVisible(bl);
    }

    private void loadDeviceClassFromFile(String string) {
        this.loadDeviceClassFromFile(string, true);
    }

    private void loadDeviceClassFromFile(String string, boolean bl) {
        Cursor cursor;
        block7: {
            Object object;
            cursor = new Cursor(3);
            try {
                object = new File(string);
                string = ((File)object).getCanonicalFile().toString();
                this.manageRecentMenu(string);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (bl && this.class_panels.getSelectedTree() != null) {
                    new PogoGUI(string);
                    return;
                }
                this.setCursor(cursor);
                Utils.getInstance().startSplashRefresher("Loading  " + Utils.getRelativeFilename(string));
                object = new DeviceClass(string);
                if (((DeviceClass)object).isOldPogoModel() && (object = this.generateFromOldAndReload((DeviceClass)object, string)) == null) {
                    return;
                }
                Utils.getInstance().startSplashRefresher("Building  " + Utils.getRelativeFilename(string));
                this.buildTree((DeviceClass)object);
                this.setTitle(this.applicationTitle((DeviceClass)object));
                cursor = new Cursor(0);
                this.setCursor(cursor);
                Utils.getInstance().stopSplashRefresher();
            }
            catch (PogoException pogoException) {
                Utils.getInstance().stopSplashRefresher();
                if (startup) {
                    System.err.println(pogoException.toString());
                }
                if (pogoException.toString().equals("CANCEL")) break block7;
                PogoException.popup((Component)this, pogoException);
                if (this.class_panels.getPanelNameAt(0) != null || runningApplis.size() <= 1) break block7;
                this.setVisible(false);
            }
        }
        cursor = new Cursor(0);
        this.setCursor(cursor);
        this.class_panels.checkWarnings();
    }

    boolean itemAlreadyExists(String string, int n) {
        ClassTree classTree = this.class_panels.getSelectedTree();
        return classTree.itemAlreadyExists(string, n);
    }

    ClassPanels getClassPanels() {
        return this.class_panels;
    }

    void setTabbedPaneSelection(ClassPanel classPanel) {
        this.tabbedPane.setSelectedComponent(classPanel);
    }

    void fireClassHaveChanged() {
        for (int i = 0; i < this.class_panels.size(); ++i) {
            if (((ClassPanel)this.class_panels.get(i)).isModified()) {
                this.tabbedPane.setForegroundAt(i, Color.red);
                continue;
            }
            this.tabbedPane.setForegroundAt(i, Color.black);
        }
    }

    static {
        startup = true;
        multiClassesPanel = null;
    }

    private class LanguagePopupMenu
    extends JPopupMenu {
        private JLabel label;
        private final int OFFSET = 2;
        private String[] menuLabels = new String[]{PogoConst.strLang[0], PogoConst.strLang[1], PogoConst.strLang[2], PogoConst.strLang[3]};

        private LanguagePopupMenu(JLabel jLabel) {
            this.label = jLabel;
            JLabel jLabel2 = new JLabel("Language");
            jLabel2.setFont(new Font("Dialog", 1, 16));
            this.add(jLabel2);
            this.add(new JPopupMenu.Separator());
            for (String string : this.menuLabels) {
                if (string == null) {
                    this.add(new JPopupMenu.Separator());
                    continue;
                }
                JMenuItem jMenuItem = new JMenuItem(string);
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        LanguagePopupMenu.this.menuActionPerformed(actionEvent);
                    }
                });
                this.add(jMenuItem);
            }
            String string = System.getenv("PythonHL");
            this.getComponent(5).setVisible(string != null && string.equals("true"));
        }

        public void showMenu(MouseEvent mouseEvent) {
            if (PogoGUI.this.hasInheritance) {
                return;
            }
            int n = mouseEvent.getModifiers();
            if ((n & 4) != 0) {
                this.show(this.label, mouseEvent.getX(), mouseEvent.getY());
            }
        }

        private void menuActionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            int n = 0;
            for (int i = 0; i < this.menuLabels.length; ++i) {
                if (this.getComponent(2 + i) != object) continue;
                n = i;
            }
            ClassTree classTree = PogoGUI.this.class_panels.getSelectedTree();
            if (classTree != null) {
                classTree.setClassLanguage(n);
                PogoGUI.this.setLanguageLogo(PogoConst.strLang[n]);
                classTree.setModified(true);
            }
        }
    }

    private class SetVisibleLater
    extends Thread {
        private Component component;

        private SetVisibleLater(Component component) {
            this.component = component;
        }

        @Override
        public void run() {
            try {
                SetVisibleLater.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.component.setVisible(true);
        }
    }

    private class ClassPanels
    extends ArrayList<ClassPanel> {
        private PogoGUI gui;
        private String warnings = "";
        private static final long serialVersionUID = -3468411367658544269L;

        private ClassPanels(PogoGUI pogoGUI2) {
            this.gui = pogoGUI2;
        }

        private String getPanelNameAt(int n) {
            ClassPanel classPanel = (ClassPanel)PogoGUI.this.tabbedPane.getComponent(n);
            return classPanel.getName();
        }

        private ClassTree getSelectedTree() {
            return ((ClassPanel)this.get(PogoGUI.this.tabbedPane.getSelectedIndex())).getTree();
        }

        private void addPanel(DeviceClass deviceClass) {
            ClassPanel classPanel = new ClassPanel(this.gui);
            classPanel.setTree(deviceClass, this.size() > 0);
            this.add(classPanel);
            PogoGUI.this.tabbedPane.add(classPanel);
            PogoGUI.this.tabbedPane.setIconAt(PogoGUI.this.class_panels.size() - 1, Utils.getInstance().logoIcon);
        }

        private void addPanels(DeviceClass deviceClass) {
            this.removeAll(this);
            PogoGUI.this.tabbedPane.removeAll();
            this.warnings = InheritanceUtils.getInstance().manageInheritanceItems(deviceClass);
            this.addPanel(deviceClass);
            ArrayList<DeviceClass> arrayList = deviceClass.getAncestors();
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                this.addPanel(arrayList.get(i));
            }
            PogoGUI.this.hasInheritance = arrayList.size() > 0;
            PogoGUI.this.getContentPane().remove(PogoGUI.this.inherPanel);
            PogoGUI.this.inherPanel = new InheritancePanel(deviceClass, this.gui);
            PogoGUI.this.getContentPane().add((Component)PogoGUI.this.inherPanel, "East");
            PogoGUI.this.pack();
        }

        private void checkWarnings() {
            if (this.warnings.length() > 0) {
                Utils.getInstance().stopSplashRefresher();
                JOptionPane.showMessageDialog(this.gui, "Inheritance change(s):\n" + this.warnings, "Warning Window", 2);
            }
        }

        private void updateInheritancePanelForSelection() {
            if (!PogoGUI.this.reBuildTabbedPane) {
                ClassPanel classPanel = (ClassPanel)PogoGUI.this.tabbedPane.getSelectedComponent();
                if (PogoGUI.this.inherPanel instanceof InheritancePanel) {
                    ((InheritancePanel)PogoGUI.this.inherPanel).setSelected(classPanel.getName());
                }
            }
        }
    }
}

