/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui;

import fr.esrf.tango.pogo.pogoDsl.PogoDeviceClass;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.tango.pogo.pogo_gui.DeviceClass;
import org.tango.pogo.pogo_gui.MultiClassesPanel;
import org.tango.pogo.pogo_gui.PogoGUI;
import org.tango.pogo.pogo_gui.tools.OAWutils;
import org.tango.pogo.pogo_gui.tools.PogoException;
import org.tango.pogo.pogo_gui.tools.PogoProperty;
import org.tango.pogo.pogo_gui.tools.Utils;

public class Pogo {
    private static final int GENE_SRC = 0;
    private static final int GENE_DOC = 1;
    private static final int MULTI = 2;
    private static final int HELP = 3;
    private static final String[] known_actions = new String[]{"-src", "-doc", "-multi", "-?"};
    private DeviceClass deviceClass = null;
    private PogoException pogoException = null;
    private ArrayList<String> sourcefiles = new ArrayList();

    public Pogo() throws PogoException {
        PogoProperty.init();
    }

    public Pogo(String string) throws PogoException {
        this();
        this.sourcefiles.add(string);
    }

    public DeviceClass getDeviceClass() {
        return this.deviceClass;
    }

    public boolean hasFailed() {
        return this.pogoException != null;
    }

    public PogoException getPogoException() {
        return this.pogoException;
    }

    public void generateSourceFiles() {
        try {
            for (String string : this.sourcefiles) {
                this.deviceClass = new DeviceClass(string);
                PogoDeviceClass pogoDeviceClass = this.deviceClass.getPogoDeviceClass();
                if (this.deviceClass.isOldPogoModel()) {
                    this.deviceClass.generateFromOldModel(string, true);
                    continue;
                }
                this.deviceClass.getPogoDeviceClass().getDescription().setFilestogenerate("Code files");
                OAWutils.getInstance().generate(pogoDeviceClass);
            }
        }
        catch (PogoException pogoException) {
            System.err.println(pogoException.getMessage());
            this.pogoException = pogoException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.pogoException = new PogoException(exception.toString());
        }
    }

    public void generateDocumentation() {
        try {
            for (String string : this.sourcefiles) {
                System.out.println("===============================================================");
                System.out.println("\tBuild doc from " + string);
                System.out.println("===============================================================");
                this.deviceClass = new DeviceClass(string);
                PogoDeviceClass pogoDeviceClass = this.deviceClass.getPogoDeviceClass();
                this.deviceClass.getPogoDeviceClass().getDescription().setFilestogenerate("html");
                OAWutils.getInstance().generate(pogoDeviceClass);
                if (!this.deviceClass.isOldPogoModel()) continue;
                this.deviceClass.generateDocFromOldModel(string, null);
            }
        }
        catch (PogoException pogoException) {
            System.err.println(pogoException.getMessage());
            this.pogoException = pogoException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.pogoException = new PogoException(exception.toString());
        }
    }

    private void startPogoGUI() {
        try {
            if (this.sourcefiles.size() == 0) {
                new PogoGUI(null);
            } else {
                new PogoGUI(this.sourcefiles.get(0));
            }
        }
        catch (Exception exception) {
            Utils.getInstance().stopSplashRefresher();
            PogoException.popup((Component)new JFrame(), exception);
            System.exit(-1);
        }
        catch (Error error) {
            Utils.getInstance().stopSplashRefresher();
            JOptionPane.showMessageDialog(new JFrame(), error.toString(), "Error Window", 0);
            System.exit(-1);
        }
    }

    private void startPogoMulti() {
        try {
            boolean bl;
            String string = System.getenv("TEST_MODE");
            boolean bl2 = bl = string != null && string.equals("true");
            if (!Utils.osIsUnix() && !bl) {
                throw new PogoException("Multi classes project is available only on Linux");
            }
            if (this.sourcefiles.size() == 0) {
                new MultiClassesPanel(new JFrame(), null).setVisible(true);
            } else {
                new MultiClassesPanel(new JFrame(), this.sourcefiles.get(0)).setVisible(true);
            }
        }
        catch (Exception exception) {
            Utils.getInstance().stopSplashRefresher();
            PogoException.popup((Component)new JFrame(), exception);
            System.exit(-1);
        }
        catch (Error error) {
            Utils.getInstance().stopSplashRefresher();
            JOptionPane.showMessageDialog(new JFrame(), error.toString(), "Error Window", 0);
            System.exit(-1);
        }
    }

    private int manageArgs(String[] stringArray) {
        int n = -1;
        for (String string : stringArray) {
            boolean bl = false;
            for (int i = 0; !bl && i < known_actions.length; ++i) {
                bl = string.equals(known_actions[i]);
                if (!bl) continue;
                n = i;
            }
            if (bl) continue;
            this.sourcefiles.add(string);
        }
        return n;
    }

    private static void displaySyntax() {
        System.out.println("Syntax:");
        System.out.println("pogo <action> <filename1> <filename2>....");
        System.out.println();
        System.out.println("Without option, pogo start the Graphic User Interface");
        System.out.println();
        System.out.println("Actions:");
        System.out.println("\t-src:\twill re-generate the device server source files.");
        System.out.println("\t-multi:\twill start Pogo for multi class server.");
        System.out.println("\t-doc:\twill generate the device server documentation.");
        System.out.println();
    }

    public static void main(String[] stringArray) {
        try {
            Pogo pogo = new Pogo();
            switch (pogo.manageArgs(stringArray)) {
                case 0: {
                    pogo.generateSourceFiles();
                    System.exit(0);
                    break;
                }
                case 1: {
                    pogo.generateDocumentation();
                    System.exit(0);
                    break;
                }
                case 2: {
                    pogo.startPogoMulti();
                    break;
                }
                case 3: {
                    Pogo.displaySyntax();
                    System.exit(0);
                    break;
                }
                default: {
                    pogo.startPogoGUI();
                    break;
                }
            }
        }
        catch (PogoException pogoException) {
            System.err.println(pogoException.getMessage());
            System.exit(-1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
    }
}

