/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.validation.impl;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.parsetree.reconstr.ITransientValueService;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.validation.IAssignmentQuantityAllocator;
import org.eclipse.xtext.validation.IAssignmentQuantityIntervalProvider;
import org.eclipse.xtext.validation.IConcreteSyntaxConstraintProvider;
import org.eclipse.xtext.validation.IConcreteSyntaxDiagnosticProvider;
import org.eclipse.xtext.validation.IConcreteSyntaxValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcreteSyntaxValidator
implements IConcreteSyntaxValidator {
    @Inject
    protected IConcreteSyntaxConstraintProvider constraintProvider;
    @Inject
    protected IConcreteSyntaxDiagnosticProvider diagnosticProvider;
    @Inject
    protected IAssignmentQuantityIntervalProvider intervalProvider;
    @Inject
    protected IAssignmentQuantityAllocator quantityProvider;
    @Inject
    protected ITransientValueService transSrvc;

    protected Set<IConcreteSyntaxConstraintProvider.ISyntaxConstraint> collectUnfulfilledSemanticElements(EClass cls, IConcreteSyntaxConstraintProvider.ISyntaxConstraint ele) {
        if (ele.isOptional()) {
            return Collections.emptySet();
        }
        if (ele.getSemanticTypesToCheck() != null && !ele.getSemanticTypesToCheck().contains(cls)) {
            return Collections.singleton(ele);
        }
        switch (ele.getType()) {
            case GROUP: {
                HashSet<IConcreteSyntaxConstraintProvider.ISyntaxConstraint> l1 = new HashSet<IConcreteSyntaxConstraintProvider.ISyntaxConstraint>();
                for (IConcreteSyntaxConstraintProvider.ISyntaxConstraint e : ele.getContents()) {
                    l1.addAll(this.collectUnfulfilledSemanticElements(cls, e));
                }
                return l1;
            }
            case ALTERNATIVE: {
                HashSet<IConcreteSyntaxConstraintProvider.ISyntaxConstraint> l2 = new HashSet<IConcreteSyntaxConstraintProvider.ISyntaxConstraint>();
                for (IConcreteSyntaxConstraintProvider.ISyntaxConstraint e : ele.getContents()) {
                    Set<IConcreteSyntaxConstraintProvider.ISyntaxConstraint> r = this.collectUnfulfilledSemanticElements(cls, e);
                    if (r.size() == 0) {
                        return Collections.emptySet();
                    }
                    l2.addAll(r);
                }
                return l2;
            }
        }
        return Collections.emptySet();
    }

    public boolean isEObjectTransient(EObject obj) {
        if (obj.eContainmentFeature() == null) {
            return false;
        }
        EReference ref = obj.eContainmentFeature();
        EObject cnt = obj.eContainer();
        return ref.isMany() && this.transSrvc.isCheckElementsIndividually(cnt, ref) ? this.transSrvc.isTransient(cnt, ref, ((List)cnt.eGet(ref)).indexOf(obj)) : this.transSrvc.isTransient(cnt, ref, 0);
    }

    @Override
    public boolean validateObject(EObject obj, IConcreteSyntaxValidator.IDiagnosticAcceptor acceptor, Map<Object, Object> context) {
        if (this.isEObjectTransient(obj)) {
            return true;
        }
        ArrayList<IConcreteSyntaxDiagnosticProvider.IConcreteSyntaxDiagnostic> allDiags = new ArrayList<IConcreteSyntaxDiagnosticProvider.IConcreteSyntaxDiagnostic>();
        Collection<IConcreteSyntaxConstraintProvider.ISyntaxConstraint> rules = this.constraintProvider.getConstraints(obj.eClass());
        if (rules.isEmpty()) {
            return true;
        }
        for (IConcreteSyntaxConstraintProvider.ISyntaxConstraint rule : rules) {
            List<IConcreteSyntaxDiagnosticProvider.IConcreteSyntaxDiagnostic> diags = this.validateRule(obj, rule);
            if (diags.size() == 0) {
                return true;
            }
            allDiags.addAll(diags);
        }
        for (IConcreteSyntaxDiagnosticProvider.IConcreteSyntaxDiagnostic d : allDiags) {
            acceptor.accept(d);
        }
        return false;
    }

    protected List<IConcreteSyntaxDiagnosticProvider.IConcreteSyntaxDiagnostic> validateQuantities(IAssignmentQuantityAllocator.IQuantities quants, IConcreteSyntaxConstraintProvider.ISyntaxConstraint rule) {
        ArrayList<IConcreteSyntaxDiagnosticProvider.IConcreteSyntaxDiagnostic> diag = new ArrayList<IConcreteSyntaxDiagnosticProvider.IConcreteSyntaxDiagnostic>();
        HashMap<IConcreteSyntaxConstraintProvider.ISyntaxConstraint, Pair<Integer, Integer>> minmax = Maps.newHashMap();
        for (Map.Entry<EStructuralFeature, Collection<IConcreteSyntaxConstraintProvider.ISyntaxConstraint>> e : quants.groupByFeature().entrySet()) {
            int min = -1;
            int max = 0;
            HashSet<IConcreteSyntaxConstraintProvider.ISyntaxConstraint> involved = new HashSet<IConcreteSyntaxConstraintProvider.ISyntaxConstraint>();
            for (IConcreteSyntaxConstraintProvider.ISyntaxConstraint a : e.getValue()) {
                int ma;
                involved.add(a);
                int mi = this.intervalProvider.getMin(quants, a, involved);
                if (mi != -1) {
                    int n = min = min == -1 ? mi : mi + min;
                }
                if ((ma = this.intervalProvider.getMax(quants, a, involved, null)) != -1 && max != Integer.MAX_VALUE) {
                    max = ma == Integer.MAX_VALUE ? ma : max + ma;
                }
                minmax.put(a, Tuples.create(mi, ma));
            }
            int actual = quants.getFeatureQuantity(e.getKey());
            if (actual >= min && actual <= max) continue;
            diag.add(this.diagnosticProvider.createFeatureQuantityDiagnostic(rule, quants, e.getKey(), actual, min, max, involved));
        }
        return diag;
    }

    @Override
    public boolean validateRecursive(EObject obj, IConcreteSyntaxValidator.IDiagnosticAcceptor acceptor, Map<Object, Object> context) {
        boolean r = true;
        r &= this.validateObject(obj, acceptor, context);
        TreeIterator<EObject> i = obj.eAllContents();
        while (i.hasNext()) {
            r &= this.validateObject((EObject)i.next(), acceptor, context);
        }
        return r;
    }

    protected List<IConcreteSyntaxDiagnosticProvider.IConcreteSyntaxDiagnostic> validateRule(EObject obj, IConcreteSyntaxConstraintProvider.ISyntaxConstraint rule) {
        ArrayList<IConcreteSyntaxDiagnosticProvider.IConcreteSyntaxDiagnostic> allDiags = new ArrayList<IConcreteSyntaxDiagnosticProvider.IConcreteSyntaxDiagnostic>();
        Set<IConcreteSyntaxConstraintProvider.ISyntaxConstraint> expectedTypes = this.collectUnfulfilledSemanticElements(obj.eClass(), rule);
        if (expectedTypes.size() > 0) {
            allDiags.add(this.diagnosticProvider.createUnexpectedTypeDiagnostic(rule, obj, expectedTypes));
        }
        if (!allDiags.isEmpty()) {
            return allDiags;
        }
        IAssignmentQuantityAllocator.IQuantities quantities = this.quantityProvider.getAssignmentQuantities(obj, rule, allDiags);
        if (quantities == null || !allDiags.isEmpty()) {
            return allDiags;
        }
        List<IConcreteSyntaxDiagnosticProvider.IConcreteSyntaxDiagnostic> diags = this.validateQuantities(quantities, rule);
        if (diags.isEmpty()) {
            return diags;
        }
        allDiags.addAll(diags);
        return allDiags;
    }
}

