/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.impl;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.Collections;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.ISelectable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCompoundSelectable
implements ISelectable {
    @Override
    public boolean isEmpty() {
        return Iterables.isEmpty(this.getSelectables());
    }

    @Override
    public Iterable<IEObjectDescription> getExportedObjects() {
        return Iterables.concat(Iterables.transform(this.getSelectables(), new Function<ISelectable, Iterable<IEObjectDescription>>(){

            @Override
            public Iterable<IEObjectDescription> apply(ISelectable from) {
                if (from != null) {
                    return from.getExportedObjects();
                }
                return Collections.emptyList();
            }
        }));
    }

    protected abstract Iterable<? extends ISelectable> getSelectables();

    @Override
    public Iterable<IEObjectDescription> getExportedObjectsByType(final EClass type) {
        return Iterables.concat(Iterables.transform(this.getSelectables(), new Function<ISelectable, Iterable<IEObjectDescription>>(){

            @Override
            public Iterable<IEObjectDescription> apply(ISelectable from) {
                if (from != null) {
                    return from.getExportedObjectsByType(type);
                }
                return Collections.emptyList();
            }
        }));
    }

    @Override
    public Iterable<IEObjectDescription> getExportedObjectsByObject(final EObject object) {
        return Iterables.concat(Iterables.transform(this.getSelectables(), new Function<ISelectable, Iterable<IEObjectDescription>>(){

            @Override
            public Iterable<IEObjectDescription> apply(ISelectable from) {
                if (from != null) {
                    return from.getExportedObjectsByObject(object);
                }
                return Collections.emptyList();
            }
        }));
    }

    @Override
    public Iterable<IEObjectDescription> getExportedObjects(final EClass type, final QualifiedName qualifiedName, final boolean ignoreCase) {
        return Iterables.concat(Iterables.transform(this.getSelectables(), new Function<ISelectable, Iterable<IEObjectDescription>>(){

            @Override
            public Iterable<IEObjectDescription> apply(ISelectable from) {
                if (from != null) {
                    return from.getExportedObjects(type, qualifiedName, ignoreCase);
                }
                return Collections.emptyList();
            }
        }));
    }
}

