/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.nodemodel.impl;

import com.google.common.collect.UnmodifiableIterator;
import java.util.NoSuchElementException;
import org.eclipse.xtext.nodemodel.BidiTreeIterator;
import org.eclipse.xtext.nodemodel.impl.AbstractNode;
import org.eclipse.xtext.nodemodel.impl.CompositeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicNodeTreeIterator
extends UnmodifiableIterator<AbstractNode>
implements BidiTreeIterator<AbstractNode> {
    private final AbstractNode root;
    private AbstractNode lastReturned;
    private AbstractNode next;
    private boolean nextComputed = false;
    private boolean pruned = false;
    private AbstractNode previous;
    private boolean previousComputed = false;

    protected BasicNodeTreeIterator(AbstractNode root) {
        this.root = root;
    }

    @Override
    public boolean hasNext() {
        if (this.nextComputed) {
            return this.next != null;
        }
        if (this.lastReturned == null) {
            this.next = this.root;
        } else if (!this.pruned && this.lastReturned instanceof CompositeNode && ((CompositeNode)this.lastReturned).basicGetFirstChild() != null) {
            this.next = ((CompositeNode)this.lastReturned).basicGetFirstChild();
        } else if (this.lastReturned != this.root && this.lastReturned.basicHasNextSibling()) {
            this.next = this.lastReturned.basicGetNextSibling();
        } else if (this.lastReturned != this.root) {
            CompositeNode parent = this.lastReturned.basicGetParent();
            while (this.next == null && parent != this.root) {
                if (parent.basicHasNextSibling()) {
                    this.next = parent.basicGetNextSibling();
                }
                parent = parent.basicGetParent();
            }
        }
        this.nextComputed = true;
        return this.next != null;
    }

    @Override
    public AbstractNode next() {
        if (this.next == null && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.lastReturned = this.next;
        this.afterAdvance();
        return this.lastReturned;
    }

    protected void afterAdvance() {
        this.next = null;
        this.previous = null;
        this.nextComputed = false;
        this.previousComputed = false;
        this.pruned = false;
    }

    @Override
    public boolean hasPrevious() {
        if (this.previousComputed) {
            return this.previous != null;
        }
        if (this.lastReturned == null) {
            this.previous = this.root;
        } else if (!this.pruned && this.lastReturned instanceof CompositeNode && ((CompositeNode)this.lastReturned).basicGetFirstChild() != null) {
            this.previous = ((CompositeNode)this.lastReturned).basicGetLastChild();
        } else if (this.lastReturned != this.root && this.lastReturned.basicHasPreviousSibling()) {
            this.previous = this.lastReturned.basicGetPreviousSibling();
        } else if (this.lastReturned != this.root) {
            CompositeNode parent = this.lastReturned.basicGetParent();
            while (this.previous == null && parent != this.root) {
                if (parent.basicHasPreviousSibling()) {
                    this.previous = parent.basicGetPreviousSibling();
                }
                parent = parent.basicGetParent();
            }
        }
        this.previousComputed = true;
        return this.previous != null;
    }

    @Override
    public AbstractNode previous() {
        if (this.previous == null && !this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        this.lastReturned = this.previous;
        this.afterAdvance();
        return this.lastReturned;
    }

    @Override
    public void prune() {
        if (this.lastReturned == null) {
            throw new IllegalStateException("Cannot prune before #next or #previous");
        }
        this.pruned = true;
    }
}

