/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputConfiguration {
    private String name;
    private String description;
    private String outputDirectory;
    private boolean createOutputDirectory;
    private boolean cleanUpDerivedResources = true;
    private boolean overrideExistingResources = true;
    private boolean setDerivedProperty = true;
    private boolean canClearOutputDirectory = false;
    private boolean installDslAsPrimarySource = false;
    private boolean hideSyntheticLocalVariables = true;
    private boolean keepLocalHistory = false;
    private boolean useOutputPerSourceFolder = false;
    private Set<SourceMapping> sourceMappings = Sets.newHashSet();

    public OutputConfiguration(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public boolean isCleanUpDerivedResources() {
        return this.cleanUpDerivedResources;
    }

    public void setCleanUpDerivedResources(boolean cleanUpDerivedResources) {
        this.cleanUpDerivedResources = cleanUpDerivedResources;
    }

    public boolean isOverrideExistingResources() {
        return this.overrideExistingResources;
    }

    public void setOverrideExistingResources(boolean overrideExistingResources) {
        this.overrideExistingResources = overrideExistingResources;
    }

    public boolean isSetDerivedProperty() {
        return this.setDerivedProperty;
    }

    public void setSetDerivedProperty(boolean setDerivedProperty) {
        this.setDerivedProperty = setDerivedProperty;
    }

    public boolean isCreateOutputDirectory() {
        return this.createOutputDirectory;
    }

    public void setCreateOutputDirectory(boolean createOutputDirectory) {
        this.createOutputDirectory = createOutputDirectory;
    }

    public boolean isCanClearOutputDirectory() {
        return this.canClearOutputDirectory;
    }

    public void setCanClearOutputDirectory(boolean canClearOutputDirectory) {
        this.canClearOutputDirectory = canClearOutputDirectory;
    }

    public boolean isInstallDslAsPrimarySource() {
        return this.installDslAsPrimarySource;
    }

    public void setInstallDslAsPrimarySource(boolean installDslAsPrimarySource) {
        this.installDslAsPrimarySource = installDslAsPrimarySource;
    }

    public boolean isHideSyntheticLocalVariables() {
        return this.hideSyntheticLocalVariables;
    }

    public void setHideSyntheticLocalVariables(boolean hideSyntheticLocalVariables) {
        this.hideSyntheticLocalVariables = hideSyntheticLocalVariables;
    }

    public Boolean isKeepLocalHistory() {
        return this.keepLocalHistory;
    }

    public void setKeepLocalHistory(Boolean keepLocalHistory) {
        this.keepLocalHistory = keepLocalHistory;
    }

    public boolean isUseOutputPerSourceFolder() {
        return this.useOutputPerSourceFolder;
    }

    public void setUseOutputPerSourceFolder(boolean useOutputPerSourceFolder) {
        this.useOutputPerSourceFolder = useOutputPerSourceFolder;
    }

    public Set<SourceMapping> getSourceMappings() {
        return this.sourceMappings;
    }

    public String getOutputDirectory(String sourceFolder) {
        if (this.useOutputPerSourceFolder) {
            for (SourceMapping mapping : this.sourceMappings) {
                if (!mapping.getSourceFolder().equals(sourceFolder) || mapping.getOutputDirectory() == null) continue;
                return mapping.getOutputDirectory();
            }
        }
        return this.getOutputDirectory();
    }

    public Set<String> getSourceFolders() {
        LinkedHashSet<String> sourceFolders = Sets.newLinkedHashSet();
        for (SourceMapping mapping : this.getSourceMappings()) {
            sourceFolders.add(mapping.getSourceFolder());
        }
        return sourceFolders;
    }

    public Set<String> getOutputDirectories() {
        LinkedHashSet<String> outputDirectories = Sets.newLinkedHashSet();
        if (this.isUseOutputPerSourceFolder()) {
            for (SourceMapping mapping : this.getSourceMappings()) {
                outputDirectories.add(this.getOutputDirectory(mapping.getSourceFolder()));
            }
        } else {
            outputDirectories.add(this.getOutputDirectory());
        }
        return outputDirectories;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OutputConfiguration other = (OutputConfiguration)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public static class SourceMapping {
        private String sourceFolder;
        private String outputDirectory;
        private boolean ignore;

        public SourceMapping(String sourceFolder) {
            this.sourceFolder = Preconditions.checkNotNull(sourceFolder);
        }

        public String getSourceFolder() {
            return this.sourceFolder;
        }

        public String getOutputDirectory() {
            return this.outputDirectory;
        }

        public void setOutputDirectory(String outputDirectory) {
            this.outputDirectory = outputDirectory;
        }

        public boolean isIgnore() {
            return this.ignore;
        }

        public void setIgnore(boolean ignore) {
            this.ignore = ignore;
        }

        public boolean equals(Object obj) {
            if (obj instanceof SourceMapping) {
                SourceMapping other = (SourceMapping)obj;
                return Objects.equal(this.sourceFolder, other.sourceFolder);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode(this.sourceFolder);
        }
    }
}

