/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.impl;

import java.util.List;
import org.eclipse.xtext.common.types.JvmLowerBound;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.common.types.TypesPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NameConcatHelper {
    NameConcatHelper() {
    }

    static void appendConstraintsName(StringBuilder result, List<JvmTypeConstraint> constraints, char innerClassDelimiter, NameType nameType) {
        if (constraints == null || constraints.isEmpty()) {
            return;
        }
        int wasLength = result.length();
        boolean hasLowerBound = false;
        if (nameType != NameType.ID) {
            for (JvmTypeConstraint constraint : constraints) {
                if (!(constraint instanceof JvmLowerBound)) continue;
                hasLowerBound = true;
                break;
            }
        }
        for (JvmTypeConstraint constraint : constraints) {
            if (result.length() != wasLength) {
                result.append(" & ");
            }
            if (hasLowerBound && !(constraint instanceof JvmLowerBound) && nameType != NameType.ID) continue;
            switch (nameType) {
                case ID: {
                    result.append(constraint.getIdentifier());
                    break;
                }
                case QUALIFIED: {
                    result.append(constraint.getQualifiedName(innerClassDelimiter));
                    break;
                }
                case SIMPLE: {
                    result.append(constraint.getSimpleName());
                    break;
                }
                case TO_STRING: {
                    result.append(constraint.toString());
                }
            }
        }
    }

    static String computeFor(JvmWildcardTypeReference typeReference, char innerClassDelimiter, NameType nameType) {
        if (typeReference.eIsSet(TypesPackage.Literals.JVM_CONSTRAINT_OWNER__CONSTRAINTS)) {
            if (typeReference.getConstraints().size() == 1) {
                JvmTypeReference reference;
                JvmTypeConstraint onlyConstraint = (JvmTypeConstraint)typeReference.getConstraints().get(0);
                if (nameType != NameType.ID && nameType != NameType.TO_STRING ? (reference = onlyConstraint.getTypeReference()) == null || onlyConstraint instanceof JvmUpperBound && Object.class.getCanonicalName().equals(onlyConstraint.getTypeReference().getIdentifier()) : nameType == NameType.ID && onlyConstraint.getTypeReference() == null) {
                    return "?";
                }
            }
            StringBuilder mutableResult = new StringBuilder(64);
            mutableResult.append("? ");
            NameConcatHelper.appendConstraintsName(mutableResult, typeReference.getConstraints(), innerClassDelimiter, nameType);
            return mutableResult.toString();
        }
        return "?";
    }

    static String computeFor(JvmParameterizedTypeReference typeReference, char innerClassDelimiter, NameType nameType) {
        if (typeReference.eIsSet(TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE)) {
            StringBuilder mutableResult = new StringBuilder(64);
            JvmType type = typeReference.getType();
            switch (nameType) {
                case ID: {
                    mutableResult.append(type.getIdentifier());
                    break;
                }
                case QUALIFIED: {
                    mutableResult.append(type.getQualifiedName(innerClassDelimiter));
                    break;
                }
                case SIMPLE: {
                    mutableResult.append(type.getSimpleName());
                    break;
                }
                case TO_STRING: {
                    mutableResult.append(type.getIdentifier());
                }
            }
            if (typeReference.eIsSet(TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__ARGUMENTS)) {
                mutableResult.append("<");
                NameConcatHelper.appendArguments(mutableResult, typeReference.getArguments(), innerClassDelimiter, nameType);
                mutableResult.append(">");
                return mutableResult.toString();
            }
            return mutableResult.toString();
        }
        return null;
    }

    static void appendArguments(StringBuilder result, List<JvmTypeReference> arguments, char innerClassDelimiter, NameType nameType) {
        if (arguments == null || arguments.isEmpty()) {
            return;
        }
        int wasLength = result.length();
        for (JvmTypeReference argument : arguments) {
            if (result.length() != wasLength) {
                result.append(", ");
            }
            switch (nameType) {
                case ID: {
                    result.append(argument.getIdentifier());
                    break;
                }
                case QUALIFIED: {
                    result.append(argument.getQualifiedName(innerClassDelimiter));
                    break;
                }
                case SIMPLE: {
                    result.append(argument.getSimpleName());
                    break;
                }
                case TO_STRING: {
                    result.append(argument.toString());
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum NameType {
        ID,
        QUALIFIED,
        SIMPLE,
        TO_STRING;

    }
}

