/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.impl.javasupport;

import com.google.common.base.Objects;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.xtext.builder.impl.IQueuedBuildDataContribution;
import org.eclipse.xtext.builder.impl.javasupport.UnconfirmedStructuralChangesDelta;
import org.eclipse.xtext.common.types.ui.notification.JavaBuilderState;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class JdtQueuedBuildData
implements IQueuedBuildDataContribution {
    private Map<String, JavaBuilderState> javaBuildState;
    private Collection<UnconfirmedStructuralChangesDelta> unconfirmedDeltas;

    @Override
    public void reset() {
        HashMap<String, JavaBuilderState> _newHashMap = CollectionLiterals.newHashMap(new Pair[0]);
        this.javaBuildState = _newHashMap;
        ArrayList<UnconfirmedStructuralChangesDelta> _newArrayList = CollectionLiterals.newArrayList(new UnconfirmedStructuralChangesDelta[0]);
        this.unconfirmedDeltas = _newArrayList;
    }

    public Collection<UnconfirmedStructuralChangesDelta> getUnconfirmedDeltas() {
        return Collections.unmodifiableCollection(this.unconfirmedDeltas);
    }

    @Override
    public boolean queueChange(IResourceDescription.Delta delta) {
        boolean _switchResult = false;
        boolean _matched = false;
        if (!_matched && delta instanceof UnconfirmedStructuralChangesDelta) {
            _matched = true;
            boolean _xblockexpression = false;
            IProject project = ((UnconfirmedStructuralChangesDelta)delta).getProject();
            String _name = project.getName();
            JavaBuilderState state = this.javaBuildState.get(_name);
            boolean _equals = Objects.equal(state, null);
            if (_equals) {
                JavaBuilderState _lastBuiltState;
                String _name_1 = project.getName();
                JavaBuilderState _state = state = (_lastBuiltState = JavaBuilderState.getLastBuiltState((IProject)project));
                this.javaBuildState.put(_name_1, _state);
            }
            Integer _buildNumber = state.getBuildNumber();
            ((UnconfirmedStructuralChangesDelta)delta).setBuildNumber(_buildNumber);
            this.unconfirmedDeltas.add((UnconfirmedStructuralChangesDelta)delta);
            _switchResult = _xblockexpression = true;
        }
        if (!_matched) {
            _switchResult = false;
        }
        return _switchResult;
    }

    @Override
    public boolean needsRebuild(IProject it, final Collection<IResourceDescription.Delta> deltas) {
        Procedures.Procedure1<UnconfirmedStructuralChangesDelta> _function;
        Long _lastStructuralBuildTime_1;
        Long _lastStructuralBuildTime;
        boolean _notEquals;
        boolean _xblockexpression = false;
        String _name = it.getName();
        JavaBuilderState oldState = this.javaBuildState.get(_name);
        final JavaBuilderState newState = JavaBuilderState.getLastBuiltState((IProject)it);
        Procedures.Procedure1<UnconfirmedStructuralChangesDelta> _xifexpression = null;
        boolean _or = false;
        boolean _equals = Objects.equal(oldState, null);
        _or = _equals ? true : (_notEquals = !Objects.equal(_lastStructuralBuildTime = oldState.getLastStructuralBuildTime(), _lastStructuralBuildTime_1 = newState.getLastStructuralBuildTime()));
        _xifexpression = _or ? (_function = new Procedures.Procedure1<UnconfirmedStructuralChangesDelta>(){

            @Override
            public void apply(UnconfirmedStructuralChangesDelta it) {
                Set structurallyChangedTypes = newState.getStructurallyChangedTypes();
                boolean _or = false;
                IResourceDescription _new = it.getNew();
                boolean _namesIntersect = JdtQueuedBuildData.this.namesIntersect(_new, structurallyChangedTypes);
                if (_namesIntersect) {
                    _or = true;
                } else {
                    boolean _namesIntersect_1;
                    IResourceDescription _old = it.getOld();
                    _or = _namesIntersect_1 = JdtQueuedBuildData.this.namesIntersect(_old, structurallyChangedTypes);
                }
                if (_or) {
                    deltas.add(it);
                }
            }
        }) : null;
        _xblockexpression = this.doNeedRebuild(newState, _xifexpression);
        return _xblockexpression;
    }

    protected boolean doNeedRebuild(JavaBuilderState it, Procedures.Procedure1<? super UnconfirmedStructuralChangesDelta> processor) {
        boolean _hasNext;
        boolean _xblockexpression = false;
        Iterator<UnconfirmedStructuralChangesDelta> i = this.unconfirmedDeltas.iterator();
        boolean _while = _hasNext = i.hasNext();
        while (_while) {
            boolean _hasNext_1;
            Integer _buildNumber_1;
            boolean _lessThan;
            UnconfirmedStructuralChangesDelta unconfirmed = i.next();
            boolean _and = false;
            int _buildNumber = unconfirmed.getBuildNumber();
            boolean bl = _lessThan = _buildNumber < (_buildNumber_1 = it.getBuildNumber());
            if (!_lessThan) {
                _and = false;
            } else {
                boolean _equals;
                IProject _project = unconfirmed.getProject();
                IProject _project_1 = it.getProject();
                _and = _equals = _project.equals(_project_1);
            }
            if (_and) {
                boolean _notEquals;
                i.remove();
                boolean bl2 = _notEquals = !Objects.equal(processor, null);
                if (_notEquals) {
                    processor.apply(unconfirmed);
                }
            }
            _while = _hasNext_1 = i.hasNext();
        }
        int _size = this.unconfirmedDeltas.size();
        _xblockexpression = _size != 0;
        return _xblockexpression;
    }

    protected boolean namesIntersect(IResourceDescription resourceDescription, Set<QualifiedName> names) {
        boolean _xblockexpression = false;
        boolean _equals = Objects.equal(resourceDescription, null);
        if (_equals) {
            return false;
        }
        Iterable<IEObjectDescription> _exportedObjects = resourceDescription.getExportedObjects();
        for (IEObjectDescription objectDescription : _exportedObjects) {
            QualifiedName _qualifiedName = objectDescription.getQualifiedName();
            boolean _contains = names.contains(_qualifiedName);
            if (!_contains) continue;
            return true;
        }
        _xblockexpression = false;
        return _xblockexpression;
    }
}

