/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.eclipse.ui.internal.progress.ProgressManagerUtil;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.internal.progress.ProgressMonitorJobsDialog;
import org.eclipse.ui.progress.IProgressConstants;
import org.eclipse.ui.progress.WorkbenchJob;

class ProgressMonitorFocusJobDialog
extends ProgressMonitorJobsDialog {
    Job job;
    private boolean showDialog;

    public ProgressMonitorFocusJobDialog(Shell parentShell) {
        super(parentShell == null ? ProgressManagerUtil.getNonModalShell() : parentShell);
        this.setShellStyle(ProgressMonitorFocusJobDialog.getDefaultOrientation() | 0x800 | 0x20 | 0x10 | 0x400);
        this.setCancelable(true);
        this.enableDetailsButton = true;
    }

    @Override
    protected void cancelPressed() {
        this.job.cancel();
        super.cancelPressed();
    }

    @Override
    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.job.getName());
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        Button runInWorkspace = this.createButton(parent, 12, ProgressMessages.ProgressMonitorFocusJobDialog_RunInBackgroundButton, true);
        runInWorkspace.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                Rectangle shellPosition = ProgressMonitorFocusJobDialog.this.getShell().getBounds();
                ProgressMonitorFocusJobDialog.this.job.setProperty(IProgressConstants.PROPERTY_IN_DIALOG, Boolean.FALSE);
                ProgressMonitorFocusJobDialog.this.finishedRun();
                ProgressManagerUtil.animateDown(shellPosition);
            }
        });
        runInWorkspace.setCursor(this.arrowCursor);
        this.cancel = this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.cancel.setCursor(this.arrowCursor);
        this.createDetailsButton(parent);
    }

    private IJobChangeListener createCloseListener() {
        return new JobChangeAdapter(){

            @Override
            public void done(IJobChangeEvent event) {
                event.getJob().removeJobChangeListener(this);
                if (!PlatformUI.isWorkbenchRunning()) {
                    return;
                }
                if (ProgressMonitorFocusJobDialog.this.getShell() == null) {
                    return;
                }
                WorkbenchJob closeJob = new WorkbenchJob(ProgressMessages.ProgressMonitorFocusJobDialog_CLoseDialogJob){

                    @Override
                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        Shell currentShell = ProgressMonitorFocusJobDialog.this.getShell();
                        if (currentShell == null || currentShell.isDisposed()) {
                            return Status.CANCEL_STATUS;
                        }
                        ProgressMonitorFocusJobDialog.this.finishedRun();
                        return Status.OK_STATUS;
                    }
                };
                closeJob.setSystem(true);
                closeJob.schedule();
            }
        };
    }

    private IProgressMonitorWithBlocking getBlockingProgressMonitor() {
        return new IProgressMonitorWithBlocking(){

            @Override
            public void beginTask(String name, int totalWork) {
                final String finalName = name;
                final int finalWork = totalWork;
                this.runAsync(new Runnable(){

                    @Override
                    public void run() {
                        ProgressMonitorFocusJobDialog.this.getProgressMonitor().beginTask(finalName, finalWork);
                    }
                });
            }

            @Override
            public void clearBlocked() {
                this.runAsync(new Runnable(){

                    @Override
                    public void run() {
                        ((IProgressMonitorWithBlocking)ProgressMonitorFocusJobDialog.this.getProgressMonitor()).clearBlocked();
                    }
                });
            }

            @Override
            public void done() {
                this.runAsync(new Runnable(){

                    @Override
                    public void run() {
                        ProgressMonitorFocusJobDialog.this.getProgressMonitor().done();
                    }
                });
            }

            @Override
            public void internalWorked(double work) {
                final double finalWork = work;
                this.runAsync(new Runnable(){

                    @Override
                    public void run() {
                        ProgressMonitorFocusJobDialog.this.getProgressMonitor().internalWorked(finalWork);
                    }
                });
            }

            @Override
            public boolean isCanceled() {
                return ProgressMonitorFocusJobDialog.this.getProgressMonitor().isCanceled();
            }

            private void runAsync(final Runnable runnable) {
                Display display;
                if (ProgressMonitorFocusJobDialog.this.alreadyClosed) {
                    return;
                }
                Shell currentShell = ProgressMonitorFocusJobDialog.this.getShell();
                if (currentShell == null) {
                    display = Display.getDefault();
                } else {
                    if (currentShell.isDisposed()) {
                        return;
                    }
                    display = currentShell.getDisplay();
                }
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).ProgressMonitorFocusJobDialog.this.alreadyClosed) {
                            return;
                        }
                        Shell shell = ProgressMonitorFocusJobDialog.this.getShell();
                        if (shell != null && shell.isDisposed()) {
                            return;
                        }
                        runnable.run();
                    }
                });
            }

            @Override
            public void setBlocked(IStatus reason) {
                final IStatus finalReason = reason;
                this.runAsync(new Runnable(){

                    @Override
                    public void run() {
                        ((IProgressMonitorWithBlocking)ProgressMonitorFocusJobDialog.this.getProgressMonitor()).setBlocked(finalReason);
                    }
                });
            }

            @Override
            public void setCanceled(boolean value) {
            }

            @Override
            public void setTaskName(String name) {
                final String finalName = name;
                this.runAsync(new Runnable(){

                    @Override
                    public void run() {
                        ProgressMonitorFocusJobDialog.this.getProgressMonitor().setTaskName(finalName);
                    }
                });
            }

            @Override
            public void subTask(String name) {
                final String finalName = name;
                this.runAsync(new Runnable(){

                    @Override
                    public void run() {
                        ProgressMonitorFocusJobDialog.this.getProgressMonitor().subTask(finalName);
                    }
                });
            }

            @Override
            public void worked(int work) {
                this.internalWorked(work);
            }
        };
    }

    @Override
    public int open() {
        int result = super.open();
        IJobChangeListener listener = this.createCloseListener();
        this.job.addJobChangeListener(listener);
        if (this.job.getState() == 0) {
            this.job.removeJobChangeListener(listener);
            this.finishedRun();
            this.cleanUpFinishedJob();
        }
        return result;
    }

    public void show(Job jobToWatch, final Shell originatingShell) {
        this.job = jobToWatch;
        this.job.setProperty(IProgressConstants.PROPERTY_IN_DIALOG, Boolean.TRUE);
        ProgressManager.getInstance().progressFor(this.job).addProgressListener(this.getBlockingProgressMonitor());
        this.setOpenOnRun(false);
        this.aboutToRun();
        BusyIndicator.showWhile(PlatformUI.getWorkbench().getDisplay(), new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(ProgressManagerUtil.SHORT_OPERATION_TIME);
                }
                catch (InterruptedException interruptedException) {}
            }
        });
        WorkbenchJob openJob = new WorkbenchJob(ProgressMessages.ProgressMonitorFocusJobDialog_UserDialogJob){

            @Override
            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (ProgressMonitorFocusJobDialog.this.job.getState() == 0) {
                    ProgressMonitorFocusJobDialog.this.finishedRun();
                    ProgressMonitorFocusJobDialog.this.cleanUpFinishedJob();
                    return Status.CANCEL_STATUS;
                }
                if (!ProgressManagerUtil.safeToOpen(ProgressMonitorFocusJobDialog.this, originatingShell)) {
                    return Status.CANCEL_STATUS;
                }
                if (ProgressMonitorFocusJobDialog.this.getParentShell() != null && ProgressMonitorFocusJobDialog.this.getParentShell().isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                ProgressMonitorFocusJobDialog.this.open();
                return Status.OK_STATUS;
            }
        };
        openJob.setSystem(true);
        openJob.schedule();
    }

    private void cleanUpFinishedJob() {
        ProgressManager.getInstance().checkForStaleness(this.job);
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Control area = super.createDialogArea(parent);
        this.getProgressMonitor().setTaskName(ProgressManager.getInstance().getJobInfo(this.job).getDisplayString());
        return area;
    }

    @Override
    protected void createExtendedDialogArea(Composite parent) {
        this.showDialog = WorkbenchPlugin.getDefault().getPreferenceStore().getBoolean("RUN_IN_BACKGROUND");
        final Button showUserDialogButton = new Button(parent, 32);
        showUserDialogButton.setText(WorkbenchMessages.WorkbenchPreference_RunInBackgroundButton);
        showUserDialogButton.setToolTipText(WorkbenchMessages.WorkbenchPreference_RunInBackgroundToolTip);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        gd.horizontalAlignment = 4;
        showUserDialogButton.setLayoutData(gd);
        showUserDialogButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                ProgressMonitorFocusJobDialog.this.showDialog = showUserDialogButton.getSelection();
            }
        });
        super.createExtendedDialogArea(parent);
    }

    @Override
    public boolean close() {
        if (this.getReturnCode() != 1) {
            WorkbenchPlugin.getDefault().getPreferenceStore().setValue("RUN_IN_BACKGROUND", this.showDialog);
        }
        return super.close();
    }
}

