/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.about;

import java.io.IOException;
import java.security.GeneralSecurityException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.signedcontent.SignedContent;
import org.eclipse.osgi.signedcontent.SignedContentFactory;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.about.AboutData;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class AboutBundleData
extends AboutData {
    private Bundle bundle;
    private boolean isSignedDetermined = false;
    private boolean isSigned;

    public AboutBundleData(Bundle bundle) {
        super(AboutBundleData.getResourceString(bundle, "Bundle-Vendor"), AboutBundleData.getResourceString(bundle, "Bundle-Name"), AboutBundleData.getResourceString(bundle, "Bundle-Version"), bundle.getSymbolicName());
        this.bundle = bundle;
    }

    public int getState() {
        return this.bundle.getState();
    }

    public String getStateName() {
        switch (this.getState()) {
            case 2: {
                return WorkbenchMessages.AboutPluginsDialog_state_installed;
            }
            case 4: {
                return WorkbenchMessages.AboutPluginsDialog_state_resolved;
            }
            case 8: {
                return WorkbenchMessages.AboutPluginsDialog_state_starting;
            }
            case 16: {
                return WorkbenchMessages.AboutPluginsDialog_state_stopping;
            }
            case 1: {
                return WorkbenchMessages.AboutPluginsDialog_state_uninstalled;
            }
            case 32: {
                return WorkbenchMessages.AboutPluginsDialog_state_active;
            }
        }
        return WorkbenchMessages.AboutPluginsDialog_state_unknown;
    }

    private static String getResourceString(Bundle bundle, String headerName) {
        String value = bundle.getHeaders().get(headerName);
        return value == null ? null : Platform.getResourceString(bundle, value);
    }

    public boolean isSignedDetermined() {
        return this.isSignedDetermined;
    }

    public boolean isSigned() throws IllegalStateException {
        if (this.isSignedDetermined) {
            return this.isSigned;
        }
        BundleContext bundleContext = WorkbenchPlugin.getDefault().getBundleContext();
        ServiceReference<?> factoryRef = bundleContext.getServiceReference(SignedContentFactory.class.getName());
        if (factoryRef == null) {
            throw new IllegalStateException();
        }
        SignedContentFactory contentFactory = (SignedContentFactory)bundleContext.getService(factoryRef);
        try {
            SignedContent signedContent = contentFactory.getSignedContent(this.bundle);
            this.isSigned = signedContent != null && signedContent.isSigned();
            this.isSignedDetermined = true;
            boolean bl = this.isSigned;
            return bl;
        }
        catch (IOException e) {
            throw (IllegalStateException)new IllegalStateException().initCause(e);
        }
        catch (GeneralSecurityException e) {
            throw (IllegalStateException)new IllegalStateException().initCause(e);
        }
        finally {
            bundleContext.ungetService(factoryRef);
        }
    }

    public Bundle getBundle() {
        return this.bundle;
    }
}

