/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.compatibility.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.osgi.compatibility.state.StateConverter;
import org.eclipse.osgi.container.ModuleCapability;
import org.eclipse.osgi.container.ModuleContainer;
import org.eclipse.osgi.container.ModuleDatabase;
import org.eclipse.osgi.container.ModuleRevision;
import org.eclipse.osgi.container.ModuleWire;
import org.eclipse.osgi.container.ModuleWiring;
import org.eclipse.osgi.internal.resolver.BaseDescriptionImpl;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;

class PlatformBundleListener
implements SynchronousBundleListener,
FrameworkListener,
ResolverHookFactory {
    private final State systemState;
    private final StateConverter converter;
    private final ModuleDatabase database;
    private final ModuleContainer container;
    private long lastResolveStamp = -1L;
    private AtomicBoolean gotUnresolved = new AtomicBoolean(false);

    PlatformBundleListener(State systemState, StateConverter converter, ModuleDatabase database, ModuleContainer container) {
        this.systemState = systemState;
        this.converter = converter;
        this.database = database;
        this.container = container;
    }

    @Override
    public void bundleChanged(BundleEvent event) {
        switch (event.getType()) {
            case 1: {
                BundleRevision revision = event.getBundle().adapt(BundleRevision.class);
                if (revision == null) break;
                this.systemState.addBundle(this.converter.createDescription(revision));
                this.systemState.setTimeStamp(this.database.getRevisionsTimestamp());
                break;
            }
            case 16: {
                this.systemState.removeBundle(event.getBundle().getBundleId());
                this.systemState.setTimeStamp(this.database.getRevisionsTimestamp());
                break;
            }
            case 8: {
                BundleRevision revision = event.getBundle().adapt(BundleRevision.class);
                if (revision == null) break;
                this.systemState.updateBundle(this.converter.createDescription(revision));
                this.systemState.setTimeStamp(this.database.getRevisionsTimestamp());
                break;
            }
            case 64: {
                this.gotUnresolved.set(true);
                break;
            }
            case 32: {
                this.resolve(this.gotUnresolved.getAndSet(false));
                break;
            }
        }
    }

    private void resolve(boolean uninstalled) {
        this.database.readLock();
        try {
            if (this.lastResolveStamp != this.database.getRevisionsTimestamp()) {
                Collection<ModuleRevision> containerRemovalPending = this.container.getRemovalPending();
                BundleDescription[] stateRemovalPendingDescs = this.systemState.getRemovalPending();
                ArrayList<BundleDescription> stateRemovalPending = new ArrayList<BundleDescription>(stateRemovalPendingDescs.length);
                BundleDescription[] bundleDescriptionArray = stateRemovalPendingDescs;
                int n = stateRemovalPendingDescs.length;
                int n2 = 0;
                while (n2 < n) {
                    BundleDescription description = bundleDescriptionArray[n2];
                    if (!containerRemovalPending.contains(description.getUserObject())) {
                        stateRemovalPending.add(description);
                    }
                    ++n2;
                }
                if (!stateRemovalPending.isEmpty()) {
                    this.systemState.resolve(stateRemovalPending.toArray(new BundleDescription[stateRemovalPending.size()]), true);
                } else {
                    this.systemState.resolve(!uninstalled);
                }
                this.lastResolveStamp = this.database.getRevisionsTimestamp();
                this.systemState.setTimeStamp(this.database.getRevisionsTimestamp());
            }
        }
        finally {
            this.database.readUnlock();
        }
    }

    @Override
    public void frameworkEvent(FrameworkEvent event) {
        if (event.getType() == 4) {
            this.resolve(this.gotUnresolved.getAndSet(false));
        }
    }

    @Override
    public ResolverHook begin(Collection<BundleRevision> triggers) {
        return new ResolverHook(){

            @Override
            public void filterSingletonCollisions(BundleCapability singleton, Collection<BundleCapability> collisionCandidates) {
                BundleDescription desc = (BundleDescription)singleton.getRevision();
                ModuleRevision revision = (ModuleRevision)desc.getUserObject();
                if (revision.getWiring() != null) {
                    collisionCandidates.clear();
                } else {
                    Iterator<BundleCapability> iCandidates = collisionCandidates.iterator();
                    while (iCandidates.hasNext()) {
                        BundleDescription candDesc = (BundleDescription)iCandidates.next().getRevision();
                        ModuleRevision candRevision = (ModuleRevision)candDesc.getUserObject();
                        if (candRevision.getWiring() != null) continue;
                        iCandidates.remove();
                    }
                }
            }

            @Override
            public void filterResolvable(Collection<BundleRevision> candidates) {
                Iterator<BundleRevision> iCandidates = candidates.iterator();
                while (iCandidates.hasNext()) {
                    BundleDescription candDesc = (BundleDescription)iCandidates.next();
                    ModuleRevision candRevision = (ModuleRevision)candDesc.getUserObject();
                    if (candRevision.getWiring() != null) continue;
                    iCandidates.remove();
                }
            }

            @Override
            public void filterMatches(BundleRequirement requirement, Collection<BundleCapability> candidates) {
                String namespace = requirement.getNamespace();
                BundleDescription reqDesc = (BundleDescription)requirement.getRevision();
                ModuleRevision reqRevision = (ModuleRevision)reqDesc.getUserObject();
                ModuleWiring reqWiring = reqRevision.getWiring();
                if (reqWiring == null) {
                    candidates.clear();
                    return;
                }
                ArrayList<ModuleWiring> wirings = new ArrayList<ModuleWiring>(1);
                if ((reqRevision.getTypes() & 1) != 0) {
                    if ("osgi.ee".equals(namespace) || "osgi.wiring.host".equals(namespace)) {
                        wirings.add(reqWiring);
                    } else {
                        List<ModuleWire> hostWires = reqWiring.getRequiredModuleWires(namespace);
                        for (ModuleWire hostWire : hostWires) {
                            ModuleWiring hostWiring = hostWire.getProviderWiring();
                            if (hostWiring == null) continue;
                            wirings.add(hostWiring);
                        }
                    }
                } else {
                    wirings.add(reqWiring);
                }
                Iterator<BundleCapability> iCandidates = candidates.iterator();
                while (iCandidates.hasNext()) {
                    BaseDescriptionImpl.BaseCapability baseCapability = (BaseDescriptionImpl.BaseCapability)iCandidates.next();
                    Object userObject = baseCapability.getBaseDescription().getUserObject();
                    boolean foundCandidate = false;
                    block2: for (ModuleWiring wiring : wirings) {
                        List<ModuleWire> wires = wiring.getRequiredModuleWires(namespace);
                        for (ModuleWire wire : wires) {
                            if (userObject instanceof ModuleRevision && userObject.equals(wire.getProvider())) {
                                foundCandidate = true;
                            } else if (userObject instanceof ModuleCapability && userObject.equals(wire.getCapability())) {
                                foundCandidate = true;
                            }
                            if (foundCandidate) break block2;
                        }
                    }
                    if (foundCandidate) continue;
                    iCandidates.remove();
                }
            }

            @Override
            public void end() {
            }
        };
    }
}

