/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe2.language.scoping;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.AbstractScope;
import org.eclipse.xtext.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapBasedScope
extends AbstractScope {
    private Map<QualifiedName, ? extends EObject> entries;

    public MapBasedScope(Map<QualifiedName, ? extends EObject> entries) {
        super(IScope.NULLSCOPE, false);
        this.entries = entries;
    }

    @Override
    protected Iterable<IEObjectDescription> getAllLocalElements() {
        return Iterables.transform(this.entries.entrySet(), new Function<Map.Entry<QualifiedName, ? extends EObject>, IEObjectDescription>(){

            @Override
            public IEObjectDescription apply(Map.Entry<QualifiedName, ? extends EObject> from) {
                return new MapEntry(from);
            }
        });
    }

    @Override
    protected Iterable<IEObjectDescription> getLocalElementsByName(QualifiedName name) {
        EObject element = this.entries.get(name);
        if (element != null) {
            return Collections.singleton(EObjectDescription.create(name, element));
        }
        return Collections.emptySet();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MapEntry
    implements IEObjectDescription {
        private final Map.Entry<QualifiedName, ? extends EObject> entry;

        public MapEntry(Map.Entry<QualifiedName, ? extends EObject> entry) {
            this.entry = entry;
        }

        @Override
        public QualifiedName getName() {
            return this.entry.getKey();
        }

        @Override
        public QualifiedName getQualifiedName() {
            return this.entry.getKey();
        }

        @Override
        public EObject getEObjectOrProxy() {
            return this.entry.getValue();
        }

        @Override
        public URI getEObjectURI() {
            return EcoreUtil.getURI(this.entry.getValue());
        }

        @Override
        public EClass getEClass() {
            return this.entry.getValue().eClass();
        }

        @Override
        public String getUserData(String name) {
            return null;
        }

        @Override
        public String[] getUserDataKeys() {
            return Strings.EMPTY_ARRAY;
        }
    }
}

