/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe.core.container;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.mwe.core.ConfigurationException;
import org.eclipse.emf.mwe.core.WorkflowComponent;
import org.eclipse.emf.mwe.core.WorkflowComponentWithID;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.ao.AbstractWorkflowAdvice;
import org.eclipse.emf.mwe.core.config.FeatureComponent;
import org.eclipse.emf.mwe.core.container.ConditionEvaluationException;
import org.eclipse.emf.mwe.core.container.IfComponent;
import org.eclipse.emf.mwe.core.container.WorkflowConditional;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.lib.Mwe2Bridge;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.emf.mwe.internal.core.Workflow;
import org.eclipse.emf.mwe.internal.core.ast.parser.Location;
import org.eclipse.emf.mwe.internal.core.util.ComponentPrinter;
import org.eclipse.emf.mwe2.runtime.workflow.IWorkflowComponent;
import org.eclipse.emf.mwe2.runtime.workflow.IWorkflowContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeComponent
implements WorkflowComponentWithID,
IWorkflowComponent {
    private static final String COMPONENT_NAME = "Composite component";
    protected static final Log log = LogFactory.getLog(CompositeComponent.class);
    private final String name;
    private String resource;
    private Location location;
    private Location ownLocation;
    private CompositeComponent container;
    protected List<WorkflowComponent> components = new ArrayList<WorkflowComponent>();
    private String id;
    private Mwe2Bridge bridge;

    public CompositeComponent(String name) {
        this.name = name;
    }

    public List<WorkflowComponent> getComponents() {
        return this.components;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getLogMessage() {
        return "CompositeComponent " + (this.id != null ? this.id : "");
    }

    @Override
    public void invoke(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        this.internalInvoke(ctx, monitor, issues);
    }

    private void internalInvoke(WorkflowContext model, ProgressMonitor monitor, Issues issues) {
        for (WorkflowComponent comp : this.components) {
            if (monitor != null && monitor.isCanceled()) {
                return;
            }
            if (comp instanceof AbstractWorkflowAdvice) continue;
            comp.setContainer(this);
            if (monitor != null) {
                monitor.preTask(comp, model);
            }
            log.info(ComponentPrinter.getString(comp));
            comp.invoke(model, monitor, issues);
            if (monitor == null) continue;
            monitor.postTask(comp, model);
        }
    }

    @Override
    public void checkConfiguration(Issues issues) throws ConfigurationException {
        for (WorkflowComponent comp : this.components) {
            if (!(comp instanceof AbstractWorkflowAdvice)) continue;
            AbstractWorkflowAdvice advice = (AbstractWorkflowAdvice)comp;
            String adviceTargetID = advice.getAdviceTarget();
            if (adviceTargetID == null) {
                issues.addError(advice, "No 'adviceTarget' given.");
                continue;
            }
            Collection<WorkflowComponent> targetComponents = this.findComponentByID(adviceTargetID);
            if (targetComponents.size() == 0) {
                issues.addWarning(advice, "No component with ID '" + adviceTargetID + "' found.");
            }
            if (targetComponents.size() > 1) {
                issues.addWarning(advice, "More than on component with ID '" + adviceTargetID + "' found.");
            }
            if (!this.needsToWeave(comp, issues)) continue;
            for (WorkflowComponent c : targetComponents) {
                ((AbstractWorkflowAdvice)comp).weave(c, issues);
            }
        }
        for (WorkflowComponent comp : this.components) {
            if (comp instanceof AbstractWorkflowAdvice) continue;
            if (log.isDebugEnabled()) {
                log.debug("Checking configuration of: " + ComponentPrinter.getString(comp));
            }
            comp.checkConfiguration(issues);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean needsToWeave(WorkflowComponent comp, Issues issues) {
        try {
            WorkflowComponent current = comp;
            while (true) {
                WorkflowConditional cond;
                if (current == null) {
                    return true;
                }
                if (current instanceof WorkflowConditional && !(cond = (WorkflowConditional)((Object)current)).evaluate()) {
                    return false;
                }
                current = current.getContainer();
            }
        }
        catch (ConditionEvaluationException ex) {
            issues.addError(this, ex.getMessage());
            return false;
        }
    }

    private Collection<WorkflowComponent> findComponentByID(String adviceTargetID) {
        ArrayList<WorkflowComponent> hits = new ArrayList<WorkflowComponent>();
        CompositeComponent c = this;
        while (c.getContainer() != null) {
            c = c.getContainer();
        }
        c.resolveComponentByID(adviceTargetID, hits);
        return hits;
    }

    private void resolveComponentByID(String adviceTargetID, List<WorkflowComponent> hits) {
        for (WorkflowComponent component : this.components) {
            if (!(component instanceof WorkflowComponentWithID) || !adviceTargetID.equals(((WorkflowComponentWithID)component).getId())) continue;
            hits.add(component);
        }
        for (WorkflowComponent component : this.components) {
            if (!(component instanceof CompositeComponent)) continue;
            ((CompositeComponent)component).resolveComponentByID(adviceTargetID, hits);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    public Location getOwnLocation() {
        return this.ownLocation;
    }

    public void setOwnLocation(Location endLocation) {
        this.ownLocation = endLocation;
    }

    public void addBean(Object obj) {
    }

    public void addComponent(WorkflowComponent component) {
        this.components.add(component);
        component.setContainer(this);
    }

    public void addCartridge(Workflow cartridge) {
        this.components.add(cartridge);
        cartridge.setContainer(this);
    }

    public void addIf(IfComponent comp) {
        this.addComponent(comp);
    }

    public void addFeature(FeatureComponent comp) {
        this.addComponent(comp);
    }

    @Override
    public CompositeComponent getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(CompositeComponent container) {
        this.container = container;
    }

    public void put(String name, WorkflowComponent comp) {
        this.addComponent(comp);
    }

    @Override
    public String getComponentName() {
        return COMPONENT_NAME;
    }

    protected Mwe2Bridge getBridge() {
        if (this.bridge == null) {
            this.bridge = new Mwe2Bridge(this);
        }
        return this.bridge;
    }

    @Override
    public void preInvoke() {
        this.getBridge().preInvoke();
    }

    @Override
    public void invoke(IWorkflowContext ctx) {
        this.getBridge().invoke(ctx);
    }

    @Override
    public void postInvoke() {
        this.getBridge().postInvoke();
    }
}

