/*
 * Decompiled with CFR 0.152.
 */
package net.danieldietrich.protectedregions.core;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.danieldietrich.protectedregions.core.DefaultRegionParser;
import net.danieldietrich.protectedregions.core.IRegionOracle;
import net.danieldietrich.protectedregions.core.IRegionParser;

public class RegionParserBuilder {
    private final List<IRegionParser.ICommentType> commentTypes = new ArrayList<IRegionParser.ICommentType>();
    private final List<IRegionParser.ICDataType> cdataTypes = new ArrayList<IRegionParser.ICDataType>();
    private String name = "unnamed";
    private IRegionOracle oracle = null;
    private boolean inverse = false;

    public RegionParserBuilder name(String name) {
        this.name = name;
        return this;
    }

    public RegionParserBuilder addComment(String start, String end) {
        this.commentTypes.add(new CommentType(start, end, CommentType.Style.MULTILINE));
        return this;
    }

    public RegionParserBuilder addNestableComment(String start, String end) {
        this.commentTypes.add(new CommentType(start, end, CommentType.Style.MULTILINE_NESTABLE));
        return this;
    }

    public RegionParserBuilder addComment(String start) {
        this.commentTypes.add(new CommentType(start, null, CommentType.Style.SINGLELINE));
        return this;
    }

    public RegionParserBuilder ignoreCData(char delimiter) {
        this.cdataTypes.add(new CDataType(String.valueOf(delimiter), String.valueOf(delimiter), null));
        return this;
    }

    public RegionParserBuilder ignoreCData(char delimiter, char escapeCharacter) {
        this.cdataTypes.add(new CDataType(String.valueOf(delimiter), String.valueOf(delimiter), String.valueOf(escapeCharacter)));
        return this;
    }

    public RegionParserBuilder ignoreCData(String start, String end) {
        this.cdataTypes.add(new CDataType(start, end, null));
        return this;
    }

    public RegionParserBuilder useOracle(IRegionOracle oracle) {
        this.oracle = oracle;
        return this;
    }

    public RegionParserBuilder setInverse(boolean inverse) {
        this.inverse = inverse;
        return this;
    }

    public IRegionParser build() {
        if (this.oracle == null) {
            this.oracle = new DefaultOracle(this.inverse);
        }
        DefaultRegionParser result = new DefaultRegionParser(this.name, this.commentTypes, this.cdataTypes, this.oracle, this.inverse);
        return result;
    }

    private static class CDataType
    implements IRegionParser.ICDataType {
        final String start;
        final String end;
        final String escapeString;

        CDataType(String start, String end, String escapeString) {
            this.start = start;
            this.end = end;
            this.escapeString = escapeString;
        }

        public String getStart() {
            return this.start;
        }

        public String getEnd() {
            return this.end;
        }

        public String getEscapeString() {
            return this.escapeString;
        }

        public boolean isEscapable() {
            return this.escapeString != null;
        }
    }

    private static class CommentType
    implements IRegionParser.ICommentType {
        final String start;
        final String end;
        final Style style;

        CommentType(String start, String end, Style style) {
            this.start = start;
            this.end = end;
            this.style = style;
        }

        public boolean isMultiline() {
            return !Style.SINGLELINE.equals((Object)this.style);
        }

        public boolean isNestable() {
            return Style.MULTILINE_NESTABLE.equals((Object)this.style);
        }

        public String getStart() {
            return this.start;
        }

        public String getEnd() {
            return this.end;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum Style {
            MULTILINE,
            MULTILINE_NESTABLE,
            SINGLELINE;

        }
    }

    private static class DefaultOracle
    implements IRegionOracle {
        private static final String ID = "([a-zA-Z_$][a-zA-Z\\d_$]*\\.)*[a-zA-Z_$][a-zA-Z\\d_$]*";
        private Pattern start;
        private Pattern end;

        DefaultOracle(boolean inverse) {
            String label = inverse ? "GENERATED" : "PROTECTED\\s+REGION";
            this.start = Pattern.compile("\\s*" + label + "\\s+ID\\s*\\(\\s*" + ID + "\\s*\\)\\s+(ENABLED\\s+)?START\\s*");
            this.end = Pattern.compile("\\s*" + label + "\\s+END\\s*");
        }

        public boolean isMarkedRegionStart(String s) {
            return this.start.matcher(s).matches();
        }

        public boolean isMarkedRegionEnd(String s) {
            return this.end.matcher(s).matches();
        }

        public String getId(String markedRegionStart) {
            int i = markedRegionStart.indexOf("(");
            int j = i + 1 + markedRegionStart.substring(i + 1).indexOf(")");
            return i != -1 && j != -1 ? markedRegionStart.substring(i + 1, j).trim() : null;
        }

        public boolean isEnabled(String markedRegionStart) {
            return markedRegionStart.contains("ENABLED");
        }
    }
}

