/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tango.pogo.generator.html;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import fr.esrf.tango.pogo.generator.common.StringUtils;
import fr.esrf.tango.pogo.generator.html.HtmlUtils;
import fr.esrf.tango.pogo.pogoDsl.ClassDescription;
import fr.esrf.tango.pogo.pogoDsl.PogoDeviceClass;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public class HtmlIndex
implements IGenerator {
    @Inject
    @Extension
    private HtmlUtils _htmlUtils;

    @Override
    public void doGenerate(Resource resource, IFileSystemAccess fsa) {
        TreeIterator<EObject> _allContents = resource.getAllContents();
        Iterable<EObject> _iterable = IteratorExtensions.toIterable(_allContents);
        Iterable<PogoDeviceClass> _filter = Iterables.filter(_iterable, PogoDeviceClass.class);
        for (PogoDeviceClass cls : _filter) {
            ClassDescription _description = cls.getDescription();
            String _filestogenerate = _description.getFilestogenerate();
            boolean _contains = _filestogenerate.contains("html");
            if (!_contains) continue;
            StringUtils.printTrace("Generating doc_html/index.html");
            CharSequence _generateHtmlIndexFile = this.generateHtmlIndexFile(cls);
            fsa.generateFile("doc_html/index.html", _generateHtmlIndexFile);
            StringUtils.printTrace("Generating doc_html/TitleBanner.html");
            CharSequence _generateHtmlTitleBannerFile = this.generateHtmlTitleBannerFile(cls);
            fsa.generateFile("doc_html/TitleBanner.html", _generateHtmlTitleBannerFile);
        }
    }

    public CharSequence generateHtmlIndexFile(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
        _builder.newLine();
        _builder.append("<HTML>");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("<HEAD>");
        _builder.newLine();
        _builder.append("       ");
        _builder.append("<META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=iso-8859-1\">");
        _builder.newLine();
        _builder.append("       ");
        _builder.append("<META name=\"GENERATOR\" CONTENT=\"Mozilla/4.04 [en] (X11; I; SunOS 5.6 sun4d) [Netscape]\">");
        _builder.newLine();
        _builder.append("       ");
        _builder.append("<META name=\"Author\" CONTENT=\"Pascal Verdier\">");
        _builder.newLine();
        _builder.append("       ");
        _builder.append("<META name=\"Description\" CONTENT=\"");
        String _name = cls.getName();
        _builder.append((Object)_name, "       ");
        _builder.append("  Pages\">");
        _builder.newLineIfNotEmpty();
        _builder.append("       ");
        _builder.append("<META name=\"Keywords\" CONTENT=\"");
        String _name_1 = cls.getName();
        _builder.append((Object)_name_1, "       ");
        _builder.append(" Tango class User Guide\">");
        _builder.newLineIfNotEmpty();
        _builder.append("       ");
        _builder.append("<TITLE>");
        String _name_2 = cls.getName();
        _builder.append((Object)_name_2, "       ");
        _builder.append(" Tango class User Guide</TITLE>");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("</HEAD>");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        boolean _isFromClasses2www = HtmlUtils.isFromClasses2www();
        if (_isFromClasses2www) {
            _builder.append("<!--- Definition for the 2 frames window ----------->");
            _builder.newLine();
            _builder.append("<frameset rows=\"65,*\">");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("<frame src=\"TitleBanner.html\"        name=\"title\">");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("<frame src=\"ClassDescription.html\"   name=\"document\">");
            _builder.newLine();
            _builder.append("</frameset>");
            _builder.newLine();
        } else {
            _builder.append("<!--- Definition for the 4 frames window ----------->");
            _builder.newLine();
            _builder.append("<frameset rows=\"58,65,*,65\">");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("<frame src=\"http://www.esrf.fr/computing/cs/tango/TangoBanner.html\"   name=\"header\">");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("<frame src=\"TitleBanner.html\"        name=\"title\">");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("<frame src=\"ClassDescription.html\"   name=\"document\">");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("<frame src=\"http://www.esrf.fr/computing/cs/tango/SrcForgeBanner.html\" name=\"footer\" >");
            _builder.newLine();
            _builder.append("</frameset>");
            _builder.newLine();
        }
        _builder.append("</html>");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateHtmlTitleBannerFile(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<!DOCTYPE html PUBLIC \"-//W3C//Dtd XHTML 1.0 transitional//EN\" \"http://www.w3.org/TR/xhtml1/Dtd/xhtml1-transitional.dtd\">");
        _builder.newLine();
        _builder.append("<html>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("<center>");
        _builder.newLine();
        _builder.append("\t\t");
        String _name = cls.getName();
        String _plus = String.valueOf(_name) + " Tango ";
        ClassDescription _description = cls.getDescription();
        String _language = _description.getLanguage();
        String _plus_1 = String.valueOf(_plus) + _language;
        String _plus_2 = String.valueOf(_plus_1) + " Class";
        String _htmlTitle = this._htmlUtils.htmlTitle(_plus_2);
        _builder.append((Object)_htmlTitle, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("<table BORDER=\"1\" WIDTH=\"100%\" CELLSPACING=0>");
        _builder.newLine();
        _builder.append("\t       ");
        _builder.append("<td ALIGN=\"center\"> <a href=\"ClassDescription.html\" target=\"document\">  Description </a></td>");
        _builder.newLine();
        _builder.append("\t       ");
        _builder.append("<td ALIGN=\"center\"> <a href=\"Properties.html\"       target=\"document\">  Properties  </a></td>");
        _builder.newLine();
        _builder.append("\t       ");
        _builder.append("<td ALIGN=\"center\"> <a href=\"Commands.html\"         target=\"document\">  Commands    </a></td>");
        _builder.newLine();
        _builder.append("\t       ");
        _builder.append("<td ALIGN=\"center\"> <a href=\"Attributes.html\"       target=\"document\">  Attributes  </a></td>");
        _builder.newLine();
        _builder.append("\t       ");
        _builder.append("<td ALIGN=\"center\"> <a href=\"States.html\"           target=\"document\">  States      </a></td>");
        _builder.newLine();
        _builder.append("\t       ");
        _builder.append("<td ALIGN=\"center\"> <a href=\"FullDocument.html\"     target=\"new\">       Printable   </a></td>");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("</table>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("</center>");
        _builder.newLine();
        _builder.append("</html>");
        _builder.newLine();
        return _builder;
    }
}

