/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tango.pogo.generator.cpp.utils;

import com.google.inject.Inject;
import fr.esrf.tango.pogo.generator.common.StringUtils;
import fr.esrf.tango.pogo.generator.cpp.utils.CppStringUtils;
import fr.esrf.tango.pogo.generator.cpp.utils.CppTypeDefinitions;
import fr.esrf.tango.pogo.generator.cpp.utils.Headers;
import fr.esrf.tango.pogo.generator.cpp.utils.InheritanceUtils;
import fr.esrf.tango.pogo.generator.cpp.utils.ProtectedArea;
import fr.esrf.tango.pogo.pogoDsl.ClassDescription;
import fr.esrf.tango.pogo.pogoDsl.PogoDeviceClass;
import fr.esrf.tango.pogo.pogoDsl.PropType;
import fr.esrf.tango.pogo.pogoDsl.Property;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;

public class Properties {
    @Inject
    @Extension
    private CppStringUtils _cppStringUtils;
    @Inject
    @Extension
    private InheritanceUtils _inheritanceUtils;
    @Inject
    @Extension
    private ProtectedArea _protectedArea;
    @Inject
    @Extension
    private Headers _headers;

    public CharSequence getDevicePropertiesMethod(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        String _simpleMethodHeader = this._headers.simpleMethodHeader(cls, "get_device_property", "Read database to initialize property data members.");
        _builder.append((Object)_simpleMethodHeader, "");
        _builder.newLineIfNotEmpty();
        _builder.append("void ");
        String _name = cls.getName();
        _builder.append((Object)_name, "");
        _builder.append("::get_device_property()");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        String _protectedArea = this._protectedArea.protectedArea(cls, "get_device_property_before", "Initialize property data members", true);
        _builder.append((Object)_protectedArea, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        EList<Property> _deviceProperties = cls.getDeviceProperties();
        boolean _hasMandatoryProperty = this._cppStringUtils.hasMandatoryProperty(_deviceProperties);
        if (_hasMandatoryProperty) {
            _builder.append("\t");
            _builder.append("mandatoryNotDefined = false;");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("\t");
        _builder.append("//\tRead device properties from database.");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("Tango::DbData\tdev_prop;");
        _builder.newLine();
        EList<Property> _deviceProperties_1 = cls.getDeviceProperties();
        for (Property property : _deviceProperties_1) {
            _builder.append("\t");
            _builder.append("dev_prop.push_back(Tango::DbDatum(\"");
            String _name_1 = property.getName();
            _builder.append((Object)_name_1, "\t");
            _builder.append("\"));");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("\t");
        _builder.append("//\tis there at least one property to be read ?");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (dev_prop.size()>0)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("//\tCall database and extract values");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (Tango::Util::instance()->_UseDb==true)");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("get_db_device()->get_property(dev_prop);");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("//\tget instance on ");
        String _name_2 = cls.getName();
        _builder.append((Object)_name_2, "\t\t");
        _builder.append("Class to get class property");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("Tango::DbDatum\tdef_prop, cl_prop;");
        _builder.newLine();
        _builder.append("\t\t");
        String _name_3 = cls.getName();
        _builder.append((Object)_name_3, "\t\t");
        _builder.append("Class\t*ds_class =");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("(static_cast<");
        String _name_4 = cls.getName();
        _builder.append((Object)_name_4, "\t\t\t");
        _builder.append("Class *>(get_device_class()));");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("int\ti = -1;");
        _builder.newLine();
        _builder.newLine();
        EList<Property> _deviceProperties_2 = cls.getDeviceProperties();
        for (Property property_1 : _deviceProperties_2) {
            _builder.append("\t\t");
            _builder.append("//\tTry to initialize ");
            String _name_5 = property_1.getName();
            _builder.append((Object)_name_5, "\t\t");
            _builder.append(" from class property");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("cl_prop = ds_class->get_class_property(dev_prop[++i].name);");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("if (cl_prop.is_empty()==false)\tcl_prop  >>  ");
            String _name_6 = property_1.getName();
            String _dataMemberName = this._cppStringUtils.dataMemberName(_name_6);
            _builder.append((Object)_dataMemberName, "\t\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("else {");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("//\tTry to initialize ");
            String _name_7 = property_1.getName();
            _builder.append((Object)_name_7, "\t\t\t");
            _builder.append(" from default device value");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("def_prop = ds_class->get_default_device_property(dev_prop[i].name);");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("if (def_prop.is_empty()==false)\tdef_prop  >>  ");
            String _name_8 = property_1.getName();
            String _dataMemberName_1 = this._cppStringUtils.dataMemberName(_name_8);
            _builder.append((Object)_dataMemberName_1, "\t\t\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("//\tAnd try to extract ");
            String _name_9 = property_1.getName();
            _builder.append((Object)_name_9, "\t\t");
            _builder.append(" value from database");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("if (dev_prop[i].is_empty()==false)\tdev_prop[i]  >>  ");
            String _name_10 = property_1.getName();
            String _dataMemberName_2 = this._cppStringUtils.dataMemberName(_name_10);
            _builder.append((Object)_dataMemberName_2, "\t\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            String _mandatory = property_1.getMandatory();
            boolean _isTrue = StringUtils.isTrue(_mandatory);
            if (_isTrue) {
                _builder.append("\t\t");
                _builder.append("//\tProperty StartDsPath is mandatory, check if has been defined in database.");
                _builder.newLine();
                _builder.append("\t\t");
                _builder.append("check_mandatory_property(cl_prop, dev_prop[i]);");
                _builder.newLine();
            }
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        String _protectedArea_1 = this._protectedArea.protectedArea(cls, "get_device_property_after", "Check device property data members init", true);
        _builder.append((Object)_protectedArea_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getClassPropertiesMethod(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        String _simpleMethodHeaderClass = this._headers.simpleMethodHeaderClass(cls, "get_class_property", "Read database to initialize class property data members.");
        _builder.append((Object)_simpleMethodHeaderClass, "");
        _builder.newLineIfNotEmpty();
        _builder.append("void ");
        String _name = cls.getName();
        _builder.append((Object)_name, "");
        _builder.append("Class::get_class_property()");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        String _protectedAreaClass = this._protectedArea.protectedAreaClass(cls, "get_class_property_before", "Initialize class property data members", true);
        _builder.append((Object)_protectedAreaClass, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("//\tRead class properties from database.");
        _builder.newLine();
        EList<Property> _classProperties = cls.getClassProperties();
        for (Property property : _classProperties) {
            _builder.append("\t");
            _builder.append("cl_prop.push_back(Tango::DbDatum(\"");
            String _name_1 = property.getName();
            _builder.append((Object)_name_1, "\t");
            _builder.append("\"));");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("//\tCall database and extract values");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (Tango::Util::instance()->_UseDb==true)");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("get_db_class()->get_property(cl_prop);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("Tango::DbDatum\tdef_prop;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("int\ti = -1;");
        _builder.newLine();
        _builder.newLine();
        EList<Property> _classProperties_1 = cls.getClassProperties();
        for (Property property_1 : _classProperties_1) {
            _builder.append("\t");
            _builder.append("//\tTry to extract ");
            String _name_2 = property_1.getName();
            _builder.append((Object)_name_2, "\t");
            _builder.append(" value");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("if (cl_prop[++i].is_empty()==false)\tcl_prop[i]  >>  ");
            String _name_3 = property_1.getName();
            String _dataMemberName = this._cppStringUtils.dataMemberName(_name_3);
            _builder.append((Object)_dataMemberName, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("else");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("//\tCheck default value for ");
            String _name_4 = property_1.getName();
            _builder.append((Object)_name_4, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("def_prop = get_default_class_property(cl_prop[i].name);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("if (def_prop.is_empty()==false)");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("def_prop    >>  ");
            String _name_5 = property_1.getName();
            String _dataMemberName_1 = this._cppStringUtils.dataMemberName(_name_5);
            _builder.append((Object)_dataMemberName_1, "\t\t\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("cl_prop[i]  <<  ");
            String _name_6 = property_1.getName();
            String _dataMemberName_2 = this._cppStringUtils.dataMemberName(_name_6);
            _builder.append((Object)_dataMemberName_2, "\t\t\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("\t");
        String _protectedAreaClass_1 = this._protectedArea.protectedAreaClass(cls, "get_class_property_after", "Check class property data members init", true);
        _builder.append((Object)_protectedAreaClass_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence propertyRelatedMethod(PogoDeviceClass cls) {
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        String _simpleMethodHeaderClass = this._headers.simpleMethodHeaderClass(cls, "get_class_property", "Get the class property for specified name.");
        _builder.append((Object)_simpleMethodHeaderClass, "");
        _builder.newLineIfNotEmpty();
        _builder.append("Tango::DbDatum ");
        String _name = cls.getName();
        _builder.append((Object)_name, "");
        _builder.append("Class::get_class_property(string &prop_name)");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("for (unsigned int i=0 ; i<cl_prop.size() ; i++)");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (cl_prop[i].name == prop_name)");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return cl_prop[i];");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("//\tif not found, returns  an empty DbDatum");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return Tango::DbDatum(prop_name);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        String _simpleMethodHeaderClass_1 = this._headers.simpleMethodHeaderClass(cls, "get_default_device_property", "Return the default value for device property.");
        _builder.append((Object)_simpleMethodHeaderClass_1, "");
        _builder.newLineIfNotEmpty();
        _builder.append("Tango::DbDatum ");
        String _name_1 = cls.getName();
        _builder.append((Object)_name_1, "");
        _builder.append("Class::get_default_device_property(string &prop_name)");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("for (unsigned int i=0 ; i<dev_def_prop.size() ; i++)");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (dev_def_prop[i].name == prop_name)");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return dev_def_prop[i];");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("//\tif not found, return  an empty DbDatum");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return Tango::DbDatum(prop_name);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        String _simpleMethodHeaderClass_2 = this._headers.simpleMethodHeaderClass(cls, "get_default_class_property", "Return the default value for class property.");
        _builder.append((Object)_simpleMethodHeaderClass_2, "");
        _builder.newLineIfNotEmpty();
        _builder.append("Tango::DbDatum ");
        String _name_2 = cls.getName();
        _builder.append((Object)_name_2, "");
        _builder.append("Class::get_default_class_property(string &prop_name)");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("for (unsigned int i=0 ; i<cl_def_prop.size() ; i++)");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (cl_def_prop[i].name == prop_name)");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return cl_def_prop[i];");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("//\tif not found, return  an empty DbDatum");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return Tango::DbDatum(prop_name);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        EList<Property> _classProperties = cls.getClassProperties();
        int _size = _classProperties.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            CharSequence _classPropertiesMethod = this.getClassPropertiesMethod(cls);
            _builder.append((Object)_classPropertiesMethod, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        CharSequence _setDefaultPropertiesForWizard = this.setDefaultPropertiesForWizard(cls);
        _builder.append((Object)_setDefaultPropertiesForWizard, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _writeClassProperties = this.writeClassProperties(cls);
        _builder.append((Object)_writeClassProperties, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence setDefaultPropertyForWizard(Property property, String target) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("prop_name = \"");
        String _name = property.getName();
        _builder.append((Object)_name, "");
        _builder.append("\";");
        _builder.newLineIfNotEmpty();
        _builder.append("prop_desc = \"");
        String _description = property.getDescription();
        String _oneLineString = this._cppStringUtils.oneLineString(_description);
        _builder.append((Object)_oneLineString, "");
        _builder.append("\";");
        _builder.newLineIfNotEmpty();
        _builder.append("prop_def  = \"");
        EList<String> _defaultPropValue = property.getDefaultPropValue();
        String _list2String = this._cppStringUtils.list2String(_defaultPropValue);
        _builder.append((Object)_list2String, "");
        _builder.append("\";");
        _builder.newLineIfNotEmpty();
        _builder.append("vect_data.clear();");
        _builder.newLine();
        EList<String> _defaultPropValue_1 = property.getDefaultPropValue();
        for (String value : _defaultPropValue_1) {
            _builder.append("vect_data.push_back(\"");
            _builder.append((Object)value, "");
            _builder.append("\");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("if (prop_def.length()>0)");
        _builder.newLine();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("Tango::DbDatum\tdata(prop_name);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("data << vect_data ;");
        _builder.newLine();
        _builder.append("\t");
        boolean _equals = target.equals("class");
        if (_equals) {
            _builder.append("cl");
        } else {
            _builder.append("dev");
        }
        _builder.append("_def_prop.push_back(data);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("add_wiz_");
        _builder.append((Object)target, "\t");
        _builder.append("_prop(prop_name, prop_desc,  prop_def);");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.append("else");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("add_wiz_");
        _builder.append((Object)target, "\t");
        _builder.append("_prop(prop_name, prop_desc);");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence writeClassProperties(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        String _simpleMethodHeaderClass = this._headers.simpleMethodHeaderClass(cls, "write_class_property", "Set class description fields as property in database");
        _builder.append((Object)_simpleMethodHeaderClass, "");
        _builder.newLineIfNotEmpty();
        _builder.append("void ");
        String _name = cls.getName();
        _builder.append((Object)_name, "");
        _builder.append("Class::write_class_property()");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        boolean _isConcreteClass = this._inheritanceUtils.isConcreteClass(cls);
        if (_isConcreteClass) {
            _builder.append("\t");
            _builder.append("//\tFirst time, check if database used");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("if (Tango::Util::_UseDb == false)");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("return;");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t");
            _builder.append("Tango::DbData\tdata;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("string\tclassname = get_name();");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("string\theader;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("string::size_type\tstart, end;");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t");
            _builder.append("//\tPut title");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("Tango::DbDatum\ttitle(\"ProjectTitle\");");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("string\tstr_title(\"");
            ClassDescription _description = cls.getDescription();
            String _title = _description.getTitle();
            _builder.append((Object)_title, "\t");
            _builder.append("\");");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("title << str_title;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("data.push_back(title);");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t");
            _builder.append("//\tPut Description");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("Tango::DbDatum\tdescription(\"Description\");");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("vector<string>\tstr_desc;");
            _builder.newLine();
            _builder.append("\t");
            ClassDescription _description_1 = cls.getDescription();
            String _description_2 = _description_1.getDescription();
            String _string2Vector = this._cppStringUtils.string2Vector(_description_2, "str_desc");
            _builder.append((Object)_string2Vector, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("description << str_desc;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("data.push_back(description);");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t");
            _builder.append("//\tput cvs or svn location");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("string\tfilename(\"");
            String _name_1 = cls.getName();
            _builder.append((Object)_name_1, "\t");
            _builder.append("\");");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("filename += \"Class.cpp\";");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t");
            _builder.append("// check for cvs information");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("string\tsrc_path(CvsPath);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("start = src_path.find(\"/\");");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("if (start!=string::npos)");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("end   = src_path.find(filename);");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("if (end>start)");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("string\tstrloc = src_path.substr(start, end-start);");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("//\tCheck if specific repository");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("start = strloc.find(\"/cvsroot/\");");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("if (start!=string::npos && start>0)");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t\t\t\t");
            _builder.append("string\trepository = strloc.substr(0, start);");
            _builder.newLine();
            _builder.append("\t\t\t\t");
            _builder.append("if (repository.find(\"/segfs/\")!=string::npos)");
            _builder.newLine();
            _builder.append("\t\t\t\t\t");
            _builder.append("strloc = \"ESRF:\" + strloc.substr(start, strloc.length()-start);");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("Tango::DbDatum\tcvs_loc(\"cvs_location\");");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("cvs_loc << strloc;");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("data.push_back(cvs_loc);");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t");
            _builder.append("// check for svn information");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("else");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("string\tsrc_path(SvnPath);");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("start = src_path.find(\"://\");");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("if (start!=string::npos)");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("end = src_path.find(filename);");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("if (end>start)");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t\t\t\t");
            _builder.append("header = \"$HeadURL: \";");
            _builder.newLine();
            _builder.append("\t\t\t\t");
            _builder.append("start = header.length();");
            _builder.newLine();
            _builder.append("\t\t\t\t");
            _builder.append("string\tstrloc = src_path.substr(start, (end-start));");
            _builder.newLine();
            _builder.append("\t\t\t\t");
            _builder.newLine();
            _builder.append("\t\t\t\t");
            _builder.append("Tango::DbDatum\tsvn_loc(\"svn_location\");");
            _builder.newLine();
            _builder.append("\t\t\t\t");
            _builder.append("svn_loc << strloc;");
            _builder.newLine();
            _builder.append("\t\t\t\t");
            _builder.append("data.push_back(svn_loc);");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t");
            _builder.append("//\tGet CVS or SVN revision tag");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("// CVS tag");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("string\ttagname(TagName);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("header = \"$Name: \";");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("start = header.length();");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("string\tendstr(\" $\");");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("end   = tagname.find(endstr);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("if (end!=string::npos && end>start)");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("string\tstrtag = tagname.substr(start, end-start);");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("Tango::DbDatum\tcvs_tag(\"cvs_tag\");");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("cvs_tag << strtag;");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("data.push_back(cvs_tag);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("// SVN tag");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("string\tsvnpath(SvnPath);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("header = \"$HeadURL: \";");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("start = header.length();");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("end   = svnpath.find(endstr);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("if (end!=string::npos && end>start)");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("string\tstrloc = svnpath.substr(start, end-start);");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("string tagstr (\"/tags/\");");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("start = strloc.find(tagstr);");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("if ( start!=string::npos )");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("start = start + tagstr.length();");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("end   = strloc.find(filename);");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("string\tstrtag = strloc.substr(start, end-start-1);");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("Tango::DbDatum\tsvn_tag(\"svn_tag\");");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("svn_tag << strtag;");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("data.push_back(svn_tag);");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t");
            _builder.append("//\tGet URL location");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("string\thttpServ(HttpServer);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("if (httpServ.length()>0)");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("Tango::DbDatum\tdb_doc_url(\"doc_url\");");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("db_doc_url << httpServ;");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("data.push_back(db_doc_url);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t");
            _builder.append("//  Put inheritance");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("Tango::DbDatum\tinher_datum(\"InheritedFrom\");");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("vector<string> inheritance;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("inheritance.push_back(\"");
            String _DeviceImpl = StringUtils.DeviceImpl();
            _builder.append((Object)_DeviceImpl, "\t");
            _builder.append("\");");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("inher_datum << inheritance;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("data.push_back(inher_datum);");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t");
            _builder.append("//\tCall database and and values");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("get_db_class()->put_property(data);");
            _builder.newLine();
        }
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence setDefaultPropertiesForWizard(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        String _simpleMethodHeaderClass = this._headers.simpleMethodHeaderClass(cls, "set_default_property", "Set default property (class and device) for wizard.\nFor each property, add to wizard property name and description.\nIf default value has been set, add it to wizard property and\nstore it in a DbDatum.");
        _builder.append((Object)_simpleMethodHeaderClass, "");
        _builder.newLineIfNotEmpty();
        _builder.append("void ");
        String _name = cls.getName();
        _builder.append((Object)_name, "");
        _builder.append("Class::set_default_property()");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("string\tprop_name;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("string\tprop_desc;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("string\tprop_def;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("vector<string>\tvect_data;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("//\tSet Default Class Properties");
        _builder.newLine();
        EList<Property> _classProperties = cls.getClassProperties();
        for (Property property : _classProperties) {
            boolean _isConcreteHere = this._inheritanceUtils.isConcreteHere(property);
            if (!_isConcreteHere) continue;
            _builder.append("\t");
            CharSequence _setDefaultPropertyForWizard = this.setDefaultPropertyForWizard(property, "class");
            _builder.append((Object)_setDefaultPropertyForWizard, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("\t");
        _builder.append("//\tSet Default device Properties");
        _builder.newLine();
        EList<Property> _deviceProperties = cls.getDeviceProperties();
        for (Property property_1 : _deviceProperties) {
            boolean _isConcreteHere_1 = this._inheritanceUtils.isConcreteHere(property_1);
            if (!_isConcreteHere_1) continue;
            _builder.append("\t");
            CharSequence _setDefaultPropertyForWizard_1 = this.setDefaultPropertyForWizard(property_1, "dev");
            _builder.append((Object)_setDefaultPropertyForWizard_1, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence classPropertyDeclarations(PogoDeviceClass cls) {
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        EList<Property> _classProperties = cls.getClassProperties();
        int _size = _classProperties.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            _builder.append("//\tClass properties data members");
            _builder.newLine();
            _builder.append("public:");
            _builder.newLine();
            EList<Property> _classProperties_1 = cls.getClassProperties();
            for (Property property : _classProperties_1) {
                _builder.append("\t");
                _builder.append("//\t");
                String _name = property.getName();
                _builder.append((Object)_name, "\t");
                _builder.append(":\t");
                String _description = property.getDescription();
                String _comments = StringUtils.comments(_description, "//  ");
                _builder.append((Object)_comments, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                PropType _type = property.getType();
                String _cppPropType = CppTypeDefinitions.cppPropType(_type);
                _builder.append((Object)_cppPropType, "\t");
                _builder.append("\t");
                String _name_1 = property.getName();
                String _dataMemberName = this._cppStringUtils.dataMemberName(_name_1);
                _builder.append((Object)_dataMemberName, "\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append("public:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("//\twrite class properties data members");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("Tango::DbData\tcl_prop;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("Tango::DbData\tcl_def_prop;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("Tango::DbData\tdev_def_prop;");
        _builder.newLine();
        return _builder;
    }
}

