/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tango.pogo.generator.cpp.utils;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import fr.esrf.tango.pogo.generator.common.StringUtils;
import fr.esrf.tango.pogo.generator.cpp.utils.CppStringUtils;
import fr.esrf.tango.pogo.generator.cpp.utils.CppTypeDefinitions;
import fr.esrf.tango.pogo.generator.cpp.utils.InheritanceUtils;
import fr.esrf.tango.pogo.generator.cpp.utils.ProtectedArea;
import fr.esrf.tango.pogo.pogoDsl.AttrProperties;
import fr.esrf.tango.pogo.pogoDsl.Attribute;
import fr.esrf.tango.pogo.pogoDsl.EventCriteria;
import fr.esrf.tango.pogo.pogoDsl.FireEvents;
import fr.esrf.tango.pogo.pogoDsl.ForwardedAttribute;
import fr.esrf.tango.pogo.pogoDsl.PogoDeviceClass;
import fr.esrf.tango.pogo.pogoDsl.Type;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;

public class Attributes {
    @Inject
    @Extension
    private ProtectedArea _protectedArea;
    @Inject
    @Extension
    private CppStringUtils _cppStringUtils;
    @Inject
    @Extension
    private CppTypeDefinitions _cppTypeDefinitions;
    @Inject
    @Extension
    private InheritanceUtils _inheritanceUtils;

    public String writeAttrubuteMethod(Attribute attribute) {
        String _name = attribute.getName();
        return "write_" + _name;
    }

    public String readAttrubuteMethod(Attribute attribute) {
        String _name = attribute.getName();
        return "read_" + _name;
    }

    public String readAttrubuteSize(Attribute attribute) {
        String _xifexpression = null;
        boolean _isScalar = this._cppStringUtils.isScalar(attribute);
        if (_isScalar) {
            _xifexpression = "";
        } else {
            String _xifexpression_1 = null;
            boolean _isSpectrum = this._cppStringUtils.isSpectrum(attribute);
            if (_isSpectrum) {
                String _maxX = attribute.getMaxX();
                _xifexpression_1 = ", " + _maxX;
            } else {
                String _xifexpression_2 = null;
                boolean _isImage = this._cppStringUtils.isImage(attribute);
                if (_isImage) {
                    String _maxX_1 = attribute.getMaxX();
                    String _plus = ", " + _maxX_1;
                    String _plus_1 = String.valueOf(_plus) + ", ";
                    String _maxY = attribute.getMaxY();
                    _xifexpression_2 = String.valueOf(_plus_1) + _maxY;
                }
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    public String readAttrubuteSizeForAllocation(Attribute attribute) {
        String _xifexpression = null;
        boolean _isScalar = this._cppStringUtils.isScalar(attribute);
        if (_isScalar) {
            _xifexpression = "[1]";
        } else {
            String _xifexpression_1 = null;
            boolean _isSpectrum = this._cppStringUtils.isSpectrum(attribute);
            if (_isSpectrum) {
                String _maxX = attribute.getMaxX();
                String _plus = "[" + _maxX;
                _xifexpression_1 = String.valueOf(_plus) + "]";
            } else {
                String _xifexpression_2 = null;
                boolean _isImage = this._cppStringUtils.isImage(attribute);
                if (_isImage) {
                    String _maxX_1 = attribute.getMaxX();
                    String _plus_1 = "[" + _maxX_1;
                    String _plus_2 = String.valueOf(_plus_1) + "*";
                    String _maxY = attribute.getMaxY();
                    String _plus_3 = String.valueOf(_plus_2) + _maxY;
                    _xifexpression_2 = String.valueOf(_plus_3) + "]";
                }
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    public String readAttrubuteDataMember(Attribute attribute) {
        String _name = attribute.getName();
        String _plus = "attr_" + _name;
        return String.valueOf(_plus) + "_read";
    }

    public String deleteAttributeDataMember(Attribute attribute) {
        String _readAttrubuteDataMember = this.readAttrubuteDataMember(attribute);
        String _plus = "delete[] " + _readAttrubuteDataMember;
        return String.valueOf(_plus) + ";";
    }

    public CharSequence deleteAttributeDataMembers(EList<Attribute> attributes) {
        StringConcatenation _builder = new StringConcatenation();
        for (Attribute attribute : attributes) {
            String _allocReadMember;
            boolean _isTrue;
            boolean _isConcreteHere = this._inheritanceUtils.isConcreteHere(attribute);
            if (!_isConcreteHere || !(_isTrue = StringUtils.isTrue(_allocReadMember = attribute.getAllocReadMember()))) continue;
            String _deleteAttributeDataMember = this.deleteAttributeDataMember(attribute);
            _builder.append((Object)_deleteAttributeDataMember, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public String allocateAttributeDataMember(Attribute attribute) {
        String _xifexpression = null;
        Type _dataType = attribute.getDataType();
        String _cppType = CppTypeDefinitions.cppType(_dataType);
        boolean _contains = _cppType.contains("Enum");
        if (_contains) {
            String _readAttrubuteDataMember = this.readAttrubuteDataMember(attribute);
            String _plus = String.valueOf(_readAttrubuteDataMember) + " = new ";
            String _name = attribute.getName();
            String _plus_1 = String.valueOf(_plus) + _name;
            String _plus_2 = String.valueOf(_plus_1) + "Enum";
            String _readAttrubuteSizeForAllocation = this.readAttrubuteSizeForAllocation(attribute);
            String _plus_3 = String.valueOf(_plus_2) + _readAttrubuteSizeForAllocation;
            _xifexpression = String.valueOf(_plus_3) + ";";
        } else {
            String _readAttrubuteDataMember_1 = this.readAttrubuteDataMember(attribute);
            String _plus_4 = String.valueOf(_readAttrubuteDataMember_1) + " = new ";
            Type _dataType_1 = attribute.getDataType();
            String _cppType_1 = CppTypeDefinitions.cppType(_dataType_1);
            String _plus_5 = String.valueOf(_plus_4) + _cppType_1;
            String _readAttrubuteSizeForAllocation_1 = this.readAttrubuteSizeForAllocation(attribute);
            String _plus_6 = String.valueOf(_plus_5) + _readAttrubuteSizeForAllocation_1;
            _xifexpression = String.valueOf(_plus_6) + ";";
        }
        return _xifexpression;
    }

    public CharSequence allocateAttributeDataMembers(EList<Attribute> attributes) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        for (Attribute attribute : attributes) {
            String _allocReadMember;
            boolean _isTrue;
            boolean _isConcreteHere = this._inheritanceUtils.isConcreteHere(attribute);
            if (!_isConcreteHere || !(_isTrue = StringUtils.isTrue(_allocReadMember = attribute.getAllocReadMember()))) continue;
            String _allocateAttributeDataMember = this.allocateAttributeDataMember(attribute);
            _builder.append((Object)_allocateAttributeDataMember, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence readAttributeMethod(PogoDeviceClass cls, Attribute attribute) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("void ");
        String _name = cls.getName();
        _builder.append((Object)_name, "");
        _builder.append("::");
        String _readAttrubuteMethod = this.readAttrubuteMethod(attribute);
        _builder.append((Object)_readAttrubuteMethod, "");
        _builder.append("(Tango::Attribute &attr)");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("DEBUG_STREAM << \"");
        String _name_1 = cls.getName();
        _builder.append((Object)_name_1, "\t");
        _builder.append("::");
        String _readAttrubuteMethod_1 = this.readAttrubuteMethod(attribute);
        _builder.append((Object)_readAttrubuteMethod_1, "\t");
        _builder.append("(Tango::Attribute &attr) entering... \" << endl;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _readAttrubuteMethod_2 = this.readAttrubuteMethod(attribute);
        String _readAttrubuteDataMember = this.readAttrubuteDataMember(attribute);
        String _plus = "//\tSet the attribute value\nattr.set_value(" + _readAttrubuteDataMember;
        String _readAttrubuteSize = this.readAttrubuteSize(attribute);
        String _plus_1 = String.valueOf(_plus) + _readAttrubuteSize;
        String _plus_2 = String.valueOf(_plus_1) + ");";
        String _protectedArea = this._protectedArea.protectedArea(cls, _readAttrubuteMethod_2, _plus_2, false);
        _builder.append((Object)_protectedArea, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence readDynamicAttributeMethod(PogoDeviceClass cls, Attribute attribute) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("void ");
        String _name = cls.getName();
        _builder.append((Object)_name, "");
        _builder.append("::");
        String _readAttrubuteMethod = this.readAttrubuteMethod(attribute);
        _builder.append((Object)_readAttrubuteMethod, "");
        _builder.append("(Tango::Attribute &attr)");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("DEBUG_STREAM << \"");
        String _name_1 = cls.getName();
        _builder.append((Object)_name_1, "\t");
        _builder.append("::");
        String _readAttrubuteMethod_1 = this.readAttrubuteMethod(attribute);
        _builder.append((Object)_readAttrubuteMethod_1, "\t");
        _builder.append("(Tango::Attribute &attr) entering... \" << endl;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _strType = this._cppStringUtils.strType(attribute);
        _builder.append((Object)_strType, "\t");
        _builder.append("\t*att_value = get_");
        String _name_2 = attribute.getName();
        _builder.append((Object)_name_2, "\t");
        _builder.append("_data_ptr(attr.get_name());");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _readAttrubuteMethod_2 = this.readAttrubuteMethod(attribute);
        String _readAttrubuteSize = this.readAttrubuteSize(attribute);
        String _plus = "//\tSet the attribute value\nattr.set_value(att_value" + _readAttrubuteSize;
        String _plus_1 = String.valueOf(_plus) + ");";
        String _protectedArea = this._protectedArea.protectedArea(cls, _readAttrubuteMethod_2, _plus_1, false);
        _builder.append((Object)_protectedArea, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence writeAttributeMethod(PogoDeviceClass cls, Attribute attribute) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("void ");
        String _name = cls.getName();
        _builder.append((Object)_name, "");
        _builder.append("::");
        String _writeAttrubuteMethod = this.writeAttrubuteMethod(attribute);
        _builder.append((Object)_writeAttrubuteMethod, "");
        _builder.append("(Tango::WAttribute &attr)");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("DEBUG_STREAM << \"");
        String _name_1 = cls.getName();
        _builder.append((Object)_name_1, "\t");
        _builder.append("::");
        String _writeAttrubuteMethod_1 = this.writeAttrubuteMethod(attribute);
        _builder.append((Object)_writeAttrubuteMethod_1, "\t");
        _builder.append("(Tango::WAttribute &attr) entering... \" << endl;");
        _builder.newLineIfNotEmpty();
        boolean _isScalar = this._cppStringUtils.isScalar(attribute);
        if (_isScalar) {
            _builder.append("\t");
            _builder.append("//\tRetrieve write value");
            _builder.newLine();
            Type _dataType = attribute.getDataType();
            String _cppType = CppTypeDefinitions.cppType(_dataType);
            boolean _contains = _cppType.contains("Enum");
            if (_contains) {
                _builder.append("\t");
                String _name_2 = attribute.getName();
                _builder.append((Object)_name_2, "\t");
                _builder.append("Enum\tw_val;");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append("\t");
                String _strType = this._cppStringUtils.strType(attribute);
                _builder.append((Object)_strType, "\t");
                _builder.append("\tw_val;");
                _builder.newLineIfNotEmpty();
            }
        } else {
            _builder.append("\t");
            _builder.append("//\tRetrieve number of write values");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("int\tw_length = attr.get_write_value_length();");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t");
            _builder.append("//\tRetrieve pointer on write values (Do not delete !)");
            _builder.newLine();
            String _strType_1 = this._cppStringUtils.strType(attribute);
            boolean _contains_1 = _strType_1.contains("String");
            if (_contains_1) {
                _builder.append("\t");
                _builder.append("const Tango::ConstDevString\t*w_val;");
                _builder.newLine();
            } else {
                _builder.append("\t");
                _builder.append("const ");
                String _strType_2 = this._cppStringUtils.strType(attribute);
                _builder.append((Object)_strType_2, "\t");
                _builder.append("\t*w_val;");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append("\t");
        _builder.append("attr.get_write_value(w_val);");
        _builder.newLine();
        _builder.append("\t");
        String _writeAttrubuteMethod_2 = this.writeAttrubuteMethod(attribute);
        String _protectedArea = this._protectedArea.protectedArea(cls, _writeAttrubuteMethod_2, "", false);
        _builder.append((Object)_protectedArea, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence attributeClass(PogoDeviceClass cls, Attribute attribute, boolean dynamic) {
        boolean _isWrite;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("//\tAttribute ");
        String _name = attribute.getName();
        _builder.append((Object)_name, "");
        _builder.append(" class definition");
        _builder.newLineIfNotEmpty();
        _builder.append("class ");
        String _name_1 = attribute.getName();
        _builder.append((Object)_name_1, "");
        _builder.append("Attrib: public Tango::");
        String _inheritance = this.inheritance(attribute);
        _builder.append((Object)_inheritance, "");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("public:");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _Constructor = this.Constructor(attribute, dynamic);
        _builder.append((Object)_Constructor, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("~");
        String _name_2 = attribute.getName();
        _builder.append((Object)_name_2, "\t");
        _builder.append("Attrib() {};");
        _builder.newLineIfNotEmpty();
        boolean _isRead = StringUtils.isRead(attribute);
        if (_isRead) {
            _builder.append("\t");
            _builder.append("virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("{(static_cast<");
            String _name_3 = cls.getName();
            _builder.append((Object)_name_3, "\t\t");
            _builder.append(" *>(dev))->read_");
            String _name_4 = attribute.getName();
            _builder.append((Object)_name_4, "\t\t");
            _builder.append("(att);}");
            _builder.newLineIfNotEmpty();
        }
        if (_isWrite = StringUtils.isWrite(attribute)) {
            _builder.append("\t");
            _builder.append("virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("{(static_cast<");
            String _name_5 = cls.getName();
            _builder.append((Object)_name_5, "\t\t");
            _builder.append(" *>(dev))->write_");
            String _name_6 = attribute.getName();
            _builder.append((Object)_name_6, "\t\t");
            _builder.append("(att);}");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.append("virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("{return (static_cast<");
        String _name_7 = cls.getName();
        _builder.append((Object)_name_7, "\t\t");
        _builder.append(" *>(dev))->is_");
        String _name_8 = attribute.getName();
        _builder.append((Object)_name_8, "\t\t");
        _builder.append("_allowed(ty);}");
        _builder.newLineIfNotEmpty();
        Type _dataType = attribute.getDataType();
        String _cppType = CppTypeDefinitions.cppType(_dataType);
        String _string = _cppType.toString();
        boolean _contains = _string.contains("Enum");
        if (_contains) {
            _builder.append("\t");
            _builder.append("virtual bool same_type(const type_info &in_type) {return typeid(");
            String _name_9 = attribute.getName();
            _builder.append((Object)_name_9, "\t");
            _builder.append("Enum) == in_type;}");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("virtual string get_enum_type() {return string(\"");
            String _name_10 = attribute.getName();
            _builder.append((Object)_name_10, "\t");
            _builder.append("Enum\");}");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("};");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }

    public CharSequence forwardedAttributeClass(ForwardedAttribute attribute) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("//\tForwarded Attribute ");
        String _name = attribute.getName();
        _builder.append((Object)_name, "");
        _builder.append(" class definition");
        _builder.newLineIfNotEmpty();
        _builder.append("class ");
        String _name_1 = attribute.getName();
        _builder.append((Object)_name_1, "");
        _builder.append("Attrib: public Tango::FwdAttr");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("public:");
        _builder.newLine();
        _builder.append("\t");
        String _name_2 = attribute.getName();
        _builder.append((Object)_name_2, "\t");
        _builder.append("Attrib(const string &_n):FwdAttr(_n) {};");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("~");
        String _name_3 = attribute.getName();
        _builder.append((Object)_name_3, "\t");
        _builder.append("Attrib() {};");
        _builder.newLineIfNotEmpty();
        _builder.append("};");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }

    public String inheritance(Attribute attribute) {
        String _xifexpression = null;
        boolean _isScalar = this._cppStringUtils.isScalar(attribute);
        if (_isScalar) {
            _xifexpression = "Attr";
        } else {
            String _xifexpression_1 = null;
            boolean _isSpectrum = this._cppStringUtils.isSpectrum(attribute);
            if (_isSpectrum) {
                _xifexpression_1 = "SpectrumAttr";
            } else {
                String _xifexpression_2 = null;
                boolean _isImage = this._cppStringUtils.isImage(attribute);
                if (_isImage) {
                    _xifexpression_2 = "ImageAttr";
                }
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    public CharSequence Constructor(Attribute attribute, boolean dynamic) {
        StringConcatenation _builder = new StringConcatenation();
        if (dynamic) {
            boolean _isScalar = this._cppStringUtils.isScalar(attribute);
            if (_isScalar) {
                String _name = attribute.getName();
                _builder.append((Object)_name, "");
                _builder.append("Attrib(const string &att_name):");
                String _inheritance = this.inheritance(attribute);
                _builder.append((Object)_inheritance, "");
                _builder.append("(att_name.c_str(), ");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                Type _dataType = attribute.getDataType();
                String _cppTypeEnum = CppTypeDefinitions.cppTypeEnum(_dataType);
                _builder.append((Object)_cppTypeEnum, "\t\t");
                _builder.append(", Tango::");
                String _rwType = attribute.getRwType();
                _builder.append((Object)_rwType, "\t\t");
                _builder.append(") {};");
                _builder.newLineIfNotEmpty();
            } else {
                boolean _isSpectrum = this._cppStringUtils.isSpectrum(attribute);
                if (_isSpectrum) {
                    String _name_1 = attribute.getName();
                    _builder.append((Object)_name_1, "");
                    _builder.append("Attrib(const string &att_name):");
                    String _inheritance_1 = this.inheritance(attribute);
                    _builder.append((Object)_inheritance_1, "");
                    _builder.append("(att_name.c_str(), ");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    Type _dataType_1 = attribute.getDataType();
                    String _cppTypeEnum_1 = CppTypeDefinitions.cppTypeEnum(_dataType_1);
                    _builder.append((Object)_cppTypeEnum_1, "\t\t");
                    _builder.append(", Tango::");
                    String _rwType_1 = attribute.getRwType();
                    _builder.append((Object)_rwType_1, "\t\t");
                    _builder.append(", ");
                    String _maxX = attribute.getMaxX();
                    _builder.append((Object)_maxX, "\t\t");
                    _builder.append(") {};");
                    _builder.newLineIfNotEmpty();
                } else {
                    String _name_2 = attribute.getName();
                    _builder.append((Object)_name_2, "");
                    _builder.append("Attrib(const string &att_name):");
                    String _inheritance_2 = this.inheritance(attribute);
                    _builder.append((Object)_inheritance_2, "");
                    _builder.append("(att_name.c_str(), ");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    Type _dataType_2 = attribute.getDataType();
                    String _cppTypeEnum_2 = CppTypeDefinitions.cppTypeEnum(_dataType_2);
                    _builder.append((Object)_cppTypeEnum_2, "\t\t");
                    _builder.append(", Tango::");
                    String _rwType_2 = attribute.getRwType();
                    _builder.append((Object)_rwType_2, "\t\t");
                    _builder.append(", ");
                    String _maxX_1 = attribute.getMaxX();
                    _builder.append((Object)_maxX_1, "\t\t");
                    _builder.append(", ");
                    String _maxY = attribute.getMaxY();
                    _builder.append((Object)_maxY, "\t\t");
                    _builder.append(") {};");
                    _builder.newLineIfNotEmpty();
                }
            }
        } else {
            boolean _isScalar_1 = this._cppStringUtils.isScalar(attribute);
            if (_isScalar_1) {
                String _name_3 = attribute.getName();
                _builder.append((Object)_name_3, "");
                _builder.append("Attrib():");
                String _inheritance_3 = this.inheritance(attribute);
                _builder.append((Object)_inheritance_3, "");
                _builder.append("(\"");
                String _name_4 = attribute.getName();
                _builder.append((Object)_name_4, "");
                _builder.append("\",");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                Type _dataType_3 = attribute.getDataType();
                String _cppTypeEnum_3 = CppTypeDefinitions.cppTypeEnum(_dataType_3);
                _builder.append((Object)_cppTypeEnum_3, "\t\t");
                _builder.append(", Tango::");
                String _rwType_3 = attribute.getRwType();
                _builder.append((Object)_rwType_3, "\t\t");
                String _readWithWrite = CppStringUtils.readWithWrite(attribute);
                _builder.append((Object)_readWithWrite, "\t\t");
                _builder.append(") {};");
                _builder.newLineIfNotEmpty();
            } else {
                boolean _isSpectrum_1 = this._cppStringUtils.isSpectrum(attribute);
                if (_isSpectrum_1) {
                    String _name_5 = attribute.getName();
                    _builder.append((Object)_name_5, "");
                    _builder.append("Attrib():");
                    String _inheritance_4 = this.inheritance(attribute);
                    _builder.append((Object)_inheritance_4, "");
                    _builder.append("(\"");
                    String _name_6 = attribute.getName();
                    _builder.append((Object)_name_6, "");
                    _builder.append("\",");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    Type _dataType_4 = attribute.getDataType();
                    String _cppTypeEnum_4 = CppTypeDefinitions.cppTypeEnum(_dataType_4);
                    _builder.append((Object)_cppTypeEnum_4, "\t\t");
                    _builder.append(", Tango::");
                    String _rwType_4 = attribute.getRwType();
                    _builder.append((Object)_rwType_4, "\t\t");
                    _builder.append(", ");
                    String _maxX_2 = attribute.getMaxX();
                    _builder.append((Object)_maxX_2, "\t\t");
                    _builder.append(") {};");
                    _builder.newLineIfNotEmpty();
                } else {
                    String _name_7 = attribute.getName();
                    _builder.append((Object)_name_7, "");
                    _builder.append("Attrib():");
                    String _inheritance_5 = this.inheritance(attribute);
                    _builder.append((Object)_inheritance_5, "");
                    _builder.append("(\"");
                    String _name_8 = attribute.getName();
                    _builder.append((Object)_name_8, "");
                    _builder.append("\",");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    Type _dataType_5 = attribute.getDataType();
                    String _cppTypeEnum_5 = CppTypeDefinitions.cppTypeEnum(_dataType_5);
                    _builder.append((Object)_cppTypeEnum_5, "\t\t");
                    _builder.append(", Tango::");
                    String _rwType_5 = attribute.getRwType();
                    _builder.append((Object)_rwType_5, "\t\t");
                    _builder.append(", ");
                    String _maxX_3 = attribute.getMaxX();
                    _builder.append((Object)_maxX_3, "\t\t");
                    _builder.append(", ");
                    String _maxY_1 = attribute.getMaxY();
                    _builder.append((Object)_maxY_1, "\t\t");
                    _builder.append(") {};");
                    _builder.newLineIfNotEmpty();
                }
            }
        }
        return _builder;
    }

    public CharSequence attributeFactory(Attribute attribute) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isConcreteHere = this._inheritanceUtils.isConcreteHere(attribute);
        if (_isConcreteHere) {
            CharSequence _attributeFactory = this.attributeFactory(attribute, null);
            _builder.append((Object)_attributeFactory, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence attributeFactory(Attribute attribute, PogoDeviceClass cls) {
        boolean _greaterThan;
        boolean _notEquals_3;
        EventCriteria _evArchiveCriteria;
        boolean _notEquals_2;
        boolean _notEquals_1;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("//\tAttribute : ");
        String _name = attribute.getName();
        _builder.append((Object)_name, "");
        _builder.newLineIfNotEmpty();
        boolean bl = _notEquals = !Objects.equal(cls, null);
        if (_notEquals) {
            CharSequence _allocateDynamicAttrubutePointer = this.allocateDynamicAttrubutePointer(attribute);
            _builder.append((Object)_allocateDynamicAttrubutePointer, "");
            _builder.newLineIfNotEmpty();
            String _name_1 = attribute.getName();
            _builder.append((Object)_name_1, "");
            _builder.append("Attrib\t*");
            String _name_2 = attribute.getName();
            String _lowerCase = _name_2.toLowerCase();
            _builder.append((Object)_lowerCase, "");
            _builder.append(" = new ");
            String _name_3 = attribute.getName();
            _builder.append((Object)_name_3, "");
            _builder.append("Attrib(attname);");
            _builder.newLineIfNotEmpty();
        } else {
            String _name_4 = attribute.getName();
            _builder.append((Object)_name_4, "");
            _builder.append("Attrib\t*");
            String _name_5 = attribute.getName();
            String _lowerCase_1 = _name_5.toLowerCase();
            _builder.append((Object)_lowerCase_1, "");
            _builder.append(" = new ");
            String _name_6 = attribute.getName();
            _builder.append((Object)_name_6, "");
            _builder.append("Attrib();");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("Tango::UserDefaultAttrProp\t");
        String _name_7 = attribute.getName();
        String _lowerCase_2 = _name_7.toLowerCase();
        _builder.append((Object)_lowerCase_2, "");
        _builder.append("_prop;");
        _builder.newLineIfNotEmpty();
        AttrProperties _properties = attribute.getProperties();
        String _description = _properties.getDescription();
        CharSequence _setProperty = this.setProperty(attribute, "description", _description);
        _builder.append((Object)_setProperty, "");
        _builder.newLineIfNotEmpty();
        AttrProperties _properties_1 = attribute.getProperties();
        String _label = _properties_1.getLabel();
        CharSequence _setProperty_1 = this.setProperty(attribute, "label", _label);
        _builder.append((Object)_setProperty_1, "");
        _builder.newLineIfNotEmpty();
        AttrProperties _properties_2 = attribute.getProperties();
        String _unit = _properties_2.getUnit();
        CharSequence _setProperty_2 = this.setProperty(attribute, "unit", _unit);
        _builder.append((Object)_setProperty_2, "");
        _builder.newLineIfNotEmpty();
        AttrProperties _properties_3 = attribute.getProperties();
        String _standardUnit = _properties_3.getStandardUnit();
        CharSequence _setProperty_3 = this.setProperty(attribute, "standard_unit", _standardUnit);
        _builder.append((Object)_setProperty_3, "");
        _builder.newLineIfNotEmpty();
        AttrProperties _properties_4 = attribute.getProperties();
        String _displayUnit = _properties_4.getDisplayUnit();
        CharSequence _setProperty_4 = this.setProperty(attribute, "display_unit", _displayUnit);
        _builder.append((Object)_setProperty_4, "");
        _builder.newLineIfNotEmpty();
        AttrProperties _properties_5 = attribute.getProperties();
        String _format = _properties_5.getFormat();
        CharSequence _setProperty_5 = this.setProperty(attribute, "format", _format);
        _builder.append((Object)_setProperty_5, "");
        _builder.newLineIfNotEmpty();
        AttrProperties _properties_6 = attribute.getProperties();
        String _maxValue = _properties_6.getMaxValue();
        CharSequence _setProperty_6 = this.setProperty(attribute, "max_value", _maxValue);
        _builder.append((Object)_setProperty_6, "");
        _builder.newLineIfNotEmpty();
        AttrProperties _properties_7 = attribute.getProperties();
        String _minValue = _properties_7.getMinValue();
        CharSequence _setProperty_7 = this.setProperty(attribute, "min_value", _minValue);
        _builder.append((Object)_setProperty_7, "");
        _builder.newLineIfNotEmpty();
        AttrProperties _properties_8 = attribute.getProperties();
        String _maxAlarm = _properties_8.getMaxAlarm();
        CharSequence _setProperty_8 = this.setProperty(attribute, "max_alarm", _maxAlarm);
        _builder.append((Object)_setProperty_8, "");
        _builder.newLineIfNotEmpty();
        AttrProperties _properties_9 = attribute.getProperties();
        String _minAlarm = _properties_9.getMinAlarm();
        CharSequence _setProperty_9 = this.setProperty(attribute, "min_alarm", _minAlarm);
        _builder.append((Object)_setProperty_9, "");
        _builder.newLineIfNotEmpty();
        AttrProperties _properties_10 = attribute.getProperties();
        String _maxWarning = _properties_10.getMaxWarning();
        CharSequence _setProperty_10 = this.setProperty(attribute, "max_warning", _maxWarning);
        _builder.append((Object)_setProperty_10, "");
        _builder.newLineIfNotEmpty();
        AttrProperties _properties_11 = attribute.getProperties();
        String _minWarning = _properties_11.getMinWarning();
        CharSequence _setProperty_11 = this.setProperty(attribute, "min_warning", _minWarning);
        _builder.append((Object)_setProperty_11, "");
        _builder.newLineIfNotEmpty();
        AttrProperties _properties_12 = attribute.getProperties();
        String _deltaTime = _properties_12.getDeltaTime();
        CharSequence _setProperty_12 = this.setProperty(attribute, "delta_t", _deltaTime);
        _builder.append((Object)_setProperty_12, "");
        _builder.newLineIfNotEmpty();
        AttrProperties _properties_13 = attribute.getProperties();
        String _deltaValue = _properties_13.getDeltaValue();
        CharSequence _setProperty_13 = this.setProperty(attribute, "delta_val", _deltaValue);
        _builder.append((Object)_setProperty_13, "");
        _builder.newLineIfNotEmpty();
        EventCriteria _eventCriteria = attribute.getEventCriteria();
        boolean bl2 = _notEquals_1 = !Objects.equal(_eventCriteria, null);
        if (_notEquals_1) {
            EventCriteria _eventCriteria_1 = attribute.getEventCriteria();
            String _period = _eventCriteria_1.getPeriod();
            CharSequence _setEventProprty = this.setEventProprty(attribute, "event_period", _period);
            _builder.append((Object)_setEventProprty, "");
            _builder.newLineIfNotEmpty();
            EventCriteria _eventCriteria_2 = attribute.getEventCriteria();
            String _relChange = _eventCriteria_2.getRelChange();
            CharSequence _setEventProprty_1 = this.setEventProprty(attribute, "event_rel_change", _relChange);
            _builder.append((Object)_setEventProprty_1, "");
            _builder.newLineIfNotEmpty();
            EventCriteria _eventCriteria_3 = attribute.getEventCriteria();
            String _absChange = _eventCriteria_3.getAbsChange();
            CharSequence _setEventProprty_2 = this.setEventProprty(attribute, "event_abs_change", _absChange);
            _builder.append((Object)_setEventProprty_2, "");
            _builder.newLineIfNotEmpty();
        }
        boolean bl3 = _notEquals_2 = !Objects.equal(_evArchiveCriteria = attribute.getEvArchiveCriteria(), null);
        if (_notEquals_2) {
            EventCriteria _evArchiveCriteria_1 = attribute.getEvArchiveCriteria();
            String _period_1 = _evArchiveCriteria_1.getPeriod();
            CharSequence _setEventProprty_3 = this.setEventProprty(attribute, "archive_event_period", _period_1);
            _builder.append((Object)_setEventProprty_3, "");
            _builder.newLineIfNotEmpty();
            EventCriteria _evArchiveCriteria_2 = attribute.getEvArchiveCriteria();
            String _relChange_1 = _evArchiveCriteria_2.getRelChange();
            CharSequence _setEventProprty_4 = this.setEventProprty(attribute, "archive_event_rel_change", _relChange_1);
            _builder.append((Object)_setEventProprty_4, "");
            _builder.newLineIfNotEmpty();
            EventCriteria _evArchiveCriteria_3 = attribute.getEvArchiveCriteria();
            String _absChange_1 = _evArchiveCriteria_3.getAbsChange();
            CharSequence _setEventProprty_5 = this.setEventProprty(attribute, "archive_event_abs_change", _absChange_1);
            _builder.append((Object)_setEventProprty_5, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        boolean bl4 = _notEquals_3 = !Objects.equal(cls, null);
        if (_notEquals_3) {
            String _name_8 = attribute.getName();
            String _plus = "att_" + _name_8;
            String _plus_1 = String.valueOf(_plus) + "_dynamic_attribute";
            String _protectedArea = this._protectedArea.protectedArea(cls, _plus_1, "", false);
            _builder.append((Object)_protectedArea, "");
            _builder.newLineIfNotEmpty();
        }
        CharSequence _manageEnumLabels = this.manageEnumLabels(attribute);
        _builder.append((Object)_manageEnumLabels, "");
        _builder.newLineIfNotEmpty();
        String _name_9 = attribute.getName();
        String _lowerCase_3 = _name_9.toLowerCase();
        _builder.append((Object)_lowerCase_3, "");
        _builder.append("->set_default_properties(");
        String _name_10 = attribute.getName();
        String _lowerCase_4 = _name_10.toLowerCase();
        _builder.append((Object)_lowerCase_4, "");
        _builder.append("_prop);");
        _builder.newLineIfNotEmpty();
        String _polledPeriod = attribute.getPolledPeriod();
        int _integerValue = StringUtils.getIntegerValue(_polledPeriod);
        boolean bl5 = _greaterThan = _integerValue > 0;
        if (_greaterThan) {
            String _polledPeriod_1 = attribute.getPolledPeriod();
            CharSequence _setExtendedProprty = this.setExtendedProprty(attribute, "polling_period", _polledPeriod_1, "Not Polled");
            _builder.append((Object)_setExtendedProprty, "");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append("//\tNot Polled");
            _builder.newLine();
        }
        String _displayLevel = attribute.getDisplayLevel();
        CharSequence _setExtendedProprty_1 = this.setExtendedProprty(attribute, "disp_level", _displayLevel, "Tango::OPERATOR");
        _builder.append((Object)_setExtendedProprty_1, "");
        _builder.newLineIfNotEmpty();
        CharSequence _setAttributeMemorized = this.setAttributeMemorized(attribute, "Not Memorized");
        _builder.append((Object)_setAttributeMemorized, "");
        _builder.newLineIfNotEmpty();
        CharSequence _setEventCriteria = this.setEventCriteria(attribute);
        _builder.append((Object)_setEventCriteria, "");
        _builder.newLineIfNotEmpty();
        boolean _equals = Objects.equal(cls, null);
        if (_equals) {
            _builder.append("att_list.push_back(");
            String _name_11 = attribute.getName();
            String _lowerCase_5 = _name_11.toLowerCase();
            _builder.append((Object)_lowerCase_5, "");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        } else {
            String _declareIfNeeded = this._cppTypeDefinitions.declareIfNeeded(attribute);
            _builder.append((Object)_declareIfNeeded, "");
            _builder.newLineIfNotEmpty();
            String _name_12 = attribute.getName();
            _builder.append((Object)_name_12, "");
            _builder.append("_data.insert(make_pair(attname, ");
            String _defaultValue = this._cppTypeDefinitions.defaultValue(attribute);
            _builder.append((Object)_defaultValue, "");
            _builder.append("));");
            _builder.newLineIfNotEmpty();
            _builder.append("add_attribute(");
            String _name_13 = attribute.getName();
            String _lowerCase_6 = _name_13.toLowerCase();
            _builder.append((Object)_lowerCase_6, "");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence setProperty(Attribute attribute, String propertyName, String strValue) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isSet = StringUtils.isSet(strValue);
        if (_isSet) {
            String _name = attribute.getName();
            String _lowerCase = _name.toLowerCase();
            _builder.append((Object)_lowerCase, "");
            _builder.append("_prop.set_");
            _builder.append((Object)propertyName, "");
            _builder.append("(\"");
            String _oneLineString = this._cppStringUtils.oneLineString(strValue);
            _builder.append((Object)_oneLineString, "");
            _builder.append("\");");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append("//\t");
            _builder.append((Object)propertyName, "");
            _builder.append("\tnot set for ");
            String _name_1 = attribute.getName();
            _builder.append((Object)_name_1, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence setExtendedProprty(Attribute attribute, String propertyName, String strValue, String comment) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isSet = StringUtils.isSet(strValue);
        if (_isSet) {
            boolean _equals = Objects.equal(propertyName, "disp_level");
            if (_equals) {
                String _name = attribute.getName();
                String _lowerCase = _name.toLowerCase();
                _builder.append((Object)_lowerCase, "");
                _builder.append("->set_");
                _builder.append((Object)propertyName, "");
                _builder.append("(Tango::");
                _builder.append((Object)strValue, "");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
            } else {
                String _name_1 = attribute.getName();
                String _lowerCase_1 = _name_1.toLowerCase();
                _builder.append((Object)_lowerCase_1, "");
                _builder.append("->set_");
                _builder.append((Object)propertyName, "");
                _builder.append("(");
                _builder.append((Object)strValue, "");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
            }
        } else {
            _builder.append("//\t");
            _builder.append((Object)comment, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence setEventProprty(Attribute attribute, String propertyName, String strValue) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isSet = StringUtils.isSet(strValue);
        if (_isSet) {
            String _name = attribute.getName();
            String _lowerCase = _name.toLowerCase();
            _builder.append((Object)_lowerCase, "");
            _builder.append("_prop.set_");
            _builder.append((Object)propertyName, "");
            _builder.append("(\"");
            _builder.append((Object)strValue, "");
            _builder.append("\");");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence manageEnumLabels(Attribute attribute) {
        StringConcatenation _builder = new StringConcatenation();
        Type _dataType = attribute.getDataType();
        String _cppType = CppTypeDefinitions.cppType(_dataType);
        String _string = _cppType.toString();
        boolean _contains = _string.contains("Enum");
        if (_contains) {
            EList<String> _enumLabels_1;
            int _size;
            boolean _greaterThan;
            boolean _notEquals;
            boolean _and = false;
            EList<String> _enumLabels = attribute.getEnumLabels();
            boolean bl = _notEquals = !Objects.equal(_enumLabels, null);
            _and = !_notEquals ? false : (_greaterThan = (_size = (_enumLabels_1 = attribute.getEnumLabels()).size()) > 0);
            if (_and) {
                _builder.append("{");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("vector<string> labels;");
                _builder.newLine();
                EList<String> _enumLabels_2 = attribute.getEnumLabels();
                for (String label : _enumLabels_2) {
                    _builder.append("\t");
                    _builder.append("labels.push_back(\"");
                    _builder.append((Object)label, "\t");
                    _builder.append("\");");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("\t");
                String _name = attribute.getName();
                String _lowerCase = _name.toLowerCase();
                _builder.append((Object)_lowerCase, "\t");
                _builder.append("_prop.set_enum_labels(labels);");
                _builder.newLineIfNotEmpty();
                _builder.append("}");
                _builder.newLine();
            }
        }
        return _builder;
    }

    public CharSequence setEventCriteria(Attribute attribute) {
        FireEvents _archiveEvent_1;
        String _fire_4;
        boolean _isTrue_2;
        FireEvents _archiveEvent;
        boolean _notEquals_2;
        FireEvents _changeEvent_1;
        String _fire_2;
        boolean _isTrue_1;
        FireEvents _changeEvent;
        boolean _notEquals_1;
        FireEvents _dataReadyEvent_1;
        String _fire;
        boolean _isTrue;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        FireEvents _dataReadyEvent = attribute.getDataReadyEvent();
        boolean bl = _notEquals = !Objects.equal(_dataReadyEvent, null);
        if (_notEquals && (_isTrue = StringUtils.isTrue(_fire = (_dataReadyEvent_1 = attribute.getDataReadyEvent()).getFire()))) {
            String _name = attribute.getName();
            String _lowerCase = _name.toLowerCase();
            _builder.append((Object)_lowerCase, "");
            _builder.append("->set_data_ready_event(");
            FireEvents _dataReadyEvent_2 = attribute.getDataReadyEvent();
            String _fire_1 = _dataReadyEvent_2.getFire();
            _builder.append((Object)_fire_1, "");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        }
        boolean bl2 = _notEquals_1 = !Objects.equal(_changeEvent = attribute.getChangeEvent(), null);
        if (_notEquals_1 && (_isTrue_1 = StringUtils.isTrue(_fire_2 = (_changeEvent_1 = attribute.getChangeEvent()).getFire()))) {
            String _name_1 = attribute.getName();
            String _lowerCase_1 = _name_1.toLowerCase();
            _builder.append((Object)_lowerCase_1, "");
            _builder.append("->set_change_event(");
            FireEvents _changeEvent_2 = attribute.getChangeEvent();
            String _fire_3 = _changeEvent_2.getFire();
            _builder.append((Object)_fire_3, "");
            _builder.append(", ");
            FireEvents _changeEvent_3 = attribute.getChangeEvent();
            String _libCheckCriteria = _changeEvent_3.getLibCheckCriteria();
            _builder.append((Object)_libCheckCriteria, "");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        }
        boolean bl3 = _notEquals_2 = !Objects.equal(_archiveEvent = attribute.getArchiveEvent(), null);
        if (_notEquals_2 && (_isTrue_2 = StringUtils.isTrue(_fire_4 = (_archiveEvent_1 = attribute.getArchiveEvent()).getFire()))) {
            String _name_2 = attribute.getName();
            String _lowerCase_2 = _name_2.toLowerCase();
            _builder.append((Object)_lowerCase_2, "");
            _builder.append("->set_archive_event(");
            FireEvents _archiveEvent_2 = attribute.getArchiveEvent();
            String _fire_5 = _archiveEvent_2.getFire();
            _builder.append((Object)_fire_5, "");
            _builder.append(", ");
            FireEvents _archiveEvent_3 = attribute.getArchiveEvent();
            String _libCheckCriteria_1 = _archiveEvent_3.getLibCheckCriteria();
            _builder.append((Object)_libCheckCriteria_1, "");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence setAttributeMemorized(Attribute attribute, String comment) {
        StringConcatenation _builder = new StringConcatenation();
        String _memorized = attribute.getMemorized();
        boolean _isSet = StringUtils.isSet(_memorized);
        if (_isSet) {
            String _name = attribute.getName();
            String _lowerCase = _name.toLowerCase();
            _builder.append((Object)_lowerCase, "");
            _builder.append("->set_memorized();");
            _builder.newLineIfNotEmpty();
            String _memorizedAtInit = attribute.getMemorizedAtInit();
            boolean _isSet_1 = StringUtils.isSet(_memorizedAtInit);
            if (_isSet_1) {
                String _name_1 = attribute.getName();
                String _lowerCase_1 = _name_1.toLowerCase();
                _builder.append((Object)_lowerCase_1, "");
                _builder.append("->set_memorized_init(");
                String _memorizedAtInit_1 = attribute.getMemorizedAtInit();
                _builder.append((Object)_memorizedAtInit_1, "");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
            } else {
                String _name_2 = attribute.getName();
                String _lowerCase_2 = _name_2.toLowerCase();
                _builder.append((Object)_lowerCase_2, "");
                _builder.append("->set_memorized_init(false);");
                _builder.newLineIfNotEmpty();
            }
        } else {
            _builder.append("//\t");
            _builder.append((Object)comment, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence allocateDynamicAttrubutePointer(Attribute attribute) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isSpectrum = this._cppStringUtils.isSpectrum(attribute);
        if (_isSpectrum) {
            _builder.append("if (ptr==NULL)");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("ptr = new ");
            Type _dataType = attribute.getDataType();
            String _cppType = CppTypeDefinitions.cppType(_dataType);
            _builder.append((Object)_cppType, "\t");
            _builder.append("[");
            String _maxX = attribute.getMaxX();
            _builder.append((Object)_maxX, "\t");
            _builder.append("];");
            _builder.newLineIfNotEmpty();
        } else {
            boolean _isImage = this._cppStringUtils.isImage(attribute);
            if (_isImage) {
                _builder.append("if (ptr==NULL)");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("ptr = new ");
                Type _dataType_1 = attribute.getDataType();
                String _cppType_1 = CppTypeDefinitions.cppType(_dataType_1);
                _builder.append((Object)_cppType_1, "\t");
                _builder.append("[");
                String _maxX_1 = attribute.getMaxX();
                _builder.append((Object)_maxX_1, "\t");
                _builder.append("*");
                String _maxY = attribute.getMaxY();
                _builder.append((Object)_maxY, "\t");
                _builder.append("];");
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }
}

