/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tango.pogo.generator.cpp;

import com.google.inject.Inject;
import fr.esrf.tango.pogo.generator.cpp.utils.Headers;
import fr.esrf.tango.pogo.generator.cpp.utils.ProtectedArea;
import fr.esrf.tango.pogo.pogoDsl.PogoDeviceClass;
import fr.esrf.tango.pogo.pogoDsl.PogoMultiClasses;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;

public class Main {
    @Inject
    @Extension
    private ProtectedArea _protectedArea;
    @Inject
    @Extension
    private Headers _headers;

    public CharSequence generateMainFile(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        String _openProtectedArea = this._protectedArea.openProtectedArea(cls, "main.cpp");
        _builder.append((Object)_openProtectedArea, "");
        _builder.newLineIfNotEmpty();
        String _mainFileHeader = this._headers.mainFileHeader(cls);
        _builder.append((Object)_mainFileHeader, "");
        _builder.newLineIfNotEmpty();
        CharSequence _mainCode = this.mainCode();
        _builder.append((Object)_mainCode, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _closeProtectedArea = this._protectedArea.closeProtectedArea(cls, "main.cpp");
        _builder.append((Object)_closeProtectedArea, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence generateMainFile(PogoMultiClasses multi) {
        StringConcatenation _builder = new StringConcatenation();
        String _mainFileHeader = this._headers.mainFileHeader(multi);
        _builder.append((Object)_mainFileHeader, "");
        _builder.newLineIfNotEmpty();
        CharSequence _mainCode = this.mainCode();
        _builder.append((Object)_mainCode, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence mainCode() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#include <tango.h>");
        _builder.newLine();
        _builder.newLine();
        _builder.append("// Check if crash reporting is used.");
        _builder.newLine();
        _builder.append("#if defined(ENABLE_CRASH_REPORT)");
        _builder.newLine();
        _builder.append("#  include <crashreporting/crash_report.h>");
        _builder.newLine();
        _builder.append("#else");
        _builder.newLine();
        _builder.append("#  define DECLARE_CRASH_HANDLER");
        _builder.newLine();
        _builder.append("#  define INSTALL_CRASH_HANDLER");
        _builder.newLine();
        _builder.append("#endif");
        _builder.newLine();
        _builder.newLine();
        _builder.append("DECLARE_CRASH_HANDLER;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("int main(int argc,char *argv[])");
        _builder.newLine();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("INSTALL_CRASH_HANDLER");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("try");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// Initialise the device server");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("//----------------------------------------");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("Tango::Util *tg = Tango::Util::init(argc,argv);");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// Create the device server singleton ");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("//\twhich will create everything");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("//----------------------------------------");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("tg->server_init(false);");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// Run the endless loop");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("//----------------------------------------");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("cout << \"Ready to accept request\" << endl;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("tg->server_run();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("catch (bad_alloc &)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("cout << \"Can't allocate memory to store device object !!!\" << endl;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("cout << \"Exiting\" << endl;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("catch (CORBA::Exception &e)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("Tango::Except::print_exception(e);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("cout << \"Received a CORBA_Exception\" << endl;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("cout << \"Exiting\" << endl;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("Tango::Util::instance()->server_cleanup();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return(0);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }
}

