/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tango.pogo.generator.common;

import fr.esrf.tango.pogo.pogoDsl.Attribute;
import fr.esrf.tango.pogo.pogoDsl.Property;
import fr.esrf.tango.pogo.pogoDsl.State;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;

public class StringUtils {
    private static boolean trace;
    private static boolean traceNotSet;

    static {
        traceNotSet = true;
    }

    public static String DeviceImpl() {
        return "TANGO_BASE_CLASS";
    }

    public static boolean isTrue(String str) {
        return str != null && str.equals("true");
    }

    public static boolean isFalse(String str) {
        return !StringUtils.isTrue(str);
    }

    public static void printTrace(String s) {
        if (traceNotSet) {
            trace = StringUtils.isTrue(System.getenv("XTendTrace"));
            traceNotSet = false;
        }
        if (trace) {
            System.out.println(s);
        }
    }

    public static boolean isSet(String str) {
        return str != null && !str.isEmpty();
    }

    public static int getIntegerValue(String str) {
        if (!StringUtils.isSet(str)) {
            return -1;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public String dataMemberName(String s) {
        return String.valueOf(s.substring(0, 1).toLowerCase()) + s.substring(1, s.length());
    }

    public String list2String(EList<String> list) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < list.size()) {
            sb.append((String)list.get(i));
            if (i < list.size() - 1) {
                sb.append("\\n");
            }
            ++i;
        }
        return sb.toString();
    }

    public String oneLineString(String text) {
        int end;
        if (text == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int start = 0;
        while ((end = text.indexOf(10, start)) > 0) {
            sb.append(text.substring(start, end)).append("\\n");
            start = end + 1;
        }
        sb.append(text.substring(start));
        return sb.toString();
    }

    public String string2Vector(String text, String vectorName) {
        int end;
        StringBuffer sb = new StringBuffer();
        int start = 0;
        while ((end = text.indexOf(10, start)) > 0) {
            sb.append(vectorName).append(".push_back(\"");
            sb.append(text.substring(start, end)).append("\");\n");
            start = end + 1;
        }
        sb.append(vectorName).append(".push_back(\"");
        sb.append(text.substring(start)).append("\");\n");
        return sb.toString();
    }

    public static String comments(String s, String tag) {
        return s.replaceAll("\n", "\n" + tag);
    }

    public String ifContentFromList(EList<String> list) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < list.size()) {
            sb.append("get_state()==Tango::").append((String)list.get(i));
            if (i < list.size() - 1) {
                sb.append(" ||\n\t");
            }
            ++i;
        }
        return sb.toString();
    }

    public String ifContentFromListPython(EList<String> list) {
        StringBuffer sb = new StringBuffer();
        sb.append("self.get_state() in [");
        int i = 0;
        while (i < list.size()) {
            sb.append("PyTango.DevState.").append((String)list.get(i));
            if (i < list.size() - 1) {
                sb.append(",\n    ");
            }
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    public String ifContentFromListPythonHL(EList<String> list) {
        StringBuffer sb = new StringBuffer();
        sb.append("self.get_state() not in [");
        int i = 0;
        while (i < list.size()) {
            sb.append("DevState.").append((String)list.get(i));
            if (i < list.size() - 1) {
                sb.append(",");
            }
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean hasMandatoryProperty(EList<Property> properties) {
        for (Property property : properties) {
            if (!StringUtils.isTrue(property.getMandatory())) continue;
            return true;
        }
        return false;
    }

    public boolean isScalar(Attribute attr) {
        return attr.getAttType().equals("Scalar");
    }

    public boolean isSpectrum(Attribute attr) {
        return attr.getAttType().equals("Spectrum");
    }

    public boolean isImage(Attribute attr) {
        return attr.getAttType().equals("Image");
    }

    public String attTypeDimentions(Attribute attr) {
        if (this.isSpectrum(attr)) {
            return " max = " + attr.getMaxX();
        }
        if (this.isImage(attr)) {
            return " max = " + attr.getMaxX() + " x " + attr.getMaxY();
        }
        return "";
    }

    public static boolean isRead(Attribute attribute) {
        String str = attribute.getRwType();
        return StringUtils.isSet(str) && str.contains("READ");
    }

    public static boolean isWrite(Attribute attribute) {
        String str = attribute.getRwType();
        return StringUtils.isSet(str) && str.contains("WRITE");
    }

    public static String statesTable(EList<State> states) {
        ArrayList<String[]> list = new ArrayList<String[]>();
        list.add(new String[]{"================================================================"});
        list.add(new String[]{"States", "Description"});
        list.add(new String[]{"================================================================"});
        for (State state : states) {
            list.add(new String[]{state.getName(), state.getDescription()});
        }
        return StringUtils.buildTable(list);
    }

    private static String buildTable(ArrayList<String[]> list) {
        StringBuffer sb = new StringBuffer();
        int length = 0;
        for (String[] array : list) {
            if (array.length <= 1 || array[0].length() <= length) continue;
            length = array[0].length();
        }
        for (String[] array : list) {
            if (array.length > 1) {
                sb.append("//  ").append(StringUtils.buildTab(array[0], length)).append("  |  ").append(array[1]);
            } else {
                sb.append("//").append(array[0]);
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    private static String buildTab(String str, int nbChar) {
        StringBuffer sb = new StringBuffer(str);
        int i = str.length();
        while (i < nbChar) {
            sb.append(' ');
            ++i;
        }
        return sb.toString();
    }

    public void insertInProtectedRegion(String fileName, String key, String textToInsert) throws Exception {
        String code = StringUtils.readFile(fileName);
        int start = code.indexOf("PROTECTED REGION ID(" + key + ") ENABLED START");
        if (start > 0) {
            start = code.indexOf("\n", start) + 1;
            int end = code.indexOf("PROTECTED REGION END", start);
            end = code.lastIndexOf("\n", end);
            code = String.valueOf(code.substring(0, start)) + textToInsert + code.substring(end);
            StringUtils.writeFile(fileName, code);
        } else {
            System.err.println("PROTECTED REGION ID(" + key + ") ENABLED START" + " not found !!");
        }
    }

    public String getProtectedRegionContent(String fileName, String key) throws Exception {
        String code = StringUtils.readFile(fileName);
        int start = code.indexOf("PROTECTED REGION ID(" + key + ") ENABLED START");
        if (start > 0) {
            start = code.indexOf("\n", start) + 1;
            int end = code.indexOf("PROTECTED REGION END", start);
            end = code.lastIndexOf("\n", end);
            return code.substring(start, end);
        }
        return null;
    }

    public static String readFile(String filename) throws Exception {
        String str = "";
        FileInputStream fid = new FileInputStream(filename);
        int nb = fid.available();
        byte[] inStr = new byte[nb];
        nb = fid.read(inStr);
        fid.close();
        if (nb > 0) {
            str = StringUtils.takeOffWindowsChar(inStr);
        }
        return str;
    }

    protected static String takeOffWindowsChar(byte[] b_in) {
        int nb = 0;
        byte[] byArray = b_in;
        int n = b_in.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            if (b != 13) {
                ++nb;
            }
            ++n2;
        }
        byte[] b_out = new byte[nb];
        int i = 0;
        int j = 0;
        while (i < b_in.length) {
            if (b_in[i] != 13) {
                b_out[j++] = b_in[i];
            }
            ++i;
        }
        return new String(b_out);
    }

    public static void writeFile(String filename, String code) throws Exception {
        FileOutputStream fidout = new FileOutputStream(filename);
        fidout.write(code.getBytes());
        fidout.close();
    }

    public static boolean fileExists(String fileName) {
        return new File(fileName).exists();
    }

    public static String label2enum(String label) {
        String enumStr = label.toUpperCase();
        enumStr = StringUtils.myReplaceAll(enumStr, "*", "mult");
        enumStr = StringUtils.myReplaceAll(enumStr, "/", "div");
        enumStr = StringUtils.myReplaceAll(enumStr, "+", "plus");
        enumStr = StringUtils.myReplaceAll(enumStr, "-", "minus");
        enumStr = StringUtils.myReplaceAll(enumStr, ".", "point");
        enumStr = StringUtils.myReplaceAll(enumStr, "=", "equal");
        enumStr = StringUtils.myReplaceAll(enumStr, "%", "percent");
        enumStr = StringUtils.myReplaceAll(enumStr, ">", "sup");
        enumStr = StringUtils.myReplaceAll(enumStr, "<", "inf");
        return "_" + enumStr.replaceAll(" ", "_");
    }

    private static String myReplaceAll(String inCode, String oldStr, String newStr) {
        int end;
        StringBuilder sb = new StringBuilder();
        int start = 0;
        while ((end = inCode.indexOf(oldStr, start)) > 0) {
            sb.append(inCode.substring(start, end)).append(newStr);
            start = end + oldStr.length();
        }
        sb.append(inCode.substring(start));
        return sb.toString();
    }

    public static String licenseText(String licence, String commentTag) {
        if (licence != null && licence.equals("none")) {
            return "";
        }
        if (licence != null && licence.equals("APACHE")) {
            return String.valueOf(commentTag) + StringUtils.comments("This file is part of Tango device class.\n\nTango is free software: you can redistribute it and/or modify\nit under the terms of the APACHE licence.\n", commentTag) + "\n";
        }
        if (licence != null && licence.equals("MIT")) {
            return String.valueOf(commentTag) + StringUtils.comments("This file is part of Tango device class.\n\nTango is free software: you can redistribute it and/or modify\nit under the terms of the MIT licence.\n", commentTag) + "\n";
        }
        if (licence != null && licence.equals("LGPL")) {
            String gpl = "This file is part of Tango device class.\n\nTango is free software: you can redistribute it and/or modify\nit under the terms of the GNU General Public License as published by\nthe Free Software Foundation, either version 3 of the License, or\n(at your option) any later version.\n\nTango is distributed in the hope that it will be useful,\nbut WITHOUT ANY WARRANTY; without even the implied warranty of\nMERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\nGNU General Public License for more details.\n\nYou should have received a copy of the GNU General Public License\nalong with Tango.  If not, see <http://www.gnu.org/licenses/>.\n";
            String str = "General Public License";
            StringBuilder sb = new StringBuilder();
            int start = 0;
            int end = 0;
            while ((end = gpl.indexOf(str, start + str.length())) > 0) {
                sb.append(String.valueOf(gpl.substring(start, end)) + "Lesser ");
                start = end;
            }
            sb.append(gpl.substring(start));
            return String.valueOf(commentTag) + StringUtils.comments(sb.toString(), commentTag) + "\n";
        }
        return String.valueOf(commentTag) + StringUtils.comments("This file is part of Tango device class.\n\nTango is free software: you can redistribute it and/or modify\nit under the terms of the GNU General Public License as published by\nthe Free Software Foundation, either version 3 of the License, or\n(at your option) any later version.\n\nTango is distributed in the hope that it will be useful,\nbut WITHOUT ANY WARRANTY; without even the implied warranty of\nMERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\nGNU General Public License for more details.\n\nYou should have received a copy of the GNU General Public License\nalong with Tango.  If not, see <http://www.gnu.org/licenses/>.\n", commentTag) + "\n";
    }

    public static String getCopyrightCommented(String copyright) {
        if (copyright == null || copyright.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int start = 0;
        int end = 0;
        while ((end = copyright.indexOf(10, start)) > 0) {
            String line = "// " + copyright.substring(start, ++end);
            sb.append(line);
            start = end;
        }
        sb.append("// ").append(copyright.substring(start)).append("\n");
        return sb.toString();
    }

    public static String getIncludePath() {
        String tangoInclude = System.getenv("TANGO_INCLUDE");
        if (tangoInclude == null) {
            return "$TANGO_ROOT/include";
        }
        return tangoInclude;
    }
}

