/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui.packaging;

import fr.esrf.tango.pogo.pogoDsl.AdditionalFile;
import fr.esrf.tango.pogo.pogoDsl.Inheritance;
import fr.esrf.tango.pogo.pogoDsl.OneClassSimpleDef;
import fr.esrf.tango.pogo.pogoDsl.PogoDeviceClass;
import fr.esrf.tango.pogo.pogoDsl.PogoMultiClasses;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.tango.pogo.pogo_gui.packaging.PackUtils;
import org.tango.pogo.pogo_gui.tools.ParserTool;
import org.tango.pogo.pogo_gui.tools.PogoException;

public class Packaging {
    private ArrayList<PackClass> classes = new ArrayList();
    private ArrayList<String> addedClasses = new ArrayList();
    private String packageName;
    private String packageAuthor;
    private String packagePath;
    private String packageVersion;
    private boolean multipleClasses = false;
    private PackFile[] packFiles = new PackFile[]{new PackFile("README", true, true), new PackFile("COPYING", false, false), new PackFile("NEWS", false, false), new PackFile("INSTALL", false, false), new PackFile("AUTHORS", true, false), new PackFile("ChangeLog", false, false), new PackFile("autogen.sh", true, true), new PackFile("configure.ac", true, true), new PackFile("Makefile.am", true, true), new PackFile("src/Makefile.am", true, true), new PackFile("m4/gcc_release.m4", false, false)};
    private static final String[] directories = new String[]{"", "src", "build", "m4"};
    private static final boolean NO_MODIF = false;
    private static final boolean MODIFY = true;
    private static final boolean NO_UPDATE = false;
    private static final boolean UPDATE = true;
    static final String PackageDir = "/packaging/";

    public Packaging(PogoDeviceClass deviceClass, String packageVersion, String author) throws PogoException {
        this.packageVersion = packageVersion;
        String className = deviceClass.getName();
        String path = deviceClass.getDescription().getSourcePath();
        this.initialize(className, path, author);
        PackClass _class = new PackClass(className, path);
        _class.addAdditionalFiles(deviceClass.getAdditionalFiles());
        this.classes.add(_class);
        this.manageInheritances(deviceClass.getDescription().getInheritances());
    }

    public Packaging(PogoMultiClasses deviceClasses, String packageVersion, String author) throws PogoException {
        this.packageVersion = packageVersion;
        String className = deviceClasses.getName();
        String path = deviceClasses.getSourcePath();
        this.initialize(className, path, author);
        EList<OneClassSimpleDef> simpleDefList = deviceClasses.getClasses();
        for (OneClassSimpleDef _class : simpleDefList) {
            PackClass packClass = new PackClass(_class.getClassname(), _class.getSourcePath());
            packClass.addAdditionalFiles(_class.getAdditionalFiles());
            this.classes.add(packClass);
            this.manageInheritances(_class.getInheritances());
        }
        this.multipleClasses = true;
    }

    private void manageInheritances(List<Inheritance> inheritances) throws PogoException {
        for (Inheritance inheritance : inheritances) {
            String name = inheritance.getClassname();
            if (name.startsWith("Device") && name.endsWith("Impl")) continue;
            this.classes.add(new PackClass(name, inheritance.getSourcePath()));
        }
    }

    private void initialize(String name, String path, String author) throws PogoException {
        this.packageName = name;
        this.packagePath = String.valueOf(path) + "/packaging";
        this.packageAuthor = author;
        if (!Packaging.isAvailable()) {
            throw new PogoException("Property 'PACKAGING_HOME' not set");
        }
        PackFile[] packFileArray = this.packFiles;
        int n = this.packFiles.length;
        int n2 = 0;
        while (n2 < n) {
            PackFile packFile = packFileArray[n2];
            if (PackUtils.getInstance().fileExistsInPackage(PackageDir + packFile.name)) {
                throw new PogoException("Template file '" + packFile.name + "' not found");
            }
            ++n2;
        }
    }

    private void copyTemplates() throws PogoException {
        PackFile[] packFileArray = this.packFiles;
        int n = this.packFiles.length;
        int n2 = 0;
        while (n2 < n) {
            PackFile packFile = packFileArray[n2];
            String targetFile = String.valueOf(this.packagePath) + "/" + packFile.name;
            packFile.alreadyExists = new File(targetFile).exists();
            if (packFile.update || !packFile.alreadyExists) {
                String code = PackUtils.getInstance().readFileFromPackage(PackageDir + packFile.name);
                ParserTool.writeFile(targetFile, code);
                if (packFile.name.endsWith(".sh") && !new File(targetFile).setExecutable(true)) {
                    System.err.println("Cannot set executable " + targetFile);
                }
            }
            ++n2;
        }
    }

    private String addSourceReferences(String code) {
        String nextLine = PackUtils.buildNextLine(String.valueOf(this.packageName) + "_SOURCES = ");
        StringBuilder sb = new StringBuilder();
        for (PackClass _class : this.classes) {
            if (this.addedClasses.indexOf(_class.name) < 0) {
                for (String file : _class.headers) {
                    sb.append(file).append(nextLine);
                }
                ArrayList files = _class.sources;
                for (String file : files) {
                    sb.append(file).append(nextLine);
                }
                this.addedClasses.add(_class.name);
                continue;
            }
            PackUtils.println(String.valueOf(_class.name) + " has already been added!");
        }
        String factory = this.multipleClasses ? "MultiClassesFactory.cpp" : "ClassFactory.cpp";
        sb.append(factory).append(nextLine);
        sb.append("main.cpp");
        code = code.replaceAll("TEMPLATE_SOURCES", sb.toString());
        return code;
    }

    private void updateTemplate(String fileName) throws PogoException {
        String code = ParserTool.readFile(fileName);
        if (fileName.endsWith("src/Makefile.am")) {
            code = this.addSourceReferences(code);
        }
        code = code.replaceAll("TEMPLATE_AUTHOR", this.packageAuthor);
        code = code.replaceAll("TEMPLATE_VERSION", this.packageVersion);
        code = code.replaceAll("TEMPLATE_CLASS", this.packageName);
        ParserTool.writeFile(fileName, code);
    }

    private void updateConfig(String fileName, ArrayList<String> headers, ArrayList<String> functions) throws PogoException {
        String code = ParserTool.readFile(fileName);
        code = code.replaceAll("TEMPLATE_CHECK_HEADERS", PackUtils.buildConfigureList(headers));
        code = code.replaceAll("TEMPLATE_CHECK_FUNCS", PackUtils.buildConfigureList(functions));
        ParserTool.writeFile(fileName, code);
    }

    private void createSourceLinks(String path, String fileName, String srcPath) throws PogoException {
        ArrayList<String> list = new ArrayList<String>();
        list.add(fileName);
        this.createSourceLinks(path, list, srcPath);
    }

    private void createSourceLinks(String path, ArrayList<String> fileNames, String srcPath) throws PogoException {
        try {
            String scriptName = String.valueOf(path) + "/create_links";
            String code = "#!/bin/sh\n\n";
            code = String.valueOf(code) + "cd  " + path + "\n\n";
            for (String fileName : fileNames) {
                code = String.valueOf(code) + "rm -f  " + fileName + "\n";
                code = String.valueOf(code) + "ln -s  " + srcPath + "/" + fileName + "   " + fileName + "\n\n";
            }
            ParserTool.writeFile(scriptName, code);
            File script = new File(scriptName);
            if (script.setExecutable(true)) {
                PackUtils.println("execute " + scriptName);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                PackUtils.executeShellCommand(scriptName);
            }
            script.delete();
        }
        catch (Exception e) {
            throw new PogoException("Cannot create link: " + e);
        }
    }

    public void generate(ArrayList<String> headers, ArrayList<String> functions) throws PogoException {
        PackUtils.buildDirectories(directories, this.packagePath);
        this.copyTemplates();
        PackFile[] packFileArray = this.packFiles;
        int n = this.packFiles.length;
        int n2 = 0;
        while (n2 < n) {
            PackFile packFile = packFileArray[n2];
            if (packFile.doUpdates()) {
                this.updateTemplate(String.valueOf(this.packagePath) + "/" + packFile.name);
                if (packFile.name.endsWith("configure.ac")) {
                    this.updateConfig(String.valueOf(this.packagePath) + "/" + packFile.name, headers, functions);
                }
            }
            ++n2;
        }
        if (this.multipleClasses) {
            for (PackClass _class : this.classes) {
                this.createSourceLinks(String.valueOf(this.packagePath) + "/src", _class.headers, _class.path);
                this.createSourceLinks(String.valueOf(this.packagePath) + "/src", _class.getSources(), _class.path);
                _class.manageSerialSpecialCase();
            }
            this.createSourceLinks(String.valueOf(this.packagePath) + "/src", "MultiClassesFactory.cpp", "../..");
        } else {
            int cnt = 0;
            for (PackClass _class : this.classes) {
                String srcPath = cnt++ == 0 ? "../.." : _class.path;
                this.createSourceLinks(String.valueOf(this.packagePath) + "/src", _class.headers, srcPath);
                this.createSourceLinks(String.valueOf(this.packagePath) + "/src", _class.getSources(), srcPath);
                _class.manageSerialSpecialCase();
            }
            this.createSourceLinks(String.valueOf(this.packagePath) + "/src", "ClassFactory.cpp", "../..");
        }
        this.createSourceLinks(String.valueOf(this.packagePath) + "/src", "main.cpp", "../..");
        PackUtils.println("Packaging for " + this.packageName + " has been created in:\n" + this.packagePath);
    }

    public static boolean isAvailable() {
        return PackUtils.isAvailable();
    }

    public String getPackagePath() {
        return this.packagePath;
    }

    public String getPackageName() {
        return this.packageName;
    }

    private class PackClass {
        private String name;
        private String path;
        private ArrayList<String> headers;
        private ArrayList<String> sources;
        private final String[] badSerialFiles = new String[]{"SerialLinux.cpp", "SerialWin32.cpp"};

        private PackClass(String name, String path) throws PogoException {
            this.name = name;
            this.path = path;
            this.headers = PackUtils.getFileList(path, ".h");
            this.sources = new ArrayList();
            this.sources.add(String.valueOf(name) + ".cpp");
            this.sources.add(String.valueOf(name) + "Class.cpp");
            this.sources.add(String.valueOf(name) + "StateMachine.cpp");
            String dynAttrFile = String.valueOf(name) + "DynAttrUtils.cpp";
            if (new File(String.valueOf(path) + "/" + dynAttrFile).exists()) {
                this.sources.add(dynAttrFile);
            }
        }

        private void addAdditionalFiles(List<AdditionalFile> additionalFiles) {
            if (additionalFiles != null) {
                for (AdditionalFile file : additionalFiles) {
                    this.sources.add(String.valueOf(file.getName()) + ".cpp");
                }
            }
        }

        private void manageSerialSpecialCase() {
            if (this.name.equals("Serial")) {
                try {
                    String code = ParserTool.readFile(String.valueOf(Packaging.this.packagePath) + "/Makefile.am");
                    String key = "EXTRA_DIST = ";
                    String badFiles = "";
                    String[] stringArray = this.badSerialFiles;
                    int n = this.badSerialFiles.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String badFile = stringArray[n2];
                        badFiles = String.valueOf(badFiles) + " src/" + badFile + " ";
                        ++n2;
                    }
                    int pos = code.indexOf(key);
                    if (pos > 0) {
                        code = String.valueOf(code.substring(0, pos += key.length())) + badFiles + code.substring(pos);
                        ParserTool.writeFile(String.valueOf(Packaging.this.packagePath) + "/Makefile.am", code);
                    }
                }
                catch (PogoException e) {
                    System.err.println(e);
                }
            }
        }

        private ArrayList<String> getSources() {
            ArrayList<String> list = new ArrayList<String>();
            for (String file : this.sources) {
                if (file.equals("main.cpp") || file.equals("ClassFactory.cpp")) continue;
                list.add(file);
            }
            if (this.name.equals("Serial")) {
                Collections.addAll(list, this.badSerialFiles);
            }
            return list;
        }
    }

    private class PackFile {
        String name;
        boolean modify;
        boolean update = false;
        boolean alreadyExists = false;

        private PackFile(String name, boolean modify, boolean update) {
            this.name = name;
            this.modify = modify;
            this.update = update;
        }

        private boolean doUpdates() {
            return this.modify && !this.alreadyExists || this.update;
        }
    }
}

