/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util.formallang;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.xtext.util.formallang.ProductionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductionStringFactory<TOKEN>
implements ProductionFactory<String, TOKEN> {
    protected Function<TOKEN, String> token2String;

    public ProductionStringFactory() {
    }

    public ProductionStringFactory(Function<TOKEN, String> token2String) {
        this.token2String = token2String;
    }

    protected String card(boolean many, boolean optional) {
        return many ? (optional ? "*" : "+") : (optional ? "?" : "");
    }

    @Override
    public String createForAlternativeChildren(boolean many, boolean optional, Iterable<String> children) {
        ArrayList<String> childrenSorted = Lists.newArrayList(Iterables.filter(children, Predicates.notNull()));
        Collections.sort(childrenSorted);
        return "(" + Joiner.on(" | ").join(childrenSorted) + ")" + this.card(many, optional);
    }

    @Override
    public String createForSequentialChildren(boolean many, boolean optional, Iterable<String> children) {
        children = Iterables.filter(children, Predicates.notNull());
        if (many || optional) {
            return "(" + Joiner.on(" ").join(children) + ")" + this.card(many, optional);
        }
        return String.valueOf(Joiner.on(" ").join(children)) + this.card(many, optional);
    }

    @Override
    public String createForToken(boolean many, boolean optional, TOKEN token) {
        if (this.token2String != null) {
            return String.valueOf(this.token2String.apply(token)) + this.card(many, optional);
        }
        if (token == null) {
            return "null" + this.card(many, optional);
        }
        return String.valueOf(token.toString()) + this.card(many, optional);
    }

    @Override
    public String createForUnordertedChildren(boolean many, boolean optional, Iterable<String> children) {
        ArrayList<String> childrenSorted = Lists.newArrayList(Iterables.filter(children, Predicates.notNull()));
        Collections.sort(childrenSorted);
        return "(" + Joiner.on(" & ").join(childrenSorted) + ")" + this.card(many, optional);
    }
}

