/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.serializer.analysis;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.grammaranalysis.impl.GrammarElementTitleSwitch;
import org.eclipse.xtext.serializer.analysis.ISerState;
import org.eclipse.xtext.util.formallang.NfaGraphFormatter;
import org.eclipse.xtext.util.formallang.NfaUtil;
import org.eclipse.xtext.util.formallang.Pda;
import org.eclipse.xtext.util.formallang.PdaFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializerPDA
implements Pda<ISerState, RuleCall> {
    protected SerializerPDAState start;
    protected SerializerPDAState stop;

    public SerializerPDA(SerializerPDAState start, SerializerPDAState stop) {
        this.start = start;
        this.stop = stop;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        return new NfaUtil().equalsIgnoreOrder(this, (SerializerPDA)obj);
    }

    @Override
    public Iterable<ISerState> getFollowers(ISerState state) {
        return ((SerializerPDAState)state).followers;
    }

    @Override
    public RuleCall getPop(ISerState state) {
        SerializerPDAState s = (SerializerPDAState)state;
        return s.type == ISerState.SerStateType.POP ? (RuleCall)s.grammarElement : null;
    }

    @Override
    public RuleCall getPush(ISerState state) {
        SerializerPDAState s = (SerializerPDAState)state;
        return s.type == ISerState.SerStateType.PUSH ? (RuleCall)s.grammarElement : null;
    }

    @Override
    public ISerState getStart() {
        return this.start;
    }

    @Override
    public ISerState getStop() {
        return this.stop;
    }

    public int hashCode() {
        int r = 0;
        if (this.start != null && this.start.followers != null) {
            for (ISerState s : this.start.followers) {
                if (s == null) continue;
                r += s.hashCode();
            }
        }
        return r;
    }

    public String toString() {
        return new NfaGraphFormatter().format(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SerializerPDACloneFactory
    implements PdaFactory<SerializerPDA, ISerState, RuleCall, ISerState> {
        @Override
        public SerializerPDA create(ISerState start, ISerState stop) {
            SerializerPDAState s1 = new SerializerPDAState(start.getGrammarElement(), ISerState.SerStateType.START);
            SerializerPDAState s2 = new SerializerPDAState(stop.getGrammarElement(), ISerState.SerStateType.STOP);
            return new SerializerPDA(s1, s2);
        }

        @Override
        public ISerState createPop(SerializerPDA pda, ISerState token) {
            return new SerializerPDAState(token.getGrammarElement(), ISerState.SerStateType.POP);
        }

        @Override
        public ISerState createPush(SerializerPDA pda, ISerState token) {
            return new SerializerPDAState(token.getGrammarElement(), ISerState.SerStateType.PUSH);
        }

        @Override
        public ISerState createState(SerializerPDA nfa, ISerState token) {
            return new SerializerPDAState(token.getGrammarElement(), ISerState.SerStateType.ELEMENT);
        }

        @Override
        public void setFollowers(SerializerPDA nfa, ISerState owner, Iterable<ISerState> followers) {
            ((SerializerPDAState)owner).followers = Lists.newArrayList(followers);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SerializerPDAElementFactory
    implements PdaFactory<SerializerPDA, ISerState, RuleCall, AbstractElement> {
        @Override
        public SerializerPDA create(AbstractElement start, AbstractElement stop) {
            SerializerPDAState s1 = new SerializerPDAState(start, ISerState.SerStateType.START);
            SerializerPDAState s2 = new SerializerPDAState(stop, ISerState.SerStateType.STOP);
            return new SerializerPDA(s1, s2);
        }

        @Override
        public ISerState createPop(SerializerPDA pda, AbstractElement token) {
            return new SerializerPDAState(token, ISerState.SerStateType.POP);
        }

        @Override
        public ISerState createPush(SerializerPDA pda, AbstractElement token) {
            return new SerializerPDAState(token, ISerState.SerStateType.PUSH);
        }

        @Override
        public ISerState createState(SerializerPDA nfa, AbstractElement token) {
            return new SerializerPDAState(token, ISerState.SerStateType.ELEMENT);
        }

        @Override
        public void setFollowers(SerializerPDA nfa, ISerState owner, Iterable<ISerState> followers) {
            ((SerializerPDAState)owner).followers = Lists.newArrayList(followers);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SerializerPDAGetToken
    implements Function<ISerState, AbstractElement> {
        @Override
        public AbstractElement apply(ISerState input) {
            return input.getGrammarElement();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SerializerPDAState
    implements ISerState {
        protected List<ISerState> followers = Collections.emptyList();
        protected AbstractElement grammarElement;
        protected ISerState.SerStateType type;

        public SerializerPDAState(AbstractElement grammarElement, ISerState.SerStateType type) {
            this.type = type;
            this.grammarElement = grammarElement;
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            SerializerPDAState s = (SerializerPDAState)obj;
            return this.grammarElement == s.grammarElement && this.type == s.type;
        }

        public List<ISerState> getFollowers() {
            return this.followers;
        }

        @Override
        public AbstractElement getGrammarElement() {
            return this.grammarElement;
        }

        @Override
        public ISerState.SerStateType getType() {
            return this.type;
        }

        public int hashCode() {
            return (this.grammarElement != null ? this.grammarElement.hashCode() : 1) * this.type.hashCode();
        }

        public String toString() {
            GrammarElementTitleSwitch fmt = new GrammarElementTitleSwitch().hideCardinality().showQualified().showAssignments();
            switch (this.type) {
                case ELEMENT: {
                    return fmt.apply(this.grammarElement);
                }
                case POP: {
                    return "<<" + fmt.apply(this.grammarElement);
                }
                case PUSH: {
                    return ">>" + fmt.apply(this.grammarElement);
                }
                case START: {
                    return "start";
                }
                case STOP: {
                    return "stop";
                }
            }
            return "";
        }
    }
}

