/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.scoping.impl;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.AbstractScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultimapBasedScope
extends AbstractScope {
    private Multimap<QualifiedName, IEObjectDescription> elements;

    public static IScope createScope(IScope parent, Iterable<IEObjectDescription> descriptions, boolean ignoreCase) {
        LinkedHashMultimap<QualifiedName, IEObjectDescription> map = null;
        for (IEObjectDescription description : descriptions) {
            if (map == null) {
                map = LinkedHashMultimap.create(5, 2);
            }
            if (ignoreCase) {
                map.put(description.getName().toLowerCase(), description);
                continue;
            }
            map.put(description.getName(), description);
        }
        if (map == null || map.isEmpty()) {
            return parent;
        }
        return new MultimapBasedScope(parent, map, ignoreCase);
    }

    protected MultimapBasedScope(IScope parent, Multimap<QualifiedName, IEObjectDescription> elements, boolean ignoreCase) {
        super(parent, ignoreCase);
        this.elements = elements;
    }

    @Override
    protected Iterable<IEObjectDescription> getAllLocalElements() {
        return this.elements.values();
    }

    @Override
    protected Iterable<IEObjectDescription> getLocalElementsByName(QualifiedName name) {
        QualifiedName query = name;
        if (this.isIgnoreCase()) {
            query = name.toLowerCase();
        }
        if (this.elements.containsKey(query)) {
            Collection<IEObjectDescription> result = this.elements.get(query);
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    protected boolean isShadowed(IEObjectDescription fromParent) {
        QualifiedName name = fromParent.getName();
        if (this.isIgnoreCase()) {
            name = name.toLowerCase();
        }
        boolean result = this.elements.containsKey(name);
        return result;
    }
}

