/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.registry.PerspectiveDescriptor;
import org.eclipse.ui.internal.registry.PerspectiveRegistry;

public class ResetPerspectiveHandler
extends AbstractHandler {
    @Override
    public Object execute(ExecutionEvent event) {
        IPerspectiveDescriptor descriptor;
        WorkbenchPage page;
        IWorkbenchWindow activeWorkbenchWindow = HandlerUtil.getActiveWorkbenchWindow(event);
        if (activeWorkbenchWindow != null && (page = (WorkbenchPage)activeWorkbenchWindow.getActivePage()) != null && (descriptor = page.getPerspective()) != null) {
            String message;
            boolean offerRevertToBase = false;
            if (descriptor instanceof PerspectiveDescriptor) {
                PerspectiveDescriptor desc = (PerspectiveDescriptor)descriptor;
                boolean bl = offerRevertToBase = desc.isPredefined() && desc.hasCustomDefinition();
            }
            if (offerRevertToBase) {
                message = NLS.bind(WorkbenchMessages.RevertPerspective_message, descriptor.getLabel());
                boolean toggleState = false;
                MessageDialogWithToggle dialog = MessageDialogWithToggle.open(3, activeWorkbenchWindow.getShell(), WorkbenchMessages.RevertPerspective_title, message, WorkbenchMessages.RevertPerspective_option, toggleState, null, null, 0x10000000);
                if (dialog.getReturnCode() == 2) {
                    if (dialog.getToggleState()) {
                        PerspectiveRegistry reg = (PerspectiveRegistry)PlatformUI.getWorkbench().getPerspectiveRegistry();
                        reg.revertPerspective(descriptor);
                    }
                    page.resetPerspective();
                }
            } else {
                message = NLS.bind(WorkbenchMessages.ResetPerspective_message, descriptor.getLabel());
                boolean result = MessageDialog.open(3, activeWorkbenchWindow.getShell(), WorkbenchMessages.ResetPerspective_title, message, 0x10000000);
                if (result) {
                    page.resetPerspective();
                }
            }
        }
        return null;
    }
}

