/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xpand2.ast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.internal.xpand2.ast.AbstractDefinition;
import org.eclipse.internal.xpand2.ast.Advice;
import org.eclipse.internal.xpand2.ast.Definition;
import org.eclipse.internal.xpand2.ast.ExtensionImportDeclaration;
import org.eclipse.internal.xpand2.ast.ImportDeclaration;
import org.eclipse.internal.xpand2.model.XpandAdvice;
import org.eclipse.internal.xpand2.model.XpandDefinition;
import org.eclipse.internal.xpand2.model.XpandResource;
import org.eclipse.internal.xtend.expression.ast.Identifier;
import org.eclipse.internal.xtend.expression.ast.SyntaxElement;
import org.eclipse.internal.xtend.util.QualifiedName;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xpand2.XpandUtil;
import org.eclipse.xtend.expression.AnalysationIssue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Template
extends SyntaxElement
implements XpandResource {
    private static final ImportDeclaration[] NO_IMPORT = new ImportDeclaration[0];
    private static final ExtensionImportDeclaration[] NO_EXT_IMPORT = new ExtensionImportDeclaration[0];
    private static final Advice[] NO_ADVICE = new Advice[0];
    private final ImportDeclaration[] imports;
    private final Definition[] definitions;
    private QualifiedName fullyQualifiedName;
    private final ExtensionImportDeclaration[] extensions;
    private final Advice[] advices;
    private String[] commonPrefixes = null;
    String[] importedExtensions = null;

    public ExtensionImportDeclaration[] getExtensions() {
        return this.extensions;
    }

    public List<String> getImportedExtensionsAsList() {
        ArrayList<String> result = new ArrayList<String>(this.extensions.length);
        ExtensionImportDeclaration[] extensionImportDeclarationArray = this.extensions;
        int n = this.extensions.length;
        int n2 = 0;
        while (n2 < n) {
            ExtensionImportDeclaration ext = extensionImportDeclarationArray[n2];
            result.add(ext.getImportString().toString());
            ++n2;
        }
        return result;
    }

    @Override
    public String getFullyQualifiedName() {
        return this.fullyQualifiedName != null ? this.fullyQualifiedName.toString("::") : null;
    }

    public QualifiedName getQualifiedName() {
        return this.fullyQualifiedName;
    }

    @Override
    public void setFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = QualifiedName.create(fullyQualifiedName, "::");
    }

    public Template(ImportDeclaration[] imports, ExtensionImportDeclaration[] extensions, Definition[] definitions, Advice[] advices) {
        this.imports = imports.length > 0 ? imports : NO_IMPORT;
        this.extensions = extensions.length > 0 ? extensions : NO_EXT_IMPORT;
        AbstractDefinition[] abstractDefinitionArray = definitions;
        int n = definitions.length;
        int n2 = 0;
        while (n2 < n) {
            Definition definition = abstractDefinitionArray[n2];
            definition.setOwner(this);
            ++n2;
        }
        this.definitions = definitions;
        abstractDefinitionArray = advices;
        n = advices.length;
        n2 = 0;
        while (n2 < n) {
            AbstractDefinition advice = abstractDefinitionArray[n2];
            advice.setOwner(this);
            ++n2;
        }
        this.advices = advices.length > 0 ? advices : NO_ADVICE;
    }

    @Override
    public XpandDefinition[] getDefinitions() {
        return this.definitions;
    }

    public List<XpandDefinition> getDefinitionsAsList() {
        return Arrays.asList(this.definitions);
    }

    public AbstractDefinition[] getAllDefinitions() {
        ArrayList<AbstractDefinition> l = new ArrayList<AbstractDefinition>();
        l.addAll(Arrays.asList(this.definitions));
        l.addAll(Arrays.asList(this.advices));
        Collections.sort(l, new Comparator<SyntaxElement>(){

            @Override
            public int compare(SyntaxElement o1, SyntaxElement o2) {
                return new Integer(o1.getStart()).compareTo(o2.getStart());
            }
        });
        return l.toArray(new AbstractDefinition[l.size()]);
    }

    public ImportDeclaration[] getImports() {
        return this.imports;
    }

    public List<ImportDeclaration> getImportsAsList() {
        return Arrays.asList(this.imports);
    }

    @Override
    public void analyze(XpandExecutionContext ctx, Set<AnalysationIssue> issues) {
        try {
            HashSet<AnalysationIssue> issuesFromThisResource = new HashSet<AnalysationIssue>();
            ctx = (XpandExecutionContext)ctx.cloneWithResource(this);
            if (ctx.getCallback() != null && !ctx.getCallback().pre(this, ctx)) {
                return;
            }
            try {
                ExtensionImportDeclaration[] extensionImportDeclarationArray = this.extensions;
                int n = this.extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    ExtensionImportDeclaration extension = extensionImportDeclarationArray[n2];
                    extension.analyze(ctx, issuesFromThisResource);
                    ++n2;
                }
                this.checkDuplicateDefinitions(issuesFromThisResource);
                HashSet<Identifier> uniqueNames = new HashSet<Identifier>();
                SyntaxElement[] syntaxElementArray = this.extensions;
                int n3 = this.extensions.length;
                n = 0;
                while (n < n3) {
                    ExtensionImportDeclaration imp = syntaxElementArray[n];
                    if (uniqueNames.contains(imp.getImportString())) {
                        String msg = "Duplicate extension importing: " + imp.getImportString();
                        issues.add(new AnalysationIssue(AnalysationIssue.SYNTAX_ERROR, msg, imp));
                    }
                    uniqueNames.add(imp.getImportString());
                    ++n;
                }
                syntaxElementArray = this.definitions;
                n3 = this.definitions.length;
                n = 0;
                while (n < n3) {
                    SyntaxElement definition = syntaxElementArray[n];
                    ((AbstractDefinition)definition).analyze(ctx, issuesFromThisResource);
                    ++n;
                }
                syntaxElementArray = this.advices;
                n3 = this.advices.length;
                n = 0;
                while (n < n3) {
                    SyntaxElement advice = syntaxElementArray[n];
                    ((Advice)advice).analyze(ctx, issuesFromThisResource);
                    ++n;
                }
                syntaxElementArray = this.imports;
                n3 = this.imports.length;
                n = 0;
                while (n < n3) {
                    SyntaxElement importDeclaration = syntaxElementArray[n];
                    ((ImportDeclaration)importDeclaration).analyze(ctx, issuesFromThisResource);
                    ++n;
                }
                HashSet<AnalysationIssue> issuesToRemove = new HashSet<AnalysationIssue>();
                for (AnalysationIssue issue : issuesFromThisResource) {
                    if (!issue.getType().equals(AnalysationIssue.RESOURCE_NOT_FOUND)) continue;
                    ImportDeclaration importStmt = (ImportDeclaration)issue.getElement();
                    for (AnalysationIssue issue2 : issuesFromThisResource) {
                        if (!issue2.getType().equals(AnalysationIssue.INTERNAL_ERROR) || !issue2.getMessage().matches("Error parsing extensions.*" + importStmt.getImportString() + "$")) continue;
                        issuesToRemove.add(issue2);
                    }
                }
                issuesFromThisResource.removeAll(issuesToRemove);
                issues.addAll(issuesFromThisResource);
            }
            catch (RuntimeException ex) {
                issues.add(new AnalysationIssue(AnalysationIssue.INTERNAL_ERROR, ex.getMessage(), this));
            }
        }
        finally {
            if (ctx.getCallback() != null) {
                ctx.getCallback().post(this, ctx, null);
            }
        }
    }

    @Override
    public XpandDefinition[] getDefinitionsByName(String aName) {
        ArrayList<Definition> defs = new ArrayList<Definition>();
        Definition[] definitionArray = this.definitions;
        int n = this.definitions.length;
        int n2 = 0;
        while (n2 < n) {
            Definition def = definitionArray[n2];
            if (def.getName().equals(aName)) {
                defs.add(def);
            }
            ++n2;
        }
        return defs.toArray(new XpandDefinition[defs.size()]);
    }

    @Override
    public String[] getImportedNamespaces() {
        if (this.commonPrefixes == null) {
            ArrayList<String> l = new ArrayList<String>();
            String thisNs = XpandUtil.withoutLastSegment(this.getFullyQualifiedName());
            int i = 0;
            while (i < this.getImports().length) {
                ImportDeclaration anImport = this.getImports()[i];
                l.add(anImport.getImportString().toString());
                ++i;
            }
            if (thisNs != null) {
                l.add(thisNs);
            }
            this.commonPrefixes = l.toArray(new String[l.size()]);
        }
        return this.commonPrefixes;
    }

    public List<String> getImportedNamespacesAsList() {
        return Arrays.asList(this.getImportedNamespaces());
    }

    @Override
    public String[] getImportedExtensions() {
        if (this.importedExtensions == null) {
            ArrayList<String> l = new ArrayList<String>();
            int i = 0;
            while (i < this.getExtensions().length) {
                ExtensionImportDeclaration anImport = this.getExtensions()[i];
                l.add(anImport.getImportString().toString());
                ++i;
            }
            this.importedExtensions = l.toArray(new String[l.size()]);
        }
        return this.importedExtensions;
    }

    @Override
    public XpandAdvice[] getAdvices() {
        return this.advices;
    }

    private void checkDuplicateDefinitions(Set<AnalysationIssue> issues) {
        HashSet<Definition> definitionSet = new HashSet<Definition>();
        Definition[] definitionArray = this.definitions;
        int n = this.definitions.length;
        int n2 = 0;
        while (n2 < n) {
            Definition def = definitionArray[n2];
            if (!definitionSet.contains(def)) {
                definitionSet.add(def);
            } else {
                Definition origDef = null;
                for (Definition d : definitionSet) {
                    if (!d.equals(def)) continue;
                    origDef = d;
                    break;
                }
                issues.add(new AnalysationIssue(AnalysationIssue.INTERNAL_ERROR, "Duplicate DEFINE definition '" + def.getName() + "'", def, false, def.getStart()));
                issues.add(new AnalysationIssue(AnalysationIssue.INTERNAL_ERROR, "Duplicate DEFINE definition '" + (origDef != null ? origDef.getName() : "") + "'", origDef, false, origDef.getStart()));
            }
            ++n2;
        }
    }

    public String toString() {
        return this.getFileName();
    }
}

