/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tango.pogo.generator.cpp;

import com.google.inject.Inject;
import fr.esrf.tango.pogo.generator.cpp.utils.Attributes;
import fr.esrf.tango.pogo.generator.cpp.utils.Commands;
import fr.esrf.tango.pogo.generator.cpp.utils.Headers;
import fr.esrf.tango.pogo.generator.cpp.utils.InheritanceUtils;
import fr.esrf.tango.pogo.generator.cpp.utils.Pipes;
import fr.esrf.tango.pogo.generator.cpp.utils.Properties;
import fr.esrf.tango.pogo.generator.cpp.utils.ProtectedArea;
import fr.esrf.tango.pogo.pogoDsl.Attribute;
import fr.esrf.tango.pogo.pogoDsl.Command;
import fr.esrf.tango.pogo.pogoDsl.ForwardedAttribute;
import fr.esrf.tango.pogo.pogoDsl.Pipe;
import fr.esrf.tango.pogo.pogoDsl.PogoDeviceClass;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;

public class DeviceClassInclude {
    @Inject
    @Extension
    private ProtectedArea _protectedArea;
    @Inject
    @Extension
    private Headers _headers;
    @Inject
    @Extension
    private Commands _commands;
    @Inject
    @Extension
    private Attributes _attributes;
    @Inject
    @Extension
    private Pipes _pipes;
    @Inject
    @Extension
    private Properties _properties;
    @Inject
    @Extension
    private InheritanceUtils _inheritanceUtils;

    public CharSequence generateDeviceClassIncludeFile(PogoDeviceClass cls) {
        EList<Command> _dynamicCommands;
        int _size_5;
        boolean _greaterThan_5;
        EList<Command> _commands;
        int _size_4;
        boolean _greaterThan_4;
        EList<Pipe> _pipes;
        int _size_3;
        boolean _greaterThan_3;
        EList<ForwardedAttribute> _forwardedAttributes;
        int _size_2;
        boolean _greaterThan_2;
        EList<Attribute> _dynamicAttributes;
        int _size_1;
        boolean _greaterThan_1;
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _fileHeader = this.fileHeader(cls);
        _builder.append((Object)_fileHeader, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.newLine();
        _builder.append("namespace ");
        String _name = cls.getName();
        _builder.append((Object)_name, "");
        _builder.append("_ns");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        String _protectedAreaClass = this._protectedArea.protectedAreaClass(cls, "classes for dynamic creation", "", false);
        _builder.append((Object)_protectedAreaClass, "");
        _builder.newLineIfNotEmpty();
        EList<Attribute> _attributes = cls.getAttributes();
        int _size = _attributes.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            _builder.newLine();
            _builder.append("//=========================================");
            _builder.newLine();
            _builder.append("//\tDefine classes for attributes");
            _builder.newLine();
            _builder.append("//=========================================");
            _builder.newLine();
            CharSequence _attributeClasses = this.attributeClasses(cls);
            _builder.append((Object)_attributeClasses, "");
            _builder.newLineIfNotEmpty();
        }
        boolean bl2 = _greaterThan_1 = (_size_1 = (_dynamicAttributes = cls.getDynamicAttributes()).size()) > 0;
        if (_greaterThan_1) {
            _builder.newLine();
            _builder.append("//=========================================");
            _builder.newLine();
            _builder.append("//\tDefine classes for dynamic attributes");
            _builder.newLine();
            _builder.append("//=========================================");
            _builder.newLine();
            CharSequence _dynamicAttributeClasses = this.dynamicAttributeClasses(cls);
            _builder.append((Object)_dynamicAttributeClasses, "");
            _builder.newLineIfNotEmpty();
        }
        boolean bl3 = _greaterThan_2 = (_size_2 = (_forwardedAttributes = cls.getForwardedAttributes()).size()) > 0;
        if (_greaterThan_2) {
            _builder.newLine();
            _builder.append("//=========================================");
            _builder.newLine();
            _builder.append("//\tDefine classes for forwarded attributes");
            _builder.newLine();
            _builder.append("//=========================================");
            _builder.newLine();
            CharSequence _forwardedAttributeClasses = this.forwardedAttributeClasses(cls);
            _builder.append((Object)_forwardedAttributeClasses, "");
            _builder.newLineIfNotEmpty();
        }
        boolean bl4 = _greaterThan_3 = (_size_3 = (_pipes = cls.getPipes()).size()) > 0;
        if (_greaterThan_3) {
            _builder.newLine();
            _builder.append("//=========================================");
            _builder.newLine();
            _builder.append("//\tDefine classes for pipes");
            _builder.newLine();
            _builder.append("//=========================================");
            _builder.newLine();
            CharSequence _pipeClasses = this.pipeClasses(cls);
            _builder.append((Object)_pipeClasses, "");
            _builder.newLineIfNotEmpty();
        }
        boolean bl5 = _greaterThan_4 = (_size_4 = (_commands = cls.getCommands()).size()) > 2;
        if (_greaterThan_4) {
            _builder.newLine();
            _builder.append("//=========================================");
            _builder.newLine();
            _builder.append("//\tDefine classes for commands");
            _builder.newLine();
            _builder.append("//=========================================");
            _builder.newLine();
            CharSequence _commandClasses = this.commandClasses(cls);
            _builder.append((Object)_commandClasses, "");
            _builder.newLineIfNotEmpty();
        }
        boolean bl6 = _greaterThan_5 = (_size_5 = (_dynamicCommands = cls.getDynamicCommands()).size()) > 0;
        if (_greaterThan_5) {
            _builder.newLine();
            _builder.append("//=========================================");
            _builder.newLine();
            _builder.append("//\tDefine classes for dynamic commands");
            _builder.newLine();
            _builder.append("//=========================================");
            _builder.newLine();
            CharSequence _dynamicCommandClasses = this.dynamicCommandClasses(cls);
            _builder.append((Object)_dynamicCommandClasses, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*\tThe ");
        String _name_1 = cls.getName();
        _builder.append((Object)_name_1, " ");
        _builder.append("Class singleton definition");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#ifdef _TG_WINDOWS_");
        _builder.newLine();
        _builder.append("class __declspec(dllexport)  ");
        String _name_2 = cls.getName();
        _builder.append((Object)_name_2, "");
        _builder.append("Class : public ");
        String _inheritedClassNameForDeviceClass = this._inheritanceUtils.inheritedClassNameForDeviceClass(cls);
        _builder.append((Object)_inheritedClassNameForDeviceClass, "");
        _builder.newLineIfNotEmpty();
        _builder.append("#else");
        _builder.newLine();
        _builder.append("class ");
        String _name_3 = cls.getName();
        _builder.append((Object)_name_3, "");
        _builder.append("Class : public ");
        String _inheritedClassNameForDeviceClass_1 = this._inheritanceUtils.inheritedClassNameForDeviceClass(cls);
        _builder.append((Object)_inheritedClassNameForDeviceClass_1, "");
        _builder.newLineIfNotEmpty();
        _builder.append("#endif");
        _builder.newLine();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        String _protectedAreaClass_1 = this._protectedArea.protectedAreaClass(cls, "Additionnal DServer data members", "", false);
        _builder.append((Object)_protectedAreaClass_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _classPropertyDeclarations = this._properties.classPropertyDeclarations(cls);
        _builder.append((Object)_classPropertyDeclarations, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _publicMethodPrototypes = this.publicMethodPrototypes(cls);
        _builder.append((Object)_publicMethodPrototypes, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _protectedMethodPrototypes = this.protectedMethodPrototypes(cls);
        _builder.append((Object)_protectedMethodPrototypes, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _privateMethodPrototypes = this.privateMethodPrototypes(cls);
        _builder.append((Object)_privateMethodPrototypes, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("};");
        _builder.newLine();
        _builder.newLine();
        _builder.append("}\t//\tEnd of namespace");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#endif   //\t");
        String _name_4 = cls.getName();
        _builder.append((Object)_name_4, "");
        _builder.append("_H");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence fileHeader(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        String _deviceClassIncludeFileHeader = this._headers.deviceClassIncludeFileHeader(cls);
        String _plus = String.valueOf(_deviceClassIncludeFileHeader) + "\n\n";
        String _plus_1 = String.valueOf(_plus) + "#ifndef ";
        String _name = cls.getName();
        String _plus_2 = String.valueOf(_plus_1) + _name;
        String _plus_3 = String.valueOf(_plus_2) + "Class_H\n";
        String _plus_4 = String.valueOf(_plus_3) + "#define ";
        String _name_1 = cls.getName();
        String _plus_5 = String.valueOf(_plus_4) + _name_1;
        String _plus_6 = String.valueOf(_plus_5) + "Class_H\n\n";
        String _plus_7 = String.valueOf(_plus_6) + "#include <tango.h>\n";
        String _inheritanceIncludeList = this._inheritanceUtils.inheritanceIncludeList(cls, true);
        String _plus_8 = String.valueOf(_plus_7) + _inheritanceIncludeList;
        String _plus_9 = String.valueOf(_plus_8) + "#include <";
        String _name_2 = cls.getName();
        String _plus_10 = String.valueOf(_plus_9) + _name_2;
        String _plus_11 = String.valueOf(_plus_10) + ".h>\n";
        String _protectedAreaClass = this._protectedArea.protectedAreaClass(cls, ".h", _plus_11, false);
        _builder.append((Object)_protectedAreaClass, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence attributeClasses(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        EList<Attribute> _attributes = cls.getAttributes();
        for (Attribute attribute : _attributes) {
            boolean _isConcreteHere = this._inheritanceUtils.isConcreteHere(attribute);
            if (!_isConcreteHere) continue;
            CharSequence _attributeClass = this._attributes.attributeClass(cls, attribute, false);
            _builder.append((Object)_attributeClass, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence dynamicAttributeClasses(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        EList<Attribute> _dynamicAttributes = cls.getDynamicAttributes();
        for (Attribute attribute : _dynamicAttributes) {
            CharSequence _attributeClass = this._attributes.attributeClass(cls, attribute, true);
            _builder.append((Object)_attributeClass, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence forwardedAttributeClasses(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        EList<ForwardedAttribute> _forwardedAttributes = cls.getForwardedAttributes();
        for (ForwardedAttribute attribute : _forwardedAttributes) {
            CharSequence _forwardedAttributeClass = this._attributes.forwardedAttributeClass(attribute);
            _builder.append((Object)_forwardedAttributeClass, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence pipeClasses(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        EList<Pipe> _pipes = cls.getPipes();
        for (Pipe pipe : _pipes) {
            String _name = cls.getName();
            CharSequence _pipeClass = this._pipes.pipeClass(pipe, _name);
            _builder.append((Object)_pipeClass, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence commandClasses(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        EList<Command> _commands = cls.getCommands();
        for (Command command : _commands) {
            String _name_1;
            boolean _equals_2;
            boolean _equals_3;
            boolean _equals_1;
            boolean _isConcreteHere = this._inheritanceUtils.isConcreteHere(command);
            if (!_isConcreteHere) continue;
            boolean _and = false;
            String _name = command.getName();
            boolean _equals = _name.equals("State");
            boolean bl = _equals_1 = !_equals;
            _and = !_equals_1 ? false : (_equals_3 = !(_equals_2 = (_name_1 = command.getName()).equals("Status")));
            if (!_and) continue;
            CharSequence _commandClass = this._commands.commandClass(cls, command);
            _builder.append((Object)_commandClass, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence dynamicCommandClasses(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        EList<Command> _dynamicCommands = cls.getDynamicCommands();
        for (Command command : _dynamicCommands) {
            CharSequence _commandClass = this._commands.commandClass(cls, command);
            _builder.append((Object)_commandClass, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence publicMethodPrototypes(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("//\tMethod prototypes");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("static ");
        String _name = cls.getName();
        _builder.append((Object)_name, "\t");
        _builder.append("Class *init(const char *);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("static ");
        String _name_1 = cls.getName();
        _builder.append((Object)_name_1, "\t");
        _builder.append("Class *instance();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("~");
        String _name_2 = cls.getName();
        _builder.append((Object)_name_2, "\t");
        _builder.append("Class();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("Tango::DbDatum\tget_class_property(string &);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("Tango::DbDatum\tget_default_device_property(string &);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("Tango::DbDatum\tget_default_class_property(string &);");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }

    public CharSequence protectedMethodPrototypes(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("protected:");
        _builder.newLine();
        _builder.append("\t");
        String _name = cls.getName();
        _builder.append((Object)_name, "\t");
        _builder.append("Class(string &);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("static ");
        String _name_1 = cls.getName();
        _builder.append((Object)_name_1, "\t");
        _builder.append("Class *_instance;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("void command_factory();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("void attribute_factory(vector<Tango::Attr *> &);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("void pipe_factory();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("void write_class_property();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("void set_default_property();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("void get_class_property();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("string get_cvstag();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("string get_cvsroot();");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }

    public CharSequence privateMethodPrototypes(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("private:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("void device_factory(const Tango::DevVarStringArray *);");
        _builder.newLine();
        boolean _isConcreteClass = this._inheritanceUtils.isConcreteClass(cls);
        if (_isConcreteClass) {
            _builder.append("\t");
            _builder.append("void create_static_attribute_list(vector<Tango::Attr *> &);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("void erase_dynamic_attributes(const Tango::DevVarStringArray *,vector<Tango::Attr *> &);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("vector<string>\tdefaultAttList;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("Tango::Attr *get_attr_object_by_name(vector<Tango::Attr *> &att_list, string attname);");
            _builder.newLine();
        }
        return _builder;
    }
}

