/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tango.pogo.generator;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.eclipse.emf.mwe2.launch.runtime.Mwe2Launcher;

public class PogoGeneratorMain {
    private static final String WORKFLOW_MODULE = "fr.esrf.tango.pogo.generator.PogoDslGeneratorMWE";
    private static final String TYPE_CPP = "cpp";
    private static final String TYPE_JAVA = "java";
    private static final String TYPE_PYTHON = "python";
    private static final String TYPE_PYTHON_HL = "pythonHL";
    private static final String OPT_LANGUAGE = "language";

    public static void main(String[] args) {
        int retval = new PogoGeneratorMain().run(args);
        if (retval != 0) {
            System.exit(retval);
        }
    }

    protected int run(String[] args) {
        Options options = new Options();
        OptionBuilder.withArgName("path");
        OptionBuilder.withDescription("Model source directory");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        OptionBuilder.withValueSeparator(' ');
        Option optSrcDir = OptionBuilder.create("srcdir");
        OptionBuilder.withArgName("path");
        OptionBuilder.withDescription("Generator target directory (default: ./src-gen)");
        OptionBuilder.hasArg();
        Option optTargetDir = OptionBuilder.create("targetdir");
        OptionBuilder.withArgName(OPT_LANGUAGE);
        OptionBuilder.withDescription("Specify target languages (cpp, java, python, pythonHL)");
        OptionBuilder.hasArg();
        Option optFileTypes = OptionBuilder.create(OPT_LANGUAGE);
        options.addOption(optSrcDir);
        options.addOption(optTargetDir);
        options.addOption(optFileTypes);
        GnuParser parser = new GnuParser();
        CommandLine line = null;
        try {
            line = parser.parse(options, args);
        }
        catch (ParseException exp) {
            System.out.println(exp.getMessage());
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("java -jar pogogen.jar [OPTIONS]", options);
            return -1;
        }
        ArrayList<String> launchArgs = Lists.newArrayList();
        launchArgs.add(WORKFLOW_MODULE);
        launchArgs.add("-pmodelPath=" + line.getOptionValue("srcdir"));
        launchArgs.add("-ptargetDir=" + line.getOptionValue("targetdir", "./src-gen"));
        if (line.hasOption(OPT_LANGUAGE)) {
            HashSet<String> languages = Sets.newHashSet(line.getOptionValue(OPT_LANGUAGE).split(","));
            if (languages.contains(TYPE_CPP)) {
                launchArgs.add("-pgenerateCpp=true");
            }
            if (languages.contains(TYPE_JAVA)) {
                launchArgs.add("-pgenerateJava=true");
            }
            if (languages.contains(TYPE_PYTHON)) {
                launchArgs.add("-pgeneratePython=true");
            }
            if (languages.contains(TYPE_PYTHON_HL)) {
                launchArgs.add("-pgeneratePythonHL=true");
            }
        }
        try {
            Mwe2Launcher.main(launchArgs.toArray(new String[0]));
            return 0;
        }
        catch (Exception e) {
            return -1;
        }
    }
}

