/*
 * Decompiled with CFR 0.152.
 */
package pogo.appli;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import pogo.appli.PogoAppli;
import pogo.appli.PogoAppliDefs;
import pogo.appli.PogoFileFilter;
import pogo.gene.PogoDefs;

public class PrefGeneDialog
extends JDialog
implements PogoAppliDefs,
PogoDefs {
    private static int returnStatus = 0;
    private JPanel jPanel1;
    private JButton okBtn;
    private JButton cancelBtn;
    private JPanel jPanel;
    private JLabel nameLbl;
    private JLabel jLabel5;
    private JTextField outPathText;
    private JButton jButton1;
    private JLabel jLabel2;
    private JRadioButton asAbstractClassBtn;
    private JRadioButton asDeviceServerBtn;

    public PrefGeneDialog(JFrame parent, int lang) {
        super((Frame)parent, true);
        this.initComponents();
        if (lang == 0) {
            this.asAbstractClassBtn.setVisible(false);
            this.asDeviceServerBtn.setVisible(false);
        }
        this.pack();
        PogoAppli.centerDialog(this, parent);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.okBtn = new JButton();
        this.cancelBtn = new JButton();
        this.jPanel = new JPanel();
        this.nameLbl = new JLabel();
        this.jLabel5 = new JLabel();
        this.outPathText = new JTextField();
        this.jButton1 = new JButton();
        this.jLabel2 = new JLabel();
        this.asAbstractClassBtn = new JRadioButton();
        this.asDeviceServerBtn = new JRadioButton();
        this.setTitle("Generation Preference  Window");
        this.setBackground(new Color(198, 178, 168));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PrefGeneDialog.this.closeDialog(evt);
            }
        });
        this.jPanel1.setLayout(new FlowLayout(2));
        this.okBtn.setText("OK");
        this.okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrefGeneDialog.this.okBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.okBtn);
        this.cancelBtn.setText("Cancel");
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrefGeneDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.cancelBtn);
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel.setLayout(new GridBagLayout());
        this.nameLbl.setFont(new Font("Arial", 1, 12));
        this.nameLbl.setText("  Output Path:    ");
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        this.jPanel.add((Component)this.nameLbl, gridBagConstraints1);
        this.jLabel5.setText("    ");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 5;
        this.jPanel.add((Component)this.jLabel5, gridBagConstraints1);
        this.outPathText.setMinimumSize(new Dimension(450, 25));
        this.outPathText.setPreferredSize(new Dimension(450, 25));
        this.outPathText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrefGeneDialog.this.okBtnActionPerformed(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.gridy = 0;
        this.jPanel.add((Component)this.outPathText, gridBagConstraints1);
        this.jButton1.setText("Browse");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrefGeneDialog.this.browsActionPerformed(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 3;
        gridBagConstraints1.gridy = 0;
        this.jPanel.add((Component)this.jButton1, gridBagConstraints1);
        this.jLabel2.setText("    ");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        this.jPanel.add((Component)this.jLabel2, gridBagConstraints1);
        this.asAbstractClassBtn.setText("As a Abstract Class");
        this.asAbstractClassBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrefGeneDialog.this.asAbstractClassBtnActionPerformed(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridy = 3;
        gridBagConstraints1.fill = 2;
        this.jPanel.add((Component)this.asAbstractClassBtn, gridBagConstraints1);
        this.asDeviceServerBtn.setText("As a Device Server");
        this.asDeviceServerBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrefGeneDialog.this.asDeviceServerBtnActionPerformed(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 4;
        gridBagConstraints1.fill = 2;
        this.jPanel.add((Component)this.asDeviceServerBtn, gridBagConstraints1);
        this.getContentPane().add((Component)this.jPanel, "North");
    }

    private void asDeviceServerBtnActionPerformed(ActionEvent evt) {
        this.asAbstractClassBtn.setSelected(false);
        this.asDeviceServerBtn.setSelected(true);
    }

    private void asAbstractClassBtnActionPerformed(ActionEvent evt) {
        this.asAbstractClassBtn.setSelected(true);
        this.asDeviceServerBtn.setSelected(false);
    }

    private void browsActionPerformed(ActionEvent evt) {
        File file;
        JFileChooser chooser = new JFileChooser(this.outPathText.getText());
        chooser.addChoosableFileFilter(new PogoFileFilter("", "Directory"));
        chooser.setFileSelectionMode(1);
        int retval = chooser.showDialog(this, "Target Dir.");
        if (retval == 0 && (file = chooser.getSelectedFile()) != null && file.isDirectory()) {
            this.outPathText.setText(file.getAbsolutePath().toString());
        }
        this.outPathText.requestFocus();
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose(0);
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        String path = new String(this.outPathText.getText());
        File file = new File(path);
        if (file.exists()) {
            if (file.isDirectory()) {
                this.doClose(1);
            } else {
                JOptionPane.showMessageDialog(this, new String(path + " is not a directory !"), "Error Window", 0);
            }
        } else if (JOptionPane.showConfirmDialog(this, new String(path + " Does not exists !\n\n" + "   Would you like to create it ? "), "Error Window", 0) == 0) {
            try {
                if (!file.mkdir()) {
                    JOptionPane.showMessageDialog(this, new String("Cannot create: " + path), "Error Window", 0);
                } else {
                    System.out.println(path + " created");
                    this.doClose(1);
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, new String("Cannot create: " + path + "\n" + e), "Error Window", 0);
            }
        }
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    public int showDialog(String path, boolean is_abstractclass) {
        if (is_abstractclass) {
            this.asAbstractClassBtn.setSelected(true);
            this.asDeviceServerBtn.setSelected(false);
        } else {
            this.asAbstractClassBtn.setSelected(false);
            this.asDeviceServerBtn.setSelected(true);
        }
        this.outPathText.setText(path);
        this.outPathText.setRequestFocusEnabled(true);
        this.outPathText.requestFocus();
        this.setVisible(true);
        return returnStatus;
    }

    private void doClose(int retStatus) {
        returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }

    public String getOutputPath() {
        return new String(this.outPathText.getText());
    }

    public boolean getOutputModel() {
        return this.asAbstractClassBtn.getSelectedObjects() != null;
    }

    public static void main(String[] args) {
        new PrefGeneDialog(new JFrame(), 0).setVisible(true);
    }
}

