/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui.tools;

import java.io.File;
import java.util.ArrayList;
import javax.swing.filechooser.FileFilter;
import org.tango.pogo.pogo_gui.tools.ParserTool;
import org.tango.pogo.pogo_gui.tools.PogoException;

public class PogoFileFilter
extends FileFilter {
    private ArrayList<String> filters = new ArrayList();
    private String description = null;
    private String fullDescription = null;
    private boolean useExtensionsInDescription = true;
    public static final String[] cpp_target = new String[]{"Inherited from class ", ": public Tango::Device_4Impl", ": public Tango::Device_3Impl", ": public Tango::Device_2Impl", ": public Tango::DeviceImpl"};
    public static final String[] java_target = new String[]{" extends DeviceImpl"};
    public static final String[] py_target = new String[]{"(PyTango.Device_4Impl):", "(PyTango.Device_3Impl):"};

    public PogoFileFilter() {
    }

    public PogoFileFilter(String extension, String description) {
        this();
        if (extension != null) {
            this.addExtension(extension);
        }
        if (description != null) {
            this.setDescription(description);
        }
    }

    public PogoFileFilter(String[] filters, String description) {
        this();
        String[] stringArray = filters;
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            String filter = stringArray[n2];
            this.addExtension(filter);
            ++n2;
        }
        if (description != null) {
            this.setDescription(description);
        }
    }

    @Override
    public boolean accept(File f) {
        if (f != null) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = PogoFileFilter.getExtension(f);
            if (extension != null) {
                for (String filter : this.filters) {
                    if (!filter.equals(extension)) continue;
                    if (this.getDescription().toLowerCase().startsWith("pogo-6")) {
                        return PogoFileFilter.isDeviceImplClass(f.toString());
                    }
                    if (this.getDescription().toLowerCase().startsWith("additional")) {
                        boolean generated = this.isPogoGeneratedFile(f.toString());
                        return !generated;
                    }
                    if (this.getDescription().toLowerCase().startsWith("multi classes")) {
                        return this.isMultiClassXmi(f.toString());
                    }
                    return !this.isMultiClassXmi(f.toString());
                }
            }
        }
        return false;
    }

    public static String getExtension(File f) {
        if (f != null) {
            String filename = f.getName();
            return PogoFileFilter.getExtension(filename);
        }
        return null;
    }

    public static String getExtension(String filename) {
        int i;
        if (filename != null && (i = filename.lastIndexOf(46)) > 0 && i < filename.length() - 1) {
            return filename.substring(i + 1).toLowerCase();
        }
        return null;
    }

    public void addExtension(String extension) {
        this.filters.add(extension.toLowerCase());
        this.fullDescription = null;
    }

    @Override
    public String getDescription() {
        if (this.fullDescription == null) {
            if (this.description == null || this.isExtensionListInDescription()) {
                this.fullDescription = this.description == null ? "" : String.valueOf(this.description) + "  (";
                int i = 0;
                while (i < this.filters.size()) {
                    this.fullDescription = String.valueOf(this.fullDescription) + "*." + this.filters.get(i);
                    if (i < this.filters.size() - 1) {
                        this.fullDescription = String.valueOf(this.fullDescription) + ", ";
                    }
                    ++i;
                }
                this.fullDescription = String.valueOf(this.fullDescription) + ")";
            } else {
                this.fullDescription = this.description;
            }
        }
        return this.fullDescription;
    }

    public void setDescription(String description) {
        this.description = description;
        this.fullDescription = null;
    }

    public void setExtensionListInDescription(boolean b) {
        this.useExtensionsInDescription = b;
        this.fullDescription = null;
    }

    public boolean isExtensionListInDescription() {
        return this.useExtensionsInDescription;
    }

    private boolean isPogoGeneratedFile(String fileName) {
        String code;
        try {
            code = ParserTool.readFile(fileName);
        }
        catch (PogoException e) {
            return false;
        }
        return code.contains("PROTECTED REGION ID");
    }

    private boolean isMultiClassXmi(String filename) {
        return filename.endsWith(".multi.xmi");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isDeviceImplClass(String filename) {
        try {
            String readcode = ParserTool.readFile(filename);
            if (readcode.startsWith("/*----- PROTECTED REGION ID")) {
                return false;
            }
            String[] stringArray = cpp_target;
            int n = cpp_target.length;
            int n2 = 0;
            while (n2 < n) {
                String aCpp_target = stringArray[n2];
                if (readcode.indexOf(aCpp_target) > 0) {
                    return true;
                }
                ++n2;
            }
            stringArray = java_target;
            n = java_target.length;
            n2 = 0;
            while (n2 < n) {
                String aJava_target = stringArray[n2];
                if (readcode.indexOf(aJava_target) > 0) {
                    return true;
                }
                ++n2;
            }
            stringArray = py_target;
            n = py_target.length;
            n2 = 0;
            while (n2 < n) {
                String aPy_target = stringArray[n2];
                if (readcode.indexOf(aPy_target) > 0) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

