/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui.tools;

import com.google.inject.Injector;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.tango.pogo.pogoDsl.AdditionalFile;
import fr.esrf.tango.pogo.pogoDsl.Argument;
import fr.esrf.tango.pogo.pogoDsl.AttrProperties;
import fr.esrf.tango.pogo.pogoDsl.Attribute;
import fr.esrf.tango.pogo.pogoDsl.ClassDescription;
import fr.esrf.tango.pogo.pogoDsl.ClassIdentification;
import fr.esrf.tango.pogo.pogoDsl.Command;
import fr.esrf.tango.pogo.pogoDsl.EventCriteria;
import fr.esrf.tango.pogo.pogoDsl.FireEvents;
import fr.esrf.tango.pogo.pogoDsl.ForwardedAttribute;
import fr.esrf.tango.pogo.pogoDsl.InheritanceStatus;
import fr.esrf.tango.pogo.pogoDsl.OneClassSimpleDef;
import fr.esrf.tango.pogo.pogoDsl.Pipe;
import fr.esrf.tango.pogo.pogoDsl.PogoDeviceClass;
import fr.esrf.tango.pogo.pogoDsl.PogoDslFactory;
import fr.esrf.tango.pogo.pogoDsl.PogoDslPackage;
import fr.esrf.tango.pogo.pogoDsl.PogoMultiClasses;
import fr.esrf.tango.pogo.pogoDsl.PogoSystem;
import fr.esrf.tango.pogo.pogoDsl.Preferences;
import fr.esrf.tango.pogo.pogoDsl.PropType;
import fr.esrf.tango.pogo.pogoDsl.Property;
import fr.esrf.tango.pogo.pogoDsl.State;
import fr.esrf.tango.pogo.pogoDsl.Type;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.mwe2.language.Mwe2StandaloneSetup;
import org.eclipse.emf.mwe2.launch.runtime.Mwe2Runner;
import org.tango.pogo.pogo_gui.PropertyDialog;
import org.tango.pogo.pogo_gui.tools.ParserTool;
import org.tango.pogo.pogo_gui.tools.PogoException;
import org.tango.pogo.pogo_gui.tools.PogoProperty;
import org.tango.pogo.pogo_gui.tools.Utils;

public class OAWutils {
    private static OAWutils instance = null;
    private static String backend = "/fr/esrf/tango/pogo/generator/PogoDslGeneratorMWE.mwe2";
    public static PogoDslPackage dp = PogoDslPackage.eINSTANCE;
    public static PogoDslFactory factory = PogoDslFactory.eINSTANCE;

    private OAWutils() {
        System.setProperty("file.encoding", "ISO-8859-1");
        String str = System.getenv("backend");
        if (str != null) {
            backend = str;
        }
        System.out.println("backend=" + backend);
    }

    public static OAWutils getInstance() {
        if (instance == null) {
            instance = new OAWutils();
        }
        return instance;
    }

    public PogoMultiClasses loadMultiClassesModel(String xmiFile) throws PogoException {
        Object pogoObj = this.loadTheModel(xmiFile);
        if (!(pogoObj instanceof PogoMultiClasses)) {
            throw new PogoException("This is not a Pogo Multi Classes file !");
        }
        PogoMultiClasses pmc = (PogoMultiClasses)pogoObj;
        this.reverseClassOrder(pmc);
        this.setProjectPath(pmc, xmiFile);
        return pmc;
    }

    private void setProjectPath(PogoMultiClasses pmc, String fileName) {
        if (fileName.endsWith(".xmi")) {
            String path = Utils.getPath(fileName);
            pmc.setSourcePath(path);
        }
    }

    public PogoDeviceClass loadDeviceClassModel(String xmiFile) throws PogoException {
        return this.loadDeviceClassModel(xmiFile, true);
    }

    public PogoDeviceClass loadDeviceClassModel(String xmiFile, boolean checkVersion) throws PogoException {
        Object pogoObj;
        if (checkVersion) {
            ParserTool.renameXmiKey("<inheritance ", "<inheritances ", xmiFile);
        }
        if (!((pogoObj = this.loadTheModel(xmiFile)) instanceof PogoDeviceClass)) {
            throw new PogoException("This is not a Pogo Device Class file !");
        }
        return (PogoDeviceClass)pogoObj;
    }

    private Object loadTheModel(String xmiFileName) throws PogoException {
        ParserTool.removeXmiKey("htmlInheritance", xmiFileName);
        System.out.println("Loading " + xmiFileName);
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        URI fileURI = URI.createFileURI(new File(xmiFileName).getAbsolutePath());
        Resource resource = new ResourceSetImpl().createResource(fileURI);
        try {
            resource.load(null);
        }
        catch (IOException e) {
            throw new PogoException(e.toString());
        }
        PogoSystem sys = (PogoSystem)resource.getContents().get(0);
        if (sys.getMultiClasses().size() > 0) {
            return sys.getMultiClasses().get(0);
        }
        return sys.getClasses().get(0);
    }

    private String generateXmiFile(PogoDeviceClass pogoClass) throws PogoException {
        if (pogoClass.getDescription().getIdentification() == null) {
            pogoClass.getDescription().setIdentification(factory.createClassIdentification());
        }
        PogoSystem sys = this.buildPogoSystem(pogoClass);
        pogoClass.setPogoRevision(Double.toString(Utils.getPogoGuiRevision()));
        String xmiFileName = String.valueOf(pogoClass.getDescription().getSourcePath()) + "/" + pogoClass.getName() + ".xmi";
        if (!Utils.osIsUnix()) {
            xmiFileName = "//" + xmiFileName;
        }
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        URI fileURI = URI.createFileURI(new File(xmiFileName).getAbsolutePath());
        Resource resource = resourceSet.createResource(fileURI);
        resource.getContents().add(sys);
        try {
            resource.save(Collections.EMPTY_MAP);
            System.out.println(String.valueOf(xmiFileName) + " generated");
        }
        catch (IOException e) {
            throw new PogoException(e.toString());
        }
        return xmiFileName;
    }

    public void generate(PogoDeviceClass pogoClass) throws PogoException {
        String xmiFileName = this.generateXmiFile(pogoClass);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("targetDir", pogoClass.getDescription().getSourcePath());
        params.put("targetLanguage", pogoClass.getDescription().getLanguage());
        params.put("modelPath", xmiFileName);
        System.setProperty("targetDir", pogoClass.getDescription().getSourcePath());
        System.setProperty("className", pogoClass.getName());
        System.setProperty("targetLanguage", this.generateCodeFiles(pogoClass.getDescription()) ? pogoClass.getDescription().getLanguage() : "");
        System.setProperty("pythonProj", pogoClass.getDescription().getFilestogenerate().contains("PyHL Project") ? "true" : "false");
        Utils.manageHtmlDirectory(pogoClass, true);
        try {
            System.out.println("Running Workflow for " + pogoClass.getDescription().getFilestogenerate() + "\tfrom:\n" + xmiFileName);
            this.runWorkflow(params);
        }
        catch (PogoException e) {
            Utils.manageHtmlDirectory(pogoClass, false);
            throw e;
        }
        Utils.manageHtmlDirectory(pogoClass, false);
        if (pogoClass.getDescription().getFilestogenerate().contains("VC")) {
            ParserTool.manageWindowsProjects(pogoClass);
        }
    }

    private boolean generateCodeFiles(ClassDescription classDescription) {
        String str = classDescription.getFilestogenerate().toLowerCase();
        return str.contains("code files");
    }

    public void generate(PogoMultiClasses multiClasses) throws PogoException {
        PogoSystem sys = factory.createPogoSystem();
        this.reverseClassOrder(multiClasses);
        sys.getMultiClasses().add(multiClasses);
        multiClasses.setPogoRevision(Double.toString(Utils.getPogoGuiRevision()));
        String xmiFileName = String.valueOf(multiClasses.getSourcePath()) + "/" + multiClasses.getName() + ".multi.xmi";
        if (!Utils.osIsUnix()) {
            xmiFileName = "//" + xmiFileName;
        }
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        URI fileURI = URI.createFileURI(new File(xmiFileName).getAbsolutePath());
        Resource resource = resourceSet.createResource(fileURI);
        resource.getContents().add(sys);
        try {
            resource.save(Collections.EMPTY_MAP);
            System.out.println(String.valueOf(xmiFileName) + " generated");
        }
        catch (IOException e) {
            throw new PogoException(e.toString());
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("targetDir", multiClasses.getSourcePath());
        params.put("targetLanguage", "MultiCpp");
        params.put("modelPath", xmiFileName);
        System.setProperty("targetDir", multiClasses.getSourcePath());
        System.setProperty("targetLanguage", "MultiCpp");
        this.runWorkflow(params);
    }

    public void runWorkflow(HashMap<String, String> params) throws PogoException {
        try {
            URL url = this.getClass().getResource(backend);
            URI uri = URI.createURI(url.toString());
            long t0 = System.currentTimeMillis();
            Injector injector = new Mwe2StandaloneSetup().createInjectorAndDoEMFRegistration();
            Mwe2Runner runner = injector.getInstance(Mwe2Runner.class);
            runner.run(uri, params);
            long t1 = System.currentTimeMillis();
            System.out.println("elapsed time : " + (t1 - t0) + " ms");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PogoException(e.toString());
        }
    }

    private void doPreProcessing(PogoDeviceClass pogoClass) throws PogoException {
        String institute = System.getenv("INSTITUTE");
        if (institute == null) {
            institute = System.getProperty("INSTITUTE");
        }
        if (institute != null) {
            pogoClass.setInstitute(institute.toUpperCase());
        }
        Preferences pref = factory.createPreferences();
        pref.setMakefileHome(PogoProperty.makefileHome);
        pref.setDocHome(PogoProperty.docHome);
        pogoClass.setPreferences(pref);
        if (pogoClass.getDescription().getFilestogenerate().toLowerCase().contains("code") && pogoClass.getDescription().getLanguage().toLowerCase().equals("cpp")) {
            ParserTool.modifyProtectedAreaID(pogoClass.getDescription().getSourcePath(), "ClassFactory.cpp", "ClassFactory.cpp", String.valueOf(pogoClass.getName()) + "::ClassFactory.cpp");
            new ParserTool().convertForXTendCompatibility(pogoClass, true);
        }
        if (pogoClass.getDescription().getFilestogenerate().contains("html")) {
            String filename = String.valueOf(pogoClass.getDescription().getSourcePath()) + "/" + pogoClass.getPreferences().getDocHome() + "/Description.html";
            pogoClass.getDescription().setDescriptionHtmlExists(Utils.strBoolean(new File(filename).exists()));
        }
        EList<Property> properties = pogoClass.getDeviceProperties();
        boolean hasMandatory = false;
        boolean hasConcrete = false;
        for (Property property : properties) {
            if (Utils.isTrue(property.getMandatory())) {
                hasMandatory = true;
            }
            if (!Utils.isFalse(property.getStatus().getInherited())) continue;
            hasConcrete = true;
        }
        pogoClass.getDescription().setHasMandatoryProperty(Utils.strBoolean(hasMandatory));
        pogoClass.getDescription().setHasConcreteProperty(Utils.strBoolean(hasConcrete));
    }

    public static Command[] createStateStatusCommand() {
        Command[] commands = new Command[2];
        int i = 0;
        while (i < 2) {
            String argout_desc;
            String argout_str;
            String desc;
            String name;
            if (i == 0) {
                name = "State";
                desc = "This command gets the device state (stored in its device_state data member) and returns it to the caller.";
                argout_str = "State";
                argout_desc = "Device state";
            } else {
                name = "Status";
                desc = "This command gets the device status (stored in its device_status data member) and returns it to the caller.";
                argout_str = "ConstDevString";
                argout_desc = "Device status";
            }
            Command cmd = factory.createCommand();
            cmd.setName(name);
            cmd.setExecMethod(Utils.buildCppExecuteMethodName(name));
            cmd.setDescription(desc);
            Argument argin = factory.createArgument();
            Argument argout = factory.createArgument();
            Type arginType = OAWutils.tango2pogoType("DevVoid");
            Type argoutType = OAWutils.tango2pogoType(argout_str);
            argin.setType(arginType);
            argout.setType(argoutType);
            argin.setDescription("none");
            argout.setDescription(argout_desc);
            cmd.setArgin(argin);
            cmd.setArgout(argout);
            InheritanceStatus status = factory.createInheritanceStatus();
            status.setAbstract("true");
            status.setInherited("true");
            status.setConcrete("true");
            cmd.setStatus(status);
            commands[i] = cmd;
            ++i;
        }
        return commands;
    }

    public static Type createType(Type type) {
        return OAWutils.tango2pogoType(OAWutils.pogo2tangoType(type.toString()));
    }

    public static Type tango2pogoType(String tangoType) {
        if (tangoType.startsWith("Tango::")) {
            tangoType = tangoType.substring("Tango::".length());
        }
        if (tangoType.equals("void")) {
            tangoType = "DevVoid";
        }
        if (tangoType.equals("DevVoid")) {
            return factory.createVoidType();
        }
        if (tangoType.equals("DevBoolean")) {
            return factory.createBooleanType();
        }
        if (tangoType.equals("DevShort")) {
            return factory.createShortType();
        }
        if (tangoType.equals("DevLong")) {
            return factory.createIntType();
        }
        if (tangoType.equals("DevFloat")) {
            return factory.createFloatType();
        }
        if (tangoType.equals("DevDouble")) {
            return factory.createDoubleType();
        }
        if (tangoType.equals("DevUShort")) {
            return factory.createUShortType();
        }
        if (tangoType.equals("DevULong")) {
            return factory.createUIntType();
        }
        if (tangoType.equals("DevString")) {
            return factory.createStringType();
        }
        if (tangoType.equals("DevVarCharArray")) {
            return factory.createCharArrayType();
        }
        if (tangoType.equals("DevVarShortArray")) {
            return factory.createShortArrayType();
        }
        if (tangoType.equals("DevVarLongArray") || tangoType.equals("DevVarIntArray")) {
            return factory.createIntArrayType();
        }
        if (tangoType.equals("DevVarFloatArray")) {
            return factory.createFloatArrayType();
        }
        if (tangoType.equals("DevVarDoubleArray")) {
            return factory.createDoubleArrayType();
        }
        if (tangoType.equals("DevVarUShortArray")) {
            return factory.createUShortArrayType();
        }
        if (tangoType.equals("DevVarULongArray") || tangoType.equals("DevVarUIntArray")) {
            return factory.createUIntArrayType();
        }
        if (tangoType.equals("DevVarStringArray")) {
            return factory.createStringArrayType();
        }
        if (tangoType.equals("DevVarLongStringArray")) {
            return factory.createLongStringArrayType();
        }
        if (tangoType.equals("DevVarDoubleStringArray")) {
            return factory.createDoubleStringArrayType();
        }
        if (tangoType.equals("DevState") || tangoType.equals("State")) {
            return factory.createStateType();
        }
        if (tangoType.equals("ConstDevString")) {
            return factory.createConstStringType();
        }
        if (tangoType.equals("DevVarBooleanArray")) {
            return factory.createBooleanArrayType();
        }
        if (tangoType.equals("DevUChar")) {
            return factory.createUCharType();
        }
        if (tangoType.equals("DevLong64")) {
            return factory.createLongType();
        }
        if (tangoType.equals("DevULong64")) {
            return factory.createULongType();
        }
        if (tangoType.equals("DevVarLong64Array")) {
            return factory.createLongArrayType();
        }
        if (tangoType.equals("DevVarULong64Array")) {
            return factory.createULongArrayType();
        }
        if (tangoType.equals("DevInt")) {
            return factory.createIntType();
        }
        if (tangoType.equals("DevEncoded")) {
            return factory.createEncodedType();
        }
        if (tangoType.equals("DevEnum")) {
            return factory.createEnumType();
        }
        System.out.println(String.valueOf(tangoType) + " NOT FOUND !!!");
        return null;
    }

    public static String pogo2tangoType(String strPogoType) {
        String header = "fr.esrf.tango.pogo.pogoDsl.impl.";
        String footer = "TypeImpl";
        if (strPogoType.startsWith(header)) {
            String tangoType = strPogoType.substring(header.length());
            int pos = tangoType.indexOf(footer);
            if (pos > 0) {
                tangoType = tangoType.substring(0, pos);
            }
            if (tangoType.indexOf("Array") > 0) {
                if (tangoType.contains("LongString")) {
                    return "DevVarLongStringArray";
                }
                if (tangoType.contains("DoubleString")) {
                    return "DevVarDoubleStringArray";
                }
                if (tangoType.contains("ULong")) {
                    return "DevVarULong64Array";
                }
                if (tangoType.contains("Long")) {
                    return "DevVarLong64Array";
                }
                if (tangoType.contains("UInt")) {
                    return "DevVarULongArray";
                }
                if (tangoType.contains("Int")) {
                    return "DevVarLongArray";
                }
                return "DevVar" + tangoType;
            }
            if (tangoType.startsWith("Const")) {
                return TangoConst.Tango_CmdArgTypeName[20];
            }
            if (tangoType.equals("State")) {
                return tangoType;
            }
            if (tangoType.equals("Long")) {
                return "DevLong64";
            }
            if (tangoType.equals("ULong")) {
                return "DevULong64";
            }
            if (tangoType.equals("Int")) {
                return "DevLong";
            }
            if (tangoType.equals("UInt")) {
                return "DevULong";
            }
            return "Dev" + tangoType;
        }
        return "Not a Pogo Type";
    }

    private PogoSystem buildPogoSystem(PogoDeviceClass pogoClass) throws PogoException {
        PogoSystem sys = factory.createPogoSystem();
        this.doPreProcessing(pogoClass);
        sys.getClasses().add(pogoClass);
        return sys;
    }

    private void reverseClassOrder(PogoMultiClasses pmc) {
        EList<OneClassSimpleDef> classes = pmc.getClasses();
        ArrayList<OneClassSimpleDef> v = new ArrayList<OneClassSimpleDef>();
        for (OneClassSimpleDef _class : classes) {
            v.add(0, _class);
        }
        classes.clear();
        for (OneClassSimpleDef _class : v) {
            classes.add(_class);
        }
    }

    public static ClassIdentification cloneClassIdentification(ClassIdentification id) {
        ClassIdentification new_id = factory.createClassIdentification();
        new_id.setBus(id.getBus());
        new_id.setClassFamily(id.getClassFamily());
        new_id.setContact(id.getContact());
        new_id.setAuthor(id.getAuthor());
        new_id.setEmailDomain(id.getEmailDomain());
        new_id.setManufacturer(id.getManufacturer());
        new_id.setPlatform(id.getPlatform());
        new_id.setReference(id.getReference());
        new_id.setSiteSpecific(id.getSiteSpecific());
        EList<String> newKeyWords = new_id.getKeyWords();
        EList<String> keyWords = id.getKeyWords();
        for (String keyWord : keyWords) {
            newKeyWords.add(keyWord);
        }
        return new_id;
    }

    public static Type cloneType(Type src) {
        String strType = OAWutils.pogo2tangoType(src.toString());
        return OAWutils.tango2pogoType(strType);
    }

    public static PropType cloneType(PropType src) {
        String strType = PropertyDialog.pogo2tangoType(src);
        return PropertyDialog.tango2pogoType(strType);
    }

    public static Command cloneCommand(Command src) {
        Command cmd = factory.createCommand();
        String name = src.getName();
        cmd.setName(name);
        cmd.setExecMethod(Utils.buildCppExecuteMethodName(name));
        cmd.setDescription(src.getDescription());
        cmd.setIsDynamic(src.getIsDynamic());
        Argument argin = factory.createArgument();
        argin.setType(OAWutils.cloneType(src.getArgin().getType()));
        argin.setDescription(src.getArgin().getDescription());
        cmd.setArgin(argin);
        Argument argout = factory.createArgument();
        argout.setType(OAWutils.cloneType(src.getArgout().getType()));
        argout.setDescription(src.getArgout().getDescription());
        cmd.setArgout(argout);
        if (src.getDisplayLevel() == null) {
            cmd.setDisplayLevel("OPERATOR");
        } else {
            cmd.setDisplayLevel(src.getDisplayLevel());
        }
        InheritanceStatus status = factory.createInheritanceStatus();
        InheritanceStatus srcStatus = src.getStatus();
        status.setAbstract(srcStatus.getAbstract());
        status.setInherited(srcStatus.getInherited());
        status.setConcrete(srcStatus.getConcrete());
        status.setConcreteHere(srcStatus.getConcreteHere());
        cmd.setStatus(status);
        EList<String> srcExcluded = src.getExcludedStates();
        EList<String> newExcluded = cmd.getExcludedStates();
        for (String s : srcExcluded) {
            newExcluded.add(s);
        }
        cmd.setPolledPeriod(src.getPolledPeriod());
        return cmd;
    }

    public static Attribute cloneAttribute(Attribute src) {
        EventCriteria archiveEventCriteria;
        Attribute attr = factory.createAttribute();
        attr.setName(src.getName());
        attr.setIsDynamic(src.getIsDynamic());
        attr.setAttType(src.getAttType());
        attr.setRwType(src.getRwType());
        if (src.getAssociatedAttr() != null && src.getAssociatedAttr().length() > 0) {
            attr.setAssociatedAttr(src.getAssociatedAttr());
        }
        attr.setDataType(OAWutils.cloneType(src.getDataType()));
        EList<String> srcEnumLabels = src.getEnumLabels();
        EList<String> newEnumLabels = attr.getEnumLabels();
        for (String s : srcEnumLabels) {
            newEnumLabels.add(s);
        }
        attr.setMaxX(src.getMaxX());
        attr.setMaxY(src.getMaxY());
        AttrProperties prop = factory.createAttrProperties();
        AttrProperties src_prop = src.getProperties();
        prop.setDescription(src_prop.getDescription());
        prop.setLabel(src_prop.getLabel());
        prop.setUnit(src_prop.getUnit());
        prop.setStandardUnit(src_prop.getStandardUnit());
        prop.setDisplayUnit(src_prop.getDisplayUnit());
        prop.setFormat(src_prop.getFormat());
        prop.setMaxValue(src_prop.getMaxValue());
        prop.setMinValue(src_prop.getMinValue());
        prop.setMaxAlarm(src_prop.getMaxAlarm());
        prop.setMinAlarm(src_prop.getMinAlarm());
        prop.setMaxWarning(src_prop.getMaxWarning());
        prop.setMinWarning(src_prop.getMinWarning());
        prop.setDeltaTime(src_prop.getDeltaTime());
        prop.setDeltaValue(src_prop.getDeltaValue());
        attr.setProperties(prop);
        attr.setPolledPeriod(src.getPolledPeriod());
        if (src.getDisplayLevel() == null) {
            attr.setDisplayLevel("OPERATOR");
        } else {
            attr.setDisplayLevel(src.getDisplayLevel());
        }
        attr.setMemorized(src.getMemorized());
        attr.setMemorizedAtInit(src.getMemorizedAtInit());
        InheritanceStatus status = factory.createInheritanceStatus();
        InheritanceStatus src_st = src.getStatus();
        status.setAbstract(src_st.getAbstract());
        status.setInherited(src_st.getInherited());
        status.setConcrete(src_st.getConcrete());
        status.setConcreteHere(src_st.getConcreteHere());
        EList<String> src_excluded = src.getReadExcludedStates();
        EList<String> new_excluded = attr.getReadExcludedStates();
        for (String s : src_excluded) {
            new_excluded.add(s);
        }
        src_excluded = src.getWriteExcludedStates();
        new_excluded = attr.getWriteExcludedStates();
        for (String s : src_excluded) {
            new_excluded.add(s);
        }
        attr.setStatus(status);
        attr.setAllocReadMember(src.getAllocReadMember());
        EventCriteria eventCriteria = src.getEventCriteria();
        if (OAWutils.eventCriteriaIsSet(eventCriteria)) {
            EventCriteria newEventCriteria = factory.createEventCriteria();
            newEventCriteria.setPeriod(eventCriteria.getPeriod());
            newEventCriteria.setRelChange(eventCriteria.getRelChange());
            newEventCriteria.setAbsChange(eventCriteria.getAbsChange());
            attr.setEventCriteria(newEventCriteria);
        }
        if (OAWutils.eventCriteriaIsSet(archiveEventCriteria = src.getEvArchiveCriteria())) {
            EventCriteria newEventCriteria = factory.createEventCriteria();
            newEventCriteria.setPeriod(archiveEventCriteria.getPeriod());
            newEventCriteria.setRelChange(archiveEventCriteria.getRelChange());
            newEventCriteria.setAbsChange(archiveEventCriteria.getAbsChange());
            attr.setEvArchiveCriteria(newEventCriteria);
        }
        if (src.getChangeEvent() != null) {
            FireEvents changeEvents = factory.createFireEvents();
            changeEvents.setFire(src.getChangeEvent().getFire());
            changeEvents.setLibCheckCriteria(src.getChangeEvent().getLibCheckCriteria());
            attr.setChangeEvent(changeEvents);
        }
        if (src.getArchiveEvent() != null) {
            FireEvents archiveEvents = factory.createFireEvents();
            archiveEvents.setFire(src.getArchiveEvent().getFire());
            archiveEvents.setLibCheckCriteria(src.getArchiveEvent().getLibCheckCriteria());
            attr.setArchiveEvent(archiveEvents);
        }
        if (src.getDataReadyEvent() != null) {
            FireEvents dataReadyEvents = factory.createFireEvents();
            dataReadyEvents.setFire(src.getDataReadyEvent().getFire());
            dataReadyEvents.setLibCheckCriteria(src.getDataReadyEvent().getLibCheckCriteria());
            attr.setDataReadyEvent(dataReadyEvents);
        }
        return attr;
    }

    private static boolean eventCriteriaIsSet(EventCriteria eventCriteria) {
        return eventCriteria != null && (eventCriteria.getPeriod().length() > 0 || eventCriteria.getRelChange().length() > 0 || eventCriteria.getAbsChange().length() > 0);
    }

    public static Property cloneProperty(Property src) {
        Property property = factory.createProperty();
        property.setName(src.getName());
        property.setDescription(src.getDescription());
        property.setType(OAWutils.cloneType(src.getType()));
        EList<String> list = property.getDefaultPropValue();
        EList<String> src_list = src.getDefaultPropValue();
        for (String s : src_list) {
            list.add(s);
        }
        InheritanceStatus status = factory.createInheritanceStatus();
        InheritanceStatus src_st = src.getStatus();
        status.setAbstract(src_st.getAbstract());
        status.setInherited(src_st.getInherited());
        status.setConcrete(src_st.getConcrete());
        status.setConcreteHere(src_st.getConcreteHere());
        property.setStatus(status);
        if (Utils.isTrue(src.getMandatory())) {
            property.setMandatory("true");
        }
        return property;
    }

    public static State cloneState(State src) {
        State state = factory.createState();
        state.setName(src.getName());
        state.setDescription(src.getDescription());
        InheritanceStatus status = factory.createInheritanceStatus();
        InheritanceStatus src_st = src.getStatus();
        status.setAbstract(src_st.getAbstract());
        status.setInherited(src_st.getInherited());
        status.setConcrete(src_st.getConcrete());
        status.setConcreteHere(src_st.getConcreteHere());
        state.setStatus(status);
        return state;
    }

    public static ForwardedAttribute cloneForwardedAttribute(ForwardedAttribute src) {
        ForwardedAttribute attribute = factory.createForwardedAttribute();
        attribute.setName(src.getName());
        attribute.setLabel(src.getLabel());
        InheritanceStatus status = factory.createInheritanceStatus();
        InheritanceStatus src_st = src.getStatus();
        status.setAbstract(src_st.getAbstract());
        status.setInherited(src_st.getInherited());
        status.setConcrete(src_st.getConcrete());
        status.setConcreteHere(src_st.getConcreteHere());
        attribute.setStatus(status);
        return attribute;
    }

    public static Pipe clonePipe(Pipe src) {
        Pipe pipe = factory.createPipe();
        pipe.setName(src.getName());
        pipe.setLabel(src.getLabel());
        pipe.setDescription(src.getDescription());
        pipe.setDisplayLevel(src.getDisplayLevel());
        pipe.setRwType(src.getRwType());
        EList<String> srcExcluded = src.getReadExcludedStates();
        EList<String> newExcluded = pipe.getReadExcludedStates();
        for (String s : srcExcluded) {
            newExcluded.add(s);
        }
        srcExcluded = src.getWriteExcludedStates();
        newExcluded = pipe.getWriteExcludedStates();
        for (String s : srcExcluded) {
            newExcluded.add(s);
        }
        return pipe;
    }

    public static AdditionalFile cloneAdditionalFile(AdditionalFile src) {
        AdditionalFile file = factory.createAdditionalFile();
        file.setName(src.getName());
        file.setPath(src.getPath());
        return file;
    }
}

