/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.tango.pogo.pogo_gui.tools.TangoServer;
import org.tango.pogo.pogo_gui.tools.Utils;

public class ServerDialog
extends JDialog {
    private TangoServer server;
    private int retVal = 0;
    private JTextArea descriptionText;
    private JComboBox<String> licenseComboBox;
    private JTextField nameText;
    private JLabel titleLabel;

    public ServerDialog(JFrame jFrame, TangoServer tangoServer) {
        super((Frame)jFrame, true);
        this.server = tangoServer;
        this.initComponents();
        this.licenseComboBox.addItem("GPL");
        this.licenseComboBox.addItem("LGPL");
        this.licenseComboBox.addItem("none");
        this.titleLabel.setText("Tango Server definition");
        if (tangoServer != null) {
            this.nameText.setText(tangoServer.name);
            if (tangoServer.license != null) {
                this.licenseComboBox.setSelectedItem(tangoServer.license);
            }
            this.licenseComboBox.setToolTipText(Utils.buildToolTip("WARNING:\n", "The license must be the same for\nall classes managed by this server."));
            this.descriptionText.setText(tangoServer.description);
        }
        this.pack();
        ATKGraphicsUtils.centerDialog(this);
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        this.titleLabel = new JLabel();
        JPanel jPanel2 = new JPanel();
        JLabel jLabel = new JLabel();
        this.nameText = new JTextField();
        JLabel jLabel2 = new JLabel();
        JScrollPane jScrollPane = new JScrollPane();
        this.descriptionText = new JTextArea();
        this.licenseComboBox = new JComboBox();
        JLabel jLabel3 = new JLabel();
        JPanel jPanel3 = new JPanel();
        JButton jButton = new JButton();
        JButton jButton2 = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ServerDialog.this.closeDialog(windowEvent);
            }
        });
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        jPanel.add(this.titleLabel);
        this.getContentPane().add((Component)jPanel, "North");
        jPanel2.setLayout(new GridBagLayout());
        jLabel.setText("Server Name:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(10, 10, 10, 0);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.nameText.setColumns(30);
        this.nameText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                ServerDialog.this.nameTextKeyPressed(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        jPanel2.add((Component)this.nameText, gridBagConstraints);
        jLabel2.setText("Description:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        jPanel2.add((Component)jLabel2, gridBagConstraints);
        this.descriptionText.setColumns(40);
        this.descriptionText.setRows(8);
        jScrollPane.setViewportView(this.descriptionText);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        jPanel2.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 10, 0);
        jPanel2.add(this.licenseComboBox, gridBagConstraints);
        jLabel3.setText("License :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 10, 0);
        jPanel2.add((Component)jLabel3, gridBagConstraints);
        this.getContentPane().add((Component)jPanel2, "Center");
        jButton.setText("OK");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ServerDialog.this.okBtnActionPerformed(actionEvent);
            }
        });
        jPanel3.add(jButton);
        jButton2.setText("Cancel");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ServerDialog.this.cancelBtnActionPerformed(actionEvent);
            }
        });
        jPanel3.add(jButton2);
        this.getContentPane().add((Component)jPanel3, "South");
        this.pack();
    }

    private void okBtnActionPerformed(ActionEvent actionEvent) {
        this.server.name = this.nameText.getText();
        this.server.license = this.licenseComboBox.getSelectedItem().toString();
        this.server.description = this.descriptionText.getText();
        this.doClose();
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.retVal = 2;
        this.doClose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.retVal = 2;
        this.doClose();
    }

    private void nameTextKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            this.retVal = 2;
            this.doClose();
        }
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    public int showDialog() {
        this.setVisible(true);
        return this.retVal;
    }

    public TangoServer getTangoServer() {
        return this.server;
    }
}

