/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui;

import fr.esrf.tango.pogo.pogoDsl.PogoMultiClasses;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.tango.pogo.pogo_gui.GenerateDialog;
import org.tango.pogo.pogo_gui.MultiClassesTree;
import org.tango.pogo.pogo_gui.PogoGUI;
import org.tango.pogo.pogo_gui.ServerDialog;
import org.tango.pogo.pogo_gui.packaging.ConfigurePackagingDialog;
import org.tango.pogo.pogo_gui.packaging.Packaging;
import org.tango.pogo.pogo_gui.tools.OAWutils;
import org.tango.pogo.pogo_gui.tools.PogoException;
import org.tango.pogo.pogo_gui.tools.PogoFileFilter;
import org.tango.pogo.pogo_gui.tools.PogoProperty;
import org.tango.pogo.pogo_gui.tools.TangoServer;
import org.tango.pogo.pogo_gui.tools.Utils;

public class MultiClassesPanel
extends JFrame {
    private JFrame parent;
    private static JFileChooser chooser = null;
    public static String homeDir;
    private MultiClassesTree tree;
    private JScrollPane scrollPane;
    private ArrayList<JButton> topButtons = new ArrayList();
    private static final int TOP_RELOAD = 0;
    private static final int TOP_NEW = 1;
    private static final int TOP_OPEN = 2;
    private static final int TOP_GENE = 3;
    private static final PogoFileFilter pogoFilter;
    private JMenuItem addItem;
    private JMenu editMenu;
    private JMenuItem exitItem;
    private JMenu fileMenu;
    private JMenuItem generateItem;
    private JMenuItem helpItem;
    private JMenu helpMenu;
    private JMenuItem newItem;
    private JMenuItem openItem;
    private JMenuItem packageItem;
    private JMenu recentMenu;
    private JMenuItem removeItem;
    private JPanel topPanel;

    public MultiClassesPanel(JFrame jFrame, String string) throws PogoException {
        this.parent = jFrame;
        this.initComponents();
        PogoProperty.init();
        this.customizeMenus();
        this.initOwnComponents();
        this.checkLoadAtStartup(string);
        PogoGUI.multiClassesPanel = this;
        this.packageItem.setVisible(Packaging.isAvailable());
        this.pack();
        ATKGraphicsUtils.centerFrameOnScreen(this);
    }

    private void checkLoadAtStartup(String string) {
        try {
            if (string != null && string.length() > 0) {
                this.loadXmiFile(string);
            } else {
                String string2 = Utils.getXmiFile();
                if (string2 != null) {
                    this.openItemActionPerformed(null);
                } else if (PogoProperty.loadPrevious && PogoProperty.multiClassProjectHistory.size() > 0) {
                    this.loadXmiFile(PogoProperty.multiClassProjectHistory.get(0));
                }
            }
        }
        catch (PogoException pogoException) {
            System.err.println(pogoException);
        }
    }

    private void initOwnComponents() {
        this.setTitle("Multi TANGO Classes Code Generator - 9.1.3b  -  Fri Aug 07 10:17:45 CEST 2015");
        this.scrollPane = new JScrollPane();
        this.scrollPane.setPreferredSize(new Dimension(350, 450));
        this.getContentPane().add((Component)this.scrollPane, "Center");
        homeDir = System.getenv("SOURCE_PATH");
        if (homeDir == null && (homeDir = System.getProperty("SOURCE_PATH")) == null) {
            homeDir = new File("").getAbsolutePath();
        }
        chooser = new JFileChooser(new File(homeDir).getAbsolutePath());
        chooser.setFileFilter(pogoFilter);
        this.setIconImage(Utils.getInstance().logoIcon.getImage());
        Utils utils = Utils.getInstance();
        this.addTopPanelButton(utils.reloadIcon, "Reload Server");
        this.addTopPanelButton(utils.newIcon, "New Server");
        this.addTopPanelButton(utils.openIcon, "Open Server");
        this.addTopPanelButton(utils.saveIcon, "Generate Server");
    }

    private void addTopPanelButton(ImageIcon imageIcon, String string) {
        JButton jButton = new JButton(imageIcon);
        jButton.setToolTipText(Utils.buildToolTip(string));
        jButton.setBorder(new SoftBevelBorder(0));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultiClassesPanel.this.topButtonActionPerformed(actionEvent);
            }
        });
        this.topPanel.add(jButton);
        this.topButtons.add(jButton);
    }

    private void customizeMenus() {
        this.fileMenu.setMnemonic('F');
        this.newItem.setMnemonic('N');
        this.newItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.openItem.setMnemonic('O');
        this.openItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.generateItem.setMnemonic('G');
        this.generateItem.setAccelerator(KeyStroke.getKeyStroke(71, 2));
        this.exitItem.setMnemonic('E');
        this.exitItem.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.editMenu.setMnemonic('E');
        this.addItem.setMnemonic('A');
        this.addItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.removeItem.setMnemonic('R');
        this.removeItem.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        this.helpMenu.setMnemonic('H');
        this.helpItem.setMnemonic('H');
        this.helpItem.setAccelerator(KeyStroke.getKeyStroke(72, 2));
        this.manageRecentMenu(null);
    }

    private void manageRecentMenu(String string) {
        try {
            if (string == null && PogoProperty.projectHistory.size() == 0) {
                return;
            }
            if (string != null) {
                PogoProperty.addProject(string, 1);
            }
            this.recentMenu.removeAll();
            for (String string2 : PogoProperty.multiClassProjectHistory) {
                JMenuItem jMenuItem = new JMenuItem(string2);
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        MultiClassesPanel.this.recentItemActionPerformed(actionEvent);
                    }
                });
                this.recentMenu.add(jMenuItem);
            }
        }
        catch (Exception exception) {
            System.err.println("\nWARNING:\t" + exception);
        }
    }

    private void initComponents() {
        this.topPanel = new JPanel();
        JMenuBar jMenuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.newItem = new JMenuItem();
        this.openItem = new JMenuItem();
        this.recentMenu = new JMenu();
        JMenuItem jMenuItem = new JMenuItem();
        this.generateItem = new JMenuItem();
        this.packageItem = new JMenuItem();
        this.exitItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.addItem = new JMenuItem();
        this.removeItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.helpItem = new JMenuItem();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                MultiClassesPanel.this.exitForm(windowEvent);
            }
        });
        this.topPanel.setLayout(new FlowLayout(0));
        this.getContentPane().add((Component)this.topPanel, "North");
        this.fileMenu.setText("File");
        this.newItem.setText("New");
        this.newItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultiClassesPanel.this.newItemActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.newItem);
        this.openItem.setText("Open");
        this.openItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultiClassesPanel.this.openItemActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.openItem);
        this.recentMenu.setText("Open Recent");
        jMenuItem.setText("...");
        this.recentMenu.add(jMenuItem);
        this.fileMenu.add(this.recentMenu);
        this.generateItem.setText("Generate");
        this.generateItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultiClassesPanel.this.generateItemActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.generateItem);
        this.packageItem.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        this.packageItem.setText("Export Package");
        this.packageItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultiClassesPanel.this.packageItemActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.packageItem);
        this.exitItem.setText("Exit");
        this.exitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultiClassesPanel.this.exitItemActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.exitItem);
        jMenuBar.add(this.fileMenu);
        this.editMenu.setText("Edit");
        this.editMenu.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                MultiClassesPanel.this.editMenuStateChanged(changeEvent);
            }
        });
        this.addItem.setText("Add Class");
        this.addItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultiClassesPanel.this.addItemActionPerformed(actionEvent);
            }
        });
        this.editMenu.add(this.addItem);
        this.removeItem.setText("Remove class");
        this.removeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultiClassesPanel.this.removeItemActionPerformed(actionEvent);
            }
        });
        this.editMenu.add(this.removeItem);
        jMenuBar.add(this.editMenu);
        this.helpMenu.setText("help");
        this.helpItem.setText("On Multi Class Manager");
        this.helpItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultiClassesPanel.this.helpItemActionPerformed(actionEvent);
            }
        });
        this.helpMenu.add(this.helpItem);
        jMenuBar.add(this.helpMenu);
        this.setJMenuBar(jMenuBar);
        this.pack();
    }

    private void topButtonActionPerformed(ActionEvent actionEvent) {
        JButton jButton = (JButton)actionEvent.getSource();
        block6: for (int i = 0; i < this.topButtons.size(); ++i) {
            if (this.topButtons.get(i) != jButton) continue;
            switch (i) {
                case 0: {
                    if (this.tree == null) continue block6;
                    this.reloadProject();
                    continue block6;
                }
                case 1: {
                    this.newItemActionPerformed(actionEvent);
                    continue block6;
                }
                case 2: {
                    this.openItemActionPerformed(actionEvent);
                    continue block6;
                }
                case 3: {
                    if (this.tree == null) continue block6;
                    this.generateItemActionPerformed(actionEvent);
                }
            }
        }
    }

    private void reloadProject() {
        String string;
        if (this.checkModifications() == 0 && (string = this.tree.getServerFileName()) != null) {
            try {
                this.loadXmiFile(string);
            }
            catch (PogoException pogoException) {
                pogoException.popup(this);
            }
        }
    }

    private void recentItemActionPerformed(ActionEvent actionEvent) {
        try {
            String string = ((JMenuItem)actionEvent.getSource()).getText();
            this.loadXmiFile(string);
        }
        catch (PogoException pogoException) {
            pogoException.popup(this);
        }
    }

    private void openItemActionPerformed(ActionEvent actionEvent) {
        File file;
        int n;
        if (chooser == null) {
            chooser = new JFileChooser(new File("").getAbsolutePath());
        }
        if ((n = chooser.showOpenDialog(this)) == 0 && (file = chooser.getSelectedFile()) != null && !file.isDirectory()) {
            String string = file.getAbsolutePath();
            try {
                this.loadXmiFile(string);
            }
            catch (PogoException pogoException) {
                pogoException.popup(this);
            }
        }
    }

    public PogoMultiClasses loadXmiFile(String string) throws PogoException {
        PogoMultiClasses pogoMultiClasses = OAWutils.getInstance().loadMultiClassesModel(string);
        this.buildTree(pogoMultiClasses);
        this.manageRecentMenu(string);
        return pogoMultiClasses;
    }

    private void buildTree(PogoMultiClasses pogoMultiClasses) {
        try {
            this.tree = new MultiClassesTree((JFrame)this, pogoMultiClasses);
            this.scrollPane.setViewportView(this.tree);
        }
        catch (PogoException pogoException) {
            // empty catch block
        }
    }

    private void exitItemActionPerformed(ActionEvent actionEvent) {
        this.doClose();
    }

    private void exitForm(WindowEvent windowEvent) {
        this.doClose();
    }

    private void generateItemActionPerformed(ActionEvent actionEvent) {
        this.generateFiles();
    }

    private int generateFiles() {
        if (this.tree == null) {
            return 2;
        }
        try {
            PogoMultiClasses pogoMultiClasses = this.tree.getServer();
            GenerateDialog generateDialog = new GenerateDialog(this);
            if (generateDialog.showDialog(pogoMultiClasses) == 0) {
                this.setCursor(new Cursor(3));
                pogoMultiClasses.setSourcePath(generateDialog.getPath());
                pogoMultiClasses.setFilestogenerate(generateDialog.getGenerated());
                OAWutils.getInstance().generate(pogoMultiClasses);
                this.tree.setModified(false);
                this.setCursor(new Cursor(0));
                String string = pogoMultiClasses.getSourcePath() + "/" + pogoMultiClasses.getName() + ".multi.xmi";
                this.manageRecentMenu(string);
                return 0;
            }
        }
        catch (PogoException pogoException) {
            this.setCursor(new Cursor(0));
            pogoException.popup(this);
        }
        return 2;
    }

    private void newItemActionPerformed(ActionEvent actionEvent) {
        if (this.tree != null && this.tree.getModified() && this.checkModifications() == 2) {
            return;
        }
        try {
            ServerDialog serverDialog = new ServerDialog(this, new TangoServer());
            if (serverDialog.showDialog() == 0) {
                this.tree = new MultiClassesTree((JFrame)this, serverDialog.getTangoServer());
                this.tree.setModified(true);
                this.scrollPane.setViewportView(this.tree);
            }
        }
        catch (PogoException pogoException) {
            pogoException.popup(this);
        }
    }

    private void addItemActionPerformed(ActionEvent actionEvent) {
        if (this.tree.isANodeSelected()) {
            this.tree.addClass();
        }
    }

    private void removeItemActionPerformed(ActionEvent actionEvent) {
        if (this.tree.isAClassSelected()) {
            this.tree.removeClass();
        }
    }

    private void editMenuStateChanged(ChangeEvent changeEvent) {
        boolean bl;
        boolean bl2 = bl = !this.editMenu.isSelected();
        if (this.tree != null) {
            this.addItem.setEnabled(this.tree.isANodeSelected() || bl);
            this.removeItem.setEnabled(this.tree.isAClassSelected() || bl);
        }
    }

    private void helpItemActionPerformed(ActionEvent actionEvent) {
        JOptionPane.showMessageDialog(this, "             Pogo  (Tango Code Generator)\n    This tool is able to generate, update and modify\n           a server project containing several\n                 Tango device classes.\n\nDefine a new server (Name, description,...)\nThen add classes (Highest classes to lowest ones)\nAnd finally, generate.\n\nThis tool is available only for C++ classes on Linux.\n\nhttp://www.tango-controls.org/     -    tango@esrf.fr", "Help Window", 1);
    }

    private void packageItemActionPerformed(ActionEvent actionEvent) {
        PogoMultiClasses pogoMultiClasses = this.tree.getServer();
        if (pogoMultiClasses == null) {
            return;
        }
        new ConfigurePackagingDialog(this, pogoMultiClasses, this.tree.getAuthor()).setVisible(true);
    }

    private int checkModifications() {
        if (this.tree.getModified()) {
            String string = this.tree.getName();
            Object[] objectArray = new Object[]{"Generate", "Discard", "Cancel"};
            switch (JOptionPane.showOptionDialog(this, string + " project has not been generated !\n\n", "Warning", -1, 2, null, objectArray, objectArray[0])) {
                case 0: {
                    return this.generateFiles();
                }
                case 1: {
                    return 0;
                }
            }
            return 2;
        }
        return 0;
    }

    private void doClose() {
        if (this.tree != null && this.tree.getModified() && this.checkModifications() == 2) {
            return;
        }
        if (this.parent.isVisible()) {
            this.setVisible(false);
        } else if (this.tree == null) {
            System.exit(0);
        } else if (this.tree.allEditorsAreClosed()) {
            System.exit(0);
        } else {
            this.setVisible(false);
        }
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 0) {
                new MultiClassesPanel(new JFrame(), null).setVisible(true);
            } else {
                new MultiClassesPanel(new JFrame(), stringArray[0]).setVisible(true);
            }
        }
        catch (PogoException pogoException) {
            pogoException.popup(new Frame());
        }
    }

    static {
        pogoFilter = new PogoFileFilter("xmi", "Multi Classes");
    }
}

