/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui;

import fr.esrf.TangoDs.TangoConst;
import fr.esrf.tango.pogo.pogoDsl.Argument;
import fr.esrf.tango.pogo.pogoDsl.Command;
import fr.esrf.tango.pogo.pogoDsl.InheritanceStatus;
import fr.esrf.tango.pogo.pogoDsl.Type;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.SoftBevelBorder;
import org.eclipse.emf.common.util.EList;
import org.tango.pogo.pogo_gui.EditDialog;
import org.tango.pogo.pogo_gui.PogoConst;
import org.tango.pogo.pogo_gui.PogoGUI;
import org.tango.pogo.pogo_gui.tools.OAWutils;
import org.tango.pogo.pogo_gui.tools.PogoException;
import org.tango.pogo.pogo_gui.tools.PopupTable;
import org.tango.pogo.pogo_gui.tools.Utils;

public class CommandDialog
extends JDialog {
    private int retVal = 0;
    private static String[] commandNames = new String[]{"Reset", "Off", "Warmup", "Standby", "On", "Start", "Stop", "Open", "Close", "Local", "Remote"};
    private PogoGUI pogo_gui;
    private InheritanceStatus orig_status = null;
    private boolean isStateStatus = false;
    private Command command;
    private boolean isDynamic = false;
    private JRadioButton abstractBtn;
    private JComboBox<String> arginComboBox;
    private JButton arginDescBtn;
    private JTextArea arginDescText;
    private JComboBox<String> argoutComboBox;
    private JButton argoutDescBtn;
    private JTextArea argoutDescText;
    private JTextArea descText;
    private JLabel dynamicLbl;
    private JRadioButton levelBtn;
    private JComboBox<String> nameComboBox;
    private JRadioButton overloadBtn;
    private JRadioButton polledBtn;
    private JLabel polledLbl;
    private JTextField polledTxt;
    private static int[] columnSize = new int[]{140, 130, 130, 80, 40, 40, 400};
    private static String[] columnTitle = new String[]{"Name", "Input Arg", "Output Arg", "Level", "Inherited", "Abstract", "Description"};

    public CommandDialog(PogoGUI pogoGUI, boolean bl) {
        this(pogoGUI, null);
        this.isDynamic = bl;
        this.dynamicLbl.setVisible(bl);
        this.pack();
    }

    public CommandDialog(PogoGUI pogoGUI, Command command) {
        super((Frame)pogoGUI, true);
        this.command = command;
        this.pogo_gui = pogoGUI;
        if (this.command != null) {
            this.isDynamic = Utils.isTrue(this.command.getIsDynamic());
        }
        this.initComponents();
        this.setCommand(command);
        this.manageInheritanceStatus(command);
        this.pack();
        ATKGraphicsUtils.centerDialog(this);
    }

    private void manageInheritanceStatus(Command command) {
        if (command != null) {
            this.orig_status = command.getStatus();
            if (this.isDynamic) {
                this.overloadBtn.setVisible(false);
                this.abstractBtn.setVisible(false);
                this.setEditable(true);
            } else if (Utils.isTrue(this.orig_status.getInherited())) {
                this.abstractBtn.setVisible(false);
                this.overloadBtn.setVisible(true);
                boolean bl = Utils.isTrue(this.orig_status.getConcreteHere());
                this.overloadBtn.setSelected(bl);
                this.setEditable(false);
            } else {
                this.overloadBtn.setVisible(false);
                this.abstractBtn.setVisible(true);
                this.abstractBtn.setSelected(Utils.isTrue(this.orig_status.getAbstract()));
                this.setEditable(true);
            }
        } else {
            this.overloadBtn.setVisible(false);
            this.abstractBtn.setSelected(false);
            this.orig_status = OAWutils.factory.createInheritanceStatus();
            this.orig_status.setAbstract("false");
            this.orig_status.setInherited("false");
            this.orig_status.setConcrete("true");
            this.orig_status.setConcreteHere("true");
            this.setEditable(true);
        }
    }

    private void setNotEditable(JComboBox<String> jComboBox) {
        String string = (String)jComboBox.getSelectedItem();
        if (string != null) {
            jComboBox.removeAllItems();
            jComboBox.addItem(string);
        }
    }

    private void setEditable(boolean bl) {
        this.nameComboBox.setEditable(bl);
        if (!bl) {
            this.setNotEditable(this.nameComboBox);
            this.setNotEditable(this.arginComboBox);
            this.setNotEditable(this.argoutComboBox);
            this.levelBtn.setEnabled(false);
            this.arginDescBtn.setEnabled(false);
            this.arginDescText.setEditable(false);
            this.argoutDescBtn.setEnabled(false);
            this.argoutDescText.setEditable(false);
            this.descText.setEditable(false);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setCommand(Command command) {
        void object;
        for (String string : commandNames) {
            this.nameComboBox.addItem(string);
        }
        boolean i = false;
        while (object < TangoConst.Tango_CmdArgTypeName.length) {
            if (object != 22 && object != 27) {
                String string = TangoConst.Tango_CmdArgTypeName[object];
                this.arginComboBox.addItem(string);
                this.argoutComboBox.addItem(string);
            }
            ++object;
        }
        this.polledTxt.setEnabled(false);
        this.polledTxt.setText("3000");
        if (command != null) {
            for (String string : commandNames) {
                if (!string.equals(command.getName())) continue;
                this.nameComboBox.setSelectedItem(string);
            }
            if (this.nameComboBox.getSelectedIndex() == 0) {
                String string = command.getName();
                this.nameComboBox.addItem(string);
                this.nameComboBox.setSelectedItem(string);
            }
            String string2 = Utils.strReplace(command.getDescription(), "\\n", "\n");
            string2 = Utils.strReplaceSpecialCharToDisplay(string2);
            this.descText.setText(string2);
            String string4 = Utils.strReplace(command.getArgin().getDescription(), "\\n", "\n");
            string4 = Utils.strReplaceSpecialCharToDisplay(string4);
            this.arginDescText.setText(string4);
            String string6 = Utils.strReplace(command.getArgout().getDescription(), "\\n", "\n");
            string6 = Utils.strReplaceSpecialCharToDisplay(string6);
            this.argoutDescText.setText(string6);
            String string7 = OAWutils.pogo2tangoType(command.getArgin().getType().toString());
            String string8 = OAWutils.pogo2tangoType(command.getArgout().getType().toString());
            for (String string9 : TangoConst.Tango_CmdArgTypeName) {
                if (string9.equals(string7)) {
                    this.arginComboBox.setSelectedItem(string9);
                }
                if (!string9.equals(string8)) continue;
                this.argoutComboBox.setSelectedItem(string9);
            }
            if (Utils.isEquals(command.getDisplayLevel(), PogoConst.strLevel[1])) {
                this.levelBtn.setSelected(true);
            }
            if (command.getPolledPeriod() != null && command.getPolledPeriod().length() > 0 && !command.getPolledPeriod().equals("0")) {
                this.polledBtn.setSelected(true);
                this.polledTxt.setEnabled(true);
                this.polledLbl.setVisible(true);
                this.polledTxt.setText(command.getPolledPeriod());
            }
            if (command.getName().toLowerCase().equals("state") || command.getName().toLowerCase().equals("status")) {
                this.isStateStatus = true;
                this.levelBtn.setEnabled(false);
                this.levelBtn.setSelected(false);
            }
        } else {
            String string = "";
            this.nameComboBox.addItem(string);
            this.nameComboBox.setSelectedItem(string);
        }
        if (this.isDynamic) {
            this.abstractBtn.setVisible(false);
            this.overloadBtn.setVisible(false);
        }
        this.dynamicLbl.setVisible(this.isDynamic);
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        this.dynamicLbl = new JLabel();
        JLabel jLabel = new JLabel();
        this.nameComboBox = new JComboBox();
        this.abstractBtn = new JRadioButton();
        this.overloadBtn = new JRadioButton();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        this.arginComboBox = new JComboBox();
        this.argoutComboBox = new JComboBox();
        this.arginDescBtn = new JButton();
        this.argoutDescBtn = new JButton();
        JPanel jPanel2 = new JPanel();
        this.polledBtn = new JRadioButton();
        this.polledTxt = new JTextField();
        this.polledLbl = new JLabel();
        JPanel jPanel3 = new JPanel();
        JLabel jLabel4 = new JLabel();
        this.levelBtn = new JRadioButton();
        JLabel jLabel5 = new JLabel();
        JScrollPane jScrollPane = new JScrollPane();
        this.descText = new JTextArea();
        JScrollPane jScrollPane2 = new JScrollPane();
        this.arginDescText = new JTextArea();
        JScrollPane jScrollPane3 = new JScrollPane();
        this.argoutDescText = new JTextArea();
        JPanel jPanel4 = new JPanel();
        JButton jButton = new JButton();
        JButton jButton2 = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                CommandDialog.this.closeDialog(windowEvent);
            }
        });
        jPanel.setLayout(new GridBagLayout());
        this.dynamicLbl.setFont(new Font("Arial", 1, 12));
        this.dynamicLbl.setText("Dynamic Command (Add/Remove command will be done by code)");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(10, 16, 21, 6);
        jPanel.add((Component)this.dynamicLbl, gridBagConstraints);
        jLabel.setFont(new Font("Arial", 1, 18));
        jLabel.setText("Command Name:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(20, 10, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.nameComboBox.setEditable(true);
        this.nameComboBox.setFont(new Font("Arial", 1, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(20, 10, 0, 0);
        jPanel.add(this.nameComboBox, gridBagConstraints);
        this.abstractBtn.setFont(new Font("Arial", 1, 12));
        this.abstractBtn.setText("Abstract Command");
        this.abstractBtn.setHorizontalAlignment(2);
        this.abstractBtn.setHorizontalTextPosition(2);
        this.abstractBtn.setMargin(new Insets(2, 12, 2, 12));
        this.abstractBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CommandDialog.this.abstractBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 20, 0);
        jPanel.add((Component)this.abstractBtn, gridBagConstraints);
        this.overloadBtn.setFont(new Font("Arial", 1, 12));
        this.overloadBtn.setText("Overload Command");
        this.overloadBtn.setHorizontalAlignment(2);
        this.overloadBtn.setHorizontalTextPosition(2);
        this.overloadBtn.setMargin(new Insets(2, 12, 2, 12));
        this.overloadBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CommandDialog.this.overloadBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 20, 0);
        jPanel.add((Component)this.overloadBtn, gridBagConstraints);
        jLabel2.setFont(new Font("Arial", 1, 12));
        jLabel2.setText("Input Argument:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(25, 10, 0, 10);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        jLabel3.setFont(new Font("Arial", 1, 12));
        jLabel3.setText("Output Argument:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 10, 0, 10);
        jPanel.add((Component)jLabel3, gridBagConstraints);
        this.arginComboBox.setFont(new Font("Arial", 1, 12));
        this.arginComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CommandDialog.this.arginComboBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(25, 0, 0, 0);
        jPanel.add(this.arginComboBox, gridBagConstraints);
        this.argoutComboBox.setFont(new Font("Arial", 1, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        jPanel.add(this.argoutComboBox, gridBagConstraints);
        this.arginDescBtn.setText("...");
        this.arginDescBtn.setBorder(new SoftBevelBorder(0));
        this.arginDescBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CommandDialog.this.descBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 20);
        jPanel.add((Component)this.arginDescBtn, gridBagConstraints);
        this.argoutDescBtn.setText("...");
        this.argoutDescBtn.setBorder(new SoftBevelBorder(0));
        this.argoutDescBtn.setHorizontalAlignment(2);
        this.argoutDescBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CommandDialog.this.descBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 20);
        jPanel.add((Component)this.argoutDescBtn, gridBagConstraints);
        this.polledBtn.setFont(new Font("Arial", 1, 12));
        this.polledBtn.setText("Polled  ");
        this.polledBtn.setHorizontalAlignment(2);
        this.polledBtn.setHorizontalTextPosition(2);
        this.polledBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CommandDialog.this.polledBtnActionPerformed(actionEvent);
            }
        });
        jPanel2.add(this.polledBtn);
        this.polledTxt.setColumns(8);
        this.polledTxt.setFont(new Font("Arial", 1, 12));
        jPanel2.add(this.polledTxt);
        this.polledLbl.setText("ms");
        jPanel2.add(this.polledLbl);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 15, 0);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        jLabel4.setFont(new Font("Arial", 1, 12));
        jLabel4.setText("Controlled by : ");
        jPanel3.add(jLabel4);
        this.levelBtn.setFont(new Font("Arial", 1, 12));
        this.levelBtn.setText("Expert Only");
        jPanel3.add(this.levelBtn);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(15, 10, 0, 0);
        jPanel.add((Component)jPanel3, gridBagConstraints);
        jLabel5.setFont(new Font("Arial", 1, 12));
        jLabel5.setText("Command description:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 20, 0, 10);
        jPanel.add((Component)jLabel5, gridBagConstraints);
        jScrollPane.setPreferredSize(new Dimension(326, 150));
        this.descText.setColumns(35);
        this.descText.setRows(1);
        jScrollPane.setViewportView(this.descText);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 40, 10, 10);
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        jScrollPane2.setPreferredSize(new Dimension(246, 70));
        this.arginDescText.setColumns(30);
        this.arginDescText.setRows(2);
        jScrollPane2.setViewportView(this.arginDescText);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 40, 0, 0);
        jPanel.add((Component)jScrollPane2, gridBagConstraints);
        jScrollPane3.setPreferredSize(new Dimension(246, 70));
        this.argoutDescText.setColumns(30);
        this.argoutDescText.setRows(2);
        jScrollPane3.setViewportView(this.argoutDescText);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.insets = new Insets(0, 40, 0, 0);
        jPanel.add((Component)jScrollPane3, gridBagConstraints);
        this.getContentPane().add((Component)jPanel, "Center");
        jButton.setText("OK");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CommandDialog.this.okBtnActionPerformed(actionEvent);
            }
        });
        jPanel4.add(jButton);
        jButton2.setText("Cancel");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CommandDialog.this.cancelBtnActionPerformed(actionEvent);
            }
        });
        jPanel4.add(jButton2);
        this.getContentPane().add((Component)jPanel4, "South");
        this.pack();
    }

    private void okBtnActionPerformed(ActionEvent actionEvent) {
        block5: {
            try {
                String string = (String)this.nameComboBox.getSelectedItem();
                boolean bl = this.overloadBtn.getSelectedObjects() != null;
                string = Utils.checkNameSyntax(string, "name", this.isStateStatus);
                if (this.pogo_gui.itemAlreadyExists(string, 2)) {
                    throw new PogoException("Command \"" + string + "\" Already Exists !");
                }
                if (this.polledBtn.getSelectedObjects() == null) break block5;
                try {
                    Integer.parseInt(this.polledTxt.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    throw new PogoException("Bad polling period.");
                }
            }
            catch (PogoException pogoException) {
                pogoException.popup(this);
                return;
            }
        }
        this.retVal = 0;
        this.doClose();
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.retVal = 2;
        this.doClose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.retVal = 2;
        this.doClose();
    }

    private void descBtnActionPerformed(ActionEvent actionEvent) {
        String string;
        JButton jButton = (JButton)actionEvent.getSource();
        if (jButton == this.arginDescBtn) {
            string = this.arginDescText.getText();
        } else if (jButton == this.argoutDescBtn) {
            string = this.argoutDescText.getText();
        } else {
            return;
        }
        EditDialog editDialog = new EditDialog(this, string);
        if (editDialog.showDialog() == 0) {
            if (jButton == this.arginDescBtn) {
                this.arginDescText.setText(editDialog.getText());
            } else if (jButton == this.argoutDescBtn) {
                this.argoutDescText.setText(editDialog.getText());
            }
        }
    }

    private void polledBtnActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.polledBtn.getSelectedObjects() != null;
        this.polledTxt.setEnabled(bl);
    }

    private void abstractBtnActionPerformed(ActionEvent actionEvent) {
    }

    private void overloadBtnActionPerformed(ActionEvent actionEvent) {
    }

    private void arginComboBoxActionPerformed(ActionEvent actionEvent) {
        if (this.isVisible()) {
            boolean bl;
            boolean bl2 = bl = this.arginComboBox.getSelectedIndex() == 0;
            if (!bl) {
                this.polledBtn.setSelected(false);
                this.polledTxt.setEnabled(false);
            }
            this.polledBtn.setEnabled(bl);
        }
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    Command getCommand() {
        Command command = OAWutils.factory.createCommand();
        String string = (String)this.nameComboBox.getSelectedItem();
        try {
            boolean bl = this.overloadBtn.getSelectedObjects() != null;
            string = Utils.checkNameSyntax(string, "name", bl);
        }
        catch (PogoException pogoException) {
            // empty catch block
        }
        command.setName(string);
        command.setExecMethod(Utils.buildCppExecuteMethodName(string));
        String string2 = Utils.strReplaceSpecialCharToCode(this.descText.getText());
        command.setDescription(string2);
        Argument argument = OAWutils.factory.createArgument();
        Argument argument2 = OAWutils.factory.createArgument();
        Type type = OAWutils.tango2pogoType(this.arginComboBox.getSelectedItem().toString());
        Type type2 = OAWutils.tango2pogoType(this.argoutComboBox.getSelectedItem().toString());
        argument.setType(type);
        argument2.setType(type2);
        string2 = Utils.strReplaceSpecialCharToCode(this.arginDescText.getText());
        argument.setDescription(string2);
        string2 = Utils.strReplaceSpecialCharToCode(this.argoutDescText.getText());
        argument2.setDescription(string2);
        command.setArgin(argument);
        command.setArgout(argument2);
        if (this.levelBtn.getSelectedObjects() == null) {
            command.setDisplayLevel(PogoConst.strLevel[0]);
        } else {
            command.setDisplayLevel(PogoConst.strLevel[1]);
        }
        if (this.isDynamic) {
            command.setIsDynamic("true");
        } else {
            command.setIsDynamic("false");
            if (Utils.isTrue(this.orig_status.getInherited())) {
                if (this.overloadBtn.getSelectedObjects() != null) {
                    this.orig_status.setConcrete("true");
                    this.orig_status.setConcreteHere("true");
                } else {
                    this.orig_status.setConcreteHere("false");
                }
            } else if (this.abstractBtn.getSelectedObjects() != null) {
                this.orig_status.setAbstract("true");
                this.orig_status.setConcrete("false");
                this.orig_status.setConcreteHere("false");
            } else {
                this.orig_status.setAbstract("false");
                this.orig_status.setConcrete("true");
                this.orig_status.setConcreteHere("true");
            }
        }
        command.setStatus(this.orig_status);
        if (this.polledBtn.getSelectedObjects() != null) {
            command.setPolledPeriod(this.polledTxt.getText());
        } else {
            command.setPolledPeriod("0");
        }
        if (this.command != null) {
            EList<String> eList = this.command.getExcludedStates();
            EList<String> eList2 = command.getExcludedStates();
            for (String string3 : eList) {
                eList2.add(string3);
            }
        }
        return command;
    }

    public static Command cloneCommand(Command command) {
        Command command2 = OAWutils.cloneCommand(command);
        InheritanceStatus inheritanceStatus = command2.getStatus();
        if (!Utils.isTrue(inheritanceStatus.getAbstract())) {
            inheritanceStatus.setAbstract("false");
            inheritanceStatus.setInherited("false");
            inheritanceStatus.setConcrete("true");
            inheritanceStatus.setConcreteHere("true");
        }
        if (Utils.isTrue(inheritanceStatus.getInherited())) {
            inheritanceStatus.setAbstract("false");
            inheritanceStatus.setInherited("false");
            inheritanceStatus.setConcrete("true");
            inheritanceStatus.setConcreteHere("true");
        }
        command2.setStatus(inheritanceStatus);
        return command2;
    }

    public int showDialog() {
        this.setVisible(true);
        return this.retVal;
    }

    public static void popupSummary(JFrame jFrame, ArrayList<Command> arrayList) {
        ArrayList<ArrayList<String>> arrayList2 = CommandDialog.buildSummary(arrayList);
        String string = Integer.toString(arrayList.size()) + "  Commands";
        PopupTable popupTable = new PopupTable(jFrame, string, columnTitle, arrayList2);
        int n = arrayList.size();
        if (n > 35) {
            n = 35;
        }
        popupTable.setPreferredSize(columnSize, n);
        popupTable.setVisible(true);
    }

    public static ArrayList<ArrayList<String>> buildSummary(ArrayList<Command> arrayList) {
        ArrayList<ArrayList<String>> arrayList2 = new ArrayList<ArrayList<String>>();
        for (Command command : arrayList) {
            ArrayList<String> arrayList3 = new ArrayList<String>();
            arrayList3.add(command.getName());
            arrayList3.add(OAWutils.pogo2tangoType(command.getArgin().getType().toString()));
            arrayList3.add(OAWutils.pogo2tangoType(command.getArgout().getType().toString()));
            if (Utils.isEquals(command.getDisplayLevel(), PogoConst.strLevel[1])) {
                arrayList3.add(PogoConst.strLevel[1]);
            } else {
                arrayList3.add(PogoConst.strLevel[0]);
            }
            InheritanceStatus inheritanceStatus = command.getStatus();
            arrayList3.add(Utils.strBoolean(inheritanceStatus.getInherited()));
            boolean bl = Utils.isTrue(inheritanceStatus.getConcrete()) || Utils.isTrue(inheritanceStatus.getConcreteHere());
            arrayList3.add("" + !bl);
            arrayList3.add(Utils.strReplace(command.getDescription(), "\\n", "\n"));
            arrayList2.add(arrayList3);
        }
        return arrayList2;
    }
}

