/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator;

import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenClassifier;
import org.eclipse.emf.codegen.ecore.genmodel.GenDataType;
import org.eclipse.emf.codegen.ecore.genmodel.GenEnum;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.generator.ecore.EMFGeneratorFragment;
import org.eclipse.xtext.generator.ecore.EcoreGeneratorFragment;

public class GenModelAccess {
    public static GenClass getGenClass(EClass cls, ResourceSet resourceSet) {
        return (GenClass)GenModelAccess.getGenClassifier(cls, resourceSet);
    }

    public static GenClassifier getGenClassifier(EClassifier cls, ResourceSet resourceSet) {
        GenPackage genPackage = GenModelAccess.getGenPackage(cls.getEPackage(), resourceSet);
        for (GenClassifier genCls : genPackage.getGenClassifiers()) {
            if (!cls.getName().equals(genCls.getEcoreClassifier().getName())) continue;
            return genCls;
        }
        throw new RuntimeException("No GenClassifier named '" + cls.getName() + "' found in GenModel " + genPackage.eResource().getURI());
    }

    public static GenDataType getGenDataType(EDataType dt, ResourceSet resourceSet) {
        return (GenDataType)GenModelAccess.getGenClassifier(dt, resourceSet);
    }

    public static GenEnum getGenEnum(EEnum en, ResourceSet resourceSet) {
        return (GenEnum)GenModelAccess.getGenClassifier(en, resourceSet);
    }

    public static GenFeature getGenFeature(EStructuralFeature feature, ResourceSet resourceSet) {
        GenClass genCls = (GenClass)GenModelAccess.getGenClassifier(feature.getEContainingClass(), resourceSet);
        for (GenFeature genFeat : genCls.getGenFeatures()) {
            if (!feature.getName().equals(genFeat.getEcoreFeature().getName())) continue;
            return genFeat;
        }
        throw new RuntimeException("No GenClassifier named '" + feature.getName() + "' found in GenClass '" + genCls + "' from GenModel" + genCls.eResource().getURI());
    }

    public static String getGenIntLiteral(EClass clazz, EStructuralFeature feature, ResourceSet resourceSet) {
        GenFeature genFeature = GenModelAccess.getGenFeature(feature, resourceSet);
        GenClass genClass = GenModelAccess.getGenClass(clazz, resourceSet);
        return String.valueOf(genClass.getGenPackage().getPackageInterfaceName()) + "." + genClass.getFeatureID(genFeature);
    }

    public static String getGenIntLiteral(EClassifier classifier, ResourceSet resourceSet) {
        GenClassifier genClassifier = GenModelAccess.getGenClassifier(classifier, resourceSet);
        return String.valueOf(genClassifier.getGenPackage().getPackageInterfaceName()) + "." + genClassifier.getClassifierID();
    }

    public static GenPackage getGenPackage(EPackage pkg, ResourceSet resourceSet) {
        Resource genModelResource;
        String nsURI = pkg.getNsURI();
        String location = null;
        if (pkg.eResource() != null && pkg.eResource().getURI() != null) {
            location = pkg.eResource().getURI().toString();
        }
        if ((genModelResource = GenModelAccess.getGenModelResource(location, nsURI, resourceSet)) != null) {
            for (EObject model : genModelResource.getContents()) {
                GenPackage genPkg;
                if (!(model instanceof GenModel) || (genPkg = ((GenModel)model).findGenPackage(pkg)) == null) continue;
                genPkg.getEcorePackage().getEClassifiers();
                return genPkg;
            }
            throw new RuntimeException("No GenPackage for NsURI " + nsURI + " found in " + genModelResource.getURI());
        }
        throw new RuntimeException("No GenPackage for NsURI " + nsURI + ".");
    }

    public static Resource getGenModelResource(String locationInfo, String nsURI, ResourceSet resourceSet) {
        URI genModelURI = EcorePlugin.getEPackageNsURIToGenModelLocationMap(false).get(nsURI);
        if (genModelURI == null) {
            if ("http://www.eclipse.org/emf/2002/Ecore".equals(nsURI)) {
                return null;
            }
            for (Resource res : resourceSet.getResources()) {
                for (EObject obj : res.getContents()) {
                    if (!(obj instanceof GenModel)) continue;
                    for (GenPackage genPackage : ((GenModel)obj).getGenPackages()) {
                        if (!genPackage.getNSURI().equals(nsURI)) continue;
                        return genPackage.eResource();
                    }
                }
            }
            StringBuilder buf = new StringBuilder();
            locationInfo = locationInfo != null && locationInfo.length() > 0 ? " from " + locationInfo : "";
            buf.append("Could not find a GenModel for EPackage '").append(nsURI).append("'").append(locationInfo).append("\n");
            buf.append("If the missing GenModel has been generated via " + EMFGeneratorFragment.class.getSimpleName() + " or " + EcoreGeneratorFragment.class.getSimpleName());
            buf.append(" make sure to run it first in the workflow.\n");
            buf.append("If you have a *.genmodel-file, make sure to register it via StandaloneSetup.registerGenModelFile(String)");
            throw new RuntimeException(buf.toString());
        }
        if (resourceSet == null) {
            throw new RuntimeException("There is no ResourceSet for EPackage '" + nsURI + "'. " + "Please make sure the EPackage has been loaded from a .ecore file " + "and not from the generated Java file.");
        }
        Resource genModelResource = resourceSet.getResource(genModelURI, true);
        if (genModelResource == null) {
            throw new RuntimeException("Error loading GenModel " + genModelURI);
        }
        for (EObject content : genModelResource.getContents()) {
            if (!(content instanceof GenModel)) continue;
            ((GenModel)content).reconcile();
        }
        return genModelResource;
    }

    public static String getGenTypeLiteral(EClassifier classifier, ResourceSet resourceSet) {
        GenClassifier genClassifier = GenModelAccess.getGenClassifier(classifier, resourceSet);
        String pkg = genClassifier.getGenPackage().getPackageInterfaceName();
        if (genClassifier.getGenPackage().isLiteralsInterface()) {
            return String.valueOf(pkg) + ".Literals." + genClassifier.getClassifierID();
        }
        return String.valueOf(pkg) + ".eINSTANCE.get" + genClassifier.getClassifierAccessorName() + "()";
    }

    public static String getGenTypeLiteral(EPackage pkg, ResourceSet resourceSet) {
        return String.valueOf(GenModelAccess.getGenPackage(pkg, resourceSet).getPackageInterfaceName()) + ".eINSTANCE";
    }

    public static String getGenTypeLiteral(EStructuralFeature feature, ResourceSet resourceSet) {
        GenFeature genFeature = GenModelAccess.getGenFeature(feature, resourceSet);
        String pkg = genFeature.getGenPackage().getPackageInterfaceName();
        if (genFeature.getGenPackage().isLiteralsInterface()) {
            return String.valueOf(pkg) + ".Literals." + genFeature.getGenClass().getFeatureID(genFeature);
        }
        return String.valueOf(pkg) + ".eINSTANCE.get" + genFeature.getFeatureAccessorName() + "()";
    }

    public static String getJavaTypeName(EClassifier classifier, ResourceSet resourceSet) {
        GenClassifier genClassifier = GenModelAccess.getGenClassifier(classifier, resourceSet);
        if (genClassifier instanceof GenClass) {
            return ((GenClass)genClassifier).getQualifiedInterfaceName();
        }
        return ((GenDataType)genClassifier).getQualifiedInstanceClassName();
    }
}

