/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.xtext;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.xtext.AbstractTypeScope;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.AbstractScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConstructorScope
extends AbstractScope {
    private AbstractTypeScope typeScope;

    protected AbstractConstructorScope(AbstractTypeScope typeScope) {
        super(IScope.NULLSCOPE, false);
        this.typeScope = typeScope;
    }

    @Override
    public Iterable<IEObjectDescription> getElements(EObject object) {
        if (object instanceof JvmConstructor) {
            JvmConstructor constructor = (JvmConstructor)object;
            String qualifiedNameWithDots = constructor.getQualifiedName('.');
            String qualifiedNameWithDollar = constructor.getQualifiedName();
            if (qualifiedNameWithDollar.equals(qualifiedNameWithDots)) {
                Set<IEObjectDescription> result = Collections.singleton(EObjectDescription.create(this.getQualifiedNameConverter().toQualifiedName(qualifiedNameWithDots), object));
                return result;
            }
            return Arrays.asList(EObjectDescription.create(this.getQualifiedNameConverter().toQualifiedName(qualifiedNameWithDots), object), EObjectDescription.create(this.getQualifiedNameConverter().toQualifiedName(qualifiedNameWithDollar), object));
        }
        return Collections.emptySet();
    }

    @Override
    public Iterable<IEObjectDescription> getElements(final QualifiedName name) {
        IEObjectDescription typeDescription = this.typeScope.getSingleElement(name);
        if (typeDescription == null) {
            return Collections.emptySet();
        }
        JvmType type = (JvmType)typeDescription.getEObjectOrProxy();
        if (type.eIsProxy() || !(type instanceof JvmGenericType)) {
            return Collections.emptySet();
        }
        final JvmGenericType castedType = (JvmGenericType)type;
        if (castedType.isInterface()) {
            return Collections.emptySet();
        }
        Iterable<JvmConstructor> constructors = new Iterable<JvmConstructor>(){

            @Override
            public Iterator<JvmConstructor> iterator() {
                return castedType.getDeclaredConstructors().iterator();
            }
        };
        return Iterables.transform(constructors, new Function<JvmConstructor, IEObjectDescription>(){

            @Override
            public IEObjectDescription apply(JvmConstructor from) {
                return EObjectDescription.create(name, (EObject)from);
            }
        });
    }

    @Override
    public IEObjectDescription getSingleElement(QualifiedName name) {
        Iterable<IEObjectDescription> byName = this.getElements(name);
        Iterator<IEObjectDescription> iterator = byName.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    @Override
    public final Iterable<IEObjectDescription> getAllElements() {
        return this.internalGetAllElements();
    }

    @Override
    protected Iterable<IEObjectDescription> getAllLocalElements() {
        throw new UnsupportedOperationException();
    }

    protected Iterable<IEObjectDescription> internalGetAllElements() {
        throw new UnsupportedOperationException();
    }

    public AbstractTypeScope getTypeScope() {
        return this.typeScope;
    }

    public IQualifiedNameConverter getQualifiedNameConverter() {
        return this.getTypeScope().getQualifiedNameConverter();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName();
    }
}

