/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.builderState.impl;

import java.io.IOException;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.impl.BinaryResourceImpl;
import org.eclipse.xtext.builder.builderState.BuilderStateFactory;
import org.eclipse.xtext.builder.builderState.BuilderStatePackage;
import org.eclipse.xtext.builder.builderState.EObjectDescription;
import org.eclipse.xtext.builder.builderState.ReferenceDescription;
import org.eclipse.xtext.builder.builderState.impl.EObjectDescriptionImpl;
import org.eclipse.xtext.builder.builderState.impl.ReferenceDescriptionImpl;
import org.eclipse.xtext.builder.builderState.impl.ResourceDescriptionImpl;
import org.eclipse.xtext.builder.builderState.impl.UserDataEntryImpl;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuilderStateFactoryImpl
extends EFactoryImpl
implements BuilderStateFactory {
    private static final BinaryResourceImpl.DataConverter<QualifiedName> QUALIFIED_NAME_DATA_CONVERTER = new BinaryResourceImpl.DataConverter<QualifiedName>(){

        @Override
        public QualifiedName read(BinaryResourceImpl.EObjectInputStream eObjectInputStream) throws IOException {
            return QualifiedName.createFromStream(eObjectInputStream);
        }

        @Override
        protected void doWrite(BinaryResourceImpl.EObjectOutputStream eObjectOutputStream, QualifiedName value) throws IOException {
            value.writeToStream(eObjectOutputStream);
        }
    };
    private static final BinaryResourceImpl.DataConverter<URI> URI_DATA_CONVERTER = new BinaryResourceImpl.DataConverter<URI>(){

        @Override
        public URI read(BinaryResourceImpl.EObjectInputStream eObjectInputStream) throws IOException {
            return eObjectInputStream.readURI();
        }

        @Override
        protected void doWrite(BinaryResourceImpl.EObjectOutputStream eObjectOutputStream, URI value) throws IOException {
            eObjectOutputStream.writeURI(value);
        }
    };

    public static BuilderStateFactory init() {
        try {
            BuilderStateFactory theBuilderStateFactory = (BuilderStateFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/xtext/builderstate/1.0");
            if (theBuilderStateFactory != null) {
                return theBuilderStateFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log(exception);
        }
        return new BuilderStateFactoryImpl();
    }

    @Override
    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return (EObject)((Object)this.createResourceDescription());
            }
            case 1: {
                return this.createEObjectDescription();
            }
            case 2: {
                return (EObject)((Object)this.createUserDataEntry());
            }
            case 3: {
                return this.createReferenceDescription();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    @Override
    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 6: {
                return this.createEURIFromString(eDataType, initialValue);
            }
            case 7: {
                return this.createEStringArrayFromString(eDataType, initialValue);
            }
            case 8: {
                return this.createQualifiedNameFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 6: {
                return this.convertEURIToString(eDataType, instanceValue);
            }
            case 7: {
                return this.convertEStringArrayToString(eDataType, instanceValue);
            }
            case 8: {
                return this.convertQualifiedNameToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public IResourceDescription createResourceDescription() {
        ResourceDescriptionImpl resourceDescription = new ResourceDescriptionImpl();
        return resourceDescription;
    }

    @Override
    public EObjectDescription createEObjectDescription() {
        EObjectDescriptionImpl eObjectDescription = new EObjectDescriptionImpl();
        return eObjectDescription;
    }

    public Map.Entry<String, String> createUserDataEntry() {
        UserDataEntryImpl userDataEntry = new UserDataEntryImpl();
        return userDataEntry;
    }

    @Override
    public ReferenceDescription createReferenceDescription() {
        ReferenceDescriptionImpl referenceDescription = new ReferenceDescriptionImpl();
        return referenceDescription;
    }

    public URI createEURIFromString(EDataType eDataType, String initialValue) {
        return URI.createURI(initialValue, true);
    }

    public String convertEURIToString(EDataType eDataType, Object instanceValue) {
        URI uri = (URI)instanceValue;
        return uri.toString();
    }

    public Object[] createEStringArrayFromString(EDataType eDataType, String initialValue) {
        return (Object[])super.createFromString(initialValue);
    }

    public String convertEStringArrayToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(instanceValue);
    }

    public QualifiedName createQualifiedNameFromString(EDataType eDataType, String initialValue) {
        return QualifiedName.create(Strings.unpack(initialValue));
    }

    public String convertQualifiedNameToString(EDataType eDataType, Object instanceValue) {
        QualifiedName qn = (QualifiedName)instanceValue;
        String[] array = qn.getSegments().toArray(new String[qn.getSegmentCount()]);
        String packed = Strings.pack(array);
        if (packed == null) {
            return "";
        }
        return packed;
    }

    @Override
    public BinaryResourceImpl.DataConverter<?> create(EDataType eDataType) {
        if (eDataType == BuilderStatePackage.Literals.QUALIFIED_NAME) {
            return QUALIFIED_NAME_DATA_CONVERTER;
        }
        if (eDataType == BuilderStatePackage.Literals.EURI) {
            return URI_DATA_CONVERTER;
        }
        return super.create(eDataType);
    }

    @Override
    public BuilderStatePackage getBuilderStatePackage() {
        return (BuilderStatePackage)this.getEPackage();
    }

    @Deprecated
    public static BuilderStatePackage getPackage() {
        return BuilderStatePackage.eINSTANCE;
    }
}

