/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.builderState;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.builder.builderState.IBuilderState;
import org.eclipse.xtext.builder.builderState.IMarkerUpdater;
import org.eclipse.xtext.builder.builderState.Messages;
import org.eclipse.xtext.builder.builderState.PersistedStateProvider;
import org.eclipse.xtext.builder.impl.BuildData;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.impl.AbstractResourceDescriptionChangeEventSource;
import org.eclipse.xtext.resource.impl.DefaultResourceDescriptionDelta;
import org.eclipse.xtext.resource.impl.ResourceDescriptionChangeEvent;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsData;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.ui.resource.IStorage2UriMapperExtension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBuilderState
extends AbstractResourceDescriptionChangeEventSource
implements IBuilderState {
    private volatile ResourceDescriptionsData resourceDescriptionData = new ResourceDescriptionsData(Collections.<IResourceDescription>emptyList());
    @Inject
    private IMarkerUpdater markerUpdater;
    @Inject
    private PersistedStateProvider persister;
    @Inject
    private IStorage2UriMapper storage2UriMapper;
    private volatile boolean isLoaded = false;

    public synchronized void load() {
        if (!this.isLoaded) {
            this.resourceDescriptionData = new ResourceDescriptionsData(this.persister.load());
            if (this.storage2UriMapper instanceof IStorage2UriMapperExtension) {
                ((IStorage2UriMapperExtension)this.storage2UriMapper).initializeCache();
            }
            this.isLoaded = true;
        }
    }

    protected void ensureLoaded() {
        if (!this.isLoaded) {
            this.load();
        }
    }

    protected Set<URI> ensureNotNull(Set<URI> uris) {
        return uris != null ? uris : Collections.emptySet();
    }

    protected void setResourceDescriptionsData(ResourceDescriptionsData newData) {
        this.resourceDescriptionData = newData;
    }

    protected void updateMarkers(IResourceDescription.Delta delta, ResourceSet resourceSet, IProgressMonitor monitor) {
        this.markerUpdater.updateMarkers(delta, resourceSet, monitor);
    }

    protected ResourceDescriptionsData getCopiedResourceDescriptionsData() {
        return this.resourceDescriptionData.copy();
    }

    @Override
    public Iterable<IResourceDescription> getAllResourceDescriptions() {
        this.ensureLoaded();
        return this.resourceDescriptionData.getAllResourceDescriptions();
    }

    @Override
    public IResourceDescription getResourceDescription(URI uri) {
        this.ensureLoaded();
        return this.resourceDescriptionData.getResourceDescription(uri);
    }

    public void setPersister(PersistedStateProvider persister) {
        this.persister = persister;
    }

    @Override
    public synchronized ImmutableList<IResourceDescription.Delta> update(BuildData buildData, IProgressMonitor monitor) {
        this.ensureLoaded();
        SubMonitor subMonitor = SubMonitor.convert(monitor, Messages.AbstractBuilderState_0, 1);
        subMonitor.subTask(Messages.AbstractBuilderState_0);
        if (buildData.isEmpty()) {
            return ImmutableList.of();
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        ResourceDescriptionsData newData = this.getCopiedResourceDescriptionsData();
        Collection<IResourceDescription.Delta> result = this.doUpdate(buildData, newData, subMonitor.newChild(1));
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        ResourceDescriptionChangeEvent event = new ResourceDescriptionChangeEvent(result);
        this.setResourceDescriptionsData(newData);
        this.notifyListeners(event);
        return event.getDeltas();
    }

    protected abstract Collection<IResourceDescription.Delta> doUpdate(BuildData var1, ResourceDescriptionsData var2, IProgressMonitor var3);

    @Override
    public synchronized ImmutableList<IResourceDescription.Delta> clean(Set<URI> toBeRemoved, IProgressMonitor monitor) {
        this.ensureLoaded();
        toBeRemoved = this.ensureNotNull(toBeRemoved);
        SubMonitor subMonitor = SubMonitor.convert(monitor, Messages.AbstractBuilderState_0, 2);
        subMonitor.subTask(Messages.AbstractBuilderState_0);
        if (toBeRemoved.isEmpty()) {
            return ImmutableList.of();
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        Collection<IResourceDescription.Delta> deltas = this.doClean(toBeRemoved, subMonitor.newChild(1));
        ResourceDescriptionsData newData = this.getCopiedResourceDescriptionsData();
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        for (IResourceDescription.Delta delta : deltas) {
            newData.removeDescription(delta.getOld().getURI());
        }
        ResourceDescriptionChangeEvent event = new ResourceDescriptionChangeEvent(deltas);
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        subMonitor.setWorkRemaining(event.getDeltas().size());
        for (IResourceDescription.Delta delta : event.getDeltas()) {
            this.updateMarkers(delta, null, subMonitor);
            subMonitor.worked(1);
        }
        this.setResourceDescriptionsData(newData);
        this.notifyListeners(event);
        return event.getDeltas();
    }

    protected Collection<IResourceDescription.Delta> doClean(Set<URI> toBeRemoved, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert(monitor, Messages.AbstractBuilderState_2, toBeRemoved.size());
        subMonitor.subTask(Messages.AbstractBuilderState_2);
        LinkedHashSet<IResourceDescription.Delta> result = Sets.newLinkedHashSet();
        for (URI toDelete : toBeRemoved) {
            IResourceDescription resourceDescription = this.getResourceDescription(toDelete);
            if (resourceDescription != null) {
                result.add(new DefaultResourceDescriptionDelta(resourceDescription, null));
            }
            subMonitor.worked(1);
        }
        return result;
    }

    @Override
    public Iterable<IEObjectDescription> getExportedObjects() {
        this.ensureLoaded();
        return this.resourceDescriptionData.getExportedObjects();
    }

    @Override
    public Iterable<IEObjectDescription> getExportedObjects(EClass type, QualifiedName name, boolean ignoreCase) {
        this.ensureLoaded();
        return this.resourceDescriptionData.getExportedObjects(type, name, ignoreCase);
    }

    @Override
    public Iterable<IEObjectDescription> getExportedObjectsByType(EClass type) {
        this.ensureLoaded();
        return this.resourceDescriptionData.getExportedObjectsByType(type);
    }

    @Override
    public Iterable<IEObjectDescription> getExportedObjectsByObject(EObject object) {
        this.ensureLoaded();
        return this.resourceDescriptionData.getExportedObjectsByObject(object);
    }

    @Override
    public boolean isEmpty() {
        this.ensureLoaded();
        return this.resourceDescriptionData.isEmpty();
    }
}

