/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.themes;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.css.swt.theme.ITheme;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.e4.ui.internal.css.swt.definition.IThemeElementDefinitionOverridable;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.themes.ColorDefinition;
import org.eclipse.ui.internal.themes.FontDefinition;
import org.eclipse.ui.internal.themes.IThemeDescriptor;
import org.eclipse.ui.internal.themes.IThemeRegistry;
import org.eclipse.ui.internal.themes.Theme;
import org.eclipse.ui.internal.themes.ThemeElementDefinition;
import org.eclipse.ui.internal.themes.ThemeElementHelper;
import org.eclipse.ui.internal.themes.ThemeRegistry;
import org.eclipse.ui.internal.themes.ThemeRegistryReader;
import org.eclipse.ui.internal.themes.ThemesExtension;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.themes.IThemeManager;
import org.osgi.service.event.EventHandler;

public class WorkbenchThemeManager
extends EventManager
implements IThemeManager {
    public static RGB EMPTY_COLOR_VALUE = new RGB(0, 1, 2);
    public static FontData[] EMPRY_FONT_DATA_VALUE = PreferenceConverter.FONTDATA_ARRAY_DEFAULT_DEFAULT;
    private static final String SYSTEM_DEFAULT_THEME = "org.eclipse.ui.ide.systemDefault";
    private static WorkbenchThemeManager instance;
    private IEclipseContext context;
    private IEventBroker eventBroker;
    private org.eclipse.ui.themes.ITheme currentTheme;
    private IPropertyChangeListener currentThemeListener = new IPropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            WorkbenchThemeManager.this.firePropertyChange(event);
            if (event.getSource() instanceof FontRegistry) {
                JFaceResources.getFontRegistry().put(event.getProperty(), (FontData[])event.getNewValue());
            } else if (event.getSource() instanceof ColorRegistry) {
                JFaceResources.getColorRegistry().put(event.getProperty(), (RGB)event.getNewValue());
            }
        }
    };
    private ColorRegistry defaultThemeColorRegistry;
    private FontRegistry defaultThemeFontRegistry;
    private IThemeRegistry themeRegistry;
    private Map themes = new HashMap(7);
    private EventHandler themeChangedHandler = new WorkbenchThemeChangedHandler();
    private EventHandler themeRegistryModifiedHandler = new ThemeRegistryModifiedHandler();

    public static WorkbenchThemeManager getInstance() {
        if (instance == null && PlatformUI.getWorkbench().getDisplay() != null) {
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    WorkbenchThemeManager.getInternalInstance();
                }
            });
        }
        return instance;
    }

    private static synchronized WorkbenchThemeManager getInternalInstance() {
        if (instance == null) {
            instance = new WorkbenchThemeManager();
            instance.getCurrentTheme();
        }
        return instance;
    }

    private WorkbenchThemeManager() {
        this.defaultThemeColorRegistry = new ColorRegistry(PlatformUI.getWorkbench().getDisplay());
        this.defaultThemeFontRegistry = new FontRegistry(PlatformUI.getWorkbench().getDisplay());
        FontRegistry jfaceFonts = JFaceResources.getFontRegistry();
        for (String key : jfaceFonts.getKeySet()) {
            this.defaultThemeFontRegistry.put(key, jfaceFonts.getFontData(key));
        }
        String themeId = PrefUtil.getAPIPreferenceStore().getDefaultString("CURRENT_THEME_ID");
        if (themeId.length() == 0) {
            themeId = "org.eclipse.ui.defaultTheme";
        }
        boolean highContrast = Display.getCurrent().getHighContrast();
        Display.getCurrent().addListener(39, new Listener(){

            @Override
            public void handleEvent(Event event) {
                WorkbenchThemeManager.this.updateThemes();
            }
        });
        if (highContrast) {
            themeId = SYSTEM_DEFAULT_THEME;
        }
        PrefUtil.getAPIPreferenceStore().setDefault("CURRENT_THEME_ID", themeId);
        this.context = (IEclipseContext)Workbench.getInstance().getService(IEclipseContext.class);
        this.eventBroker = (IEventBroker)Workbench.getInstance().getService(IEventBroker.class);
        if (this.eventBroker != null) {
            this.eventBroker.subscribe("org/eclipse/e4/ui/LifeCycle/themeChanged", this.themeChangedHandler);
            this.eventBroker.subscribe("org/eclipse/e4/ui/css/swt/theme/ThemeManager/themeChanged", this.themeChangedHandler);
            this.eventBroker.subscribe("org/eclipse/ui/internal/themes/WorkbenchThemeManager/themeRegistryModified", this.themeRegistryModifiedHandler);
        }
    }

    private void updateThemes() {
        ThemeRegistryReader reader = new ThemeRegistryReader();
        reader.readThemes(Platform.getExtensionRegistry(), (ThemeRegistry)this.getThemeRegistry());
        ThemeElementHelper.populateRegistry(this.getTheme("org.eclipse.ui.defaultTheme"), this.getThemeRegistry().getColors(), PrefUtil.getInternalPreferenceStore());
        IThemeDescriptor[] themeDescriptors = this.getThemeRegistry().getThemes();
        int i = 0;
        while (i < themeDescriptors.length) {
            ColorDefinition[] colorDefinitions;
            IThemeDescriptor themeDescriptor = themeDescriptors[i];
            org.eclipse.ui.themes.ITheme theme = (org.eclipse.ui.themes.ITheme)this.themes.get(themeDescriptor);
            if (theme != null && (colorDefinitions = themeDescriptor.getColors()).length > 0) {
                ThemeElementHelper.populateRegistry(theme, colorDefinitions, PrefUtil.getInternalPreferenceStore());
            }
            ++i;
        }
    }

    @Override
    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.addListenerObject(listener);
    }

    public void dispose() {
        if (this.eventBroker != null) {
            this.eventBroker.unsubscribe(this.themeChangedHandler);
            this.eventBroker.unsubscribe(this.themeRegistryModifiedHandler);
        }
        for (org.eclipse.ui.themes.ITheme theme : this.themes.values()) {
            theme.removePropertyChangeListener(this.currentThemeListener);
            theme.dispose();
        }
        this.themes.clear();
    }

    private boolean doSetCurrentTheme(String id) {
        org.eclipse.ui.themes.ITheme oldTheme = this.currentTheme;
        org.eclipse.ui.themes.ITheme newTheme = this.getTheme(id);
        if (oldTheme != newTheme && newTheme != null) {
            this.currentTheme = newTheme;
            return true;
        }
        return false;
    }

    protected void firePropertyChange(PropertyChangeEvent event) {
        Object[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IPropertyChangeListener)listeners[i]).propertyChange(event);
            ++i;
        }
    }

    protected void firePropertyChange(String changeId, org.eclipse.ui.themes.ITheme oldTheme, org.eclipse.ui.themes.ITheme newTheme) {
        PropertyChangeEvent event = new PropertyChangeEvent(this, changeId, oldTheme, newTheme);
        this.firePropertyChange(event);
    }

    @Override
    public org.eclipse.ui.themes.ITheme getCurrentTheme() {
        if (this.currentTheme == null) {
            String themeId = PrefUtil.getAPIPreferenceStore().getString("CURRENT_THEME_ID");
            if (themeId == null) {
                this.setCurrentTheme("org.eclipse.ui.defaultTheme");
            } else {
                this.setCurrentTheme(themeId);
                if (this.currentTheme == null) {
                    this.setCurrentTheme("org.eclipse.ui.defaultTheme");
                    StatusManager.getManager().handle(StatusUtil.newStatus("org.eclipse.ui", "Could not restore current theme: " + themeId, null));
                }
            }
        }
        return this.currentTheme;
    }

    public ColorRegistry getDefaultThemeColorRegistry() {
        return this.defaultThemeColorRegistry;
    }

    public FontRegistry getDefaultThemeFontRegistry() {
        return this.defaultThemeFontRegistry;
    }

    private org.eclipse.ui.themes.ITheme getTheme(IThemeDescriptor td) {
        org.eclipse.ui.themes.ITheme theme = (org.eclipse.ui.themes.ITheme)this.themes.get(td);
        if (theme == null) {
            theme = new Theme(td);
            this.themes.put(td, theme);
        }
        return theme;
    }

    @Override
    public org.eclipse.ui.themes.ITheme getTheme(String id) {
        if (id.equals("org.eclipse.ui.defaultTheme")) {
            return this.getTheme((IThemeDescriptor)null);
        }
        IThemeDescriptor td = this.getThemeRegistry().findTheme(id);
        if (td == null) {
            return null;
        }
        return this.getTheme(td);
    }

    private IThemeRegistry getThemeRegistry() {
        if (this.themeRegistry == null) {
            this.themeRegistry = WorkbenchPlugin.getDefault().getThemeRegistry();
        }
        return this.themeRegistry;
    }

    @Override
    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.removeListenerObject(listener);
    }

    @Override
    public void setCurrentTheme(String id) {
        org.eclipse.ui.themes.ITheme oldTheme = this.currentTheme;
        if (WorkbenchThemeManager.getInstance().doSetCurrentTheme(id)) {
            this.firePropertyChange("CHANGE_CURRENT_THEME", oldTheme, this.getCurrentTheme());
            if (oldTheme != null) {
                oldTheme.removePropertyChangeListener(this.currentThemeListener);
            }
            this.currentTheme.addPropertyChangeListener(this.currentThemeListener);
            if (!PrefUtil.getAPIPreferenceStore().getString("CURRENT_THEME_ID").equals(id)) {
                PrefUtil.getAPIPreferenceStore().setValue("CURRENT_THEME_ID", id);
                PrefUtil.saveAPIPrefs();
            }
            ColorRegistry jfaceColors = JFaceResources.getColorRegistry();
            ColorRegistry themeColors = this.currentTheme.getColorRegistry();
            for (String key : themeColors.getKeySet()) {
                jfaceColors.put(key, themeColors.getRGB(key));
            }
            FontRegistry jfaceFonts = JFaceResources.getFontRegistry();
            FontRegistry themeFonts = this.currentTheme.getFontRegistry();
            for (String key : themeFonts.getKeySet()) {
                jfaceFonts.put(key, themeFonts.getFontData(key));
            }
            if (oldTheme != null && this.eventBroker != null) {
                this.eventBroker.send("org/eclipse/e4/ui/LifeCycle/themeChanged", null);
                this.eventBroker.send("org/eclipse/e4/ui/LifeCycle/themeDefinitionChanged", this.context.get(MApplication.class.getName()));
            }
        }
    }

    public static interface Events {
        public static final String TOPIC = "org/eclipse/ui/internal/themes/WorkbenchThemeManager";
        public static final String THEME_REGISTRY_RESTYLED = "org/eclipse/ui/internal/themes/WorkbenchThemeManager/themeRegistryRestyled";
        public static final String THEME_REGISTRY_MODIFIED = "org/eclipse/ui/internal/themes/WorkbenchThemeManager/themeRegistryModified";
    }

    public static class ThemeRegistryModifiedHandler
    implements EventHandler {
        public void handleEvent(org.osgi.service.event.Event event) {
            this.populateThemeRegistries(this.getThemeRegistry(), this.getFontRegistry(), this.getColorRegistry(), this.getTheme(), this.getColorsAndFontsTheme());
            this.sendThemeDefinitionChangedEvent();
        }

        protected ITheme getTheme() {
            IThemeEngine themeEngine = (IThemeEngine)this.getContext().get(IThemeEngine.class.getName());
            return themeEngine != null ? themeEngine.getActiveTheme() : null;
        }

        protected ThemeRegistry getThemeRegistry() {
            return (ThemeRegistry)this.getContext().get(IThemeRegistry.class.getName());
        }

        protected FontRegistry getFontRegistry() {
            return this.getColorsAndFontsTheme().getFontRegistry();
        }

        protected ColorRegistry getColorRegistry() {
            return this.getColorsAndFontsTheme().getColorRegistry();
        }

        protected org.eclipse.ui.themes.ITheme getColorsAndFontsTheme() {
            return WorkbenchThemeManager.getInstance().getCurrentTheme();
        }

        private IEclipseContext getContext() {
            return WorkbenchThemeManager.getInstance().context;
        }

        protected void sendThemeDefinitionChangedEvent() {
            MApplication application = (MApplication)this.getContext().get(MApplication.class.getName());
            WorkbenchThemeManager.getInternalInstance().eventBroker.send("org/eclipse/e4/ui/LifeCycle/themeDefinitionChanged", (Object)application);
        }

        protected void populateThemeRegistries(ThemeRegistry themeRegistry, FontRegistry fontRegistry, ColorRegistry colorRegistry, ITheme cssTheme, org.eclipse.ui.themes.ITheme theme) {
            ThemeElementDefinition definition;
            IPreferenceStore store = PrefUtil.getInternalPreferenceStore();
            ThemeElementDefinition[] themeElementDefinitionArray = themeRegistry.getFonts();
            int n = themeElementDefinitionArray.length;
            int n2 = 0;
            while (n2 < n) {
                definition = themeElementDefinitionArray[n2];
                if (definition.isOverridden() || definition.isAddedByCss()) {
                    this.populateDefinition(cssTheme, theme, fontRegistry, (FontDefinition)definition, store);
                }
                ++n2;
            }
            themeElementDefinitionArray = themeRegistry.getColors();
            n = themeElementDefinitionArray.length;
            n2 = 0;
            while (n2 < n) {
                definition = themeElementDefinitionArray[n2];
                if (definition.isOverridden() || definition.isAddedByCss()) {
                    this.populateDefinition(cssTheme, theme, colorRegistry, (ColorDefinition)definition, store);
                }
                ++n2;
            }
        }

        protected void populateDefinition(ITheme cssTheme, org.eclipse.ui.themes.ITheme theme, ColorRegistry registry, ColorDefinition definition, IPreferenceStore store) {
            ThemeElementHelper.populateDefinition(cssTheme, theme, registry, definition, store);
        }

        protected void populateDefinition(ITheme cssTheme, org.eclipse.ui.themes.ITheme theme, FontRegistry registry, FontDefinition definition, IPreferenceStore store) {
            ThemeElementHelper.populateDefinition(cssTheme, theme, registry, definition, store);
        }
    }

    public static class WorkbenchThemeChangedHandler
    implements EventHandler {
        public void handleEvent(org.osgi.service.event.Event event) {
            IStylingEngine engine = this.getStylingEngine();
            ThemeRegistry themeRegistry = this.getThemeRegistry();
            FontRegistry fontRegistry = this.getFontRegistry();
            ColorRegistry colorRegistry = this.getColorRegistry();
            this.resetThemeRegistries(themeRegistry, fontRegistry, colorRegistry);
            this.overrideAlreadyExistingDefinitions(event, engine, themeRegistry, fontRegistry, colorRegistry);
            this.addNewDefinitions(event, engine, themeRegistry, fontRegistry, colorRegistry);
            this.sendThemeRegistryRestyledEvent();
        }

        protected IStylingEngine getStylingEngine() {
            return (IStylingEngine)this.getContext().get(IStylingEngine.SERVICE_NAME);
        }

        protected ThemeRegistry getThemeRegistry() {
            return (ThemeRegistry)this.getContext().get(IThemeRegistry.class.getName());
        }

        protected FontRegistry getFontRegistry() {
            return this.getColorsAndFontsTheme().getFontRegistry();
        }

        protected ColorRegistry getColorRegistry() {
            return this.getColorsAndFontsTheme().getColorRegistry();
        }

        protected void sendThemeRegistryRestyledEvent() {
            IEventBroker eventBroker = (IEventBroker)this.getContext().get(IEventBroker.class.getName());
            eventBroker.send("org/eclipse/ui/internal/themes/WorkbenchThemeManager/themeRegistryRestyled", null);
        }

        protected org.eclipse.ui.themes.ITheme getColorsAndFontsTheme() {
            return WorkbenchThemeManager.getInstance().getCurrentTheme();
        }

        private IEclipseContext getContext() {
            return WorkbenchThemeManager.getInstance().context;
        }

        protected ITheme getTheme(org.osgi.service.event.Event event) {
            ITheme theme = (ITheme)event.getProperty("theme");
            if (theme == null) {
                IThemeEngine themeEngine = (IThemeEngine)this.getContext().get(IThemeEngine.class.getName());
                theme = themeEngine != null ? themeEngine.getActiveTheme() : null;
            }
            return theme;
        }

        protected void resetThemeRegistries(ThemeRegistry themeRegistry, FontRegistry fontRegistry, ColorRegistry colorRegistry) {
            ThemeElementDefinition def;
            ThemeElementDefinition[] themeElementDefinitionArray = themeRegistry.getFonts();
            int n = themeElementDefinitionArray.length;
            int n2 = 0;
            while (n2 < n) {
                def = themeElementDefinitionArray[n2];
                if (def.isOverridden()) {
                    ((FontDefinition)def).resetToDefaultValue();
                    fontRegistry.put(def.getId(), ((FontDefinition)def).getValue() != null ? ((FontDefinition)def).getValue() : EMPRY_FONT_DATA_VALUE);
                }
                ++n2;
            }
            themeElementDefinitionArray = themeRegistry.getColors();
            n = themeElementDefinitionArray.length;
            n2 = 0;
            while (n2 < n) {
                def = themeElementDefinitionArray[n2];
                if (def.isOverridden()) {
                    ((ColorDefinition)def).resetToDefaultValue();
                    colorRegistry.put(def.getId(), ((ColorDefinition)def).getValue() != null ? ((ColorDefinition)def).getValue() : EMPTY_COLOR_VALUE);
                }
                ++n2;
            }
        }

        protected void overrideAlreadyExistingDefinitions(org.osgi.service.event.Event event, IStylingEngine engine, ThemeRegistry themeRegistry, FontRegistry fontRegistry, ColorRegistry colorRegistry) {
            IPreferenceStore store = PrefUtil.getInternalPreferenceStore();
            ITheme cssTheme = this.getTheme(event);
            org.eclipse.ui.themes.ITheme theme = this.getColorsAndFontsTheme();
            ThemeElementDefinition[] themeElementDefinitionArray = themeRegistry.getFonts();
            int n = themeElementDefinitionArray.length;
            int n2 = 0;
            while (n2 < n) {
                FontDefinition fontDefinition = themeElementDefinitionArray[n2];
                engine.style((Object)fontDefinition);
                if (fontDefinition.isOverridden()) {
                    this.populateDefinition(cssTheme, theme, fontRegistry, fontDefinition, store);
                    if (!fontDefinition.isModifiedByUser()) {
                        fontRegistry.put(fontDefinition.getId(), fontDefinition.getValue());
                    }
                }
                ++n2;
            }
            themeElementDefinitionArray = themeRegistry.getColors();
            n = themeElementDefinitionArray.length;
            n2 = 0;
            while (n2 < n) {
                ThemeElementDefinition colorDefinition = themeElementDefinitionArray[n2];
                engine.style((Object)colorDefinition);
                if (colorDefinition.isOverridden()) {
                    this.populateDefinition(cssTheme, theme, colorRegistry, (ColorDefinition)colorDefinition, store);
                    if (!colorDefinition.isModifiedByUser()) {
                        colorRegistry.put(colorDefinition.getId(), ((ColorDefinition)colorDefinition).getValue());
                    }
                }
                ++n2;
            }
        }

        private void addNewDefinitions(org.osgi.service.event.Event event, IStylingEngine engine, ThemeRegistry themeRegistry, FontRegistry fontRegistry, ColorRegistry colorRegistry) {
            IPreferenceStore store = PrefUtil.getInternalPreferenceStore();
            ITheme cssTheme = this.getTheme(event);
            org.eclipse.ui.themes.ITheme theme = this.getColorsAndFontsTheme();
            ThemesExtension themesExtension = this.createThemesExtension();
            engine.style((Object)themesExtension);
            for (IThemeElementDefinitionOverridable<?> definition : themesExtension.getDefinitions()) {
                engine.style(definition);
                if (definition.isOverridden() && definition instanceof FontDefinition) {
                    this.addFontDefinition((FontDefinition)definition, themeRegistry, fontRegistry);
                    this.populateDefinition(cssTheme, theme, fontRegistry, (FontDefinition)definition, store);
                    continue;
                }
                if (!definition.isOverridden() || !(definition instanceof ColorDefinition)) continue;
                this.addColorDefinition((ColorDefinition)definition, themeRegistry, colorRegistry);
                this.populateDefinition(cssTheme, theme, colorRegistry, (ColorDefinition)definition, store);
            }
        }

        private void addFontDefinition(FontDefinition definition, ThemeRegistry themeRegistry, FontRegistry fontRegistry) {
            if (themeRegistry.findFont(definition.getId()) == null) {
                themeRegistry.add(definition);
                fontRegistry.put(definition.getId(), definition.getValue());
            }
        }

        private void addColorDefinition(ColorDefinition definition, ThemeRegistry themeRegistry, ColorRegistry colorRegistry) {
            if (themeRegistry.findColor(definition.getId()) == null) {
                themeRegistry.add(definition);
                colorRegistry.put(definition.getId(), definition.getValue());
            }
        }

        protected ThemesExtension createThemesExtension() {
            return new ThemesExtension();
        }

        protected void populateDefinition(ITheme cssTheme, org.eclipse.ui.themes.ITheme theme, ColorRegistry registry, ColorDefinition definition, IPreferenceStore store) {
            ThemeElementHelper.populateDefinition(cssTheme, theme, registry, definition, store);
        }

        protected void populateDefinition(ITheme cssTheme, org.eclipse.ui.themes.ITheme theme, FontRegistry registry, FontDefinition definition, IPreferenceStore store) {
            ThemeElementHelper.populateDefinition(cssTheme, theme, registry, definition, store);
        }
    }
}

