/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.launch;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.sisu.inject.Logs;
import org.eclipse.sisu.space.ClassSpace;
import org.eclipse.sisu.space.ClassVisitor;
import org.eclipse.sisu.space.IndexedClassFinder;
import org.eclipse.sisu.space.SpaceModule;
import org.eclipse.sisu.space.SpaceVisitor;
import org.eclipse.sisu.wire.WireModule;
import org.eclipse.sisu.wire.Wiring;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SisuExtensions
implements SpaceModule.Strategy,
WireModule.Strategy {
    private final ClassSpace space;
    private final boolean global;

    private SisuExtensions(ClassSpace space, boolean global) {
        this.space = space;
        this.global = global;
    }

    public static SisuExtensions local(ClassSpace space) {
        return new SisuExtensions(space, false);
    }

    public static SisuExtensions global(ClassSpace space) {
        return new SisuExtensions(space, true);
    }

    public <T> void install(Binder binder) {
        this.install(binder, null, null);
    }

    public <T> void install(Binder binder, Class<T> contextType, T context) {
        String index = "META-INF/services/" + Module.class.getName();
        for (String name : new IndexedClassFinder(index, this.global).indexedNames(this.space)) {
            try {
                Object instance = null;
                Class<?> impl = this.space.loadClass(name);
                if (contextType != null) {
                    try {
                        instance = impl.getConstructor(contextType).newInstance(context);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {}
                }
                binder.install(instance != null ? instance : impl.newInstance());
            }
            catch (Exception e) {
                Logs.trace("Problem installing: {}", name, e);
            }
            catch (LinkageError e) {
                Logs.trace("Problem installing: {}", name, e);
            }
        }
    }

    @Override
    public Wiring wiring(Binder binder) {
        final List<Wiring> customWiring = this.load(Wiring.class, binder);
        final Wiring defaultWiring = WireModule.Strategy.DEFAULT.wiring(binder);
        return customWiring.isEmpty() ? defaultWiring : new Wiring(){

            @Override
            public boolean wire(Key<?> key) {
                for (Wiring w : customWiring) {
                    if (!w.wire(key)) continue;
                    return true;
                }
                return defaultWiring.wire(key);
            }
        };
    }

    @Override
    public SpaceVisitor visitor(Binder binder) {
        final List<SpaceVisitor> customVisitors = this.load(SpaceVisitor.class, binder);
        final SpaceVisitor defaultVisitor = SpaceModule.Strategy.DEFAULT.visitor(binder);
        return customVisitors.isEmpty() ? defaultVisitor : new SpaceVisitor(){

            public void enterSpace(ClassSpace _space) {
                for (SpaceVisitor v : customVisitors) {
                    v.enterSpace(_space);
                }
                defaultVisitor.enterSpace(_space);
            }

            public ClassVisitor visitClass(URL url) {
                for (SpaceVisitor v : customVisitors) {
                    ClassVisitor cv = v.visitClass(url);
                    if (cv == null) continue;
                    return cv;
                }
                return defaultVisitor.visitClass(url);
            }

            public void leaveSpace() {
                for (SpaceVisitor v : customVisitors) {
                    v.leaveSpace();
                }
                defaultVisitor.leaveSpace();
            }
        };
    }

    private <T> List<T> load(Class<T> spi, Binder binder) {
        ArrayList<T> extensions = new ArrayList<T>();
        String index = "META-INF/services/" + spi.getName();
        for (String name : new IndexedClassFinder(index, this.global).indexedNames(this.space)) {
            try {
                extensions.add(spi.cast(this.space.loadClass(name).getConstructor(Binder.class).newInstance(binder)));
            }
            catch (Exception e) {
                Logs.trace("Problem loading: {}", name, e);
            }
            catch (LinkageError e) {
                Logs.trace("Problem loading: {}", name, e);
            }
        }
        return extensions;
    }
}

