/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli.event;

import org.apache.maven.cli.CLIReportingUtils;
import org.apache.maven.execution.AbstractExecutionListener;
import org.apache.maven.execution.BuildFailure;
import org.apache.maven.execution.BuildSuccess;
import org.apache.maven.execution.BuildSummary;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionEventLogger
extends AbstractExecutionListener {
    private final Logger logger;
    private static final int LINE_LENGTH = 72;
    private static final int BUILD_TIME_DURATION_LENGTH = 9;

    public ExecutionEventLogger() {
        this.logger = LoggerFactory.getLogger(ExecutionEventLogger.class);
    }

    public ExecutionEventLogger(Logger logger) {
        if (logger == null) {
            throw new IllegalArgumentException("logger missing");
        }
        this.logger = logger;
    }

    private static String chars(char c, int count) {
        StringBuilder buffer = new StringBuilder(count);
        for (int i = count; i > 0; --i) {
            buffer.append(c);
        }
        return buffer.toString();
    }

    @Override
    public void projectDiscoveryStarted(ExecutionEvent event) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Scanning for projects...");
        }
    }

    @Override
    public void sessionStarted(ExecutionEvent event) {
        if (this.logger.isInfoEnabled() && event.getSession().getProjects().size() > 1) {
            this.logger.info(ExecutionEventLogger.chars('-', 72));
            this.logger.info("Reactor Build Order:");
            this.logger.info("");
            for (MavenProject project : event.getSession().getProjects()) {
                this.logger.info(project.getName());
            }
        }
    }

    @Override
    public void sessionEnded(ExecutionEvent event) {
        if (this.logger.isInfoEnabled()) {
            if (event.getSession().getProjects().size() > 1) {
                this.logReactorSummary(event.getSession());
            }
            this.logResult(event.getSession());
            this.logStats(event.getSession());
            this.logger.info(ExecutionEventLogger.chars('-', 72));
        }
    }

    private void logReactorSummary(MavenSession session) {
        this.logger.info(ExecutionEventLogger.chars('-', 72));
        this.logger.info("Reactor Summary:");
        this.logger.info("");
        MavenExecutionResult result = session.getResult();
        for (MavenProject project : session.getProjects()) {
            String buildTimeDuration;
            StringBuilder buffer = new StringBuilder(128);
            buffer.append(project.getName());
            buffer.append(' ');
            while (buffer.length() < 51) {
                buffer.append('.');
            }
            buffer.append(' ');
            BuildSummary buildSummary = result.getBuildSummary(project);
            if (buildSummary == null) {
                buffer.append("SKIPPED");
            } else if (buildSummary instanceof BuildSuccess) {
                buffer.append("SUCCESS [");
                buildTimeDuration = CLIReportingUtils.formatDuration(buildSummary.getTime());
                buffer.append(ExecutionEventLogger.chars(' ', 9 - buildTimeDuration.length()));
                buffer.append(buildTimeDuration);
                buffer.append("]");
            } else if (buildSummary instanceof BuildFailure) {
                buffer.append("FAILURE [");
                buildTimeDuration = CLIReportingUtils.formatDuration(buildSummary.getTime());
                buffer.append(ExecutionEventLogger.chars(' ', 9 - buildTimeDuration.length()));
                buffer.append(buildTimeDuration);
                buffer.append("]");
            }
            this.logger.info(buffer.toString());
        }
    }

    private void logResult(MavenSession session) {
        this.logger.info(ExecutionEventLogger.chars('-', 72));
        if (session.getResult().hasExceptions()) {
            this.logger.info("BUILD FAILURE");
        } else {
            this.logger.info("BUILD SUCCESS");
        }
    }

    private void logStats(MavenSession session) {
        this.logger.info(ExecutionEventLogger.chars('-', 72));
        long finish = System.currentTimeMillis();
        long time = finish - session.getRequest().getStartTime().getTime();
        String wallClock = session.getRequest().getDegreeOfConcurrency() > 1 ? " (Wall Clock)" : "";
        this.logger.info("Total time: " + CLIReportingUtils.formatDuration(time) + wallClock);
        this.logger.info("Finished at: " + CLIReportingUtils.formatTimestamp(finish));
        System.gc();
        Runtime r = Runtime.getRuntime();
        long MB = 0x100000L;
        this.logger.info("Final Memory: " + (r.totalMemory() - r.freeMemory()) / MB + "M/" + r.totalMemory() / MB + "M");
    }

    @Override
    public void projectSkipped(ExecutionEvent event) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(ExecutionEventLogger.chars(' ', 72));
            this.logger.info(ExecutionEventLogger.chars('-', 72));
            this.logger.info("Skipping " + event.getProject().getName());
            this.logger.info("This project has been banned from the build due to previous failures.");
            this.logger.info(ExecutionEventLogger.chars('-', 72));
        }
    }

    @Override
    public void projectStarted(ExecutionEvent event) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(ExecutionEventLogger.chars(' ', 72));
            this.logger.info(ExecutionEventLogger.chars('-', 72));
            this.logger.info("Building " + event.getProject().getName() + " " + event.getProject().getVersion());
            this.logger.info(ExecutionEventLogger.chars('-', 72));
        }
    }

    @Override
    public void mojoSkipped(ExecutionEvent event) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("Goal " + event.getMojoExecution().getGoal() + " requires online mode for execution but Maven is currently offline, skipping");
        }
    }

    @Override
    public void mojoStarted(ExecutionEvent event) {
        if (this.logger.isInfoEnabled()) {
            StringBuilder buffer = new StringBuilder(128);
            buffer.append("--- ");
            this.append(buffer, event.getMojoExecution());
            this.append(buffer, event.getProject());
            buffer.append(" ---");
            this.logger.info("");
            this.logger.info(buffer.toString());
        }
    }

    @Override
    public void forkStarted(ExecutionEvent event) {
        if (this.logger.isInfoEnabled()) {
            StringBuilder buffer = new StringBuilder(128);
            buffer.append(">>> ");
            this.append(buffer, event.getMojoExecution());
            this.append(buffer, event.getProject());
            buffer.append(" >>>");
            this.logger.info("");
            this.logger.info(buffer.toString());
        }
    }

    @Override
    public void forkSucceeded(ExecutionEvent event) {
        if (this.logger.isInfoEnabled()) {
            StringBuilder buffer = new StringBuilder(128);
            buffer.append("<<< ");
            this.append(buffer, event.getMojoExecution());
            this.append(buffer, event.getProject());
            buffer.append(" <<<");
            this.logger.info("");
            this.logger.info(buffer.toString());
        }
    }

    private void append(StringBuilder buffer, MojoExecution me) {
        buffer.append(me.getArtifactId()).append(':').append(me.getVersion());
        buffer.append(':').append(me.getGoal());
        if (me.getExecutionId() != null) {
            buffer.append(" (").append(me.getExecutionId()).append(')');
        }
    }

    private void append(StringBuilder buffer, MavenProject project) {
        buffer.append(" @ ").append(project.getArtifactId());
    }

    @Override
    public void forkedProjectStarted(ExecutionEvent event) {
        if (this.logger.isInfoEnabled() && event.getMojoExecution().getForkedExecutions().size() > 1) {
            this.logger.info(ExecutionEventLogger.chars(' ', 72));
            this.logger.info(ExecutionEventLogger.chars('>', 72));
            this.logger.info("Forking " + event.getProject().getName() + " " + event.getProject().getVersion());
            this.logger.info(ExecutionEventLogger.chars('>', 72));
        }
    }
}

