/*
 * Decompiled with CFR 0.152.
 */
package net.danieldietrich.protectedregions.xtext;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class TangoFileUtils {
    public static String readFile(URI uri) {
        String str = "";
        File file = new File(uri.getPath());
        System.out.println(uri + " exists " + file.exists());
        try {
            FileInputStream inputStream = new FileInputStream(uri.getPath());
            int nb = inputStream.available();
            byte[] inBytes = new byte[nb];
            nb = inputStream.read(inBytes);
            inputStream.close();
            if (nb > 0) {
                str = TangoFileUtils.takeOffWindowsChar(inBytes);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return str;
    }

    private static String takeOffWindowsChar(byte[] inBytes) {
        int nb = 0;
        byte[] byArray = inBytes;
        int n = inBytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            if (b != 13) {
                ++nb;
            }
            ++n2;
        }
        byte[] outBytes = new byte[nb];
        int i = 0;
        int j = 0;
        while (i < inBytes.length) {
            if (inBytes[i] != 13) {
                outBytes[j++] = inBytes[i];
            }
            ++i;
        }
        return new String(outBytes);
    }

    public static void writeFile(URI uri, String code) {
        try {
            String fileName = uri.toString();
            if (fileName.startsWith("file:")) {
                fileName = fileName.substring("file:".length());
            }
            TangoFileUtils.buildFolder(fileName);
            String os = System.getProperty("os.name");
            if (os.toLowerCase().startsWith("windows")) {
                code = TangoFileUtils.setWindowsFileFormat(code);
            }
            FileOutputStream outputStream = new FileOutputStream(fileName);
            outputStream.write(code.getBytes());
            outputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static String setWindowsFileFormat(String code) {
        ArrayList<Byte> list = new ArrayList<Byte>();
        byte[] inBytes = code.getBytes();
        int i = 0;
        while (i < inBytes.length) {
            list.add(inBytes[i]);
            if (inBytes[i] == 13 && i < inBytes.length - 1 && inBytes[i + 1] != 10) {
                list.add((byte)10);
            }
            ++i;
        }
        byte[] outBytes = new byte[list.size()];
        int i2 = 0;
        while (i2 < list.size()) {
            outBytes[i2] = (Byte)list.get(i2);
            ++i2;
        }
        return new String(outBytes);
    }

    private static void buildFolder(String fileName) {
        StringTokenizer stk = new StringTokenizer(fileName, "/");
        String path = "";
        if (fileName.startsWith("/")) {
            path = String.valueOf(path) + '/';
        }
        path = String.valueOf(path) + stk.nextToken();
        int nbTokens = stk.countTokens();
        int i = 1;
        while (i < nbTokens) {
            File file = new File(path = String.valueOf(path) + "/" + stk.nextToken());
            if (!file.exists() && !file.mkdir()) {
                throw new RuntimeException("Cannot create " + path);
            }
            ++i;
        }
    }
}

