/*
 * Decompiled with CFR 0.152.
 */
package net.danieldietrich.protectedregions.support;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.danieldietrich.protectedregions.core.IDocument;
import net.danieldietrich.protectedregions.core.IRegionParser;
import net.danieldietrich.protectedregions.core.RegionUtil;
import net.danieldietrich.protectedregions.support.IFileSystemReader;
import net.danieldietrich.protectedregions.support.IPathFilter;
import net.danieldietrich.protectedregions.support.IProtectedRegionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtectedRegionSupport
implements IProtectedRegionSupport {
    private final transient Logger logger = LoggerFactory.getLogger(ProtectedRegionSupport.class);
    private static final IPathFilter ACCEPT_ALL_FILTER = new IPathFilter(){

        public boolean accept(URI path) {
            return true;
        }
    };
    private Map<IPathFilter, IRegionParser> parsers = new HashMap<IPathFilter, IRegionParser>();
    private Map<String, IDocument.IRegion> protectedRegionPool = new HashMap<String, IDocument.IRegion>();
    private Set<String> visitedPaths = new HashSet<String>();

    public void addParser(IRegionParser parser) {
        this.addParser(parser, (IPathFilter)null);
    }

    public void addParser(IRegionParser parser, String ... fileExtensions) {
        if (fileExtensions == null || fileExtensions.length == 0) {
            throw new IllegalArgumentException("File extensions cannot be null or empty.");
        }
        this.addParser(parser, new FileExtensionFilter(fileExtensions));
    }

    public void addParser(IRegionParser parser, IPathFilter filter) {
        if (parser == null) {
            throw new IllegalArgumentException("Parser cannot be null.");
        }
        IPathFilter parserFilter = filter == null ? ACCEPT_ALL_FILTER : filter;
        this.parsers.put(parserFilter, parser);
    }

    public void readRegions(IFileSystemReader reader, String slot) {
        if (this.parsers.isEmpty()) {
            throw new IllegalStateException("#addParser methods have to be called before #read methods.");
        }
        URI uri = reader.getUri("", slot);
        if (!reader.exists(uri)) {
            this.logger.warn("path does not exist: {}", (Object)uri.getPath());
            return;
        }
        if (!reader.hasFiles(uri)) {
            throw new IllegalArgumentException("no directory: " + uri);
        }
        String canonicalPath = reader.getCanonicalPath(uri);
        if (this.isVisited(canonicalPath)) {
            this.logger.warn("skipping already visited path '{}'.", uri);
            return;
        }
        this.internal_read(reader, uri);
        this.visitedPaths.add(canonicalPath);
    }

    private boolean isVisited(String canonicalPath) {
        for (String path : this.visitedPaths) {
            if (!canonicalPath.startsWith(path)) continue;
            return true;
        }
        return false;
    }

    private void internal_read(IFileSystemReader reader, URI path) {
        HashSet<String> visitedRegions = new HashSet<String>();
        Set<URI> files = reader.listFiles(path);
        this.logger.debug("Path {} has {} files matching the readers filter.", path, (Object)Iterables.size(files));
        for (URI file : files) {
            visitedRegions.clear();
            for (IPathFilter parserFilter : this.parsers.keySet()) {
                IRegionParser parser = this.parsers.get(parserFilter);
                if (!parserFilter.accept(file)) {
                    this.logger.trace("Parser {} skips {}.", parser, (Object)file.getPath());
                    continue;
                }
                this.logger.debug("{} is parsing {}", parser, (Object)file);
                try {
                    IDocument document;
                    CharSequence input = reader.readFile(file);
                    try {
                        document = parser.parse(input);
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(parser + " failed parsing " + file, ex);
                    }
                    this.logger.debug("{} found {} regions in {} : {}", new Object[]{parser, Iterables.size(document.getRegions()), file, document.getRegions()});
                    for (IDocument.IRegion region : document.getRegions()) {
                        if (!region.isMarkedRegion()) continue;
                        String id = region.getId();
                        if (visitedRegions.contains(id)) {
                            this.logger.warn("parser {} found region {} which was parsed by another parser before.", parser, (Object)id);
                            continue;
                        }
                        visitedRegions.add(id);
                        this.logger.trace("Put Pool {} = {}", (Object)id, (Object)region.getText());
                        if (this.protectedRegionPool.containsKey(id)) {
                            throw new IllegalStateException("Duplicate protected region id: '" + id + "'. Protected region ids have to be globally unique.");
                        }
                        this.protectedRegionPool.put(id, region);
                    }
                }
                catch (IOException e) {
                    this.logger.warn("Cannot read {}", file);
                }
            }
        }
    }

    public void clearRegions() {
        this.protectedRegionPool.clear();
        this.visitedPaths.clear();
    }

    public CharSequence mergeRegions(IFileSystemReader reader, String fileName, String slot, CharSequence contents) {
        IDocument document = null;
        URI path = reader.getUri(fileName, slot);
        for (IPathFilter filter : this.parsers.keySet()) {
            if (!filter.accept(path)) continue;
            IRegionParser parser = this.parsers.get(filter);
            document = document == null ? parser.parse(contents) : parser.parse(document.getContents());
            this.logger.debug("Source document has {} regions: {}", Iterables.size(document.getRegions()), document.getRegions());
            if (parser.isInverse()) {
                try {
                    CharSequence input = reader.readFile(path);
                    document = RegionUtil.fillIn(document, parser.parse(input));
                }
                catch (Exception e) {
                    this.logger.warn("Cannot read {}", path);
                }
                continue;
            }
            this.logger.debug("Pool contains {} regions: {}", this.protectedRegionPool.size(), this.protectedRegionPool.keySet());
            for (Map.Entry<String, IDocument.IRegion> region : this.protectedRegionPool.entrySet()) {
                this.logger.trace("Pool {} = {}", (Object)region.getKey(), (Object)region.getValue().getText());
            }
            document = RegionUtil.merge(document, this.protectedRegionPool);
            this.logger.debug("Merged document has {} regions: {}", Iterables.size(document.getRegions()), document.getRegions());
        }
        return document == null ? contents : document.getContents();
    }

    private static class FileExtensionFilter
    implements IPathFilter {
        private String[] fileExtensions;

        public FileExtensionFilter(String[] fileExtensions) {
            this.fileExtensions = fileExtensions;
        }

        public boolean accept(URI uri) {
            String path = uri.getPath();
            String[] stringArray = this.fileExtensions;
            int n = this.fileExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                String fileExtension = stringArray[n2];
                if (path.endsWith(fileExtension)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }
}

