/*
 * Decompiled with CFR 0.152.
 */
package net.danieldietrich.protectedregions.core;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.regex.Pattern;
import net.danieldietrich.protectedregions.core.IDocument;
import net.danieldietrich.protectedregions.core.IRegionOracle;
import net.danieldietrich.protectedregions.core.IRegionParser;
import net.danieldietrich.protectedregions.core.RegionParserBuilder;
import net.danieldietrich.protectedregions.core.RegionParserFactory;
import net.danieldietrich.protectedregions.core.RegionUtil;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RegionUtilTest {
    private IRegionParser javaParser;
    IRegionOracle NESTED_COMMENT_ORACLE = new IRegionOracle(){
        private final Pattern PR_START = Pattern.compile("\\s*PROTECTED\\s+REGION\\s+/\\*\\s*[0-9]+\\s*\\*/\\s+(ENABLED\\s+)?START\\s*");
        private final Pattern PR_END = Pattern.compile("\\s*PROTECTED\\s+REGION\\s+END\\s*");

        public boolean isMarkedRegionStart(String comment) {
            return this.PR_START.matcher(comment).matches();
        }

        public boolean isMarkedRegionEnd(String comment) {
            return this.PR_END.matcher(comment).matches();
        }

        public String getId(String markedRegionStart) {
            int i = markedRegionStart.indexOf("/*") + 1;
            int j = i + 1 + markedRegionStart.substring(i + 1).indexOf("*/");
            return i != -1 && j != -1 ? markedRegionStart.substring(i + 1, j).trim() : null;
        }

        public boolean isEnabled(String markedRegionStart) {
            return markedRegionStart.contains("ENABLED");
        }
    };
    IRegionOracle FILL_IN_ORACLE = new IRegionOracle(){
        private final Pattern PR_START = Pattern.compile("\\s*GENERATED\\s+ID\\s*\\(\\s*[0-9]+\\s*\\)\\s+(DISABLED\\s+)?START\\s*");
        private final Pattern PR_END = Pattern.compile("\\s*GENERATED\\s+END\\s*");

        public boolean isMarkedRegionStart(String comment) {
            return this.PR_START.matcher(comment).matches();
        }

        public boolean isMarkedRegionEnd(String comment) {
            return this.PR_END.matcher(comment).matches();
        }

        public String getId(String markedRegionStart) {
            int i = markedRegionStart.indexOf("(");
            int j = i + 1 + markedRegionStart.substring(i + 1).indexOf(")");
            return i != -1 && j != -1 ? markedRegionStart.substring(i + 1, j).trim() : null;
        }

        public boolean isEnabled(String markedRegionStart) {
            return !markedRegionStart.contains("DISABLED");
        }
    };
    IRegionOracle SIMPLE_ORACLE = new IRegionOracle(){

        public boolean isMarkedRegionStart(String s) {
            String _s = s.trim();
            return _s.startsWith("$(") && _s.endsWith(")-{");
        }

        public boolean isMarkedRegionEnd(String s) {
            return "}-$".equals(s.trim());
        }

        public String getId(String s) {
            int i = s.indexOf("(");
            int j = i + 1 + s.substring(i + 1).indexOf(")");
            return i != -1 && j != -1 ? s.substring(i + 1, j).trim() : null;
        }

        public boolean isEnabled(String s) {
            return true;
        }
    };

    @Before
    public void setup() {
        this.javaParser = RegionParserFactory.createJavaParser(false);
    }

    @Test
    public void fileShoudExist() throws Exception {
        try {
            RegionParserFactory.createJavaParser().parse(new FileInputStream("does_not_exist"));
            Assert.assertTrue("FileNotFoundException should have been thrown.", false);
        }
        catch (FileNotFoundException x) {
            Assert.assertTrue(x.getMessage(), "does_not_exist (No such file or directory)".equals(x.getMessage()));
        }
    }

    @Test
    public void mergeShouldMatchExpected() throws Exception {
        IDocument currentDoc = this.javaParser.parse(new FileInputStream("src/test/resources/protected_current.txt"));
        IDocument previousDoc = this.javaParser.parse(new FileInputStream("src/test/resources/protected_previous.txt"));
        IDocument _merged = RegionUtil.merge(currentDoc, previousDoc);
        String mergedContents = _merged.getContents();
        String expectedContents = IOUtils.toString(new FileReader("src/test/resources/protected_expected.txt"));
        Assert.assertEquals(expectedContents, mergedContents);
    }

    @Test
    public void idsShouldBeUniquePerFile() throws Exception {
        try {
            this.javaParser.parse(new FileInputStream("src/test/resources/non_unique_ids.txt"));
        }
        catch (IllegalStateException x) {
            Assert.assertEquals(x.getMessage(), "Duplicate marked region id: uniqueId");
        }
    }

    @Test
    public void scalaParserShouldReadNestedComments() throws Exception {
        IRegionParser parser = RegionParserFactory.createScalaParser(this.NESTED_COMMENT_ORACLE, false);
        IDocument doc = parser.parse(new FileInputStream("src/test/resources/nested_comments.txt"));
        Assert.assertTrue(doc.getMarkedRegion("1234") != null);
    }

    @Test
    public void javaParserShouldntReadNestedComments() throws Exception {
        try {
            IRegionParser parser = RegionParserFactory.createJavaParser(this.NESTED_COMMENT_ORACLE, false);
            parser.parse(new FileInputStream("src/test/resources/nested_comments.txt"));
        }
        catch (IllegalStateException x) {
            Assert.assertTrue(x.getMessage(), "Detected marked region end without corresponding marked region start between (5,7) and (6,1), near [ PROTECTED REGION END].".equals(x.getMessage()));
        }
    }

    @Test
    public void switchedRegionsParserShouldPreserveEnabledRegionsOnly() throws Exception {
        IDocument currentDoc = this.javaParser.parse(new FileInputStream("src/test/resources/switched_current.txt"));
        IDocument previousDoc = this.javaParser.parse(new FileInputStream("src/test/resources/switched_previous.txt"));
        IDocument _merged = RegionUtil.merge(currentDoc, previousDoc);
        String mergedContents = _merged.getContents();
        String expectedContents = IOUtils.toString(new FileReader("src/test/resources/switched_expected.txt"));
        Assert.assertEquals(expectedContents, mergedContents);
    }

    @Test
    public void fillInShouldMatchExpected() throws Exception {
        IRegionParser parser = RegionParserFactory.createJavaParser(this.FILL_IN_ORACLE, false);
        IDocument currentDoc = parser.parse(new FileInputStream("src/test/resources/fill_in_current.txt"));
        IDocument previousDoc = parser.parse(new FileInputStream("src/test/resources/fill_in_previous.txt"));
        IDocument _merged = RegionUtil.fillIn(currentDoc, previousDoc);
        String mergedContents = _merged.getContents();
        String expectedContents = IOUtils.toString(new FileReader("src/test/resources/fill_in_expected.txt"));
        Assert.assertEquals(expectedContents, mergedContents);
    }

    @Test
    public void alternativeRegionNotationsWorkAsWell() throws Exception {
        IRegionParser parser = new RegionParserBuilder().addComment("/*", "*/").addComment("//").setInverse(false).useOracle(this.SIMPLE_ORACLE).build();
        IDocument currentDoc = parser.parse(new FileInputStream("src/test/resources/simple_current.txt"));
        IDocument previousDoc = parser.parse(new FileInputStream("src/test/resources/simple_previous.txt"));
        IDocument _merged = RegionUtil.merge(currentDoc, previousDoc);
        String mergedContents = _merged.getContents();
        String expectedContents = IOUtils.toString(new FileReader("src/test/resources/simple_expected.txt"));
        Assert.assertEquals(expectedContents, mergedContents);
    }

    @Test
    public void xmlParserShouldMatchExpected() throws Exception {
        IRegionParser parser = RegionParserFactory.createXmlParser();
        IDocument currentDoc = parser.parse(new FileInputStream("src/test/resources/xml_current.txt"));
        IDocument previousDoc = parser.parse(new FileInputStream("src/test/resources/xml_previous.txt"));
        IDocument _merged = RegionUtil.merge(currentDoc, previousDoc);
        String mergedContents = _merged.getContents();
        String expectedContents = IOUtils.toString(new FileReader("src/test/resources/xml_expected.txt"));
        Assert.assertEquals(expectedContents, mergedContents);
    }

    @Test
    public void xmlCDataShouldBeIgnored() throws Exception {
        try {
            RegionParserFactory.createXmlParser().parse(new FileInputStream("src/test/resources/ignore_xml_cdata.txt"));
        }
        catch (IllegalStateException x) {
            Assert.assertTrue(x.getMessage(), "Detected marked region end without corresponding marked region start between (5,7) and (5,32), near [ PROTECTED REGION END ].".equals(x.getMessage()));
        }
    }

    @Test
    public void javaStringsShouldBeIgnored() throws Exception {
        try {
            RegionParserFactory.createJavaParser().parse(new FileInputStream("src/test/resources/ignore_java_strings.txt"));
        }
        catch (IllegalStateException x) {
            Assert.assertTrue(x.getMessage(), "Detected marked region end without corresponding marked region start between (5,5) and (5,29), near [ PROTECTED REGION END ].".equals(x.getMessage()));
        }
    }

    @Test
    public void javaStringEscapesShouldBeIgnored() throws Exception {
        RegionParserFactory.createJavaParser().parse(new FileInputStream("src/test/resources/ignore_java_string_escapes.txt"));
    }
}

