/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tango.pogo.validation;

import com.google.inject.Inject;
import fr.esrf.tango.pogo.Extensions;
import fr.esrf.tango.pogo.pogoDsl.Command;
import fr.esrf.tango.pogo.pogoDsl.PogoDeviceClass;
import fr.esrf.tango.pogo.pogoDsl.PogoDslPackage;
import fr.esrf.tango.pogo.pogoDsl.Property;
import fr.esrf.tango.pogo.validation.AbstractPogoDslJavaValidator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;

public class PogoDslJavaValidator
extends AbstractPogoDslJavaValidator {
    @Inject
    private Extensions ext;

    @Override
    protected void error(String message, EObject source, EStructuralFeature feature, String code, String ... issueData) {
        super.error(String.valueOf(message) + ": " + this.ext.loc(source), source, feature, code, issueData);
    }

    @Check(value=CheckType.FAST)
    public void checkClassDescription(PogoDeviceClass element) {
        if (element.getDescription() == null) {
            this.error("no class description specified", (EObject)element, (EStructuralFeature)PogoDslPackage.Literals.POGO_DEVICE_CLASS__DESCRIPTION, "fr.esrf.tango.pogo.validation.no_class_description", new String[0]);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkCommand(Command element) {
        if (!Character.isUpperCase(element.getName().charAt(0))) {
            this.error("command names must start with a capital letter", (EObject)element, (EStructuralFeature)PogoDslPackage.Literals.COMMAND__NAME, "fr.esrf.tango.pogo.validation.command_name_start_uppercase", new String[0]);
        }
        if (element.getArgin() == null) {
            this.error("no input type specified", (EObject)element, (EStructuralFeature)PogoDslPackage.Literals.COMMAND__ARGIN, "fr.esrf.tango.pogo.validation.command_inputtype_missing", new String[0]);
        }
        if (element.getArgout() == null) {
            this.error("no output type specified", (EObject)element, (EStructuralFeature)PogoDslPackage.Literals.COMMAND__ARGOUT, "fr.esrf.tango.pogo.validation.command_outputtype_missing", new String[0]);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkPropertyName(Property element) {
        if (!Character.isUpperCase(element.getName().charAt(0))) {
            this.error("command names must start with a capital letter", (EObject)element, (EStructuralFeature)PogoDslPackage.Literals.PROPERTY__NAME, "fr.esrf.tango.pogo.validation.property_name_start_uppercase", new String[0]);
        }
    }
}

