/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tango.pogo.generator.python;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import fr.esrf.tango.pogo.generator.common.StringUtils;
import fr.esrf.tango.pogo.generator.python.ProtectedArea;
import fr.esrf.tango.pogo.generator.python.PythonTypeDefinitions;
import fr.esrf.tango.pogo.generator.python.PythonUtils;
import fr.esrf.tango.pogo.pogoDsl.Attribute;
import fr.esrf.tango.pogo.pogoDsl.ClassDescription;
import fr.esrf.tango.pogo.pogoDsl.ClassIdentification;
import fr.esrf.tango.pogo.pogoDsl.Command;
import fr.esrf.tango.pogo.pogoDsl.InheritanceStatus;
import fr.esrf.tango.pogo.pogoDsl.PogoDeviceClass;
import fr.esrf.tango.pogo.pogoDsl.Property;
import fr.esrf.tango.pogo.pogoDsl.State;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public class PythonDevice
implements IGenerator {
    @Inject
    @Extension
    private ProtectedArea _protectedArea;
    @Inject
    @Extension
    private PythonUtils _pythonUtils;
    @Inject
    @Extension
    private PythonTypeDefinitions _pythonTypeDefinitions;

    @Override
    public void doGenerate(Resource resource, IFileSystemAccess fsa) {
        TreeIterator<EObject> _allContents = resource.getAllContents();
        Iterable<EObject> _iterable = IteratorExtensions.toIterable(_allContents);
        Iterable<PogoDeviceClass> _filter = Iterables.filter(_iterable, PogoDeviceClass.class);
        for (PogoDeviceClass cls : _filter) {
            boolean _and = false;
            ClassDescription _description = cls.getDescription();
            String _filestogenerate = _description.getFilestogenerate();
            String _lowerCase = _filestogenerate.toLowerCase();
            boolean _contains = _lowerCase.contains("code files");
            if (!_contains) {
                _and = false;
            } else {
                boolean _equals;
                ClassDescription _description_1 = cls.getDescription();
                String _language = _description_1.getLanguage();
                String _lowerCase_1 = _language.toLowerCase();
                _and = _equals = _lowerCase_1.equals("python");
            }
            if (!_and) continue;
            String _name = cls.getName();
            String _plus = "doGenerate for python " + _name;
            InputOutput.println(_plus);
            String _name_1 = cls.getName();
            String _plus_1 = String.valueOf(_name_1) + ".py";
            CharSequence _generate_pythonFile = this.generate_pythonFile(cls);
            fsa.generateFile(_plus_1, _generate_pythonFile);
        }
    }

    public CharSequence generate_pythonFile(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _pythonDevice = this.pythonDevice(cls);
        _builder.append((Object)_pythonDevice, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _pythonDeviceClass = this.pythonDeviceClass(cls);
        _builder.append((Object)_pythonDeviceClass, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _pythonMainMethod = this.pythonMainMethod(cls);
        _builder.append((Object)_pythonMainMethod, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence pythonDevice(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _pythonHeader = this.pythonHeader(cls);
        _builder.append((Object)_pythonHeader, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("class ");
        String _name = cls.getName();
        _builder.append((Object)_name, "");
        _builder.append(" (");
        String _inheritedPythonClassName = this._pythonTypeDefinitions.inheritedPythonClassName(cls);
        _builder.append((Object)_inheritedPythonClassName, "");
        _builder.append("):");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("\"\"\"");
        ClassDescription _description = cls.getDescription();
        String _description_1 = _description.getDescription();
        _builder.append((Object)_description_1, "    ");
        _builder.append("\"\"\"");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("# -------- Add you global variables here --------------------------");
        _builder.newLine();
        _builder.append("    ");
        String _protectedArea = this._protectedArea.protectedArea(cls, "global_variables");
        _builder.append((Object)_protectedArea, "    ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("    ");
        CharSequence _pythonConstructors = this.pythonConstructors(cls);
        _builder.append((Object)_pythonConstructors, "    ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("    ");
        CharSequence _pythonInitDevice = this.pythonInitDevice(cls);
        _builder.append((Object)_pythonInitDevice, "    ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("def always_executed_hook(self):");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("self.debug_stream(\"In always_excuted_hook()\")");
        _builder.newLine();
        _builder.append("        ");
        String _protectedArea_1 = this._protectedArea.protectedArea(cls, "always_executed_hook");
        _builder.append((Object)_protectedArea_1, "        ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("    ");
        CharSequence _pythonAttributes = this.pythonAttributes(cls);
        _builder.append((Object)_pythonAttributes, "    ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        CharSequence _pythonCommands = this.pythonCommands(cls);
        _builder.append((Object)_pythonCommands, "    ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("    ");
        String _protectedArea_2 = this._protectedArea.protectedArea(cls, "programmer_methods");
        _builder.append((Object)_protectedArea_2, "    ");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence pythonDeviceClass(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("class ");
        String _name = cls.getName();
        _builder.append((Object)_name, "");
        _builder.append("Class(");
        String _inheritedPythonDeviceClassName = this._pythonTypeDefinitions.inheritedPythonDeviceClassName(cls);
        _builder.append((Object)_inheritedPythonDeviceClassName, "");
        _builder.append("):");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("# -------- Add you global class variables here --------------------------");
        _builder.newLine();
        _builder.append("    ");
        String _protectedArea = this._protectedArea.protectedArea(cls, "global_class_variables");
        _builder.append((Object)_protectedArea, "    ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("    ");
        CharSequence _pythonDynamicAttributesClass = this.pythonDynamicAttributesClass(cls);
        _builder.append((Object)_pythonDynamicAttributesClass, "    ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _pythonProperties = this.pythonProperties(cls);
        _builder.append((Object)_pythonProperties, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _pythonCommandDefinitions = this.pythonCommandDefinitions(cls);
        _builder.append((Object)_pythonCommandDefinitions, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _pythonAttributeDefinitions = this.pythonAttributeDefinitions(cls);
        _builder.append((Object)_pythonAttributeDefinitions, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder;
    }

    public CharSequence pythonHeader(PogoDeviceClass cls) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#!/usr/bin/env python");
        _builder.newLine();
        _builder.append("# -*- coding:utf-8 -*-");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("# ############################################################################");
        _builder.newLine();
        _builder.append("#  license :");
        _builder.newLine();
        _builder.append("# ============================================================================");
        _builder.newLine();
        _builder.append("#");
        _builder.newLine();
        _builder.append("#  File :        ");
        String _name = cls.getName();
        String _plus = String.valueOf(_name) + ".py";
        _builder.append((Object)_plus, "");
        _builder.newLineIfNotEmpty();
        _builder.append("#");
        _builder.newLine();
        _builder.append("#  Project :     ");
        ClassDescription _description = cls.getDescription();
        String _title = _description.getTitle();
        _builder.append((Object)_title, "");
        _builder.newLineIfNotEmpty();
        _builder.append("#");
        _builder.newLine();
        ClassDescription _description_1 = cls.getDescription();
        String _license = _description_1.getLicense();
        String _licenseText = StringUtils.licenseText(_license, "# ");
        _builder.append((Object)_licenseText, "");
        _builder.newLineIfNotEmpty();
        _builder.append("#");
        _builder.newLine();
        _builder.append("#  $Author :      ");
        ClassDescription _description_2 = cls.getDescription();
        ClassIdentification _identification = _description_2.getIdentification();
        String _author = _identification.getAuthor();
        _builder.append((Object)_author, "");
        _builder.append("$");
        _builder.newLineIfNotEmpty();
        _builder.append("#");
        _builder.newLine();
        _builder.append("#  $Revision :    $");
        _builder.newLine();
        _builder.append("#");
        _builder.newLine();
        _builder.append("#  $Date :        $");
        _builder.newLine();
        _builder.append("#");
        _builder.newLine();
        _builder.append("#  $HeadUrl :     $");
        _builder.newLine();
        _builder.append("# ============================================================================");
        _builder.newLine();
        _builder.append("#            This file is generated by POGO");
        _builder.newLine();
        _builder.append("#     (Program Obviously used to Generate tango Object)");
        _builder.newLine();
        _builder.append("# ############################################################################");
        _builder.newLine();
        _builder.newLine();
        _builder.append("__all__ = [\"");
        String _name_1 = cls.getName();
        _builder.append((Object)_name_1, "");
        _builder.append("\", \"");
        String _name_2 = cls.getName();
        _builder.append((Object)_name_2, "");
        _builder.append("Class\", \"main\"]");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("__docformat__ = 'restructuredtext'");
        _builder.newLine();
        _builder.newLine();
        _builder.append("import PyTango");
        _builder.newLine();
        _builder.append("import sys");
        _builder.newLine();
        String _inheritedAdditionalImport = this._pythonTypeDefinitions.inheritedAdditionalImport(cls);
        _builder.append((Object)_inheritedAdditionalImport, "");
        _builder.newLineIfNotEmpty();
        _builder.append("# Add additional import");
        _builder.newLine();
        String _protectedArea = this._protectedArea.protectedArea(cls, "additionnal_import");
        _builder.append((Object)_protectedArea, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("# Device States Description");
        _builder.newLine();
        EList<State> _states = cls.getStates();
        boolean _isEmpty = _states.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            EList<State> _states_1 = cls.getStates();
            for (State state : _states_1) {
                _builder.append("# ");
                String _name_3 = state.getName();
                _builder.append((Object)_name_3, "");
                _builder.append(" : ");
                String _description_3 = state.getDescription();
                _builder.append((Object)_description_3, "");
                _builder.newLineIfNotEmpty();
            }
        } else {
            _builder.append("# No states for this device");
            _builder.newLine();
        }
        _builder.newLine();
        return _builder;
    }

    public CharSequence pythonConstructors(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("def __init__(self, cl, name):");
        _builder.newLine();
        _builder.append("    ");
        String _inheritedConstructor = this._pythonTypeDefinitions.inheritedConstructor(cls);
        _builder.append((Object)_inheritedConstructor, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("self.debug_stream(\"In __init__()\")");
        _builder.newLine();
        _builder.append("    ");
        String _name = cls.getName();
        _builder.append((Object)_name, "    ");
        _builder.append(".init_device(self)");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        String _protectedArea = this._protectedArea.protectedArea(cls, "__init__");
        _builder.append((Object)_protectedArea, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.newLine();
        _builder.append("def delete_device(self):");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("self.debug_stream(\"In delete_device()\")");
        _builder.newLine();
        _builder.append("    ");
        String _protectedArea_1 = this._protectedArea.protectedArea(cls, "delete_device");
        _builder.append((Object)_protectedArea_1, "    ");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence pythonInitDevice(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("def init_device(self):");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("self.debug_stream(\"In init_device()\")");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("self.get_device_properties(self.get_device_class())");
        _builder.newLine();
        EList<Attribute> _attributes = cls.getAttributes();
        for (Attribute attr : _attributes) {
            boolean _isRead = StringUtils.isRead(attr);
            if (_isRead) {
                _builder.append("    self.attr_");
                String _name = attr.getName();
                _builder.append((Object)_name, "");
                _builder.append("_read = ");
                String _defaultValueDim = PythonTypeDefinitions.defaultValueDim(attr);
                _builder.append((Object)_defaultValueDim, "");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append("    ");
        CharSequence _setEventCriteria = this._pythonUtils.setEventCriteria(cls);
        _builder.append((Object)_setEventCriteria, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        String _protectedArea = this._protectedArea.protectedArea(cls, "init_device");
        _builder.append((Object)_protectedArea, "    ");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence pythonAttributes(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("# -------------------------------------------------------------------------");
        _builder.newLine();
        _builder.append("#    ");
        String _name = cls.getName();
        _builder.append((Object)_name, "");
        _builder.append(" read/write attribute methods");
        _builder.newLineIfNotEmpty();
        _builder.append("# -------------------------------------------------------------------------");
        _builder.newLine();
        _builder.newLine();
        EList<Attribute> _attributes = cls.getAttributes();
        for (Attribute attr : _attributes) {
            EList<String> _writeExcludedStates;
            boolean _isEmpty_1;
            boolean _not_1;
            boolean _not;
            boolean _isWrite;
            boolean _isRead = StringUtils.isRead(attr);
            if (_isRead) {
                CharSequence _readAttributeMethod = this._pythonUtils.readAttributeMethod(cls, attr);
                _builder.append((Object)_readAttributeMethod, "");
                _builder.newLineIfNotEmpty();
            }
            if (_isWrite = StringUtils.isWrite(attr)) {
                CharSequence _writeAttributeMethod = this._pythonUtils.writeAttributeMethod(cls, attr);
                _builder.append((Object)_writeAttributeMethod, "");
                _builder.newLineIfNotEmpty();
            }
            boolean _or = false;
            EList<String> _readExcludedStates = attr.getReadExcludedStates();
            boolean _isEmpty = _readExcludedStates.isEmpty();
            boolean bl = _not = !_isEmpty;
            _or = _not ? true : (_not_1 = !(_isEmpty_1 = (_writeExcludedStates = attr.getWriteExcludedStates()).isEmpty()));
            if (!_or) continue;
            CharSequence _attributeMethodStateMachine = this._pythonUtils.attributeMethodStateMachine(cls, attr);
            _builder.append((Object)_attributeMethodStateMachine, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        CharSequence _pythonDynamicAttributes = this.pythonDynamicAttributes(cls);
        _builder.append((Object)_pythonDynamicAttributes, "");
        _builder.newLineIfNotEmpty();
        _builder.append("def read_attr_hardware(self, data):");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("self.debug_stream(\"In read_attr_hardware()\")");
        _builder.newLine();
        _builder.append("    ");
        String _protectedArea = this._protectedArea.protectedArea(cls, "read_attr_hardware");
        _builder.append((Object)_protectedArea, "    ");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence pythonDynamicAttributes(PogoDeviceClass cls) {
        boolean _not_2;
        StringConcatenation _builder = new StringConcatenation();
        EList<Attribute> _dynamicAttributes = cls.getDynamicAttributes();
        for (Attribute attr : _dynamicAttributes) {
            EList<String> _writeExcludedStates;
            boolean _isEmpty_1;
            boolean _not_1;
            boolean _not;
            boolean _isWrite;
            boolean _isRead = StringUtils.isRead(attr);
            if (_isRead) {
                CharSequence _readAttributeMethod = this._pythonUtils.readAttributeMethod(cls, attr);
                _builder.append((Object)_readAttributeMethod, "");
                _builder.newLineIfNotEmpty();
            }
            if (_isWrite = StringUtils.isWrite(attr)) {
                CharSequence _writeAttributeMethod = this._pythonUtils.writeAttributeMethod(cls, attr);
                _builder.append((Object)_writeAttributeMethod, "");
                _builder.newLineIfNotEmpty();
            }
            boolean _or = false;
            EList<String> _readExcludedStates = attr.getReadExcludedStates();
            boolean _isEmpty = _readExcludedStates.isEmpty();
            boolean bl = _not = !_isEmpty;
            _or = _not ? true : (_not_1 = !(_isEmpty_1 = (_writeExcludedStates = attr.getWriteExcludedStates()).isEmpty()));
            if (!_or) continue;
            CharSequence _attributeMethodStateMachine = this._pythonUtils.attributeMethodStateMachine(cls, attr);
            _builder.append((Object)_attributeMethodStateMachine, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        EList<Attribute> _dynamicAttributes_1 = cls.getDynamicAttributes();
        boolean _isEmpty_2 = _dynamicAttributes_1.isEmpty();
        boolean bl = _not_2 = !_isEmpty_2;
        if (_not_2) {
            _builder.append("def initialize_dynamic_attributes(self):");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("self.debug_stream(\"In initialize_dynamic_attributes()\")");
            _builder.newLine();
            _builder.append("    ");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("#   Example to add dynamic attributes");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("#   Copy inside the folowing protected area to instanciate at startup.");
            _builder.newLine();
            _builder.append("    ");
            _builder.newLine();
            EList<Attribute> _dynamicAttributes_2 = cls.getDynamicAttributes();
            for (Attribute attr_1 : _dynamicAttributes_2) {
                _builder.append("    ");
                _builder.append("\"\"\"   For Attribute ");
                String _name = attr_1.getName();
                _builder.append((Object)_name, "    ");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                CharSequence _dynamicAttributeCreationExample = this._pythonUtils.dynamicAttributeCreationExample(attr_1);
                _builder.append((Object)_dynamicAttributeCreationExample, "    ");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                CharSequence _dynamicAttributeSetMemorizedExample = this._pythonUtils.dynamicAttributeSetMemorizedExample(attr_1);
                _builder.append((Object)_dynamicAttributeSetMemorizedExample, "    ");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                CharSequence _dynamicAttributeDefaultValueExample = this._pythonUtils.dynamicAttributeDefaultValueExample(cls, attr_1);
                _builder.append((Object)_dynamicAttributeDefaultValueExample, "    ");
                _builder.append("\"\"\"");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.newLine();
            }
            _builder.append("    ");
            String _protectedArea = this._protectedArea.protectedArea(cls, "initialize_dynamic_attributes");
            _builder.append((Object)_protectedArea, "    ");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("        ");
        _builder.newLine();
        return _builder;
    }

    public CharSequence pythonDynamicAttributesClass(PogoDeviceClass cls) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        EList<Attribute> _dynamicAttributes = cls.getDynamicAttributes();
        boolean _isEmpty = _dynamicAttributes.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append("def dyn_attr(self, dev_list):");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("\"\"\"Invoked to create dynamic attributes for the given devices.");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("Default implementation calls");
            _builder.newLine();
            _builder.append("    ");
            _builder.append(":meth:`");
            String _name = cls.getName();
            _builder.append((Object)_name, "    ");
            _builder.append(".initialize_dynamic_attributes` for each device");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            _builder.append("    ");
            _builder.append(":param dev_list: list of devices");
            _builder.newLine();
            _builder.append("    ");
            _builder.append(":type dev_list: :class:`PyTango.DeviceImpl`\"\"\"");
            _builder.newLine();
            _builder.newLine();
            _builder.append("    ");
            _builder.append("for dev in dev_list:");
            _builder.newLine();
            _builder.append("        ");
            _builder.append("try:");
            _builder.newLine();
            _builder.append("            ");
            _builder.append("dev.initialize_dynamic_attributes()");
            _builder.newLine();
            _builder.append("        ");
            _builder.append("except:");
            _builder.newLine();
            _builder.append("            ");
            _builder.append("import traceback");
            _builder.newLine();
            _builder.append("            ");
            _builder.append("dev.warn_stream(\"Failed to initialize dynamic attributes\")");
            _builder.newLine();
            _builder.append("            ");
            _builder.append("dev.debug_stream(\"Details: \" + traceback.format_exc())");
            _builder.newLine();
            _builder.append("    ");
            String _protectedArea = this._protectedArea.protectedArea(cls, "dyn_attr");
            _builder.append((Object)_protectedArea, "    ");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence pythonCommands(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("# -------------------------------------------------------------------------");
        _builder.newLine();
        _builder.append("#    ");
        String _name = cls.getName();
        _builder.append((Object)_name, "");
        _builder.append(" command methods");
        _builder.newLineIfNotEmpty();
        _builder.append("# -------------------------------------------------------------------------");
        _builder.newLine();
        _builder.newLine();
        EList<Command> _commands = cls.getCommands();
        for (Command cmd : _commands) {
            String _name_2;
            boolean _equals_2;
            boolean _equals_3;
            boolean _equals_1;
            boolean _and = false;
            String _name_1 = cmd.getName();
            boolean _equals = _name_1.equals("State");
            boolean bl = _equals_1 = !_equals;
            _and = !_equals_1 ? false : (_equals_3 = !(_equals_2 = (_name_2 = cmd.getName()).equals("Status")));
            if (_and) {
                boolean _not;
                CharSequence _commandExecution = this._pythonUtils.commandExecution(cls, cmd);
                _builder.append((Object)_commandExecution, "");
                _builder.newLineIfNotEmpty();
                EList<String> _excludedStates = cmd.getExcludedStates();
                boolean _isEmpty = _excludedStates.isEmpty();
                boolean bl2 = _not = !_isEmpty;
                if (!_not) continue;
                CharSequence _commandMethodStateMachine = this._pythonUtils.commandMethodStateMachine(cls, cmd);
                _builder.append((Object)_commandMethodStateMachine, "");
                _builder.newLineIfNotEmpty();
                continue;
            }
            InheritanceStatus _status = cmd.getStatus();
            String _concreteHere = _status.getConcreteHere();
            boolean _isTrue = StringUtils.isTrue(_concreteHere);
            if (!_isTrue) continue;
            CharSequence _commandExecution_1 = this._pythonUtils.commandExecution(cls, cmd);
            _builder.append((Object)_commandExecution_1, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence pythonProperties(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("    ");
        _builder.append("#    Class Properties");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("class_property_list = {");
        _builder.newLine();
        EList<Property> _classProperties = cls.getClassProperties();
        for (Property prop : _classProperties) {
            CharSequence _pythonPropertyClass = this._pythonUtils.pythonPropertyClass(prop);
            _builder.append((Object)_pythonPropertyClass, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("        ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("    ");
        String _inheritanceClassPropertyList = this._pythonTypeDefinitions.inheritanceClassPropertyList(cls);
        _builder.append((Object)_inheritanceClassPropertyList, "    ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("#    Device Properties");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("device_property_list = {");
        _builder.newLine();
        EList<Property> _deviceProperties = cls.getDeviceProperties();
        for (Property prop_1 : _deviceProperties) {
            CharSequence _pythonPropertyClass_1 = this._pythonUtils.pythonPropertyClass(prop_1);
            _builder.append((Object)_pythonPropertyClass_1, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("        ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("    ");
        String _inheritanceDevicePropertyList = this._pythonTypeDefinitions.inheritanceDevicePropertyList(cls);
        _builder.append((Object)_inheritanceDevicePropertyList, "    ");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence pythonCommandDefinitions(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("#    Command definitions");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("cmd_list = {");
        _builder.newLine();
        EList<Command> _commands = cls.getCommands();
        for (Command cmd : _commands) {
            String _name_1;
            boolean _equals_2;
            boolean _equals_3;
            boolean _equals_1;
            boolean _and = false;
            String _name = cmd.getName();
            boolean _equals = _name.equals("State");
            boolean bl = _equals_1 = !_equals;
            _and = !_equals_1 ? false : (_equals_3 = !(_equals_2 = (_name_1 = cmd.getName()).equals("Status")));
            if (!_and) continue;
            CharSequence _pythonCommandClass = this._pythonUtils.pythonCommandClass(cmd);
            _builder.append((Object)_pythonCommandClass, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("        ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("    ");
        String _inheritanceCmdList = this._pythonTypeDefinitions.inheritanceCmdList(cls);
        _builder.append((Object)_inheritanceCmdList, "    ");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence pythonAttributeDefinitions(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("#    Attribute definitions");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("attr_list = {");
        _builder.newLine();
        EList<Attribute> _attributes = cls.getAttributes();
        for (Attribute attr : _attributes) {
            CharSequence _pythonAttributeClass = this._pythonUtils.pythonAttributeClass(attr);
            _builder.append((Object)_pythonAttributeClass, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("        ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("    ");
        String _inheritanceAttrList = this._pythonTypeDefinitions.inheritanceAttrList(cls);
        _builder.append((Object)_inheritanceAttrList, "    ");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence pythonMainMethod(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("def main():");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("try:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("py = PyTango.Util(sys.argv)");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("py.add_class(");
        String _name = cls.getName();
        _builder.append((Object)_name, "        ");
        _builder.append("Class, ");
        String _name_1 = cls.getName();
        _builder.append((Object)_name_1, "        ");
        _builder.append(", '");
        String _name_2 = cls.getName();
        _builder.append((Object)_name_2, "        ");
        _builder.append("')");
        _builder.newLineIfNotEmpty();
        _builder.append("        ");
        String _protectedArea = this._protectedArea.protectedArea(cls, "add_classes");
        _builder.append((Object)_protectedArea, "        ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("        ");
        _builder.append("U = PyTango.Util.instance()");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("U.server_init()");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("U.server_run()");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("except PyTango.DevFailed as e:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("print ('-------> Received a DevFailed exception:', e)");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("except Exception as e:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("print ('-------> An unforeseen exception occured....', e)");
        _builder.newLine();
        _builder.newLine();
        _builder.append("if __name__ == '__main__':");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("main()");
        _builder.newLine();
        return _builder;
    }
}

