/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tango.pogo.generator.cpp;

import com.google.inject.Inject;
import fr.esrf.tango.pogo.generator.common.StringUtils;
import fr.esrf.tango.pogo.generator.cpp.utils.Attributes;
import fr.esrf.tango.pogo.generator.cpp.utils.Commands;
import fr.esrf.tango.pogo.generator.cpp.utils.CppStringUtils;
import fr.esrf.tango.pogo.generator.cpp.utils.Headers;
import fr.esrf.tango.pogo.generator.cpp.utils.InheritanceUtils;
import fr.esrf.tango.pogo.generator.cpp.utils.Pipes;
import fr.esrf.tango.pogo.generator.cpp.utils.Properties;
import fr.esrf.tango.pogo.generator.cpp.utils.ProtectedArea;
import fr.esrf.tango.pogo.pogoDsl.Attribute;
import fr.esrf.tango.pogo.pogoDsl.ClassDescription;
import fr.esrf.tango.pogo.pogoDsl.Command;
import fr.esrf.tango.pogo.pogoDsl.InheritanceStatus;
import fr.esrf.tango.pogo.pogoDsl.Pipe;
import fr.esrf.tango.pogo.pogoDsl.PogoDeviceClass;
import fr.esrf.tango.pogo.pogoDsl.Property;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;

public class DeviceSource {
    @Inject
    @Extension
    private ProtectedArea _protectedArea;
    @Inject
    @Extension
    private CppStringUtils _cppStringUtils;
    @Inject
    @Extension
    private Headers _headers;
    @Inject
    @Extension
    private Commands _commands;
    @Inject
    @Extension
    private Attributes _attributes;
    @Inject
    @Extension
    private Pipes _pipes;
    @Inject
    @Extension
    private Properties _properties;
    @Inject
    @Extension
    private InheritanceUtils _inheritanceUtils;

    public CharSequence generateDeviceSourceFile(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _fileHeader = this.fileHeader(cls);
        _builder.append((Object)_fileHeader, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*  ");
        String _name = cls.getName();
        _builder.append((Object)_name, " ");
        _builder.append(" class description:");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*    ");
        ClassDescription _description = cls.getDescription();
        String _description_1 = _description.getDescription();
        String _comments = StringUtils.comments(_description_1, "*    ");
        _builder.append((Object)_comments, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        EList<Command> _commands = cls.getCommands();
        String _commandsTable = this._cppStringUtils.commandsTable(_commands);
        _builder.append((Object)_commandsTable, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        EList<Attribute> _attributes = cls.getAttributes();
        String _attributesTable = this._cppStringUtils.attributesTable(_attributes);
        _builder.append((Object)_attributesTable, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("namespace ");
        String _name_1 = cls.getName();
        _builder.append((Object)_name_1, "");
        _builder.append("_ns");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        String _protectedArea = this._protectedArea.protectedArea(cls, "namespace_starting", "static initializations", true);
        _builder.append((Object)_protectedArea, "");
        _builder.newLineIfNotEmpty();
        CharSequence _constructors = this.constructors(cls);
        _builder.append((Object)_constructors, "");
        _builder.newLineIfNotEmpty();
        CharSequence _initDeviceMethod = this.initDeviceMethod(cls);
        _builder.append((Object)_initDeviceMethod, "");
        _builder.newLineIfNotEmpty();
        CharSequence _utilsMethods = this.utilsMethods(cls);
        _builder.append((Object)_utilsMethods, "");
        _builder.newLineIfNotEmpty();
        CharSequence _attributeMethods = this.attributeMethods(cls);
        _builder.append((Object)_attributeMethods, "");
        _builder.newLineIfNotEmpty();
        CharSequence _pipeMethods = this.pipeMethods(cls);
        _builder.append((Object)_pipeMethods, "");
        _builder.newLineIfNotEmpty();
        CharSequence _commandMethods = this.commandMethods(cls);
        _builder.append((Object)_commandMethods, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _protectedArea_1 = this._protectedArea.protectedArea(cls, "namespace_ending", "Additional Methods", true);
        _builder.append((Object)_protectedArea_1, "");
        _builder.newLineIfNotEmpty();
        _builder.append("} //\tnamespace");
        _builder.newLine();
        return _builder;
    }

    public CharSequence fileHeader(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        String _deviceSourceFileHeader = this._headers.deviceSourceFileHeader(cls);
        String _plus = String.valueOf(_deviceSourceFileHeader) + "\n\n";
        String _plus_1 = String.valueOf(_plus) + "#include <";
        String _name = cls.getName();
        String _plus_2 = String.valueOf(_plus_1) + _name;
        String _plus_3 = String.valueOf(_plus_2) + ".h>\n";
        String _plus_4 = String.valueOf(_plus_3) + "#include <";
        String _name_1 = cls.getName();
        String _plus_5 = String.valueOf(_plus_4) + _name_1;
        String _plus_6 = String.valueOf(_plus_5) + "Class.h>";
        String _protectedArea = this._protectedArea.protectedArea(cls, ".cpp", _plus_6, false);
        _builder.append((Object)_protectedArea, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence constructors(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        String _name = cls.getName();
        String _name_1 = cls.getName();
        String _plus = "Constructors for a Tango device\nimplementing the class" + _name_1;
        String _simpleMethodHeader = this._headers.simpleMethodHeader(cls, _name, _plus);
        _builder.append((Object)_simpleMethodHeader, "");
        _builder.newLineIfNotEmpty();
        String _name_2 = cls.getName();
        _builder.append((Object)_name_2, "");
        _builder.append("::");
        String _name_3 = cls.getName();
        _builder.append((Object)_name_3, "");
        _builder.append("(Tango::DeviceClass *cl, string &s)");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append(": ");
        String _inheritedClassName = this._inheritanceUtils.inheritedClassName(cls);
        _builder.append((Object)_inheritedClassName, " ");
        _builder.append("(cl, s.c_str())");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        String _protectedArea = this._protectedArea.protectedArea(cls, "constructor_1", "init_device();", false);
        _builder.append((Object)_protectedArea, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.append("//--------------------------------------------------------");
        _builder.newLine();
        String _name_4 = cls.getName();
        _builder.append((Object)_name_4, "");
        _builder.append("::");
        String _name_5 = cls.getName();
        _builder.append((Object)_name_5, "");
        _builder.append("(Tango::DeviceClass *cl, const char *s)");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append(": ");
        String _inheritedClassName_1 = this._inheritanceUtils.inheritedClassName(cls);
        _builder.append((Object)_inheritedClassName_1, " ");
        _builder.append("(cl, s)");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        String _protectedArea_1 = this._protectedArea.protectedArea(cls, "constructor_2", "init_device();", false);
        _builder.append((Object)_protectedArea_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.append("//--------------------------------------------------------");
        _builder.newLine();
        String _name_6 = cls.getName();
        _builder.append((Object)_name_6, "");
        _builder.append("::");
        String _name_7 = cls.getName();
        _builder.append((Object)_name_7, "");
        _builder.append("(Tango::DeviceClass *cl, const char *s, const char *d)");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append(": ");
        String _inheritedClassName_2 = this._inheritanceUtils.inheritedClassName(cls);
        _builder.append((Object)_inheritedClassName_2, " ");
        _builder.append("(cl, s, d)");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        String _protectedArea_2 = this._protectedArea.protectedArea(cls, "constructor_3", "init_device();", false);
        _builder.append((Object)_protectedArea_2, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        String _simpleMethodHeader_1 = this._headers.simpleMethodHeader(cls, "delete_device", "will be called at device destruction or at init command");
        _builder.append((Object)_simpleMethodHeader_1, "");
        _builder.newLineIfNotEmpty();
        _builder.append("void ");
        String _name_8 = cls.getName();
        _builder.append((Object)_name_8, "");
        _builder.append("::delete_device()");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("DEBUG_STREAM << \"");
        String _name_9 = cls.getName();
        _builder.append((Object)_name_9, "\t");
        _builder.append("::delete_device() \" << device_name << endl;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _protectedArea_3 = this._protectedArea.protectedArea(cls, "delete_device", "Delete device allocated objects", true);
        _builder.append((Object)_protectedArea_3, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        EList<Attribute> _attributes = cls.getAttributes();
        CharSequence _deleteAttributeDataMembers = this._attributes.deleteAttributeDataMembers(_attributes);
        _builder.append((Object)_deleteAttributeDataMembers, "\t");
        _builder.newLineIfNotEmpty();
        boolean _hasInheritanceClass = this._inheritanceUtils.hasInheritanceClass(cls);
        if (_hasInheritanceClass) {
            _builder.newLine();
            _builder.append("\t");
            _builder.append("if (Tango::Util::instance()->is_svr_shutting_down()==false  &&");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("Tango::Util::instance()->is_device_restarting(device_name)==false &&");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("Tango::Util::instance()->is_svr_starting()==false)");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("//\tIf not shutting down call delete device for inherited object");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            String _inheritedClassName_3 = this._inheritanceUtils.inheritedClassName(cls);
            _builder.append((Object)_inheritedClassName_3, "\t\t");
            _builder.append("_ns::");
            String _inheritedClassName_4 = this._inheritanceUtils.inheritedClassName(cls);
            _builder.append((Object)_inheritedClassName_4, "\t\t");
            _builder.append("::delete_device();");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence initDeviceMethod(PogoDeviceClass cls) {
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        String _simpleMethodHeader = this._headers.simpleMethodHeader(cls, "init_device", "will be called at device initialization.");
        _builder.append((Object)_simpleMethodHeader, "");
        _builder.newLineIfNotEmpty();
        _builder.append("void ");
        String _name = cls.getName();
        _builder.append((Object)_name, "");
        _builder.append("::init_device()");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("DEBUG_STREAM << \"");
        String _name_1 = cls.getName();
        _builder.append((Object)_name_1, "\t");
        _builder.append("::init_device() create device \" << device_name << endl;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _protectedArea = this._protectedArea.protectedArea(cls, "init_device_before", "Initialization before get_device_property() call", true);
        _builder.append((Object)_protectedArea, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        boolean _hasInheritanceClass = this._inheritanceUtils.hasInheritanceClass(cls);
        if (_hasInheritanceClass) {
            _builder.append("\t");
            _builder.append("if (Tango::Util::instance()->is_svr_starting() == false  &&");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("Tango::Util::instance()->is_device_restarting(device_name)==false)");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("//\tIf not starting up call init device for inherited object");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            String _inheritedClassName = this._inheritanceUtils.inheritedClassName(cls);
            _builder.append((Object)_inheritedClassName, "\t\t");
            _builder.append("_ns::");
            String _inheritedClassName_1 = this._inheritanceUtils.inheritedClassName(cls);
            _builder.append((Object)_inheritedClassName_1, "\t\t");
            _builder.append("::init_device();");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        boolean _and = false;
        EList<Property> _deviceProperties = cls.getDeviceProperties();
        int _size = _deviceProperties.size();
        boolean bl = _greaterThan = _size > 0;
        if (!_greaterThan) {
            _and = false;
        } else {
            boolean _isTrue;
            ClassDescription _description = cls.getDescription();
            String _hasConcreteProperty = _description.getHasConcreteProperty();
            _and = _isTrue = StringUtils.isTrue(_hasConcreteProperty);
        }
        if (_and) {
            _builder.newLine();
            _builder.append("\t");
            _builder.append("//\tGet the device properties from database");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("get_device_property();");
            _builder.newLine();
        } else {
            _builder.append("\t");
            _builder.append("//\tNo device property to be read from database");
            _builder.newLine();
        }
        _builder.append("\t");
        EList<Attribute> _attributes = cls.getAttributes();
        CharSequence _allocateAttributeDataMembers = this._attributes.allocateAttributeDataMembers(_attributes);
        _builder.append((Object)_allocateAttributeDataMembers, "\t");
        _builder.newLineIfNotEmpty();
        EList<Property> _deviceProperties_1 = cls.getDeviceProperties();
        boolean _hasMandatoryProperty = this._cppStringUtils.hasMandatoryProperty(_deviceProperties_1);
        if (_hasMandatoryProperty) {
            _builder.append("\t");
            _builder.append("//\tNo longer if mandatory property not set. ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("if (mandatoryNotDefined)");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("return;");
            _builder.newLine();
            _builder.newLine();
        }
        _builder.append("\t");
        String _protectedArea_1 = this._protectedArea.protectedArea(cls, "init_device", "Initialize device", true);
        _builder.append((Object)_protectedArea_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }

    public CharSequence utilsMethods(PogoDeviceClass cls) {
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        boolean _and = false;
        EList<Property> _deviceProperties = cls.getDeviceProperties();
        int _size = _deviceProperties.size();
        boolean bl = _greaterThan = _size > 0;
        if (!_greaterThan) {
            _and = false;
        } else {
            boolean _isTrue;
            ClassDescription _description = cls.getDescription();
            String _hasConcreteProperty = _description.getHasConcreteProperty();
            _and = _isTrue = StringUtils.isTrue(_hasConcreteProperty);
        }
        if (_and) {
            CharSequence _devicePropertiesMethod = this._properties.getDevicePropertiesMethod(cls);
            _builder.append((Object)_devicePropertiesMethod, "");
            _builder.newLineIfNotEmpty();
            EList<Property> _deviceProperties_1 = cls.getDeviceProperties();
            boolean _hasMandatoryProperty = this._cppStringUtils.hasMandatoryProperty(_deviceProperties_1);
            if (_hasMandatoryProperty) {
                String _simpleMethodHeader = this._headers.simpleMethodHeader(cls, "check_mandatory_property", "For mandatory properties check if defined in database.");
                _builder.append((Object)_simpleMethodHeader, "");
                _builder.newLineIfNotEmpty();
                _builder.append("void ");
                String _name = cls.getName();
                _builder.append((Object)_name, "");
                _builder.append("::check_mandatory_property(Tango::DbDatum &class_prop, Tango::DbDatum &dev_prop)");
                _builder.newLineIfNotEmpty();
                _builder.append("{");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("//\tCheck if all properties are empty");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("if (class_prop.is_empty() && dev_prop.is_empty())");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("{");
                _builder.newLine();
                _builder.append("\t\t");
                _builder.append("TangoSys_OMemStream\ttms;");
                _builder.newLine();
                _builder.append("\t\t");
                _builder.append("tms << endl <<\"Property \\'\" << dev_prop.name;");
                _builder.newLine();
                _builder.append("\t\t");
                _builder.append("if (Tango::Util::instance()->_UseDb==true)");
                _builder.newLine();
                _builder.append("\t\t\t");
                _builder.append("tms << \"\\' is mandatory but not defined in database\";");
                _builder.newLine();
                _builder.append("\t\t");
                _builder.append("else");
                _builder.newLine();
                _builder.append("\t\t\t");
                _builder.append("tms << \"\\' is mandatory but cannot be defined without database\";");
                _builder.newLine();
                _builder.append("\t\t");
                _builder.append("string\tstatus(get_status());");
                _builder.newLine();
                _builder.append("\t\t");
                _builder.append("status += tms.str();");
                _builder.newLine();
                _builder.append("\t\t");
                _builder.append("set_status(status);");
                _builder.newLine();
                _builder.append("\t\t");
                _builder.append("mandatoryNotDefined = true;");
                _builder.newLine();
                _builder.append("\t\t");
                String _protectedArea = this._protectedArea.protectedArea(cls, "check_mandatory_property", "cerr << tms.str() << \" for \" << device_name << endl;", false);
                _builder.append((Object)_protectedArea, "\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
                _builder.append("}");
                _builder.newLine();
                _builder.newLine();
            }
        }
        _builder.newLine();
        String _simpleMethodHeader_1 = this._headers.simpleMethodHeader(cls, "always_executed_hook", "method always executed before any command is executed");
        _builder.append((Object)_simpleMethodHeader_1, "");
        _builder.newLineIfNotEmpty();
        _builder.append("void ");
        String _name_1 = cls.getName();
        _builder.append((Object)_name_1, "");
        _builder.append("::always_executed_hook()");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("DEBUG_STREAM << \"");
        String _name_2 = cls.getName();
        _builder.append((Object)_name_2, "\t");
        _builder.append("::always_executed_hook()  \" << device_name << endl;");
        _builder.newLineIfNotEmpty();
        EList<Property> _deviceProperties_2 = cls.getDeviceProperties();
        boolean _hasMandatoryProperty_1 = this._cppStringUtils.hasMandatoryProperty(_deviceProperties_2);
        if (_hasMandatoryProperty_1) {
            _builder.append("\t");
            _builder.append("if (mandatoryNotDefined)");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("string\tstatus(get_status());");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("Tango::Except::throw_exception(");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t\t\t");
            _builder.append("(const char *)\"PROPERTY_NOT_SET\",");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t\t\t");
            _builder.append("status.c_str(),");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t\t\t");
            _builder.append("(const char *)\"");
            String _name_3 = cls.getName();
            _builder.append((Object)_name_3, "\t\t\t\t\t");
            _builder.append("::always_executed_hook()\");");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("\t");
        String _protectedArea_1 = this._protectedArea.protectedArea(cls, "always_executed_hook", "code always executed before all requests", true);
        _builder.append((Object)_protectedArea_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }

    public CharSequence pipeMethods(PogoDeviceClass cls) {
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        EList<Pipe> _pipes = cls.getPipes();
        int _size = _pipes.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            EList<Pipe> _pipes_1 = cls.getPipes();
            for (Pipe pipe : _pipes_1) {
                CharSequence _readPipeMethod = this._pipes.readPipeMethod(cls, pipe);
                _builder.append((Object)_readPipeMethod, "");
                _builder.newLineIfNotEmpty();
                String _rwType = pipe.getRwType();
                boolean _contains = _rwType.contains("WRITE");
                if (!_contains) continue;
                CharSequence _writePipeMethod = this._pipes.writePipeMethod(cls, pipe);
                _builder.append((Object)_writePipeMethod, "");
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    public CharSequence attributeMethods(PogoDeviceClass cls) {
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        String _simpleMethodHeader = this._headers.simpleMethodHeader(cls, "read_attr_hardware", "Hardware acquisition for attributes");
        _builder.append((Object)_simpleMethodHeader, "");
        _builder.newLineIfNotEmpty();
        _builder.append("void ");
        String _name = cls.getName();
        _builder.append((Object)_name, "");
        _builder.append("::read_attr_hardware(TANGO_UNUSED(vector<long> &attr_list))");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("DEBUG_STREAM << \"");
        String _name_1 = cls.getName();
        _builder.append((Object)_name_1, "\t");
        _builder.append("::read_attr_hardware(vector<long> &attr_list) entering... \" << endl;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _protectedArea = this._protectedArea.protectedArea(cls, "read_attr_hardware", "Add your own code", true);
        _builder.append((Object)_protectedArea, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        boolean _hasWritableAttribute = CppStringUtils.hasWritableAttribute(cls);
        if (_hasWritableAttribute) {
            String _simpleMethodHeader_1 = this._headers.simpleMethodHeader(cls, "write_attr_hardware", "Hardware writing for attributes");
            _builder.append((Object)_simpleMethodHeader_1, "");
            _builder.newLineIfNotEmpty();
            _builder.append("void ");
            Iterator _name_2 = cls.getName();
            _builder.append(_name_2, "");
            _builder.append("::write_attr_hardware(TANGO_UNUSED(vector<long> &attr_list))");
            _builder.newLineIfNotEmpty();
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("DEBUG_STREAM << \"");
            String _name_3 = cls.getName();
            _builder.append((Object)_name_3, "\t");
            _builder.append("::write_attr_hardware(vector<long> &attr_list) entering... \" << endl;");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            String _protectedArea_1 = this._protectedArea.protectedArea(cls, "write_attr_hardware", "Add your own code", true);
            _builder.append((Object)_protectedArea_1, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
        }
        _builder.newLine();
        EList<Attribute> _attributes = cls.getAttributes();
        for (Attribute attribute : _attributes) {
            boolean _isWrite;
            boolean _isConcreteHere = this._inheritanceUtils.isConcreteHere(attribute);
            if (!_isConcreteHere) continue;
            boolean _isRead = StringUtils.isRead(attribute);
            if (_isRead) {
                String _attributeMethodHeader = this._headers.attributeMethodHeader(attribute, "Read");
                _builder.append((Object)_attributeMethodHeader, "");
                _builder.newLineIfNotEmpty();
                CharSequence _readAttributeMethod = this._attributes.readAttributeMethod(cls, attribute);
                _builder.append((Object)_readAttributeMethod, "");
                _builder.newLineIfNotEmpty();
            }
            if (!(_isWrite = StringUtils.isWrite(attribute))) continue;
            String _attributeMethodHeader_1 = this._headers.attributeMethodHeader(attribute, "Write");
            _builder.append((Object)_attributeMethodHeader_1, "");
            _builder.newLineIfNotEmpty();
            CharSequence _writeAttributeMethod = this._attributes.writeAttributeMethod(cls, attribute);
            _builder.append((Object)_writeAttributeMethod, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        EList<Attribute> _dynamicAttributes = cls.getDynamicAttributes();
        for (Attribute attribute_1 : _dynamicAttributes) {
            boolean _isWrite_1;
            boolean _isRead_1 = StringUtils.isRead(attribute_1);
            if (_isRead_1) {
                String _attributeMethodHeader_2 = this._headers.attributeMethodHeader(attribute_1, "Read");
                _builder.append((Object)_attributeMethodHeader_2, "");
                _builder.newLineIfNotEmpty();
                CharSequence _readDynamicAttributeMethod = this._attributes.readDynamicAttributeMethod(cls, attribute_1);
                _builder.append((Object)_readDynamicAttributeMethod, "");
                _builder.newLineIfNotEmpty();
            }
            if (!(_isWrite_1 = StringUtils.isWrite(attribute_1))) continue;
            String _attributeMethodHeader_3 = this._headers.attributeMethodHeader(attribute_1, "Write");
            _builder.append((Object)_attributeMethodHeader_3, "");
            _builder.newLineIfNotEmpty();
            CharSequence _writeAttributeMethod_1 = this._attributes.writeAttributeMethod(cls, attribute_1);
            _builder.append((Object)_writeAttributeMethod_1, "");
            _builder.newLineIfNotEmpty();
        }
        String _simpleMethodHeader_2 = this._headers.simpleMethodHeader(cls, "add_dynamic_attributes", "Create the dynamic attributes if any\nfor specified device.");
        _builder.append((Object)_simpleMethodHeader_2, "");
        _builder.newLineIfNotEmpty();
        _builder.append("void ");
        String _name_4 = cls.getName();
        _builder.append((Object)_name_4, "");
        _builder.append("::add_dynamic_attributes()");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        EList<Attribute> _dynamicAttributes_1 = cls.getDynamicAttributes();
        int _size = _dynamicAttributes_1.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            _builder.append("\t");
            _builder.append("//\tExample to add dynamic attribute:");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("//\tCopy inside the following protected area to create instance(s) at startup.");
            _builder.newLine();
            EList<Attribute> _dynamicAttributes_2 = cls.getDynamicAttributes();
            for (Attribute attribute_2 : _dynamicAttributes_2) {
                _builder.append("\t");
                _builder.append("//\tadd_");
                String _name_5 = attribute_2.getName();
                _builder.append((Object)_name_5, "\t");
                _builder.append("_dynamic_attribute(\"My");
                String _name_6 = attribute_2.getName();
                _builder.append((Object)_name_6, "\t");
                _builder.append("Attribute\");");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.newLine();
        }
        _builder.append("\t");
        String _protectedArea_2 = this._protectedArea.protectedArea(cls, "add_dynamic_attributes", "Add your own code to create and add dynamic attributes if any", true);
        _builder.append((Object)_protectedArea_2, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }

    public CharSequence commandMethods(PogoDeviceClass cls) {
        boolean _greaterThan_1;
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        EList<Command> _commands = cls.getCommands();
        for (Command command : _commands) {
            InheritanceStatus _status = command.getStatus();
            String _concreteHere = _status.getConcreteHere();
            boolean _isTrue = StringUtils.isTrue(_concreteHere);
            if (!_isTrue) continue;
            _builder.append("//--------------------------------------------------------");
            _builder.newLine();
            String _commandExecutionMethodHeader = this._headers.commandExecutionMethodHeader(command);
            _builder.append((Object)_commandExecutionMethodHeader, "");
            _builder.newLineIfNotEmpty();
            _builder.append("//--------------------------------------------------------");
            _builder.newLine();
            CharSequence _commandExecutionMethod = this._commands.commandExecutionMethod(cls, command);
            _builder.append((Object)_commandExecutionMethod, "");
            _builder.newLineIfNotEmpty();
        }
        EList<Command> _dynamicCommands = cls.getDynamicCommands();
        int _size = _dynamicCommands.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            EList<Command> _dynamicCommands_1 = cls.getDynamicCommands();
            for (Command command_1 : _dynamicCommands_1) {
                InheritanceStatus _status_1 = command_1.getStatus();
                String _concreteHere_1 = _status_1.getConcreteHere();
                boolean _isTrue_1 = StringUtils.isTrue(_concreteHere_1);
                if (!_isTrue_1) continue;
                _builder.append("//--------------------------------------------------------");
                _builder.newLine();
                String _commandExecutionMethodHeader_1 = this._headers.commandExecutionMethodHeader(command_1);
                _builder.append((Object)_commandExecutionMethodHeader_1, "");
                _builder.newLineIfNotEmpty();
                _builder.append("//--------------------------------------------------------");
                _builder.newLine();
                CharSequence _commandExecutionMethod_1 = this._commands.commandExecutionMethod(cls, command_1);
                _builder.append((Object)_commandExecutionMethod_1, "");
                _builder.newLineIfNotEmpty();
            }
        }
        String _simpleMethodHeader = this._headers.simpleMethodHeader(cls, "add_dynamic_commands", "Create the dynamic commands if any\nfor specified device.");
        _builder.append((Object)_simpleMethodHeader, "");
        _builder.newLineIfNotEmpty();
        _builder.append("void ");
        String _name = cls.getName();
        _builder.append((Object)_name, "");
        _builder.append("::add_dynamic_commands()");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        EList<Command> _dynamicCommands_2 = cls.getDynamicCommands();
        int _size_1 = _dynamicCommands_2.size();
        boolean bl2 = _greaterThan_1 = _size_1 > 0;
        if (_greaterThan_1) {
            _builder.append("\t");
            _builder.append("//\tExample to add dynamic command:");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("//\tCopy inside the folowing protected area to instanciate at startup.");
            _builder.newLine();
            EList<Command> _dynamicCommands_3 = cls.getDynamicCommands();
            for (Command command_2 : _dynamicCommands_3) {
                _builder.append("\t");
                _builder.append("//\tadd_");
                String _name_1 = command_2.getName();
                _builder.append((Object)_name_1, "\t");
                _builder.append("_dynamic_command(\"My");
                String _name_2 = command_2.getName();
                _builder.append((Object)_name_2, "\t");
                _builder.append("Command\", true);");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.newLine();
        }
        _builder.append("\t");
        String _protectedArea = this._protectedArea.protectedArea(cls, "add_dynamic_commands", "Add your own code to create and add dynamic commands if any", true);
        _builder.append((Object)_protectedArea, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }
}

