/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui;

import fr.esrf.tango.pogo.pogoDsl.Argument;
import fr.esrf.tango.pogo.pogoDsl.AttrProperties;
import fr.esrf.tango.pogo.pogoDsl.Attribute;
import fr.esrf.tango.pogo.pogoDsl.Command;
import fr.esrf.tango.pogo.pogoDsl.EventCriteria;
import fr.esrf.tango.pogo.pogoDsl.FireEvents;
import fr.esrf.tango.pogo.pogoDsl.ForwardedAttribute;
import fr.esrf.tango.pogo.pogoDsl.InheritanceStatus;
import fr.esrf.tango.pogo.pogoDsl.Property;
import fr.esrf.tango.pogo.pogoDsl.State;
import java.awt.Font;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.eclipse.emf.common.util.EList;
import org.tango.pogo.pogo_gui.DeviceClass;
import org.tango.pogo.pogo_gui.PogoConst;
import org.tango.pogo.pogo_gui.PropertyDialog;
import org.tango.pogo.pogo_gui.tools.OAWutils;
import org.tango.pogo.pogo_gui.tools.PogoProperty;
import org.tango.pogo.pogo_gui.tools.Utils;

public class InheritanceUtils {
    private static InheritanceUtils instance = null;
    private static Utils utils;
    private static final boolean trace = false;

    private InheritanceUtils() {
        utils = Utils.getInstance();
    }

    public static InheritanceUtils getInstance() {
        if (instance == null) {
            instance = new InheritanceUtils();
        }
        return instance;
    }

    public String manageInheritanceItems(DeviceClass deviceClass) {
        return this.cloneAncestor(null, deviceClass);
    }

    private String cloneAncestor(DeviceClass deviceClass, DeviceClass deviceClass2) {
        StringBuilder stringBuilder = new StringBuilder();
        DeviceClass deviceClass3 = deviceClass2;
        if (deviceClass2.getAncestors().size() > 0) {
            for (int i = deviceClass2.getAncestors().size() - 1; i >= 0; --i) {
                DeviceClass deviceClass4 = deviceClass2.getAncestors().get(i);
                this.cloneAncestor(deviceClass3, deviceClass4);
                deviceClass3 = deviceClass4;
            }
        }
        if (deviceClass != null) {
            System.out.println(deviceClass.getPogoDeviceClass().getName() + " inherits from " + deviceClass2.getPogoDeviceClass().getName());
            this.cloneProperties(deviceClass, deviceClass2, false);
            this.cloneProperties(deviceClass, deviceClass2, true);
            stringBuilder.append(this.cloneCommands(deviceClass, deviceClass2));
            stringBuilder.append(this.cloneAttributes(deviceClass, deviceClass2));
            this.cloneForwardedAttributes(deviceClass, deviceClass2);
            this.cloneStates(deviceClass, deviceClass2);
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    private void cloneProperties(DeviceClass deviceClass, DeviceClass deviceClass2, boolean bl) {
        EList<Property> eList;
        EList<Property> eList2;
        if (bl) {
            eList2 = deviceClass.getPogoDeviceClass().getDeviceProperties();
            eList = deviceClass2.getPogoDeviceClass().getDeviceProperties();
        } else {
            eList2 = deviceClass.getPogoDeviceClass().getClassProperties();
            eList = deviceClass2.getPogoDeviceClass().getClassProperties();
        }
        for (Property property : eList) {
            void object2;
            Property property2 = OAWutils.factory.createProperty();
            property2.setName(property.getName());
            property2.setDescription(property.getDescription());
            property2.setType(PropertyDialog.createType(property.getType()));
            EList<String> eList3 = property.getDefaultPropValue();
            EList<String> eList4 = property2.getDefaultPropValue();
            for (String string : eList3) {
                eList4.add(string);
            }
            if (Utils.isTrue(property.getMandatory())) {
                property2.setMandatory("true");
            }
            InheritanceStatus inheritanceStatus = OAWutils.factory.createInheritanceStatus();
            inheritanceStatus.setAbstract("false");
            inheritanceStatus.setInherited("true");
            inheritanceStatus.setConcrete("true");
            property2.setStatus(inheritanceStatus);
            Object var12_15 = null;
            for (Property property3 : eList2) {
                if (!property3.getName().equals(property2.getName())) continue;
                Property property4 = property3;
            }
            if (object2 != null) {
                int n = eList2.indexOf(object2);
                eList2.remove(object2);
                eList2.add(n, property2);
                continue;
            }
            eList2.add(property2);
        }
    }

    private void cloneStates(DeviceClass deviceClass, DeviceClass deviceClass2) {
        EList<State> eList = deviceClass.getPogoDeviceClass().getStates();
        EList<State> eList2 = deviceClass2.getPogoDeviceClass().getStates();
        for (State state : eList2) {
            State state2 = OAWutils.factory.createState();
            state2.setName(state.getName());
            state2.setDescription(state.getDescription());
            InheritanceStatus inheritanceStatus = OAWutils.factory.createInheritanceStatus();
            inheritanceStatus.setAbstract("false");
            inheritanceStatus.setInherited("true");
            inheritanceStatus.setConcrete("true");
            state2.setStatus(inheritanceStatus);
            State state3 = null;
            for (State state4 : eList) {
                if (!state4.getName().equals(state2.getName())) continue;
                state3 = state4;
            }
            if (state3 != null) {
                int n = eList.indexOf(state3);
                eList.remove(state3);
                eList.add(n, state2);
                continue;
            }
            eList.add(state2);
        }
    }

    private void cloneForwardedAttributes(DeviceClass deviceClass, DeviceClass deviceClass2) {
        EList<ForwardedAttribute> eList = deviceClass.getPogoDeviceClass().getForwardedAttributes();
        EList<ForwardedAttribute> eList2 = deviceClass2.getPogoDeviceClass().getForwardedAttributes();
        for (ForwardedAttribute forwardedAttribute : eList2) {
            ForwardedAttribute forwardedAttribute2 = OAWutils.factory.createForwardedAttribute();
            forwardedAttribute2.setName(forwardedAttribute.getName());
            forwardedAttribute2.setLabel(forwardedAttribute.getLabel());
            InheritanceStatus inheritanceStatus = OAWutils.factory.createInheritanceStatus();
            inheritanceStatus.setAbstract("false");
            inheritanceStatus.setInherited("true");
            inheritanceStatus.setConcrete("true");
            forwardedAttribute2.setStatus(inheritanceStatus);
            ForwardedAttribute forwardedAttribute3 = null;
            for (ForwardedAttribute forwardedAttribute4 : eList) {
                if (!forwardedAttribute4.getName().equals(forwardedAttribute2.getName())) continue;
                forwardedAttribute3 = forwardedAttribute4;
            }
            if (forwardedAttribute3 != null) {
                int n = eList.indexOf(forwardedAttribute3);
                eList.remove(forwardedAttribute3);
                eList.add(n, forwardedAttribute2);
                continue;
            }
            eList.add(forwardedAttribute2);
        }
    }

    /*
     * Could not resolve type clashes
     */
    private String cloneAttributes(DeviceClass deviceClass, DeviceClass deviceClass2) {
        StringBuilder stringBuilder = new StringBuilder();
        EList<Attribute> eList = deviceClass.getPogoDeviceClass().getAttributes();
        EList<Attribute> eList2 = deviceClass2.getPogoDeviceClass().getAttributes();
        for (Attribute attribute : eList2) {
            Object object;
            Object object22;
            Attribute attribute2 = OAWutils.factory.createAttribute();
            attribute2.setName(attribute.getName());
            attribute2.setAttType(attribute.getAttType());
            attribute2.setRwType(attribute.getRwType());
            attribute2.setDataType(OAWutils.createType(attribute.getDataType()));
            attribute2.setMaxX(attribute.getMaxX());
            attribute2.setMaxY(attribute.getMaxY());
            attribute2.setAllocReadMember(attribute.getAllocReadMember());
            AttrProperties attrProperties = OAWutils.factory.createAttrProperties();
            AttrProperties attrProperties2 = attribute.getProperties();
            if (attrProperties2 != null) {
                attrProperties.setLabel(attrProperties2.getLabel());
                attrProperties.setUnit(attrProperties2.getUnit());
                attrProperties.setStandardUnit(attrProperties2.getStandardUnit());
                attrProperties.setDisplayUnit(attrProperties2.getDisplayUnit());
                attrProperties.setFormat(attrProperties2.getFormat());
                attrProperties.setMaxValue(attrProperties2.getMaxValue());
                attrProperties.setMinValue(attrProperties2.getMinValue());
                attrProperties.setMaxAlarm(attrProperties2.getMaxAlarm());
                attrProperties.setMinAlarm(attrProperties2.getMinAlarm());
                attrProperties.setMaxWarning(attrProperties2.getMaxWarning());
                attrProperties.setMinWarning(attrProperties2.getMinWarning());
                attrProperties.setDeltaTime(attrProperties2.getDeltaTime());
                attrProperties.setDeltaValue(attrProperties2.getDeltaValue());
                attrProperties.setDescription(attrProperties2.getDescription());
                attribute2.setProperties(attrProperties);
            }
            attribute2.setDisplayLevel(attribute.getDisplayLevel());
            attribute2.setPolledPeriod(attribute.getPolledPeriod());
            attribute2.setArchiveEvent(attribute.getArchiveEvent());
            attribute2.setChangeEvent(attribute.getChangeEvent());
            attribute2.setMemorized(attribute.getMemorized());
            attribute2.setMemorizedAtInit(attribute.getMemorizedAtInit());
            InheritanceStatus inheritanceStatus = OAWutils.factory.createInheritanceStatus();
            inheritanceStatus.setAbstract(attribute.getStatus().getAbstract());
            inheritanceStatus.setInherited("true");
            if (Utils.isTrue(attribute.getStatus().getConcrete()) || Utils.isTrue(attribute.getStatus().getConcreteHere())) {
                inheritanceStatus.setConcrete("true");
            } else {
                inheritanceStatus.setConcrete("false");
            }
            attribute2.setStatus(inheritanceStatus);
            EList<String> eList3 = attribute2.getReadExcludedStates();
            EList<String> eList4 = attribute.getReadExcludedStates();
            for (Object object22 : eList4) {
                eList3.add((String)object22);
            }
            eList3 = attribute2.getWriteExcludedStates();
            eList4 = attribute.getWriteExcludedStates();
            for (Object object22 : eList4) {
                eList3.add((String)object22);
            }
            if (attribute.getEventCriteria() != null) {
                object = OAWutils.factory.createEventCriteria();
                object.setPeriod(attribute.getEventCriteria().getPeriod());
                object.setRelChange(attribute.getEventCriteria().getRelChange());
                object.setAbsChange(attribute.getEventCriteria().getAbsChange());
                attribute2.setEventCriteria((EventCriteria)object);
            }
            if (attribute.getEvArchiveCriteria() != null) {
                object = OAWutils.factory.createEventCriteria();
                object.setPeriod(attribute.getEvArchiveCriteria().getPeriod());
                object.setRelChange(attribute.getEvArchiveCriteria().getRelChange());
                object.setAbsChange(attribute.getEvArchiveCriteria().getAbsChange());
                attribute2.setEvArchiveCriteria((EventCriteria)object);
            }
            if (attribute.getChangeEvent() != null) {
                object = OAWutils.factory.createFireEvents();
                object.setFire(attribute.getChangeEvent().getFire());
                object.setLibCheckCriteria(attribute.getChangeEvent().getLibCheckCriteria());
                attribute2.setChangeEvent((FireEvents)object);
            }
            if (attribute.getArchiveEvent() != null) {
                object = OAWutils.factory.createFireEvents();
                object.setFire(attribute.getArchiveEvent().getFire());
                object.setLibCheckCriteria(attribute.getArchiveEvent().getLibCheckCriteria());
                attribute2.setArchiveEvent((FireEvents)object);
            }
            object = null;
            object22 = eList.iterator();
            while (object22.hasNext()) {
                Attribute attribute3 = (Attribute)object22.next();
                if (!attribute3.getName().equals(attribute2.getName())) continue;
                object = attribute3;
                this.manageNonInheritedPart(attribute3, attribute2);
                InheritanceStatus inheritanceStatus2 = attribute3.getStatus();
                inheritanceStatus.setConcreteHere(inheritanceStatus2.getConcreteHere());
                inheritanceStatus.setConcrete(inheritanceStatus2.getConcrete());
                attribute2.getStatus().setHasChanged(this.attributeHasChanged(attribute3, attribute2));
                if (attribute2.getStatus().getHasChanged() == null) continue;
                System.err.println("******* " + attribute3.getName() + "  Has  Changed !!");
                System.err.println(attribute2.getStatus().getHasChanged());
                stringBuilder.append(attribute2.getStatus().getHasChanged());
            }
            if (object != null) {
                int n = eList.indexOf(object);
                eList.remove(object);
                eList.add(n, attribute2);
                continue;
            }
            eList.add(attribute2);
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    private String cloneCommands(DeviceClass deviceClass, DeviceClass deviceClass2) {
        StringBuilder stringBuilder = new StringBuilder();
        EList<Command> eList = deviceClass.getPogoDeviceClass().getCommands();
        EList<Command> eList2 = deviceClass2.getPogoDeviceClass().getCommands();
        for (Command command : eList2) {
            void object2;
            Command command2 = OAWutils.factory.createCommand();
            command2.setName(command.getName());
            command2.setDescription(command.getDescription());
            Argument argument = OAWutils.factory.createArgument();
            Argument argument2 = OAWutils.factory.createArgument();
            argument.setType(OAWutils.createType(command.getArgin().getType()));
            argument.setDescription(command.getArgin().getDescription());
            argument2.setType(OAWutils.createType(command.getArgout().getType()));
            argument2.setDescription(command.getArgout().getDescription());
            command2.setArgin(argument);
            command2.setArgout(argument2);
            command2.setDisplayLevel(command.getDisplayLevel());
            command2.setPolledPeriod(command.getPolledPeriod());
            EList<String> eList3 = command2.getExcludedStates();
            EList<String> eList4 = command.getExcludedStates();
            for (String string : eList4) {
                eList3.add(string);
            }
            command2.setExecMethod(Utils.buildCppExecuteMethodName(command2.getName()));
            InheritanceStatus inheritanceStatus = OAWutils.factory.createInheritanceStatus();
            inheritanceStatus.setAbstract(command.getStatus().getAbstract());
            inheritanceStatus.setInherited("true");
            inheritanceStatus.setConcrete(command.getStatus().getConcrete());
            command2.setStatus(inheritanceStatus);
            Object var14_17 = null;
            for (Command command3 : eList) {
                if (!command3.getName().equals(command2.getName())) continue;
                Command command4 = command3;
                this.manageNonInheritedPart(command3, command2);
                InheritanceStatus inheritanceStatus2 = command3.getStatus();
                inheritanceStatus.setConcreteHere(inheritanceStatus2.getConcreteHere());
                inheritanceStatus.setConcrete(inheritanceStatus2.getConcrete());
                command2.getStatus().setHasChanged(this.commandHasChanged(command3, command2));
                if (command2.getStatus().getHasChanged() == null) continue;
                System.err.println("******* " + command3.getName() + "  Has  Changed !!");
                System.err.println(command2.getStatus().getHasChanged());
                stringBuilder.append(command2.getStatus().getHasChanged());
            }
            if (object2 != null) {
                int n = eList.indexOf(object2);
                eList.remove(object2);
                eList.add(n, command2);
                continue;
            }
            eList.add(command2);
        }
        return stringBuilder.toString();
    }

    private void manageNonInheritedPart(Command command, Command command2) {
        if (Utils.isSet(command.getDescription())) {
            command2.setDescription(command.getDescription());
        }
        if (Utils.isSet(command.getArgin().getDescription())) {
            command2.getArgin().setDescription(command.getArgin().getDescription());
        }
        if (Utils.isSet(command.getArgout().getDescription())) {
            command2.getArgout().setDescription(command.getArgout().getDescription());
        }
        if (Utils.isSet(command.getPolledPeriod())) {
            command2.setPolledPeriod(command.getPolledPeriod());
        }
    }

    private void manageNonInheritedPart(Attribute attribute, Attribute attribute2) {
        if (Utils.isSet(attribute.getPolledPeriod())) {
            attribute2.setPolledPeriod(attribute.getPolledPeriod());
        }
        attribute2.setArchiveEvent(attribute.getArchiveEvent());
        attribute2.setChangeEvent(attribute.getChangeEvent());
        attribute2.setMemorized(attribute.getMemorized());
        attribute2.setMemorizedAtInit(attribute.getMemorizedAtInit());
        AttrProperties attrProperties = attribute.getProperties();
        AttrProperties attrProperties2 = attribute2.getProperties();
        if (Utils.isSet(attrProperties.getLabel())) {
            attrProperties2.setLabel(attrProperties.getLabel());
        }
        if (Utils.isSet(attrProperties.getUnit())) {
            attrProperties2.setUnit(attrProperties.getUnit());
        }
        if (Utils.isSet(attrProperties.getStandardUnit())) {
            attrProperties2.setStandardUnit(attrProperties.getStandardUnit());
        }
        if (Utils.isSet(attrProperties.getDisplayUnit())) {
            attrProperties2.setDisplayUnit(attrProperties.getDisplayUnit());
        }
        if (Utils.isSet(attrProperties.getFormat())) {
            attrProperties2.setFormat(attrProperties.getFormat());
        }
        if (Utils.isSet(attrProperties.getMaxValue())) {
            attrProperties2.setMaxValue(attrProperties.getMaxValue());
        }
        if (Utils.isSet(attrProperties.getMinValue())) {
            attrProperties2.setMinValue(attrProperties.getMinValue());
        }
        if (Utils.isSet(attrProperties.getMaxAlarm())) {
            attrProperties2.setMaxAlarm(attrProperties.getMaxAlarm());
        }
        if (Utils.isSet(attrProperties.getMinAlarm())) {
            attrProperties2.setMinAlarm(attrProperties.getMinAlarm());
        }
        if (Utils.isSet(attrProperties.getMaxWarning())) {
            attrProperties2.setMaxWarning(attrProperties.getMaxWarning());
        }
        if (Utils.isSet(attrProperties.getMinWarning())) {
            attrProperties2.setMinWarning(attrProperties.getMinWarning());
        }
        if (Utils.isSet(attrProperties.getDeltaTime())) {
            attrProperties2.setDeltaTime(attrProperties.getDeltaTime());
        }
        if (Utils.isSet(attrProperties.getDeltaValue())) {
            attrProperties2.setDeltaValue(attrProperties.getDeltaValue());
        }
        if (Utils.isSet(attrProperties.getDescription())) {
            attrProperties2.setDescription(attrProperties.getDescription());
        }
    }

    private String attributeHasChanged(Attribute attribute, Attribute attribute2) {
        String string = OAWutils.pogo2tangoType(attribute.getDataType().toString());
        String string2 = OAWutils.pogo2tangoType(attribute2.getDataType().toString());
        String string3 = null;
        if (!string.equals(string2)) {
            string3 = " - Attribute " + attribute.getName() + "   must be a " + string2 + "\n";
        }
        if (!attribute.getAttType().equals(attribute2.getAttType())) {
            string3 = " - Attribute " + attribute.getName() + "   must be a " + attribute2.getAttType() + "\n";
        }
        if (!attribute.getRwType().equals(attribute2.getRwType())) {
            string3 = " - Attribute " + attribute.getName() + "   must be a " + attribute2.getRwType() + "\n";
        }
        return string3;
    }

    private String commandHasChanged(Command command, Command command2) {
        String string = OAWutils.pogo2tangoType(command.getArgin().getType().toString());
        String string2 = OAWutils.pogo2tangoType(command2.getArgin().getType().toString());
        String string3 = OAWutils.pogo2tangoType(command.getArgout().getType().toString());
        String string4 = OAWutils.pogo2tangoType(command2.getArgout().getType().toString());
        String string5 = "";
        if (!string.equals(string2)) {
            string5 = string5 + " - Command " + command.getName() + "   must have a  " + string2 + " input argument\n";
        }
        if (!string3.equals(string4)) {
            string5 = string5 + " - Command " + command.getName() + "   must have a  " + string4 + " output argument\n";
        }
        if (string5.length() == 0) {
            return null;
        }
        return string5;
    }

    public ImageIcon getIcon(InheritanceStatus inheritanceStatus) {
        if (inheritanceStatus == null) {
            return InheritanceUtils.utils.unknownIcon;
        }
        if (Utils.isTrue(inheritanceStatus.getConcreteHere())) {
            return InheritanceUtils.utils.overloadedIcon;
        }
        if (Utils.isTrue(inheritanceStatus.getInherited())) {
            if (Utils.isTrue(inheritanceStatus.getConcrete())) {
                return InheritanceUtils.utils.inheritedIcon;
            }
            return InheritanceUtils.utils.abstractIcon;
        }
        if (Utils.isTrue(inheritanceStatus.getAbstract())) {
            return InheritanceUtils.utils.abstractIcon;
        }
        return InheritanceUtils.utils.unknownIcon;
    }

    public Font getLeafFont(InheritanceStatus inheritanceStatus) {
        if (inheritanceStatus == null) {
            return PogoConst.rootFont_concrete;
        }
        return Utils.isTrue(inheritanceStatus.getConcrete()) ? PogoConst.leafFont_concrete : PogoConst.leafFont_abstract;
    }

    public static String getStatusStr(InheritanceStatus inheritanceStatus) {
        if (inheritanceStatus == null) {
            return "Inheritance status is null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (Utils.isTrue(System.getenv("DEBUG"))) {
            stringBuilder.append("  ").append(Utils.isTrue(inheritanceStatus.getAbstract())).append(", ").append(Utils.isTrue(inheritanceStatus.getInherited())).append(", ").append(Utils.isTrue(inheritanceStatus.getConcrete())).append(", ").append(Utils.isTrue(inheritanceStatus.getConcreteHere())).append("  ");
        }
        StringBuilder stringBuilder2 = new StringBuilder(stringBuilder);
        if (Utils.isTrue(inheritanceStatus.getConcreteHere())) {
            if (Utils.isTrue(inheritanceStatus.getInherited())) {
                stringBuilder2.append("Overload");
            } else {
                stringBuilder2.append("Concrete");
            }
        } else if (Utils.isTrue(inheritanceStatus.getInherited())) {
            if (Utils.isTrue(inheritanceStatus.getConcrete())) {
                stringBuilder2.append("Inherited concrete");
            } else {
                stringBuilder2.append("Inherited abstract");
            }
        } else if (Utils.isTrue(inheritanceStatus.getAbstract())) {
            stringBuilder2.append("Abstract");
        } else {
            stringBuilder2.append("??");
        }
        return stringBuilder2.toString();
    }

    private static boolean isRemovable(JFrame jFrame, String string, InheritanceStatus inheritanceStatus) {
        if (Utils.isTrue(inheritanceStatus.getInherited())) {
            String string2 = string + " is inherited.  Remove it anyway ?";
            return JOptionPane.showConfirmDialog(jFrame, string2, "Confirmation Window", 0) == 0;
        }
        return true;
    }

    public static boolean isRemovable(JFrame jFrame, Property property) {
        return InheritanceUtils.isRemovable(jFrame, property.getName(), property.getStatus());
    }

    public static boolean isRemovable(JFrame jFrame, Command command) {
        return InheritanceUtils.isRemovable(jFrame, command.getName(), command.getStatus());
    }

    public static boolean isRemovable(JFrame jFrame, Attribute attribute) {
        return InheritanceUtils.isRemovable(jFrame, attribute.getName(), attribute.getStatus());
    }

    public static String checkInheritanceFileFromEnv(String string) {
        String string2 = System.getenv("INHERIT_HOME");
        if (string2 == null && PogoProperty.inheritHome != null && PogoProperty.inheritHome.length() > 0) {
            string2 = PogoProperty.inheritHome;
        }
        if (string != null) {
            string = Utils.getRelativeFilename(string);
            if (string2 != null) {
                System.out.println("Searching " + string + "    from " + string2);
                return Utils.searchFileFromDirectory(string, string2);
            }
        }
        return null;
    }
}

